/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.tango.jhdb.Hdb;
import org.tango.jhdb.HdbFailed;

public class Period {
    static final long GRANULARITY = 86400000L;
    static final SimpleDateFormat periodFormat = new SimpleDateFormat("yyyy-MM-dd");
    Timestamp start;
    Timestamp end;
    String partitionDate;
    boolean isFull;
    private static Date tmpDate = new Date();

    Period(long l, long l2, boolean bl) {
        this.start = new Timestamp(l);
        this.end = new Timestamp(l2);
        this.isFull = bl;
        tmpDate.setTime(l);
        this.partitionDate = periodFormat.format(tmpDate);
    }

    public String toString() {
        String string = Hdb.hdbDateFormat.format(this.start);
        String string2 = Hdb.hdbDateFormat.format(this.end);
        return "Full:" + Boolean.toString(this.isFull) + " Start:" + string + " Stop:" + string2 + " Partition:" + this.partitionDate;
    }

    private static Date getEndOfPeriod(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    private static Date getStartOfPeriod(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    static ArrayList<Period> getPeriods(String string, String string2) throws HdbFailed {
        Date date;
        Date date2;
        ArrayList<Period> arrayList = new ArrayList<Period>();
        try {
            date2 = Hdb.hdbDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new HdbFailed("Wrong start date format : " + parseException.getMessage());
        }
        try {
            date = Hdb.hdbDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            throw new HdbFailed("Wrong stop date format : " + parseException.getMessage());
        }
        long l = date2.getTime();
        long l2 = Period.getEndOfPeriod(date2).getTime();
        long l3 = date.getTime();
        if (l3 > l2) {
            arrayList.add(new Period(l, l2, false));
        } else {
            arrayList.add(new Period(l, l3, false));
        }
        while (l3 > l2) {
            tmpDate.setTime(l2 + 1000L);
            l = Period.getStartOfPeriod(tmpDate).getTime();
            l2 = Period.getEndOfPeriod(tmpDate).getTime();
            if (l3 > l2) {
                arrayList.add(new Period(l, l2, true));
                continue;
            }
            arrayList.add(new Period(l, l3, false));
        }
        return arrayList;
    }
}

