/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeProxy;
import java.util.ArrayList;
import java.util.Vector;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.HdbSigParam;
import org.tango.jhdb.data.HdbByteArray;
import org.tango.jhdb.data.HdbData;
import org.tango.jhdb.data.HdbDataSet;
import org.tango.jhdb.data.HdbDouble;
import org.tango.jhdb.data.HdbDoubleArray;
import org.tango.jhdb.data.HdbFloat;
import org.tango.jhdb.data.HdbFloatArray;
import org.tango.jhdb.data.HdbLong64;
import org.tango.jhdb.data.HdbLong64Array;
import org.tango.jhdb.data.HdbShort;
import org.tango.jhdb.data.HdbShortArray;
import org.tango.jhdb.data.HdbString;
import tacoHdb.common.HdbBrowser;
import tacoHdb.common.HdbConnection;
import tacoHdb.common.HdbException;
import tacoHdb.config.HdbSignal;
import tacoHdb.extract.sig.CharArrayHistoryData;
import tacoHdb.extract.sig.DoubleArrayHistoryData;
import tacoHdb.extract.sig.DoubleScalarHistoryData;
import tacoHdb.extract.sig.FloatArrayHistoryData;
import tacoHdb.extract.sig.FloatScalarHistoryData;
import tacoHdb.extract.sig.LongArrayHistoryData;
import tacoHdb.extract.sig.LongScalarHistoryData;
import tacoHdb.extract.sig.ShortArrayHistoryData;
import tacoHdb.extract.sig.ShortScalarHistoryData;
import tacoHdb.extract.sig.SigExtractQuery;
import tacoHdb.extract.sig.SigHistoryData;
import tacoHdb.extract.sig.StringScalarHistoryData;

public class OracleSchema
extends HdbReader {
    HdbConnection connection = HdbConnection.getInstance();
    HdbBrowser browser;

    public OracleSchema() throws HdbFailed {
        try {
            this.connection.connect();
        }
        catch (HdbException hdbException) {
            throw new HdbFailed(this.buildMessage(hdbException));
        }
        this.browser = new HdbBrowser();
    }

    @Override
    public String getInfo() throws HdbFailed {
        try {
            String string = String.format("%.1f", 1.1);
            String string2 = "Oracle HDB API v" + string + "\n";
            String string3 = "Host:" + this.connection.getDb().getHost() + "\n";
            String string4 = "Service:" + this.connection.getDb().getServiceName();
            return string2 + string3 + string4;
        }
        catch (HdbException hdbException) {
            throw new HdbFailed(this.buildMessage(hdbException));
        }
    }

    @Override
    public String[] getHosts() throws HdbFailed {
        try {
            Vector vector = this.browser.getSignalDomains();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < vector.size(); ++i) {
                String string = this.browser.getNethostByDomain((String)vector.get(i));
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            return stringArray;
        }
        catch (HdbException hdbException) {
            throw new HdbFailed(this.buildMessage(hdbException));
        }
    }

    @Override
    public String[] getDomains(String string) throws HdbFailed {
        try {
            Vector vector = this.browser.getSignalDomains();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = this.browser.getNethostByDomain((String)vector.get(i));
                if (!string2.equalsIgnoreCase(string)) continue;
                arrayList.add(vector.get(i));
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            return stringArray;
        }
        catch (HdbException hdbException) {
            throw new HdbFailed(this.buildMessage(hdbException));
        }
    }

    @Override
    public String[] getFamilies(String string, String string2) throws HdbFailed {
        try {
            Vector vector = this.browser.getSignalFamilies(string2);
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.get(i);
            }
            return stringArray;
        }
        catch (HdbException hdbException) {
            throw new HdbFailed(this.buildMessage(hdbException));
        }
    }

    @Override
    public String[] getMembers(String string, String string2, String string3) throws HdbFailed {
        try {
            Vector vector = this.browser.getSignalMembers(string2, string3);
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.get(i);
            }
            return stringArray;
        }
        catch (HdbException hdbException) {
            throw new HdbFailed(this.buildMessage(hdbException));
        }
    }

    @Override
    public String[] getNames(String string, String string2, String string3, String string4) throws HdbFailed {
        try {
            Vector vector = this.browser.getSignalNames(string2, string3, string4);
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.get(i);
            }
            return stringArray;
        }
        catch (HdbException hdbException) {
            throw new HdbFailed(this.buildMessage(hdbException));
        }
    }

    @Override
    public String[] getAttributeList() throws HdbFailed {
        int n;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        HdbBrowser hdbBrowser = new HdbBrowser();
        try {
            stringArray = hdbBrowser.getSignalDomains();
            for (n = 0; n < stringArray.size(); ++n) {
                String string = hdbBrowser.getNethostByDomain((String)stringArray.get(n));
                Vector vector = hdbBrowser.getSignalFamilies((String)stringArray.get(n));
                for (int i = 0; i < vector.size(); ++i) {
                    Vector vector2 = hdbBrowser.getSignalMembers((String)stringArray.get(n), (String)vector.get(i));
                    for (int j = 0; j < vector2.size(); ++j) {
                        Vector vector3 = hdbBrowser.getSignalNames((String)stringArray.get(n), (String)vector.get(i), (String)vector2.get(j));
                        for (int k = 0; k < vector3.size(); ++k) {
                            arrayList.add("tango://" + string + "/" + (String)stringArray.get(n) + "/" + (String)vector.get(i) + "/" + (String)vector2.get(j) + "/" + (String)vector3.get(k));
                        }
                    }
                }
            }
        }
        catch (HdbException hdbException) {
            throw new HdbFailed(this.buildMessage(hdbException));
        }
        stringArray = new String[arrayList.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)arrayList.get(n);
        }
        return stringArray;
    }

    @Override
    HdbDataSet getDataFromDB(HdbSigInfo hdbSigInfo, String string, String string2) throws HdbFailed {
        ArrayList<HdbData> arrayList;
        block27: {
            SigExtractQuery sigExtractQuery;
            try {
                sigExtractQuery = new SigExtractQuery(Long.parseLong(hdbSigInfo.sigId));
                sigExtractQuery.setStartDate(string);
                sigExtractQuery.setEndDate(string2);
            }
            catch (HdbException hdbException) {
                throw new HdbFailed(this.buildMessage(hdbException));
            }
            arrayList = new ArrayList<HdbData>();
            try {
                int n;
                SigHistoryData sigHistoryData = sigExtractQuery.getSigHistoryData();
                int n2 = (int)sigHistoryData.getRecNumber();
                if (n2 <= 0) break block27;
                long[] lArray = sigHistoryData.extractLongDates();
                long[] lArray2 = new long[n2];
                for (n = 0; n < n2; ++n) {
                    lArray2[n] = lArray[n] * 1000000L;
                }
                n = hdbSigInfo.type;
                switch (n) {
                    case 25: {
                        short[] sArray = ((ShortScalarHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbShort hdbShort = new HdbShort(n, sArray[i]);
                            hdbShort.setDataTime(lArray2[i]);
                            arrayList.add(hdbShort);
                        }
                        break;
                    }
                    case 5: {
                        long[] lArray3 = ((LongScalarHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbLong64 hdbLong64 = new HdbLong64(n, lArray3[i]);
                            hdbLong64.setDataTime(lArray2[i]);
                            arrayList.add(hdbLong64);
                        }
                        break;
                    }
                    case 17: {
                        float[] fArray = ((FloatScalarHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbFloat hdbFloat = new HdbFloat(n, fArray[i]);
                            hdbFloat.setDataTime(lArray2[i]);
                            arrayList.add(hdbFloat);
                        }
                        break;
                    }
                    case 1: {
                        double[] dArray = ((DoubleScalarHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbDouble hdbDouble = new HdbDouble(n, dArray[i]);
                            hdbDouble.setDataTime(lArray2[i]);
                            arrayList.add(hdbDouble);
                        }
                        break;
                    }
                    case 13: {
                        String[] stringArray = ((StringScalarHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbString hdbString = new HdbString(n, stringArray[i]);
                            hdbString.setDataTime(lArray2[i]);
                            arrayList.add(hdbString);
                        }
                        break;
                    }
                    case 11: {
                        byte[][] byArray = ((CharArrayHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbByteArray hdbByteArray = new HdbByteArray(n, byArray[i]);
                            hdbByteArray.setDataTime(lArray2[i]);
                            arrayList.add(hdbByteArray);
                        }
                        break;
                    }
                    case 27: {
                        short[][] sArray = ((ShortArrayHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbShortArray hdbShortArray = new HdbShortArray(n, sArray[i]);
                            hdbShortArray.setDataTime(lArray2[i]);
                            arrayList.add(hdbShortArray);
                        }
                        break;
                    }
                    case 7: {
                        long[][] lArray4 = ((LongArrayHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbLong64Array hdbLong64Array = new HdbLong64Array(n, lArray4[i]);
                            hdbLong64Array.setDataTime(lArray2[i]);
                            arrayList.add(hdbLong64Array);
                        }
                        break;
                    }
                    case 19: {
                        float[][] fArray = ((FloatArrayHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbFloatArray hdbFloatArray = new HdbFloatArray(n, fArray[i]);
                            hdbFloatArray.setDataTime(lArray2[i]);
                            arrayList.add(hdbFloatArray);
                        }
                        break;
                    }
                    case 3: {
                        double[][] dArray = ((DoubleArrayHistoryData)sigHistoryData).extractData();
                        for (int i = 0; i < n2; ++i) {
                            HdbDoubleArray hdbDoubleArray = new HdbDoubleArray(n, dArray[i]);
                            hdbDoubleArray.setDataTime(lArray2[i]);
                            arrayList.add(hdbDoubleArray);
                        }
                        break;
                    }
                }
            }
            catch (HdbException hdbException) {
                throw new HdbFailed(this.buildMessage(hdbException));
            }
        }
        return new HdbDataSet(arrayList);
    }

    @Override
    public HdbSigInfo getSigInfo(String string) throws HdbFailed {
        HdbSigInfo hdbSigInfo = new HdbSigInfo();
        hdbSigInfo.name = string;
        if (!string.startsWith("tango://")) {
            throw new HdbFailed("Fully qualified attribute name expected (eg:tango://nethost/domain/family/member/name)");
        }
        string = string.substring(6).toLowerCase();
        HdbSignal hdbSignal = new HdbSignal();
        hdbSignal.setFullName(string);
        try {
            int n = hdbSignal.getDefinition();
            hdbSigInfo.sigId = Long.toString(hdbSignal.getId());
            switch (hdbSignal.getDataType()) {
                case 1: {
                    throw new HdbFailed("D_BOOLEAN_TYPE not supported");
                }
                case 70: {
                    throw new HdbFailed("D_USHORT_TYPE not supported");
                }
                case 2: {
                    hdbSigInfo.type = 25;
                    break;
                }
                case 71: {
                    throw new HdbFailed("D_ULONG_TYPE not supported");
                }
                case 3: {
                    hdbSigInfo.type = 5;
                    break;
                }
                case 4: {
                    hdbSigInfo.type = 17;
                    break;
                }
                case 5: {
                    hdbSigInfo.type = 1;
                    break;
                }
                case 6: {
                    hdbSigInfo.type = 13;
                    break;
                }
                case 7: {
                    throw new HdbFailed("D_FLOAT_READPOINT not supported");
                }
                case 8: {
                    throw new HdbFailed("D_STATE_FLOAT_READPOINT not supported");
                }
                case 22: {
                    throw new HdbFailed("D_LONG_READPOINT not supported");
                }
                case 23: {
                    throw new HdbFailed("D_DOUBLE_READPOINT not supported");
                }
                case 9: {
                    hdbSigInfo.type = 11;
                    break;
                }
                case 24: {
                    throw new HdbFailed("D_VAR_STRINGARR not supported");
                }
                case 72: {
                    throw new HdbFailed("D_VAR_USHORTARR not supported");
                }
                case 10: {
                    hdbSigInfo.type = 27;
                    break;
                }
                case 69: {
                    throw new HdbFailed("D_VAR_ULONGARR not supported");
                }
                case 11: {
                    hdbSigInfo.type = 7;
                    break;
                }
                case 12: {
                    hdbSigInfo.type = 19;
                    break;
                }
                case 68: {
                    hdbSigInfo.type = 3;
                    break;
                }
                case 25: {
                    throw new HdbFailed("D_VAR_FRPARR not supported");
                }
                case 73: {
                    throw new HdbFailed("D_VAR_SFRPARR not supported");
                }
                case 45: {
                    throw new HdbFailed("D_VAR_LRPARR not supported");
                }
                case 47: {
                    throw new HdbFailed("D_OPAQUE_TYPE not supported");
                }
                default: {
                    throw new HdbFailed("Unknown dataType code " + hdbSignal.getDataType());
                }
            }
            return hdbSigInfo;
        }
        catch (Exception exception) {
            throw new HdbFailed("tacoHDB.HdbSignal.getDefinition() failed.\n" + string + "\n" + exception.getMessage());
        }
    }

    @Override
    public HdbSigParam getLastParam(String string) throws HdbFailed {
        HdbSigParam hdbSigParam = new HdbSigParam();
        try {
            if (string.startsWith("tango://aries/")) {
                string = string.substring(14);
            }
            AttributeProxy attributeProxy = new AttributeProxy(string);
            AttributeInfo attributeInfo = attributeProxy.get_info();
            hdbSigParam.label = attributeInfo.label;
            hdbSigParam.unit = attributeInfo.unit;
            try {
                hdbSigParam.standard_unit = Double.parseDouble(attributeInfo.standard_unit);
            }
            catch (NumberFormatException numberFormatException) {
                hdbSigParam.standard_unit = 1.0;
            }
            try {
                hdbSigParam.display_unit = Double.parseDouble(attributeInfo.display_unit);
            }
            catch (NumberFormatException numberFormatException) {
                hdbSigParam.display_unit = 1.0;
            }
            hdbSigParam.format = attributeInfo.format;
            hdbSigParam.description = attributeInfo.description;
        }
        catch (DevFailed devFailed) {
            throw new HdbFailed("Cannot get parameter for " + string + "\n" + devFailed.errors[0].desc);
        }
        return hdbSigParam;
    }

    @Override
    public ArrayList<HdbSigParam> getParams(String string, String string2, String string3) throws HdbFailed {
        throw new HdbFailed("getParams() not supported on Oracle HDB");
    }

    @Override
    public HdbDataSet findErrors(String string, String string2, String string3) throws HdbFailed {
        return null;
    }

    private String buildMessage(HdbException hdbException) {
        String string = "Class:" + hdbException.getClassName() + "\n" + "Method:" + hdbException.getMethod() + "\n" + hdbException.getMessage() + "\n" + hdbException.getSystemMessage();
        return string;
    }
}

