/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.tango.jhdb.AttributeBrowser;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.HdbSigParam;
import org.tango.jhdb.data.HdbData;
import org.tango.jhdb.data.HdbDataSet;

public class MySQLSchema
extends HdbReader {
    public static final String DEFAULT_DB_URL_PREFIX = "jdbc:mysql://";
    public static final int DEFAULT_DB_PORT = 3306;
    private static final String[] tableNames = new String[]{"", "att_scalar_devdouble_ro", "att_scalar_devdouble_rw", "att_array_devdouble_ro", "att_array_devdouble_rw", "att_scalar_devlong64_ro", "att_scalar_devlong64_rw", "att_array_devlong64_ro", "att_array_devlong64_rw", "", "", "", "", "att_scalar_devstring_ro", "att_scalar_devstring_rw", "att_array_devstring_ro", "att_array_devstring_rw", "att_scalar_devfloat_ro", "att_scalar_devfloat_rw", "att_array_devfloat_ro", "att_array_devfloat_rw", "att_scalar_devuchar_ro", "att_scalar_devuchar_rw", "att_array_devuchar_ro", "att_array_devuchar_rw", "att_scalar_devshort_ro", "att_scalar_devshort_rw", "att_array_devshort_ro", "att_array_devshort_rw", "att_scalar_devushort_ro", "att_scalar_devushort_rw", "att_array_devushort_ro", "att_array_devushort_rw", "att_scalar_devlong_ro", "att_scalar_devlong_rw", "att_array_devlong_ro", "att_array_devlong_rw", "att_scalar_devulong_ro", "att_scalar_devulong_rw", "att_array_devulong_ro", "att_array_devulong_rw", "att_scalar_devstate_ro", "att_scalar_devstate_rw", "att_array_devstate_ro", "att_array_devstate_rw", "att_scalar_devboolean_ro", "att_scalar_devboolean_rw", "att_array_devboolean_ro", "att_array_devboolean_rw", "att_scalar_devencoded_ro", "att_scalar_devencoded_rw", "att_array_devencoded_ro", "att_array_devencoded_rw", "att_scalar_devulong64_ro", "att_scalar_devulong64_rw", "att_array_devulong64_ro", "att_array_devulong64_rw"};
    private static final int PROGRESS_NBROW = 10000;
    private Connection connection;
    private AttributeBrowser browser = null;
    private String dbURL;

    public MySQLSchema(String string, String string2, String string3, String string4, short s) throws HdbFailed {
        Object object;
        if ((string == null || string.isEmpty()) && ((string = System.getenv("HDB_MYSQL_HOST")) == null || string.isEmpty())) {
            throw new HdbFailed("host input parameter cannot be null if HDB_MYSQL_HOST variable is not defined");
        }
        if ((string3 == null || string3.isEmpty()) && ((string3 = System.getenv("HDB_USER")) == null || string3.isEmpty())) {
            string3 = "hdbreader";
        }
        if ((string4 == null || string4.isEmpty()) && ((string4 = System.getenv("HDB_PASSWORD")) == null || string4.isEmpty())) {
            string4 = "R3aderP4ss";
        }
        if ((string2 == null || string2.isEmpty()) && ((string2 = System.getenv("HDB_NAME")) == null || string2.isEmpty())) {
            string2 = "hdb";
        }
        if (s == 0) {
            object = System.getenv("HDB_MYSQL_PORT");
            if (object == null || string4.isEmpty()) {
                s = (short)3306;
            } else {
                try {
                    s = (short)Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new HdbFailed("Invalid HDB_MYSQL_PORT variable " + numberFormatException.getMessage());
                }
            }
        }
        try {
            object = new Properties();
            ((Properties)object).setProperty("user", string3);
            ((Properties)object).setProperty("password", string4);
            ((Properties)object).setProperty("loginTimeout", Integer.toString(10));
            ((Properties)object).setProperty("tcpKeepAlive ", "true");
            this.dbURL = DEFAULT_DB_URL_PREFIX + string + ":" + Integer.toString(s) + "/" + string2;
            this.connection = DriverManager.getConnection(this.dbURL, (Properties)object);
        }
        catch (SQLException sQLException) {
            throw new HdbFailed("Failed to connect to MySQL: " + sQLException.getMessage());
        }
    }

    @Override
    public String getInfo() throws HdbFailed {
        String string = String.format("%.1f", 1.1);
        String string2 = "MySQL HDB++ API v" + string + "\n";
        String string3 = "URL:" + this.dbURL;
        return string2 + string3;
    }

    @Override
    public String[] getAttributeList() throws HdbFailed {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "SELECT att_name FROM att_conf ORDER BY att_name";
        try {
            stringArray = this.connection.createStatement(1003, 1007);
            ResultSet resultSet = stringArray.executeQuery(string);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            stringArray.close();
        }
        catch (SQLException sQLException) {
            throw new HdbFailed("Failed to retrieve attribute list: " + sQLException.getMessage());
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private void constructBrowser() throws HdbFailed {
        if (this.browser == null) {
            this.browser = AttributeBrowser.constructBrowser(this);
        }
    }

    @Override
    public String[] getHosts() throws HdbFailed {
        this.constructBrowser();
        return this.browser.getHosts();
    }

    @Override
    public String[] getDomains(String string) throws HdbFailed {
        this.constructBrowser();
        return this.browser.getDomains(string);
    }

    @Override
    public String[] getFamilies(String string, String string2) throws HdbFailed {
        this.constructBrowser();
        return this.browser.getFamilies(string, string2);
    }

    @Override
    public String[] getMembers(String string, String string2, String string3) throws HdbFailed {
        this.constructBrowser();
        return this.browser.getMembers(string, string2, string3);
    }

    @Override
    public String[] getNames(String string, String string2, String string3, String string4) throws HdbFailed {
        this.constructBrowser();
        return this.browser.getNames(string, string2, string3, string4);
    }

    @Override
    public HdbSigInfo getSigInfo(String string) throws HdbFailed {
        HdbSigInfo hdbSigInfo = new HdbSigInfo();
        hdbSigInfo.name = string;
        String string2 = "SELECT att_conf.att_conf_id,att_conf_data_type.data_type FROM att_conf,att_conf_data_type WHERE att_conf.att_conf_data_type_id=att_conf_data_type.att_conf_data_type_id AND att_name='" + string + "'";
        try {
            Statement statement = this.connection.createStatement(1003, 1007);
            ResultSet resultSet = statement.executeQuery(string2);
            if (!resultSet.next()) {
                throw new HdbFailed("Signal not found");
            }
            hdbSigInfo.sigId = resultSet.getString(1);
            hdbSigInfo.type = HdbSigInfo.typeFromName(resultSet.getString(2));
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new HdbFailed("Failed to retrieve signal id: " + sQLException.getMessage());
        }
        return hdbSigInfo;
    }

    @Override
    HdbDataSet getDataFromDB(HdbSigInfo hdbSigInfo, String string, String string2) throws HdbFailed {
        if (hdbSigInfo == null) {
            throw new HdbFailed("sigInfo input parameters is null");
        }
        this.checkDates(string, string2);
        if (HdbSigInfo.isArrayType(hdbSigInfo.type)) {
            return this.getArrayData(hdbSigInfo.type, hdbSigInfo.sigId, string, string2);
        }
        return this.getScalarData(hdbSigInfo.type, hdbSigInfo.sigId, string, string2);
    }

    @Override
    public HdbSigParam getLastParam(String string) throws HdbFailed {
        HdbSigInfo hdbSigInfo = this.getSigInfo(string);
        String string2 = "SELECT recv_time,insert_time,label,unit,standard_unit,display_unit,format,archive_rel_change,archive_abs_change,archive_period,description FROM att_parameter  WHERE att_conf_id='" + hdbSigInfo.sigId + "'" + " ORDER BY recv_time DESC limit 1";
        HdbSigParam hdbSigParam = new HdbSigParam();
        try {
            Statement statement = this.connection.createStatement(1003, 1007);
            ResultSet resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                hdbSigParam.recvTime = this.timeValue(resultSet.getTimestamp(1));
                hdbSigParam.insertTime = this.timeValue(resultSet.getTimestamp(2));
                hdbSigParam.label = resultSet.getString(3);
                hdbSigParam.unit = resultSet.getString(4);
                try {
                    hdbSigParam.standard_unit = Double.parseDouble(resultSet.getString(5));
                }
                catch (NumberFormatException numberFormatException) {
                    hdbSigParam.standard_unit = 1.0;
                }
                try {
                    hdbSigParam.display_unit = Double.parseDouble(resultSet.getString(6));
                }
                catch (NumberFormatException numberFormatException) {
                    hdbSigParam.display_unit = 1.0;
                }
            } else {
                throw new HdbFailed("Cannot get parameter for " + string);
            }
            hdbSigParam.format = resultSet.getString(7);
            hdbSigParam.archive_rel_change = resultSet.getString(8);
            hdbSigParam.archive_abs_change = resultSet.getString(9);
            hdbSigParam.archive_period = resultSet.getString(10);
            hdbSigParam.description = resultSet.getString(11);
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new HdbFailed("Failed to get parameter history: " + sQLException.getMessage());
        }
        return hdbSigParam;
    }

    @Override
    public ArrayList<HdbSigParam> getParams(String string, String string2, String string3) throws HdbFailed {
        this.checkDates(string2, string3);
        HdbSigInfo hdbSigInfo = this.getSigInfo(string);
        String string4 = "SELECT recv_time,insert_time,label,unit,standard_unit,display_unit,format,archive_rel_change,archive_abs_change,archive_period,description FROM att_parameter  WHERE att_conf_id='" + hdbSigInfo.sigId + "'" + " AND recv_time>='" + this.toDBDate(string2) + "'" + " AND recv_time<='" + this.toDBDate(string3) + "'" + " ORDER BY recv_time ASC";
        ArrayList<HdbSigParam> arrayList = new ArrayList<HdbSigParam>();
        try {
            Statement statement = this.connection.createStatement(1003, 1007);
            ResultSet resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                HdbSigParam hdbSigParam = new HdbSigParam();
                hdbSigParam.recvTime = this.timeValue(resultSet.getTimestamp(1));
                hdbSigParam.insertTime = this.timeValue(resultSet.getTimestamp(2));
                hdbSigParam.label = resultSet.getString(3);
                hdbSigParam.unit = resultSet.getString(4);
                try {
                    hdbSigParam.standard_unit = Double.parseDouble(resultSet.getString(5));
                }
                catch (NumberFormatException numberFormatException) {
                    hdbSigParam.standard_unit = 1.0;
                }
                try {
                    hdbSigParam.display_unit = Double.parseDouble(resultSet.getString(6));
                }
                catch (NumberFormatException numberFormatException) {
                    hdbSigParam.display_unit = 1.0;
                }
                hdbSigParam.format = resultSet.getString(7);
                hdbSigParam.archive_rel_change = resultSet.getString(8);
                hdbSigParam.archive_abs_change = resultSet.getString(9);
                hdbSigParam.archive_period = resultSet.getString(10);
                hdbSigParam.description = resultSet.getString(11);
                arrayList.add(hdbSigParam);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new HdbFailed("Failed to get parameter history: " + sQLException.getMessage());
        }
        return arrayList;
    }

    @Override
    public HdbDataSet findErrors(String string, String string2, String string3) throws HdbFailed {
        throw new HdbFailed("Not implemented");
    }

    private HdbDataSet getArrayData(int n, String string, String string2, String string3) throws HdbFailed {
        Object object;
        Object object2;
        String string4;
        boolean bl = HdbSigInfo.isRWType(n);
        int n2 = 0;
        if (this.hasProgressListener()) {
            string4 = "SELECT count(*) FROM " + tableNames[n] + " WHERE att_conf_id='" + string + "'" + " AND data_time>='" + this.toDBDate(string2) + "'" + " AND data_time<='" + this.toDBDate(string3) + "'";
            try {
                object2 = this.connection.createStatement(1003, 1007);
                object = object2.executeQuery(string4);
                object.next();
                n2 = object.getInt(1);
                object2.close();
            }
            catch (SQLException sQLException) {
                throw new HdbFailed("Failed to get data: " + sQLException.getMessage());
            }
        }
        object2 = bl ? ",value_w" : "";
        string4 = "SELECT data_time,recv_time,insert_time,att_error_desc.error_desc as error_desc,quality,idx,value_r" + (String)object2 + " FROM " + tableNames[n] + " left outer join att_error_desc on " + tableNames[n] + ".att_error_desc_id = att_error_desc.att_error_desc_id" + " WHERE att_conf_id='" + string + "'" + " AND data_time>='" + this.toDBDate(string2) + "'" + " AND data_time<='" + this.toDBDate(string3) + "'" + " ORDER BY data_time,idx ASC";
        object = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = null;
        if (bl) {
            arrayList2 = new ArrayList<Object>();
        }
        try {
            HdbData hdbData;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            String string5 = null;
            int n3 = 0;
            int n4 = 0;
            boolean bl2 = false;
            Statement statement = this.connection.createStatement(1003, 1007);
            statement.setFetchSize(Integer.MIN_VALUE);
            ResultSet resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                l2 = this.timeValue(resultSet.getTimestamp(1));
                if (l != l2) {
                    if (bl2) {
                        hdbData = HdbData.createData(n);
                        hdbData.parse(l, l3, l4, string5, n3, arrayList, arrayList2);
                        ((ArrayList)object).add(hdbData);
                    }
                    l3 = this.timeValue(resultSet.getTimestamp(2));
                    l4 = this.timeValue(resultSet.getTimestamp(3));
                    string5 = resultSet.getString(4);
                    n3 = resultSet.getInt(5);
                    bl2 = true;
                    arrayList.clear();
                    if (bl) {
                        arrayList2.clear();
                    }
                    l = l2;
                }
                arrayList.add(resultSet.getString(7));
                if (bl) {
                    arrayList2.add(resultSet.getString(8));
                }
                if (this.hasProgressListener() && n4 % 10000 == 0) {
                    this.fireProgressListener((double)n4 / (double)n2);
                }
                ++n4;
            }
            if (bl2) {
                hdbData = HdbData.createData(n);
                hdbData.parse(l, l3, l4, string5, n3, arrayList, arrayList2);
                ((ArrayList)object).add(hdbData);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new HdbFailed("Failed to get data: " + sQLException.getMessage());
        }
        return new HdbDataSet((ArrayList<HdbData>)object);
    }

    private HdbDataSet getScalarData(int n, String string, String string2, String string3) throws HdbFailed {
        boolean bl;
        Object object;
        String string4;
        int n2 = 0;
        if (this.hasProgressListener()) {
            string4 = "SELECT count(*) FROM " + tableNames[n] + " WHERE att_conf_id='" + string + "'" + " AND data_time>='" + this.toDBDate(string2) + "'" + " AND data_time<='" + this.toDBDate(string3) + "'";
            try {
                Statement statement = this.connection.createStatement(1003, 1007);
                object = statement.executeQuery(string4);
                object.next();
                n2 = object.getInt(1);
                statement.close();
            }
            catch (SQLException sQLException) {
                throw new HdbFailed("Failed to get data: " + sQLException.getMessage());
            }
        }
        object = (bl = HdbSigInfo.isRWType(n)) ? ",value_w" : "";
        string4 = "SELECT data_time,recv_time,insert_time, att_error_desc.error_desc as error_desc,quality,value_r" + (String)object + " FROM " + tableNames[n] + " left outer join att_error_desc on " + tableNames[n] + ".att_error_desc_id = att_error_desc.att_error_desc_id" + " WHERE att_conf_id='" + string + "'" + " AND data_time>'" + this.toDBDate(string2) + "'" + " AND data_time<'" + this.toDBDate(string3) + "'" + " ORDER BY data_time ASC";
        ArrayList<HdbData> arrayList = new ArrayList<HdbData>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = null;
        if (bl) {
            arrayList3 = new ArrayList<Object>();
        }
        int n3 = 0;
        try {
            Statement statement = this.connection.createStatement(1003, 1007);
            statement.setFetchSize(Integer.MIN_VALUE);
            ResultSet resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                HdbData hdbData = HdbData.createData(n);
                arrayList2.clear();
                arrayList2.add(resultSet.getString(6));
                if (bl) {
                    arrayList3.clear();
                    arrayList3.add(resultSet.getString(7));
                }
                hdbData.parse(this.timeValue(resultSet.getTimestamp(1)), this.timeValue(resultSet.getTimestamp(2)), this.timeValue(resultSet.getTimestamp(3)), resultSet.getString(4), resultSet.getInt(5), arrayList2, arrayList3);
                arrayList.add(hdbData);
                if (this.hasProgressListener() && n3 % 10000 == 0) {
                    this.fireProgressListener((double)n3 / (double)n2);
                }
                ++n3;
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new HdbFailed("Failed to get data: " + sQLException.getMessage());
        }
        return new HdbDataSet(arrayList);
    }

    private long timeValue(Timestamp timestamp) {
        long l = timestamp.getTime();
        l /= 1000L;
        long l2 = timestamp.getNanos();
        l *= 1000000L;
        return l += (l2 /= 1000L);
    }

    private String toDBDate(String string) {
        return string.substring(6, 10) + "-" + string.substring(3, 5) + "-" + string.substring(0, 2) + " " + string.substring(11, 19);
    }
}

