/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb;

import java.text.SimpleDateFormat;
import org.tango.jhdb.CassandraSchema;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.MySQLSchema;
import org.tango.jhdb.OracleSchema;
import org.tango.jhdb.data.HdbDataSet;

public class Hdb {
    public static final SimpleDateFormat hdbDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static final double LIB_RELEASE = 1.1;
    public static final int HDB_CASSANDRA = 1;
    public static final int HDB_MYSQL = 2;
    public static final int HDB_ORACLE = 3;
    private int hdbType = 0;
    private static final String[] hdbNames = new String[]{"No DB", "Cassandra", "MySQL", "Oracle"};
    private HdbReader schema;

    public HdbReader getReader() {
        return this.schema;
    }

    public int getDBType() {
        return this.hdbType;
    }

    public String getDBTypeName() {
        return hdbNames[this.hdbType];
    }

    public void connectMySQL(String string, String string2, String string3, String string4, short s) throws HdbFailed {
        this.hdbType = 2;
        this.schema = new MySQLSchema(string, string2, string3, string4, s);
    }

    public void connectMySQL() throws HdbFailed {
        this.hdbType = 2;
        this.schema = new MySQLSchema(null, null, null, null, 0);
    }

    public void connectCassandra(String[] stringArray, String string, String string2, String string3) throws HdbFailed {
        this.hdbType = 1;
        this.schema = new CassandraSchema(stringArray, string, string2, string3);
    }

    public void connectCassandra() throws HdbFailed {
        this.hdbType = 1;
        this.schema = new CassandraSchema(null, null, null, null);
    }

    public void connectOracle() throws HdbFailed {
        this.hdbType = 3;
        this.schema = new OracleSchema();
    }

    public void connect() throws HdbFailed {
        String string = System.getenv("HDB_TYPE");
        if (string == null || string.isEmpty()) {
            throw new HdbFailed("HDB_TYPE variable not defined");
        }
        if (string.equalsIgnoreCase("MYSQL")) {
            this.connectMySQL(null, null, null, null, (short)0);
        } else if (string.equalsIgnoreCase("CASSANDRA")) {
            this.connectCassandra(null, null, null, null);
        } else if (string.equalsIgnoreCase("ORACLE")) {
            this.connectOracle();
        } else {
            throw new HdbFailed("Wrong HDB_TYPE , MYSQL or CASSANDRA expected");
        }
    }

    public static void test(Hdb hdb, String string, String string2, String string3) throws HdbFailed {
        System.out.print("\n--------> " + string3 + " ");
        HdbDataSet hdbDataSet = hdb.getReader().getData(string3, string, string2);
        String string4 = "";
        if (hdbDataSet.size() > 0) {
            string4 = HdbSigInfo.typeStr[hdbDataSet.get(0).getType()];
        }
        System.out.println("(" + hdbDataSet.size() + " records) " + string4);
        for (int i = 0; i < hdbDataSet.size() && i < 10; ++i) {
            System.out.println("  Rec #" + i + " :" + hdbDataSet.get(i));
        }
    }

    public static void main(String[] stringArray) {
        Hdb hdb = new Hdb();
        try {
            hdb.connectCassandra();
            long l = System.currentTimeMillis();
            String[] stringArray2 = hdb.getReader().getAttributeList();
            long l2 = System.currentTimeMillis();
            System.out.println("Got " + stringArray2.length + " attributes in " + (l2 - l) + "ms");
        }
        catch (HdbFailed hdbFailed) {
            System.out.println(hdbFailed.getMessage());
        }
        System.exit(0);
    }
}

