/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.diagnostics;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.Utils;

public class SubscriberCommand {
    private List<Subscriber> subscribers;

    private SubscriberCommand(DeviceProxy configuratorProxy) throws DevFailed {
        SubscriberMap subscriberMap = new SubscriberMap(configuratorProxy);
        this.subscribers = subscriberMap.getSubscriberList();
    }

    private void executeCommand(String commandName) throws Exception {
        String errorMessage = "";
        for (Subscriber subscriber : this.subscribers) {
            try {
                subscriber.command_inout(commandName);
            }
            catch (DevFailed e) {
                errorMessage = errorMessage + subscriber.getLabel() + ": " + e.errors[0].desc + "\n";
            }
        }
        if (!errorMessage.isEmpty()) {
            throw new Exception(errorMessage);
        }
    }

    private void saveEventNumber(String fileName) throws Exception {
        String code;
        String errorMessage = "";
        long totalEvents = 0L;
        long totalAttributes = 0L;
        for (Subscriber subscriber : this.subscribers) {
            try {
                int[] nbEvents;
                DeviceAttribute attribute = subscriber.read_attribute("AttributeEventNumberList");
                if (attribute.hasFailed()) continue;
                for (int nb : nbEvents = attribute.extractLongArray()) {
                    totalEvents += (long)nb;
                    ++totalAttributes;
                }
            }
            catch (DevFailed e) {
                errorMessage = errorMessage + subscriber.getLabel() + ": " + e.errors[0].desc + "\n";
            }
        }
        System.out.println("Total events:   " + totalEvents + "/" + totalAttributes);
        try {
            code = Utils.readFile(fileName);
        }
        catch (DevFailed e) {
            code = "Date\tEvents Received\tNb Attributes\n";
        }
        code = code + SubscriberCommand.formatDate(System.currentTimeMillis()) + "\t" + totalEvents + "\t" + totalAttributes + "\n";
        Utils.writeFile(fileName, code);
        if (!errorMessage.isEmpty()) {
            throw new Exception(errorMessage);
        }
    }

    public static String formatDate(long t) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yy  HH:mm:ss");
        return simpleDateFormat.format(new Date(t));
    }

    public static void main(String[] args) {
        block8: {
            if (args.length > 0) {
                try {
                    SubscriberCommand subscriberCommand = new SubscriberCommand(Utils.getConfiguratorProxy());
                    String commandName = args[0];
                    if (commandName.equals("-save")) {
                        if (args.length > 1) {
                            String fileName = args[1];
                            subscriberCommand.saveEventNumber(fileName);
                        } else {
                            System.err.println("File name expected");
                        }
                        break block8;
                    }
                    subscriberCommand.executeCommand(commandName);
                }
                catch (Exception e) {
                    if (e instanceof DevFailed) {
                        System.err.println(new Date() + ":");
                        Except.print_exception((Exception)e);
                        break block8;
                    }
                    System.err.println(new Date() + ":\n  " + e);
                }
            } else {
                System.err.println("Command name expected");
            }
        }
        System.exit(0);
    }
}

