/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.diagnostics;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;

public class StatisticsDialog
extends JDialog {
    private List<HdbAttribute> filteredHdbAttributes;
    private List<HdbAttribute> hdbAttributes;
    private JTable table;
    private DataTableModel model;
    private TablePopupMenu popupMenu = new TablePopupMenu();
    private ArrayList<Subscriber> subscribers;
    private int selectedRow = -1;
    private int selectedColumn = 1;
    private String subscriberName = null;
    private long resetTime = 0L;
    private long readTime = 0L;
    private long sinceReset = 0L;
    private static List<String> defaultTangoHosts;
    private static JFileChooser fileChooser;
    private static final int[] columnWidth;
    private static final String[] columnNames;
    private static final int ATTRIBUTE_NAME = 0;
    private static final int EVENTS_RESET = 1;
    private static final int PERIOD_RESET = 2;
    private static final int EVENTS_STAT = 3;
    private static final int PERIOD_STAT = 4;
    private JTextField filterTextField;
    private JMenuItem readHdbItem;
    private JMenuItem resetItem;
    private JLabel titleLabel;
    private static final int STATUS = 0;
    private static final int READ_HDB = 1;
    private static final int CONFIGURE = 2;
    private static final int TEST_EVENT = 3;
    private static final int COPY_ATTR = 4;
    private static final int OFFSET = 2;
    private static String[] menuLabels;

    public StatisticsDialog(JFrame parent, SubscriberMap subscriberMap, int statisticsTimeWindow) throws DevFailed {
        super((Frame)parent, false);
        SplashUtils.getInstance().startSplash();
        try {
            defaultTangoHosts = TangoUtils.getDefaultTangoHostList();
            this.initComponents();
            this.subscribers = (ArrayList)subscriberMap.getSubscriberList();
            this.finalizeConstruction(statisticsTimeWindow, "All Subscribers ", true);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            throw e;
        }
        SplashUtils.getInstance().stopSplash();
    }

    public StatisticsDialog(JFrame parent, Subscriber subscriber, int statisticsTimeWindow, long resetTime) throws DevFailed {
        super((Frame)parent, false);
        this.resetTime = resetTime;
        if (resetTime > 0L) {
            this.sinceReset = System.currentTimeMillis() - resetTime;
        }
        SplashUtils.getInstance().startSplash();
        try {
            defaultTangoHosts = TangoUtils.getDefaultTangoHostList();
            this.initComponents();
            this.subscriberName = subscriber.getLabel();
            this.subscribers = new ArrayList(1);
            this.subscribers.add(subscriber);
            this.finalizeConstruction(statisticsTimeWindow, "Subscriber " + subscriber.getLabel(), false);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            throw e;
        }
        SplashUtils.getInstance().stopSplash();
    }

    private void finalizeConstruction(int statisticsTimeWindow, String title, boolean allowReset) throws DevFailed {
        try {
            this.buildRecords();
        }
        catch (DevFailed e) {
            if (this.subscribers.size() == 1) {
                throw e;
            }
            SplashUtils.getInstance().stopSplash();
            ErrorPane.showErrorMessage((Component)this, (String)"Read Subscribe Failed", (DevFailed)e);
        }
        this.updateColumnNames(statisticsTimeWindow);
        this.buildTableComponent();
        this.setTitle(title);
        this.displayTitle();
        this.resetItem.setVisible(allowReset);
        String s = System.getProperty("HDB_TYPE");
        this.readHdbItem.setVisible(s != null && !s.isEmpty());
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void updateColumnNames(int statisticsTimeWindow) {
        StatisticsDialog.columnNames[3] = "Ev./" + Utils.strPeriod(statisticsTimeWindow);
    }

    public static String formatResetTime(long ms) {
        StringTokenizer st = new StringTokenizer(new Date(ms).toString());
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String month = (String)list.get(1);
        String day = (String)list.get(2);
        String time = (String)list.get(3);
        return day + ' ' + month + ' ' + time;
    }

    private void displayTitle() {
        String title = this.subscriberName == null ? "Statistics on " + this.subscribers.size() + " subscribers  -  " : this.subscriberName + " - ";
        if (this.filteredHdbAttributes.size() != this.hdbAttributes.size()) {
            title = title + Integer.toString(this.filteredHdbAttributes.size()) + " filtered / ";
        }
        title = title + Integer.toString(this.hdbAttributes.size()) + " Attributes";
        if (this.resetTime > 0L) {
            title = title + " - Reset: " + StatisticsDialog.formatResetTime(this.resetTime);
        }
        this.titleLabel.setText(title);
        if (this.sinceReset > 0L) {
            String text = "<table>\n<tr><td> Reset done </td><td> " + StatisticsDialog.formatResetTime(this.resetTime) + " </td></tr>\n" + "<tr><td>Statistics read </td><td> " + StatisticsDialog.formatResetTime(this.readTime) + " </td></tr>\n" + "<tr><td>Duration </td><td> " + Utils.strPeriod((double)this.sinceReset / 1000.0) + " </td></tr>\n" + "</table>";
            this.titleLabel.setToolTipText(Utils.buildTooltip(text));
            this.table.getTableHeader().setToolTipText(Utils.buildTooltip(text));
        }
    }

    private void buildRecords() throws DevFailed {
        String[] statAttributeNames = new String[]{"AttributeList", "AttributeRecordFreqList", "AttributeEventNumberList"};
        StringBuilder errorMessage = new StringBuilder();
        this.hdbAttributes = new ArrayList<HdbAttribute>();
        for (Subscriber subscriber : this.subscribers) {
            try {
                SplashUtils.getInstance().increaseSplashProgressForLoop(this.subscribers.size(), "Reading " + subscriber.getLabel());
                DeviceAttribute[] deviceAttributes = subscriber.read_attribute(statAttributeNames);
                int i = 0;
                String[] hdbAttributeNames = new String[]{};
                if (!deviceAttributes[i].hasFailed()) {
                    hdbAttributeNames = deviceAttributes[i].extractStringArray();
                }
                double[] frequencies = new double[]{};
                if (!deviceAttributes[++i].hasFailed()) {
                    frequencies = deviceAttributes[i].extractDoubleArray();
                }
                int[] eventNumbers = new int[]{};
                if (!deviceAttributes[++i].hasFailed()) {
                    eventNumbers = deviceAttributes[i].extractLongArray();
                }
                int duration = subscriber.getStatisticsTimeWindow();
                for (int x = 0; x < hdbAttributeNames.length && x < frequencies.length && x < eventNumbers.length; ++x) {
                    this.hdbAttributes.add(new HdbAttribute(hdbAttributeNames[x], frequencies[x], eventNumbers[x], subscriber, duration));
                }
            }
            catch (DevFailed e) {
                errorMessage.append(e.errors[0].desc).append("\n");
            }
        }
        this.readTime = System.currentTimeMillis();
        Collections.sort(this.hdbAttributes, new AttributeComparator());
        this.filteredHdbAttributes = new ArrayList<HdbAttribute>();
        this.filteredHdbAttributes.addAll(this.hdbAttributes);
        if (errorMessage.length() > 0) {
            Except.throw_exception((String)"ReadSubscriberFailed", (String)errorMessage.toString());
        }
    }

    private void buildTableComponent() throws DevFailed {
        try {
            this.model = new DataTableModel();
            this.table = new JTable(this.model){

                @Override
                public String getToolTipText(MouseEvent e) {
                    String tip = null;
                    if (this.isVisible()) {
                        Point p = e.getPoint();
                        int column = this.columnAtPoint(p);
                        int row = this.rowAtPoint(p);
                        if (column == 0) {
                            HdbAttribute attribute = (HdbAttribute)StatisticsDialog.this.filteredHdbAttributes.get(row);
                            tip = Utils.buildTooltip(attribute.name);
                        }
                    }
                    return tip;
                }
            };
            this.table.setRowSelectionAllowed(true);
            this.table.setColumnSelectionAllowed(true);
            this.table.setDragEnabled(false);
            this.table.setSelectionMode(0);
            this.table.getTableHeader().setFont(new Font("Dialog", 1, 12));
            this.table.setDefaultRenderer(String.class, new LabelCellRenderer());
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    StatisticsDialog.this.tableActionPerformed(evt);
                }
            });
            this.table.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    StatisticsDialog.this.tableHeaderActionPerformed(evt);
                }
            });
            JScrollPane scrollPane = new JScrollPane(this.table);
            this.model.fireTableDataChanged();
            this.getContentPane().add((Component)scrollPane, "Center");
            Enumeration<TableColumn> columnEnum = this.table.getColumnModel().getColumns();
            int i = 0;
            int width = 0;
            while (columnEnum.hasMoreElements()) {
                width += columnWidth[i];
                TableColumn tableColumn = columnEnum.nextElement();
                tableColumn.setPreferredWidth(columnWidth[i++]);
            }
            this.pack();
            int height = this.table.getHeight();
            if (height > 800) {
                height = 800;
            }
            scrollPane.setPreferredSize(new Dimension(width, height + 20));
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)e.toString());
        }
    }

    private void tableHeaderActionPerformed(MouseEvent event) {
        this.selectedColumn = this.table.getTableHeader().columnAtPoint(new Point(event.getX(), event.getY()));
        Collections.sort(this.filteredHdbAttributes, new AttributeComparator());
    }

    private void tableActionPerformed(MouseEvent event) {
        int row;
        Point clickedPoint = new Point(event.getX(), event.getY());
        this.selectedRow = row = this.table.rowAtPoint(clickedPoint);
        this.table.repaint();
        if (event.getClickCount() == 2) {
            JOptionPane.showMessageDialog(this, this.filteredHdbAttributes.get(row).getInfo());
        } else {
            int mask = event.getModifiers();
            if ((mask & 4) != 0) {
                this.popupMenu.showMenu(event, this.filteredHdbAttributes.get(row));
            }
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.filterTextField = new JTextField();
        JButton applyButton = new JButton();
        JMenuBar jMenuBar1 = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem saveItem = new JMenuItem();
        this.resetItem = new JMenuItem();
        JMenuItem dismissItem = new JMenuItem();
        JMenu viewMenu = new JMenu();
        JMenuItem updateItem = new JMenuItem();
        this.readHdbItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StatisticsDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        jLabel1.setFont(new Font("Dialog", 1, 12));
        jLabel1.setText("Filter:   ");
        bottomPanel.add(jLabel1);
        this.filterTextField.setColumns(25);
        this.filterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsDialog.this.filterTextFieldActionPerformed(evt);
            }
        });
        bottomPanel.add(this.filterTextField);
        applyButton.setText("Apply");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsDialog.this.applyButtonActionPerformed(evt);
            }
        });
        bottomPanel.add(applyButton);
        this.getContentPane().add((Component)bottomPanel, "South");
        fileMenu.setText("File");
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        saveItem.setText("Save in text file");
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsDialog.this.saveItemActionPerformed(evt);
            }
        });
        fileMenu.add(saveItem);
        this.resetItem.setText("Reset Event Counters");
        this.resetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsDialog.this.resetItemActionPerformed(evt);
            }
        });
        fileMenu.add(this.resetItem);
        dismissItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        dismissItem.setText("Dismiss");
        dismissItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsDialog.this.dismissItemActionPerformed(evt);
            }
        });
        fileMenu.add(dismissItem);
        jMenuBar1.add(fileMenu);
        viewMenu.setText("View");
        updateItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        updateItem.setText("Update");
        updateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsDialog.this.updateItemActionPerformed(evt);
            }
        });
        viewMenu.add(updateItem);
        this.readHdbItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.readHdbItem.setText("Read attribute from HDB");
        this.readHdbItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsDialog.this.readHdbItemActionPerformed(evt);
            }
        });
        viewMenu.add(this.readHdbItem);
        jMenuBar1.add(viewMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void dismissItemActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.applyFilter();
    }

    private void filterTextFieldActionPerformed(ActionEvent evt) {
        this.applyFilter();
    }

    private void resetItemActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Reset event counter on all archivers ?", "Reset Counters", 2) == 0) {
            StringBuilder errorMessage = new StringBuilder();
            for (Subscriber subscriber : this.subscribers) {
                try {
                    subscriber.command_inout("ResetStatistics");
                }
                catch (DevFailed e) {
                    errorMessage.append(subscriber.getLabel()).append(": ").append(e.errors[0].desc).append("\n");
                }
            }
            if (errorMessage.length() > 0) {
                JOptionPane.showMessageDialog(this, errorMessage.toString(), "Reset Failed", 0);
            }
            this.updateItemActionPerformed(null);
        }
    }

    private void updateItemActionPerformed(ActionEvent evt) {
        try {
            this.resetTime = this.subscribers.get(0).getStatisticsResetTime();
            if (this.resetTime > 0L) {
                this.sinceReset = System.currentTimeMillis() - this.resetTime;
            }
            this.buildRecords();
            this.model.fireTableDataChanged();
            this.displayTitle();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Update", (DevFailed)e);
        }
    }

    private void saveItemActionPerformed(ActionEvent evt) {
        File file;
        if (fileChooser == null) {
            fileChooser = new JFileChooser(new File("").getAbsolutePath());
            fileChooser.setDialogType(1);
            fileChooser.setDialogTitle("Save as text");
        }
        if (fileChooser.showOpenDialog(this) == 0 && (file = fileChooser.getSelectedFile()) != null) {
            String filename = file.getAbsolutePath();
            this.saveDataToFile(filename);
        }
    }

    private void saveDataToFile(String fileName) {
        StringBuilder sb = new StringBuilder();
        for (String s : columnNames) {
            sb.append(s).append('\t');
        }
        sb.trimToSize();
        sb.append('\n');
        for (HdbAttribute hdbAttribute : this.filteredHdbAttributes) {
            sb.append(hdbAttribute.shortName).append('\t').append(hdbAttribute.nbStatistics).append('\t').append(hdbAttribute.averagePeriodString).append('\t').append(hdbAttribute.nbEvents).append('\n');
        }
        try {
            Utils.writeFile(fileName, sb.toString());
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)("Saving " + fileName), (DevFailed)e);
        }
    }

    private void readHdbItemActionPerformed(ActionEvent evt) {
        if (this.selectedRow < 0) {
            Utils.popupError(this, "No attribute selected !");
            return;
        }
        HdbAttribute attribute = this.filteredHdbAttributes.get(this.selectedRow);
        System.out.println("Display " + attribute.name);
        try {
            Utils.startHdbViewer(attribute.name);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.toString(), (DevFailed)e);
        }
    }

    private void applyFilter() {
        String filter = this.filterTextField.getText();
        this.filteredHdbAttributes = new ArrayList<HdbAttribute>();
        for (HdbAttribute hdbAttribute : this.hdbAttributes) {
            if (!hdbAttribute.shortName.contains(filter)) continue;
            this.filteredHdbAttributes.add(hdbAttribute);
        }
        this.model.fireTableDataChanged();
        this.displayTitle();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    static {
        fileChooser = null;
        columnWidth = new int[]{300, 100, 80, 100, 80};
        columnNames = new String[]{"Attribute Names", "Ev. since reset", "Av.Period.", "Events", "Av.Period."};
        menuLabels = new String[]{"Status", "Read attribute from HDB", "Configure Polling/Events", "Test Event", "Copy attribute name"};
    }

    private class AttributeComparator
    implements Comparator<HdbAttribute> {
        private AttributeComparator() {
        }

        @Override
        public int compare(HdbAttribute hdbAttribute1, HdbAttribute hdbAttribute2) {
            switch (StatisticsDialog.this.selectedColumn) {
                case 3: {
                    return this.valueSort(hdbAttribute2.nbStatistics, hdbAttribute1.nbStatistics);
                }
                case 4: {
                    return this.valueSort(hdbAttribute1.averagePeriod, hdbAttribute2.averagePeriod);
                }
                case 1: {
                    return this.valueSort(hdbAttribute2.nbEvents, hdbAttribute1.nbEvents);
                }
                case 2: {
                    return this.valueSort(hdbAttribute1.resetPeriod, hdbAttribute2.resetPeriod);
                }
            }
            return this.alphabeticalSort(hdbAttribute1.shortName, hdbAttribute2.shortName);
        }

        private int alphabeticalSort(String s1, String s2) {
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }

        private int valueSort(double d1, double d2) {
            if (d1 == d2) {
                return 0;
            }
            if (d1 < 0.0) {
                return 1;
            }
            if (d2 < 0.0) {
                return -1;
            }
            return d1 > d2 ? 1 : -1;
        }
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private JLabel title = new JLabel();
        private HdbAttribute selectedAttribute;

        private TablePopupMenu() {
            this.title.setFont(new Font("Dialog", 1, 12));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TablePopupMenu.this.menuActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
            String s = System.getenv("HDB_TYPE");
            this.getComponent(3).setVisible(s != null && !s.isEmpty());
        }

        private void showMenu(MouseEvent event, HdbAttribute hdbAttribute) {
            this.title.setText(hdbAttribute.shortName);
            this.selectedAttribute = hdbAttribute;
            this.getComponent(5).setVisible(false);
            this.getComponent(4).setEnabled(hdbAttribute.useDefaultTangoHost);
            this.show(StatisticsDialog.this.table, event.getX(), event.getY());
        }

        private void menuActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int itemIndex = -1;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                itemIndex = i;
            }
            switch (itemIndex) {
                case 0: {
                    JOptionPane.showMessageDialog(this, this.selectedAttribute.getInfo());
                    break;
                }
                case 2: {
                    this.selectedAttribute.configureEvent();
                    break;
                }
                case 1: {
                    StatisticsDialog.this.readHdbItemActionPerformed(null);
                    break;
                }
                case 3: {
                    Utils.getTestEvents().add(this.selectedAttribute.name);
                    break;
                }
                case 4: {
                    if (this.selectedAttribute == null) break;
                    Utils.copyToClipboard(this.selectedAttribute.name);
                }
            }
        }
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(this.getBackground(row, column));
            switch (column) {
                case 0: {
                    this.setText(((HdbAttribute)StatisticsDialog.this.filteredHdbAttributes.get(row)).shortName);
                    break;
                }
                case 3: {
                    this.setText(Integer.toString(((HdbAttribute)StatisticsDialog.this.filteredHdbAttributes.get(row)).nbStatistics));
                    break;
                }
                case 4: {
                    this.setText(((HdbAttribute)StatisticsDialog.this.filteredHdbAttributes.get(row)).averagePeriodString);
                    break;
                }
                case 1: {
                    this.setText(Integer.toString(((HdbAttribute)StatisticsDialog.this.filteredHdbAttributes.get(row)).nbEvents));
                    break;
                }
                case 2: {
                    this.setText(((HdbAttribute)StatisticsDialog.this.filteredHdbAttributes.get(row)).resetPeriodString);
                }
            }
            return this;
        }

        private Color getBackground(int row, int column) {
            switch (column) {
                case 0: {
                    return Utils.firstColumnBackground;
                }
            }
            if (StatisticsDialog.this.selectedRow >= 0 && row == StatisticsDialog.this.selectedRow) {
                return Utils.selectionBackground;
            }
            return Color.white;
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return StatisticsDialog.this.filteredHdbAttributes.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            String title = columnIndex >= this.getColumnCount() ? columnNames[this.getColumnCount() - 1] : columnNames[columnIndex];
            if (title.startsWith("tango://")) {
                int index = title.indexOf(47, "tango://".length());
                title = title.substring(index + 1);
            }
            return title;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return "";
        }

        public Class getColumnClass(int column) {
            if (StatisticsDialog.this.isVisible()) {
                return this.getValueAt(0, column).getClass();
            }
            return null;
        }
    }

    private class HdbAttribute {
        private String name;
        private String shortName;
        private int nbStatistics;
        private int nbEvents;
        private int duration;
        private String averagePeriodString;
        private double averagePeriod = -1.0;
        private Subscriber subscriber;
        private String deviceName;
        private String tangoHost;
        private double resetPeriod;
        private String resetPeriodString;
        private boolean useDefaultTangoHost = false;

        private HdbAttribute(String name, double frequency, int nbEvents, Subscriber subscriber, int duration) {
            this.name = name;
            this.shortName = TangoUtils.getOnlyDeviceName(name);
            this.nbStatistics = (int)frequency;
            this.nbEvents = nbEvents;
            this.subscriber = subscriber;
            this.duration = duration;
            if (frequency > 0.0) {
                this.averagePeriod = (double)duration / frequency;
                this.averagePeriodString = Utils.strPeriod(this.averagePeriod);
            } else {
                this.averagePeriodString = "---";
            }
            if (StatisticsDialog.this.resetTime > 0L && StatisticsDialog.this.sinceReset > 0L && nbEvents > 0) {
                this.resetPeriod = (double)StatisticsDialog.this.sinceReset / (double)nbEvents;
                this.resetPeriodString = Utils.strPeriod(this.resetPeriod / 1000.0);
            } else {
                this.resetPeriodString = "---";
            }
            this.deviceName = this.shortName.substring(0, this.shortName.lastIndexOf(47));
            this.tangoHost = TangoUtils.getOnlyTangoHost(name);
            for (String defaultTangoHost : defaultTangoHosts) {
                if (!this.tangoHost.equals(defaultTangoHost)) continue;
                this.useDefaultTangoHost = true;
            }
        }

        private String getInfo() {
            String host = null;
            String server = null;
            String attributeStatus = null;
            try {
                String deviceName = this.name.substring(0, this.name.lastIndexOf(47));
                DeviceProxy deviceProxy = new DeviceProxy(deviceName);
                DeviceInfo info = deviceProxy.get_info();
                host = info.hostname;
                server = info.server;
                attributeStatus = this.subscriber.getAttributeStatus(this.name);
            }
            catch (DevFailed e) {
                Except.print_exception((Exception)((Object)e));
            }
            catch (Exception e) {
                // empty catch block
            }
            StringBuilder sb = new StringBuilder(this.name + "\n");
            if (server != null) {
                sb.append("    - Server   ").append(server).append("\n");
            }
            if (host != null) {
                sb.append("    - registered on   ").append(host).append("\n");
            }
            sb.append("\nArchived by ").append(this.subscriber.getLabel());
            sb.append("    (").append(this.subscriber.getName()).append(")\n");
            sb.append(this.nbStatistics).append(" events during ").append(Utils.strPeriod(this.duration)).append("\n");
            sb.append(this.nbEvents).append(" Since last reset : ").append(StatisticsDialog.formatResetTime(StatisticsDialog.this.resetTime)).append("\n");
            sb.append("    - during ").append(Utils.strPeriod((double)StatisticsDialog.this.sinceReset / 1000.0));
            if (attributeStatus != null) {
                sb.append("\n\n----------------------- Attribute Status --------------------------\n");
                sb.append(attributeStatus);
            }
            return sb.toString();
        }

        private void configureEvent() {
            Utils.startJiveForDevice(this.deviceName);
        }

        public String toString() {
            return this.shortName + ":\t" + this.nbEvents;
        }
    }
}

