/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.diagnostics;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;

public class ServerInfoTable
extends JDialog {
    private JFrame parent;
    private JTable table;
    private List<ServerInfo> serverInfoList = new ArrayList<ServerInfo>();
    private static final String[] columnNames = new String[]{"Device", "Server", "Host", "Uptime"};
    private int[] columnWidth;
    private int selectedRow = -1;
    private ServerPopupMenu popupMenu = new ServerPopupMenu();
    private HashMap<String, String> subscriberLabels = null;
    private static final int DEVICE_LABEL = 0;
    private static final int SERVER_NAME = 1;
    private static final int SERVER_HOST = 2;
    private static final int SERVER_UPTIME = 3;
    private static final int START_SERVER = 0;
    private static final int STOP_SERVER = 1;
    private static final int TEST_DEVICE = 2;
    private static final int OFFSET = 2;
    private static String[] menuLabels = new String[]{"Start Server", "Stop Server", "Test Subscriber device"};

    public ServerInfoTable(JFrame parent) throws DevFailed {
        super((Frame)parent, true);
        SplashUtils.getInstance().startSplash();
        SplashUtils.getInstance().setSplashProgress(10, "Building GUI");
        this.parent = parent;
        this.initComponents();
        SplashUtils.getInstance().setSplashProgress(10, "Building Archiver objects");
        List<String> subscriberDeviceNames = this.getSubscriberDeviceNames();
        int i = 0;
        for (String subscriberDeviceName : subscriberDeviceNames) {
            this.serverInfoList.add(new ServerInfo(this.getLabel(subscriberDeviceName), subscriberDeviceName, i++ == 0));
        }
        Collections.sort(this.serverInfoList, new ServerComparator());
        this.computeColumnWidth();
        this.buildTable();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        SplashUtils.getInstance().stopSplash();
    }

    private List<String> getSubscriberDeviceNames() throws DevFailed {
        DeviceProxy configuratorProxy = Utils.getConfiguratorProxy();
        DeviceAttribute attribute = configuratorProxy.read_attribute("ArchiverList");
        String[] archivers = attribute.extractStringArray();
        ArrayList<String> list = new ArrayList<String>();
        list.add(configuratorProxy.name());
        list.addAll(Arrays.asList(archivers));
        return list;
    }

    private String getLabel(String subscriberDeviceName) {
        String deviceName;
        String label;
        if (this.subscriberLabels == null) {
            this.initializeSubscriberLabels();
        }
        if ((label = this.subscriberLabels.get(deviceName = TangoUtils.getOnlyDeviceName(subscriberDeviceName))) == null) {
            return subscriberDeviceName.substring(deviceName.lastIndexOf(47) + 1);
        }
        return label;
    }

    private void initializeSubscriberLabels() {
        this.subscriberLabels = new HashMap();
        String[] properties = new String[]{};
        try {
            DbDatum datum = ApiUtil.get_db_obj().get_property("HdbConfigurator", "ArchiverLabels");
            if (!datum.is_empty()) {
                properties = datum.extractStringArray();
            }
        }
        catch (DevFailed e) {
            System.err.println(e.toString());
        }
        for (String property : properties) {
            StringTokenizer stk = new StringTokenizer(property, ":");
            if (stk.countTokens() != 2) continue;
            String deviceName = stk.nextToken().trim();
            String label = stk.nextToken().trim();
            this.subscriberLabels.put(deviceName, label);
        }
    }

    private void computeColumnWidth() {
        this.columnWidth = new int[columnNames.length];
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> servers = new ArrayList<String>();
        ArrayList<String> hosts = new ArrayList<String>();
        ArrayList<String> uptime = new ArrayList<String>();
        for (ServerInfo serverInfo : this.serverInfoList) {
            labels.add(serverInfo.label);
            servers.add(serverInfo.serverName);
            hosts.add(serverInfo.host);
            uptime.add(serverInfo.uptime);
        }
        this.columnWidth[0] = Utils.getTableColumnWidth(labels);
        this.columnWidth[1] = Utils.getTableColumnWidth(servers) + 10;
        this.columnWidth[2] = Utils.getTableColumnWidth(hosts);
        this.columnWidth[3] = Utils.getTableColumnWidth(uptime);
    }

    private void buildTable() {
        DataTableModel model = new DataTableModel();
        this.table = new JTable(model);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setDragEnabled(false);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setFont(new Font("Dialog", 1, 14));
        this.table.setDefaultRenderer(String.class, new LabelCellRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                ServerInfoTable.this.tableActionPerformed(event);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.getContentPane().add((Component)scrollPane, "Center");
        Enumeration<TableColumn> columnEnum = this.table.getColumnModel().getColumns();
        int i = 0;
        int width = 0;
        while (columnEnum.hasMoreElements()) {
            width += this.columnWidth[i];
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(this.columnWidth[i++]);
        }
        this.pack();
        int height = this.table.getHeight();
        if (height > 800) {
            height = 800;
        }
        scrollPane.setPreferredSize(new Dimension(width, height + 40));
    }

    private void tableActionPerformed(MouseEvent event) {
        this.selectedRow = this.table.rowAtPoint(new Point(event.getX(), event.getY()));
        if ((event.getModifiers() & 4) != 0) {
            this.popupMenu.showMenu(event);
        }
        this.table.repaint();
    }

    public void setSelection(String selection) {
        int row = 0;
        for (ServerInfo serverInfo : this.serverInfoList) {
            if (serverInfo.label.equals(selection) || serverInfo.serverName.equals(selection)) {
                this.selectedRow = row;
            }
            ++row;
        }
        this.repaint();
    }

    private void testSelectedDevice() {
        try {
            TangoUtils.testDevice(this, this.serverInfoList.get(this.selectedRow).deviceName);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ServerInfoTable.this.closeDialog(evt);
            }
        });
        titleLabel.setFont(new Font("Dialog", 1, 18));
        titleLabel.setText("Information on HDB++ Servers");
        topPanel.add(titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerInfoTable.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            for (ServerInfo serverInfo : this.serverInfoList) {
                serverInfo.runThread = false;
            }
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        UIManager.put("ToolTip.foreground", new ColorUIResource(Color.black));
        UIManager.put("ToolTip.background", new ColorUIResource(Utils.toolTipBackground));
        try {
            new ServerInfoTable(null).setVisible(true);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    private class ServerComparator
    implements Comparator<ServerInfo> {
        private ServerComparator() {
        }

        @Override
        public int compare(ServerInfo serverInfo1, ServerInfo serverInfo2) {
            if (serverInfo1.configurator) {
                return -1;
            }
            if (serverInfo2.configurator) {
                return 1;
            }
            return this.alphabeticalSort(serverInfo1.label, serverInfo2.label);
        }

        private int alphabeticalSort(String s1, String s2) {
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(this.getBackground(row, column));
            ServerInfo serverInfo = (ServerInfo)ServerInfoTable.this.serverInfoList.get(row);
            this.setIcon(null);
            this.setToolTipText(null);
            switch (column) {
                case 0: {
                    this.setToolTipText(serverInfo.deviceName);
                    this.setText(serverInfo.label);
                    break;
                }
                case 1: {
                    this.setIcon(serverInfo.getStateIcon());
                    this.setText(serverInfo.serverName);
                    break;
                }
                case 2: {
                    this.setText(serverInfo.host);
                    break;
                }
                case 3: {
                    this.setText(serverInfo.uptime);
                }
            }
            if (serverInfo.configurator) {
                this.setFont(new Font("Dialog", 1, 14));
            } else {
                this.setFont(new Font("Dialog", 0, 12));
            }
            return this;
        }

        private Color getBackground(int row, int column) {
            if (row == ServerInfoTable.this.selectedRow) {
                return Utils.selectionBackground;
            }
            if (((ServerInfo)ServerInfoTable.this.serverInfoList.get(row)).configurator) {
                return Utils.firstColumnBackground;
            }
            switch (column) {
                case 0: {
                    return Utils.firstColumnBackground;
                }
            }
            return Color.white;
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ServerInfoTable.this.serverInfoList.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            String title = columnIndex >= this.getColumnCount() ? columnNames[this.getColumnCount() - 1] : columnNames[columnIndex];
            if (title.startsWith("tango://")) {
                int index = title.indexOf(47, "tango://".length());
                title = title.substring(index + 1);
            }
            return title;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return "";
        }

        public Class getColumnClass(int column) {
            if (ServerInfoTable.this.isVisible()) {
                return this.getValueAt(0, column).getClass();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private class ServerPopupMenu
    extends JPopupMenu {
        private JLabel title = new JLabel();

        private ServerPopupMenu() {
            this.title.setFont(new Font("Dialog", 1, 12));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ServerPopupMenu.this.menuActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        private void showMenu(MouseEvent event) {
            ServerInfo serverInfo = (ServerInfo)ServerInfoTable.this.serverInfoList.get(ServerInfoTable.this.selectedRow);
            this.title.setText("  " + serverInfo.label);
            this.getComponent(2).setVisible(!serverInfo.alive);
            this.getComponent(3).setVisible(serverInfo.alive);
            this.show(ServerInfoTable.this.table, event.getX(), event.getY());
        }

        private void menuActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int itemIndex = -1;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                itemIndex = i;
            }
            ServerInfo serverInfo = (ServerInfo)ServerInfoTable.this.serverInfoList.get(ServerInfoTable.this.selectedRow);
            try {
                switch (itemIndex) {
                    case 0: {
                        serverInfo.startServer();
                        break;
                    }
                    case 1: {
                        if (JOptionPane.showConfirmDialog(this, "Stop  " + serverInfo.label + " ?", "Confirm", 2) != 0) break;
                        serverInfo.stopServer();
                        break;
                    }
                    case 2: {
                        ServerInfoTable.this.testSelectedDevice();
                    }
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private class ServerInfo {
        private String label;
        private String deviceName;
        private DeviceProxy adminProxy;
        private String serverName = " - - - ";
        private String uptime = " - - - ";
        private String host = " - - - ";
        private boolean configurator;
        private boolean alive = false;
        private boolean runThread = true;

        private ServerInfo(String name, String deviceName, boolean configurator) {
            this.label = configurator ? "ES Manager" : name;
            this.deviceName = deviceName;
            this.configurator = configurator;
            try {
                String serverInfo = new DeviceProxy(deviceName).get_info().toString();
                this.serverName = this.getInfo(serverInfo, "Server:");
                this.uptime = this.getInfo(serverInfo, "last_exported:");
                this.host = this.getInfo(serverInfo, "host:");
            }
            catch (DevFailed e) {
                System.err.println(e.toString());
            }
            new StateThread().start();
        }

        private String getInfo(String serverInfo, String target) {
            int end;
            int start = serverInfo.indexOf(target);
            if (start > 0 && (end = serverInfo.indexOf("\n", start += target.length())) > 0) {
                String str = serverInfo.substring(start, end).trim();
                if (target.equals("host:")) {
                    int idx = str.indexOf("(");
                    if (idx > 0) {
                        str = str.substring(0, idx).trim();
                    }
                    if ((idx = str.indexOf(46)) > 0) {
                        str = str.substring(0, idx);
                    }
                }
                return str;
            }
            System.out.println(serverInfo);
            return target + ": not found";
        }

        private void startServer() throws DevFailed {
            DeviceData argIn = new DeviceData();
            argIn.insert(this.serverName);
            new DeviceProxy("tango/admin/" + this.host).command_inout("DevStart", argIn);
        }

        private void stopServer() throws DevFailed {
            this.adminProxy.command_inout("kill");
        }

        private ImageIcon getStateIcon() {
            try {
                if (this.alive) {
                    return Utils.getGreenBall();
                }
                return Utils.getRedBall();
            }
            catch (DevFailed e) {
                return null;
            }
        }

        private class StateThread
        extends Thread {
            private StateThread() {
            }

            @Override
            public void run() {
                while (ServerInfo.this.runThread) {
                    boolean running;
                    try {
                        if (ServerInfo.this.adminProxy == null) {
                            ServerInfo.this.adminProxy = new DeviceProxy("dserver/" + ServerInfo.this.serverName);
                        }
                        ServerInfo.this.adminProxy.ping();
                        running = true;
                    }
                    catch (DevFailed e) {
                        running = false;
                    }
                    if (ServerInfoTable.this.table == null) {
                        ServerInfo.this.alive = running;
                    } else if (running != ServerInfo.this.alive) {
                        ServerInfo.this.alive = running;
                        ServerInfoTable.this.table.repaint();
                    }
                    try {
                        StateThread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

