/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.diagnostics;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.tango.hdb_configurator.atktable.TableScalarViewer;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.HdbConfigurator;
import org.tango.hdb_configurator.diagnostics.AtkMoniDialog;
import org.tango.hdb_configurator.diagnostics.AttributesTableDialog;
import org.tango.hdb_configurator.diagnostics.DistributionDialog;
import org.tango.hdb_configurator.diagnostics.FaultyAttributesDialog;
import org.tango.hdb_configurator.diagnostics.ServerInfoTable;
import org.tango.hdb_configurator.diagnostics.StatisticsDialog;

public class HdbDiagnostics
extends JFrame {
    private DeviceProxy configuratorProxy;
    private SubscriberMap subscriberMap;
    private SubscriberMenu subscriberMenu = new SubscriberMenu();
    private List<String> labels;
    private TableScalarViewer subscriberTableViewer;
    private JFrame parent;
    private int statisticsTimeWindow;
    private long statisticsResetTime;
    private boolean buildSubscriberMap;
    private ServerInfoTable serverInfoTable = null;
    private HdbConfigurator hdbConfigurator = null;
    private static final String[] ATTRIBUTES = new String[]{"AttributeNokNumber", "AttributeStartedNumber", "AttributePausedNumber", "AttributeStoppedNumber", "AttributePendingNumber", "AttributeRecordFreq", "AttributeFailureFreq", "Context"};
    private static final String[] columnNames = new String[]{"Faulty", "Started", "Paused", "Stopped", "Pending", "Freq.", "Failures", "Context"};
    private static final int[] columnWiths = new int[]{60, 60, 60, 60, 60, 60, 60, 80};
    private JLabel titleLabel;
    private static final int FAULTY_ATTRIBUTES = 0;
    private static final int STARTED_ATTRIBUTES = 1;
    private static final int PAUSED_ATTRIBUTES = 2;
    private static final int STOPPED_ATTRIBUTES = 3;
    private static final int PENDING_ATTRIBUTES = 4;
    private static final int RECORD_FREQUENCY = 5;
    private static final int CONFIGURE_ARCHIVER = 7;
    private static final int SERVER_STATUS = 8;
    private static final int STOP_FAULTY = 9;
    private static final int COPY_DEVICE_NAME = 10;
    private static final int TEST_ARCHIVER = 11;
    private static final int TEST_CONFIGURATOR = 12;
    private static final int OFFSET = 3;
    private static final int FAILURE_FREQUENCY = 6;
    private static final int CONTEXT = 7;
    private static String[] menuLabels = new String[]{"Faulty  Attributes", "Started Attributes", "Paused Attributes", "Stopped Attributes", "Pending Attributes", "Record Frequency", null, "Configure Archiver", "Server Status", "Stop Faulty Attributes", "Copy device name", "Test  Archiver", "Test  Configurator"};

    public HdbDiagnostics(JFrame parent) throws DevFailed {
        this(parent, null);
        if (parent instanceof HdbConfigurator) {
            this.hdbConfigurator = (HdbConfigurator)parent;
        }
    }

    public HdbDiagnostics(JFrame parent, SubscriberMap subscriberMap) throws DevFailed {
        this.parent = parent;
        this.subscriberMap = subscriberMap;
        SplashUtils.getInstance().startSplash();
        SplashUtils.getInstance().increaseSplashProgress(10, "Building GUI");
        this.setTitle(Utils.getInstance().getApplicationName());
        this.buildSubscriberMap = subscriberMap == null;
        this.initComponents();
        this.initOwnComponents();
        if (this.buildSubscriberMap) {
            String title = this.titleLabel.getText();
            String archiveName = TangoUtils.getArchiveName(this.configuratorProxy);
            if (!archiveName.isEmpty()) {
                title = title + "  (" + archiveName + ")";
                this.titleLabel.setText(title);
                String s = System.getenv("HdbExtraction");
                if (s != null && s.equals("true")) {
                    System.setProperty("HDB_TYPE", archiveName);
                }
            }
        } else {
            this.titleLabel.setText("HDB++ Subscribers");
        }
        ImageIcon icon = Utils.getInstance().getIcon("hdb++.gif", 0.75);
        this.titleLabel.setIcon(icon);
        this.setIconImage(icon.getImage());
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        SplashUtils.getInstance().stopSplash();
    }

    private void initOwnComponents() throws DevFailed {
        if (this.buildSubscriberMap) {
            this.configuratorProxy = Utils.getConfiguratorProxy();
            this.subscriberMap = Utils.getSubscriberMap(this.configuratorProxy.name(), true);
            if (this.subscriberMap.size() == 0) {
                SplashUtils.getInstance().stopSplash();
                ErrorPane.showErrorMessage((Component)this, null, (Exception)new Exception("No subscriber registered for manager " + this.configuratorProxy.name()));
                System.exit(0);
            }
        }
        this.labels = this.subscriberMap.getLabelList();
        ArrayList<String> deviceNames = new ArrayList<String>();
        for (String label : this.labels) {
            deviceNames.add(TangoUtils.getOnlyDeviceName(this.subscriberMap.getSubscriberByLabel((String)label).name));
        }
        if (this.labels.size() > 0) {
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel(this.labels.get(0));
            this.statisticsTimeWindow = subscriber.getStatisticsTimeWindow();
            HdbDiagnostics.columnNames[5] = "ev/";
            HdbDiagnostics.columnNames[6] = "Fail./";
            if (this.statisticsTimeWindow == 1) {
                columnNames[5] = columnNames[5] + "sec";
                columnNames[6] = columnNames[6] + "sec";
            } else {
                columnNames[5] = columnNames[5] + Utils.strPeriod(this.statisticsTimeWindow);
                columnNames[6] = columnNames[6] + Utils.strPeriod(this.statisticsTimeWindow);
            }
            this.statisticsResetTime = subscriber.getStatisticsResetTime();
        }
        ArrayList<String[]> attributeNames = new ArrayList<String[]>();
        for (String deviceName : deviceNames) {
            String[] line = new String[ATTRIBUTES.length];
            int i = 0;
            for (String attribute : ATTRIBUTES) {
                line[i++] = deviceName + '/' + attribute;
            }
            attributeNames.add(line);
        }
        this.subscriberTableViewer = new TableScalarViewer(this.labels, columnNames, attributeNames, columnWiths);
        this.subscriberTableViewer.setPanelTitleVisible(false);
        this.subscriberTableViewer.getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HdbDiagnostics.this.subscriberTableActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.subscriberTableViewer, "Center");
        if (this.buildSubscriberMap && this.subscriberMap.size() > 1) {
            String[] line = new String[ATTRIBUTES.length];
            int i = 0;
            for (String attribute : ATTRIBUTES) {
                line[i++] = TangoUtils.getConfiguratorDeviceName() + '/' + attribute;
            }
            ArrayList<String[]> managerAttributes = new ArrayList<String[]>();
            managerAttributes.add(line);
            ArrayList<String> rows = new ArrayList<String>();
            rows.add("E.S.  Manager");
            TableScalarViewer managerTableViewer = new TableScalarViewer(rows, columnNames, managerAttributes, columnWiths);
            managerTableViewer.setPanelTitleVisible(false);
            managerTableViewer.setTableFont(new Font("Dialog", 1, 14));
            managerTableViewer.getJTable().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    HdbDiagnostics.this.managerTableActionPerformed(evt);
                }
            });
            this.getContentPane().add((Component)managerTableViewer, "South");
        }
    }

    private void managerTableActionPerformed(MouseEvent evt) {
        int column = this.subscriberTableViewer.getJTable().columnAtPoint(new Point(evt.getX(), evt.getY()));
        if (column == 8 && evt.getClickCount() == 2) {
            try {
                this.manageConfiguratorContext();
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
            }
        }
    }

    private void manageConfiguratorContext() throws DevFailed {
        String context = this.configuratorProxy.read_attribute("Context").extractString();
        Strategy strategy = Strategy.getContextsFromDB();
        Object[] strategyNames = strategy.getNames();
        context = (String)JOptionPane.showInputDialog(this, "Context ? ", "Selection", 3, null, strategyNames, context);
        if (context != null) {
            DeviceAttribute deviceAttribute = new DeviceAttribute("Context");
            deviceAttribute.insert(context);
            this.configuratorProxy.write_attribute(deviceAttribute);
        }
    }

    private void subscriberTableActionPerformed(MouseEvent evt) {
        int mask = evt.getModifiers();
        int row = this.subscriberTableViewer.getJTable().rowAtPoint(new Point(evt.getX(), evt.getY()));
        int column = this.subscriberTableViewer.getJTable().columnAtPoint(new Point(evt.getX(), evt.getY()));
        String label = this.labels.get(row);
        if (label.toLowerCase().contains("manager")) {
            return;
        }
        try {
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel(label);
            if (evt.getClickCount() == 2 && (mask & 0x10) != 0) {
                if (column > 0) {
                    this.showAttributes(subscriber, column - 1);
                }
            } else if ((mask & 4) != 0 && column == 0) {
                this.subscriberMenu.showMenu(evt, label, subscriber);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JPanel titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        JSeparator jSeparator1 = new JSeparator();
        JScrollPane jScrollPane1 = new JScrollPane();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitItem = new JMenuItem();
        JMenu viewMenu = new JMenu();
        JMenuItem statisticsItem = new JMenuItem();
        JMenuItem distributionItem = new JMenuItem();
        JMenuItem frequencyTrendItem = new JMenuItem();
        JMenuItem attributeErrorsItem = new JMenuItem();
        JMenuItem serverInformationItem = new JMenuItem();
        JMenuItem viewerAtkErrorItem = new JMenuItem();
        JMenuItem viewerAtkDiagnosticsItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HdbDiagnostics.this.exitForm(evt);
            }
        });
        topPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("HDB++ Diagnostics");
        titlePanel.add(this.titleLabel);
        topPanel.add((Component)titlePanel, "First");
        topPanel.add((Component)jSeparator1, "Last");
        this.getContentPane().add((Component)topPanel, "North");
        this.getContentPane().add((Component)jScrollPane1, "Center");
        fileMenu.setMnemonic('F');
        fileMenu.setText("File");
        exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        exitItem.setMnemonic('E');
        exitItem.setText("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbDiagnostics.this.exitItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
        viewMenu.setMnemonic('V');
        viewMenu.setText("View");
        statisticsItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        statisticsItem.setMnemonic('S');
        statisticsItem.setText("Statistics");
        statisticsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbDiagnostics.this.statisticsItemActionPerformed(evt);
            }
        });
        viewMenu.add(statisticsItem);
        distributionItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        distributionItem.setMnemonic('D');
        distributionItem.setText("Distribution");
        distributionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbDiagnostics.this.distributionItemActionPerformed(evt);
            }
        });
        viewMenu.add(distributionItem);
        frequencyTrendItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        frequencyTrendItem.setMnemonic('F');
        frequencyTrendItem.setText("Frequency Trend");
        frequencyTrendItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbDiagnostics.this.frequencyTrendItemActionPerformed(evt);
            }
        });
        viewMenu.add(frequencyTrendItem);
        attributeErrorsItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        attributeErrorsItem.setMnemonic('A');
        attributeErrorsItem.setText("Attribute Errors");
        attributeErrorsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbDiagnostics.this.attributeErrorsItemActionPerformed(evt);
            }
        });
        viewMenu.add(attributeErrorsItem);
        serverInformationItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        serverInformationItem.setMnemonic('I');
        serverInformationItem.setText("Server information");
        serverInformationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbDiagnostics.this.serverInformationItemActionPerformed(evt);
            }
        });
        viewMenu.add(serverInformationItem);
        viewerAtkErrorItem.setMnemonic('E');
        viewerAtkErrorItem.setText("ATK Viewer Errors");
        viewerAtkErrorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbDiagnostics.this.viewerAtkErrorItemActionPerformed(evt);
            }
        });
        viewMenu.add(viewerAtkErrorItem);
        viewerAtkDiagnosticsItem.setText("ATK Viewer Diagnostics");
        viewerAtkDiagnosticsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbDiagnostics.this.viewerAtkDiagnosticsItemActionPerformed(evt);
            }
        });
        viewMenu.add(viewerAtkDiagnosticsItem);
        menuBar.add(viewMenu);
        helpMenu.setMnemonic('H');
        helpMenu.setText("help");
        aboutItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        aboutItem.setMnemonic('A');
        aboutItem.setText("About");
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbDiagnostics.this.aboutItemActionPerformed(evt);
            }
        });
        helpMenu.add(aboutItem);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
        this.pack();
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
        String message = "This application is able to display information on HDB event subscribers\n\nPascal Verdier - ESRF - Software Group";
        JOptionPane.showMessageDialog(this, message, "Help Window", 1);
    }

    private void attributeErrorsItemActionPerformed(ActionEvent evt) {
        try {
            new FaultyAttributesDialog((JFrame)this, this.subscriberMap).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void viewerAtkErrorItemActionPerformed(ActionEvent evt) {
        this.subscriberTableViewer.showErrorHistory();
    }

    private void viewerAtkDiagnosticsItemActionPerformed(ActionEvent evt) {
        try {
            ATKDiagnostic.showDiagnostic();
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
        }
    }

    private void distributionItemActionPerformed(ActionEvent evt) {
        try {
            new DistributionDialog(this, this.subscriberMap).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void statisticsItemActionPerformed(ActionEvent evt) {
        try {
            new StatisticsDialog(this, this.subscriberMap, this.statisticsTimeWindow).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)((JMenuItem)evt.getSource()).getText(), (DevFailed)e);
        }
    }

    private void frequencyTrendItemActionPerformed(ActionEvent evt) {
        try {
            ArrayList<String> attributeNames = new ArrayList<String>();
            if (this.configuratorProxy != null) {
                attributeNames.add(this.configuratorProxy.name() + "/" + ATTRIBUTES[5]);
            }
            for (String label : this.labels) {
                attributeNames.add(TangoUtils.getOnlyDeviceName(this.subscriberMap.getSubscriberByLabel((String)label).name) + "/" + ATTRIBUTES[5]);
            }
            new AtkMoniDialog(this, attributeNames, "HDB storage frequency").setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void serverInformationItemActionPerformed(ActionEvent evt) {
        try {
            if (this.serverInfoTable == null) {
                this.serverInfoTable = new ServerInfoTable(this);
            }
            this.serverInfoTable.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void configureArchiver(Subscriber subscriber) {
        try {
            if (this.hdbConfigurator == null) {
                this.hdbConfigurator = new HdbConfigurator(this, true);
            }
            this.hdbConfigurator.selectArchiver(subscriber.getLabel());
            this.hdbConfigurator.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void stopFaultyAttributes(Subscriber subscriber) {
        try {
            subscriber.command_inout("StopFaulty");
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void showAttributes(Subscriber subscriber, int type) {
        try {
            switch (type) {
                case 1: {
                    if (subscriber.hasAttribute(0)) {
                        new AttributesTableDialog(this, subscriber, 0).setVisible(true);
                    }
                    return;
                }
                case 2: {
                    if (subscriber.hasAttribute(1)) {
                        new AttributesTableDialog(this, subscriber, 1).setVisible(true);
                    }
                    return;
                }
                case 3: {
                    if (subscriber.hasAttribute(2)) {
                        new AttributesTableDialog(this, subscriber, 2).setVisible(true);
                    }
                    return;
                }
                case 0: {
                    String[] attributeList = ArchiverUtils.getAttributeList(subscriber, "Nok");
                    if (attributeList.length > 0) {
                        new FaultyAttributesDialog((JFrame)this, subscriber).setVisible(true);
                    }
                    return;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    new StatisticsDialog(this, subscriber, this.statisticsTimeWindow, this.statisticsResetTime).setVisible(true);
                    return;
                }
                case 7: {
                    Strategy strategy = Strategy.getContextsFromDB(subscriber);
                    Object[] contextNames = strategy.getNames();
                    if (contextNames.length > 2) {
                        String[] tmp = new String[contextNames.length - 1];
                        System.arraycopy(contextNames, 1, tmp, 0, contextNames.length - 1);
                        contextNames = tmp;
                        String context = (String)JOptionPane.showInputDialog(this, "Context ? ", "Selection", 3, null, contextNames, subscriber.getContext());
                        if (context != null) {
                            subscriber.setContext(context);
                        }
                    }
                    return;
                }
                default: {
                    Except.throw_exception((String)"BadOption", (String)(type + " not implemented"));
                    break;
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.toString(), (DevFailed)e);
        }
    }

    private void testDevice(DeviceProxy deviceProxy) {
        try {
            TangoUtils.testDevice(this, deviceProxy.name());
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void serverStatus(Subscriber subscriber) {
        try {
            if (this.serverInfoTable == null) {
                this.serverInfoTable = new ServerInfoTable(this);
            }
            this.serverInfoTable.setSelection(subscriber.getLabel());
            this.serverInfoTable.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void doClose() {
        if (this.parent != null && this.parent.isVisible() || this.hdbConfigurator != null && this.hdbConfigurator.isVisible()) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.put("ToolTip.foreground", new ColorUIResource(Color.black));
            UIManager.put("ToolTip.background", new ColorUIResource(Utils.toolTipBackground));
            new HdbDiagnostics(null).setVisible(true);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    private class SubscriberMenu
    extends JPopupMenu {
        private JLabel subscriberLabel = new JLabel();
        private JLabel subscriberDeviceName;
        private Subscriber selectedSubscriber;

        private SubscriberMenu() {
            this.subscriberLabel.setFont(new Font("Dialog", 1, 16));
            this.add(this.subscriberLabel);
            this.subscriberDeviceName = new JLabel();
            this.add(this.subscriberDeviceName);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        SubscriberMenu.this.hostActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        private void showMenu(MouseEvent event, String label, Subscriber subscriber) {
            this.subscriberLabel.setText(label);
            this.selectedSubscriber = subscriber;
            String deviceName = subscriber.getName();
            if (deviceName.equals(label)) {
                this.subscriberDeviceName.setVisible(false);
            } else {
                this.subscriberDeviceName.setVisible(true);
                this.subscriberDeviceName.setText("(" + deviceName + ")");
            }
            boolean expert = (event.getModifiers() & 2) != 0;
            this.getComponent(12).setVisible(subscriber.hasFaultyAttribute());
            this.getComponent(14).setVisible(expert);
            this.getComponent(15).setVisible(expert);
            this.show(HdbDiagnostics.this.subscriberTableViewer.getJTable(), event.getX(), event.getY());
        }

        private void hostActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int itemIndex = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(3 + i) != obj) continue;
                itemIndex = i;
            }
            switch (itemIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    HdbDiagnostics.this.showAttributes(this.selectedSubscriber, itemIndex);
                    break;
                }
                case 7: {
                    HdbDiagnostics.this.configureArchiver(this.selectedSubscriber);
                    break;
                }
                case 9: {
                    HdbDiagnostics.this.stopFaultyAttributes(this.selectedSubscriber);
                    break;
                }
                case 10: {
                    Utils.copyToClipboard(this.selectedSubscriber.getName());
                    break;
                }
                case 8: {
                    HdbDiagnostics.this.serverStatus(this.selectedSubscriber);
                    break;
                }
                case 11: {
                    HdbDiagnostics.this.testDevice(this.selectedSubscriber);
                    break;
                }
                case 12: {
                    HdbDiagnostics.this.testDevice(HdbDiagnostics.this.configuratorProxy);
                }
            }
        }
    }
}

