/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.diagnostics;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.ManageAttributes;

public class FaultyAttributesDialog
extends JDialog {
    private Component parent;
    private JDialog thisDialog;
    private ArrayList<FaultyAttribute> filteredFaultyAttributes;
    private ArrayList<FaultyAttribute> faultyAttributes;
    private JTable table;
    private DataTableModel model;
    private TablePopupMenu tablePopupMenu = new TablePopupMenu();
    private HeaderPopupMenu headerPopupMenu = new HeaderPopupMenu();
    private Subscriber subscriber;
    private SubscriberMap subscriberMap;
    private int selectedRow = -1;
    private int selectedColumn = 0;
    private static List<String> defaultTangoHosts;
    private static final int[] columnWidth;
    private static final String[] columnNames;
    private static final int ATTRIBUTE_NAME = 0;
    private static final int FAULT_DESCRIPTION = 1;
    private static final int SELECTION = 2;
    private static final Color selectionBackground;
    private static final Color firstColumnBackground;
    private JTextField filterTextField;
    private JLabel titleLabel;
    private static JFileChooser fileChooser;
    private static final int STOP_STORAGE = 0;
    private static final int REMOVE_ATTRIBUTE = 1;
    private static final int SELECT_ALL = 2;
    private static final int UN_SELECT_ALL = 3;
    private static final int COPY_ATTRIBUTE_LIST = 4;
    private static final int SAVE_IN_FILE = 5;
    private static final int OFFSET = 2;
    private static String[] headerMenuLabels;
    private static final int CONFIGURE = 1;
    private static final int COPY_NAME = 2;
    private static final int COPY_MESSAGE = 3;
    private static String[] tableMenuLabels;

    public FaultyAttributesDialog(JFrame parent, SubscriberMap subscriberMap) throws DevFailed {
        super((Frame)parent, false);
        this.subscriberMap = subscriberMap;
        this.parent = parent;
        this.initDialog();
    }

    public FaultyAttributesDialog(JFrame parent, Subscriber subscriber) throws DevFailed {
        super((Frame)parent, false);
        this.subscriber = subscriber;
        this.parent = parent;
        this.initDialog();
    }

    public FaultyAttributesDialog(JDialog parent, Subscriber subscriber) throws DevFailed {
        super((Dialog)parent, true);
        this.subscriber = subscriber;
        this.parent = parent;
        this.initDialog();
    }

    private void initDialog() throws DevFailed {
        this.thisDialog = this;
        SplashUtils.getInstance().startSplash();
        try {
            defaultTangoHosts = TangoUtils.getDefaultTangoHostList();
            this.initComponents();
            this.buildRecords();
            this.buildTableComponent();
            if (this.subscriber != null) {
                this.setTitle(this.subscriber.getLabel());
                this.titleLabel.setText(this.subscriber.getLabel());
            } else {
                this.setTitle("Attributes on Error");
                this.titleLabel.setText("Attributes on Error");
            }
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            throw e;
        }
        SplashUtils.getInstance().stopSplash();
    }

    private void buildRecords() throws DevFailed {
        this.faultyAttributes = new ArrayList();
        if (this.subscriber != null) {
            this.buildRecords(this.subscriber);
        } else {
            List<Subscriber> subscriberList = this.subscriberMap.getSubscriberList();
            StringBuilder errorMessage = new StringBuilder();
            for (Subscriber subscriber : subscriberList) {
                try {
                    this.buildRecords(subscriber);
                }
                catch (DevFailed e) {
                    errorMessage.append(e.errors[0].desc);
                }
            }
            if (errorMessage.length() > 0) {
                Utils.popupError(this, errorMessage.toString());
            }
        }
        this.filteredFaultyAttributes = new ArrayList();
        this.filteredFaultyAttributes.addAll(this.faultyAttributes);
        Collections.sort(this.filteredFaultyAttributes, new AttributeComparator());
    }

    private void buildRecords(Subscriber subscriber) throws DevFailed {
        String[] attributeNames = new String[]{"AttributeList", "AttributeErrorList"};
        List<String[]> list = ArchiverUtils.readStringAttributes(subscriber, attributeNames);
        String[] attributeList = list.get(0);
        String[] errorList = list.get(1);
        for (int i = 0; i < attributeList.length && i < errorList.length; ++i) {
            if (errorList[i].isEmpty()) continue;
            this.faultyAttributes.add(new FaultyAttribute(subscriber, attributeList[i], errorList[i]));
        }
    }

    private void buildTableComponent() throws DevFailed {
        try {
            this.model = new DataTableModel();
            this.table = new JTable(this.model);
            this.table.setRowSelectionAllowed(true);
            this.table.setColumnSelectionAllowed(true);
            this.table.setDragEnabled(false);
            this.table.setSelectionMode(0);
            this.table.getTableHeader().setFont(new Font("Dialog", 1, 12));
            this.table.setDefaultRenderer(String.class, new LabelCellRenderer());
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    FaultyAttributesDialog.this.tableActionPerformed(evt);
                }
            });
            this.table.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    FaultyAttributesDialog.this.tableHeaderActionPerformed(evt);
                }
            });
            JScrollPane scrollPane = new JScrollPane(this.table);
            this.getContentPane().add((Component)scrollPane, "Center");
            Enumeration<TableColumn> columnEnum = this.table.getColumnModel().getColumns();
            int i = 0;
            int width = 0;
            while (columnEnum.hasMoreElements()) {
                width += columnWidth[i];
                TableColumn tableColumn = columnEnum.nextElement();
                tableColumn.setPreferredWidth(columnWidth[i++]);
            }
            this.pack();
            int height = this.table.getHeight();
            if (height > 800) {
                height = 800;
            }
            scrollPane.setPreferredSize(new Dimension(width, height + 20));
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)e.toString());
        }
    }

    private void tableHeaderActionPerformed(MouseEvent event) {
        JTableHeader tableHeader = (JTableHeader)event.getSource();
        this.selectedColumn = tableHeader.columnAtPoint(event.getPoint());
        int mask = event.getModifiers();
        if ((mask & 0x10) != 0) {
            Collections.sort(this.filteredFaultyAttributes, new AttributeComparator());
            this.model.fireTableDataChanged();
        } else if ((mask & 4) != 0) {
            if (this.selectedColumn == 2) {
                this.headerPopupMenu.showMenu(event);
            } else if (this.selectedColumn == 0) {
                this.headerPopupMenu.showMenu(event);
            }
        }
    }

    private void tableActionPerformed(MouseEvent event) {
        int row;
        Point clickedPoint = new Point(event.getX(), event.getY());
        this.selectedRow = row = this.table.rowAtPoint(clickedPoint);
        this.table.repaint();
        int mask = event.getModifiers();
        if ((mask & 0x10) != 0) {
            if (this.table.columnAtPoint(clickedPoint) == 2) {
                FaultyAttribute attribute = this.filteredFaultyAttributes.get(row);
                attribute.selected = !attribute.selected;
            }
        } else if ((mask & 4) != 0) {
            this.tablePopupMenu.showMenu(event, this.filteredFaultyAttributes.get(row));
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel1 = new JLabel();
        this.filterTextField = new JTextField();
        JButton applyButton = new JButton();
        JMenuBar jMenuBar1 = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem updateItem = new JMenuItem();
        JMenuItem dismissItem = new JMenuItem();
        JMenu actionMenu = new JMenu();
        JMenuItem stopArchivingMenuItem = new JMenuItem();
        JMenuItem removeArchivingMenuItem = new JMenuItem();
        JMenuItem selectAllMenuItem = new JMenuItem();
        JMenuItem unSelectAllMenuItem = new JMenuItem();
        JMenu viewMenu = new JMenu();
        JMenuItem summaryItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FaultyAttributesDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        jLabel2.setText("            ");
        topPanel.add(jLabel2);
        jLabel1.setText("Filter:   ");
        topPanel.add(jLabel1);
        this.filterTextField.setColumns(25);
        this.filterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultyAttributesDialog.this.filterTextFieldActionPerformed(evt);
            }
        });
        topPanel.add(this.filterTextField);
        applyButton.setText("Apply");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultyAttributesDialog.this.applyButtonActionPerformed(evt);
            }
        });
        topPanel.add(applyButton);
        this.getContentPane().add((Component)topPanel, "North");
        fileMenu.setText("File");
        updateItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        updateItem.setText("Update");
        updateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultyAttributesDialog.this.updateItemActionPerformed(evt);
            }
        });
        fileMenu.add(updateItem);
        dismissItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        dismissItem.setText("Dismiss");
        dismissItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultyAttributesDialog.this.dismissItemActionPerformed(evt);
            }
        });
        fileMenu.add(dismissItem);
        jMenuBar1.add(fileMenu);
        actionMenu.setMnemonic('A');
        actionMenu.setText("Action");
        stopArchivingMenuItem.setMnemonic('S');
        stopArchivingMenuItem.setText("Stop archiving on selected attributes");
        stopArchivingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultyAttributesDialog.this.stopArchivingMenuItemActionPerformed(evt);
            }
        });
        actionMenu.add(stopArchivingMenuItem);
        removeArchivingMenuItem.setMnemonic('S');
        removeArchivingMenuItem.setText("Remove archiving on selected attributes");
        removeArchivingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultyAttributesDialog.this.removeArchivingMenuItemActionPerformed(evt);
            }
        });
        actionMenu.add(removeArchivingMenuItem);
        selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        selectAllMenuItem.setMnemonic('S');
        selectAllMenuItem.setText("Select all attributes");
        selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultyAttributesDialog.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        actionMenu.add(selectAllMenuItem);
        unSelectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        unSelectAllMenuItem.setMnemonic('U');
        unSelectAllMenuItem.setText("Un Select all attributes");
        unSelectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultyAttributesDialog.this.unSelectAllMenuItemActionPerformed(evt);
            }
        });
        actionMenu.add(unSelectAllMenuItem);
        jMenuBar1.add(actionMenu);
        viewMenu.setText("View");
        summaryItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        summaryItem.setText("Summary");
        summaryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultyAttributesDialog.this.summaryItemActionPerformed(evt);
            }
        });
        viewMenu.add(summaryItem);
        jMenuBar1.add(viewMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void dismissItemActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.applyFilter();
    }

    private void filterTextFieldActionPerformed(ActionEvent evt) {
        this.applyFilter();
    }

    private void summaryItemActionPerformed(ActionEvent evt) {
        ArrayList<AttributeErrorMessage> errorMessages = new ArrayList<AttributeErrorMessage>();
        for (FaultyAttribute faultyAttribute : this.faultyAttributes) {
            AttributeErrorMessage attributeErrorMessage = null;
            for (AttributeErrorMessage errorMessage : errorMessages) {
                if (!errorMessage.message.equals(faultyAttribute.shortFaultDescription)) continue;
                attributeErrorMessage = errorMessage;
            }
            if (attributeErrorMessage == null) {
                attributeErrorMessage = new AttributeErrorMessage(faultyAttribute.shortFaultDescription);
                errorMessages.add(attributeErrorMessage);
            }
            attributeErrorMessage.counter++;
        }
        Collections.sort(errorMessages, new ErrorComparator());
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.faultyAttributes.size())).append(" Attributes on error:\n\n");
        for (AttributeErrorMessage errorMessage : errorMessages) {
            sb.append(Integer.toString(errorMessage.counter)).append(":  ").append(errorMessage.message).append("\n");
        }
        JOptionPane.showMessageDialog(this, sb.toString(), "Attribute Errors", 1);
    }

    private void updateItemActionPerformed(ActionEvent evt) {
        try {
            this.buildRecords();
            this.model.fireTableDataChanged();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Update", (DevFailed)e);
        }
    }

    private void stopArchivingMenuItemActionPerformed(ActionEvent evt) {
        this.stopSelectedAttributes();
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        this.setAttributeSelection(true);
    }

    private void unSelectAllMenuItemActionPerformed(ActionEvent evt) {
        this.setAttributeSelection(false);
    }

    private void removeArchivingMenuItemActionPerformed(ActionEvent evt) {
        this.removeSelectedAttributes();
    }

    private void applyFilter() {
        String filter = this.filterTextField.getText();
        this.filteredFaultyAttributes = new ArrayList();
        for (FaultyAttribute faultyAttribute : this.faultyAttributes) {
            if (!faultyAttribute.attributeName.contains(filter)) continue;
            this.filteredFaultyAttributes.add(faultyAttribute);
        }
        this.model.fireTableDataChanged();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void stopSelectedAttributes() {
        if (JOptionPane.showConfirmDialog(this, "Stop archiving for selected attributes ?", "Confirm dialog", 0, 3) == 1) {
            return;
        }
        try {
            SplashUtils.getInstance().startSplash();
            SplashUtils.getInstance().setSplashProgress(5, "Removing attributes");
            int nb = 0;
            for (FaultyAttribute attribute : this.filteredFaultyAttributes) {
                if (!attribute.selected) continue;
                SplashUtils.getInstance().increaseSplashProgress(2, "Removing " + attribute.attributeName);
                attribute.stopStorage();
                ++nb;
            }
            SplashUtils.getInstance().increaseSplashProgress(2, "Waiting.....");
            new RefreshThread(nb).start();
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            ErrorPane.showErrorMessage((Component)this.thisDialog, (String)e.toString(), (DevFailed)e);
        }
    }

    private void removeSelectedAttributes() {
        if (JOptionPane.showConfirmDialog(this, "Remove archiving for selected attributes ?", "Confirm dialog", 0, 3) == 1) {
            return;
        }
        try {
            SplashUtils.getInstance().startSplash();
            SplashUtils.getInstance().setSplashProgress(5, "Removing attributes");
            ArrayList<String> attributeList = new ArrayList<String>();
            for (FaultyAttribute attribute : this.filteredFaultyAttributes) {
                if (!attribute.selected) continue;
                SplashUtils.getInstance().increaseSplashProgress(2, "Removing " + attribute.attributeName);
                attribute.stopStorage();
                attributeList.add(attribute.attributeName);
            }
            ManageAttributes.removeAttributes(this.subscriberMap.getConfiguratorProxy(), attributeList);
            SplashUtils.getInstance().increaseSplashProgress(2, "Waiting.....");
            new RefreshThread(attributeList.size()).start();
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            ErrorPane.showErrorMessage((Component)this.thisDialog, (String)e.toString(), (DevFailed)e);
        }
    }

    private void setAttributeSelection(boolean b) {
        for (FaultyAttribute attribute : this.filteredFaultyAttributes) {
            attribute.selected = b;
        }
        this.table.repaint();
    }

    private void saveInFile() {
        try {
            File file;
            StringBuilder sb = new StringBuilder("Attribute Names\tFault Description\n");
            for (FaultyAttribute attribute : this.faultyAttributes) {
                sb.append(attribute.attributeName).append('\t').append(attribute.faultDescription).append('\n');
            }
            if (fileChooser == null) {
                fileChooser = new JFileChooser(new File("").getAbsolutePath());
                fileChooser.setApproveButtonText("Save");
            }
            if (fileChooser.showOpenDialog(this) == 0 && (file = fileChooser.getSelectedFile()) != null) {
                if (file.exists() && JOptionPane.showConfirmDialog(this, "File already exists.\nOverwrite it ?", "Confirm", 2) != 0) {
                    return;
                }
                Utils.writeFile(file.getName(), sb.toString());
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void copyAttributeList() {
        StringBuilder sb = new StringBuilder();
        for (FaultyAttribute attribute : this.faultyAttributes) {
            sb.append(attribute.attributeName).append('\n');
        }
        Utils.copyToClipboard(sb.toString());
    }

    static {
        columnWidth = new int[]{400, 500, 60};
        columnNames = new String[]{"Attribute Names", "Fault description", "Selection"};
        selectionBackground = new Color(0xE0E0FF);
        firstColumnBackground = new Color(0xE0E0E0);
        fileChooser = null;
        headerMenuLabels = new String[]{"Stop Archiving for Selected Attributes", "Remove Archiving for Selected Attributes", "Select All", "Un Select All", "Copy attribute list", "Save to file"};
        tableMenuLabels = new String[]{"Stop Archiving", "Configure Polling/Events", "Copy attribute name", "Copy error message"};
    }

    private class ErrorComparator
    implements Comparator<AttributeErrorMessage> {
        private ErrorComparator() {
        }

        @Override
        public int compare(AttributeErrorMessage attribute1, AttributeErrorMessage attribute2) {
            if (attribute1.counter == attribute2.counter) {
                return 0;
            }
            return attribute1.counter > attribute2.counter ? -1 : 1;
        }
    }

    private class AttributeComparator
    implements Comparator<FaultyAttribute> {
        private AttributeComparator() {
        }

        @Override
        public int compare(FaultyAttribute attribute1, FaultyAttribute attribute2) {
            if (FaultyAttributesDialog.this.selectedColumn == 1) {
                return this.alphabeticalSort(attribute1.faultDescription, attribute2.faultDescription);
            }
            return this.alphabeticalSort(attribute1.attributeName, attribute2.attributeName);
        }

        private int alphabeticalSort(String s1, String s2) {
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private JLabel title = new JLabel();
        private FaultyAttribute selectedAttribute;

        private TablePopupMenu() {
            this.title.setFont(new Font("Dialog", 1, 12));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : tableMenuLabels) {
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TablePopupMenu.this.menuActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        private void showMenu(MouseEvent event, FaultyAttribute faultyAttribute) {
            this.title.setText(faultyAttribute.attributeName);
            this.selectedAttribute = faultyAttribute;
            this.getComponent(3).setEnabled(faultyAttribute.useDefaultTangoHost);
            this.getComponent(5).setEnabled(this.selectedAttribute != null);
            this.show(FaultyAttributesDialog.this.table, event.getX(), event.getY());
        }

        private void menuActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int itemIndex = -1;
            for (int i = 0; i < tableMenuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                itemIndex = i;
            }
            switch (itemIndex) {
                case 0: {
                    try {
                        this.selectedAttribute.stopStorage();
                        new RefreshThread(1).start();
                    }
                    catch (DevFailed e) {
                        ErrorPane.showErrorMessage((Component)FaultyAttributesDialog.this.thisDialog, (String)e.toString(), (DevFailed)e);
                    }
                    break;
                }
                case 1: {
                    this.selectedAttribute.configureEvent();
                    break;
                }
                case 2: {
                    if (this.selectedAttribute == null) break;
                    Utils.copyToClipboard(this.selectedAttribute.attributeName);
                    break;
                }
                case 3: {
                    if (this.selectedAttribute == null) break;
                    Utils.copyToClipboard(this.selectedAttribute.faultDescription);
                }
            }
        }
    }

    private class HeaderPopupMenu
    extends JPopupMenu {
        private JLabel title = new JLabel();

        private HeaderPopupMenu() {
            this.title.setFont(new Font("Dialog", 1, 12));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : headerMenuLabels) {
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        HeaderPopupMenu.this.menuActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        private void showMenu(MouseEvent event) {
            this.title.setText("Selection");
            this.getComponent(2).setVisible(FaultyAttributesDialog.this.selectedColumn == 2);
            this.getComponent(3).setVisible(FaultyAttributesDialog.this.selectedColumn == 2);
            this.getComponent(4).setVisible(FaultyAttributesDialog.this.selectedColumn == 2);
            this.getComponent(5).setVisible(FaultyAttributesDialog.this.selectedColumn == 2);
            this.getComponent(6).setVisible(FaultyAttributesDialog.this.selectedColumn == 0);
            this.getComponent(7).setVisible(FaultyAttributesDialog.this.selectedColumn == 0);
            this.show(FaultyAttributesDialog.this.table.getTableHeader(), event.getX(), event.getY());
        }

        private void menuActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int itemIndex = -1;
            for (int i = 0; i < headerMenuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                itemIndex = i;
            }
            switch (itemIndex) {
                case 0: {
                    FaultyAttributesDialog.this.stopSelectedAttributes();
                    break;
                }
                case 1: {
                    FaultyAttributesDialog.this.removeSelectedAttributes();
                    break;
                }
                case 2: 
                case 3: {
                    FaultyAttributesDialog.this.setAttributeSelection(itemIndex == 2);
                    break;
                }
                case 4: {
                    FaultyAttributesDialog.this.copyAttributeList();
                    break;
                }
                case 5: {
                    FaultyAttributesDialog.this.saveInFile();
                }
            }
        }
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(this.getBackground(row, column));
            FaultyAttribute attribute = (FaultyAttribute)FaultyAttributesDialog.this.filteredFaultyAttributes.get(row);
            switch (column) {
                case 0: {
                    this.setText(attribute.attributeName);
                    this.setToolTipText(null);
                    this.setIcon(null);
                    break;
                }
                case 1: {
                    this.setText(attribute.faultDescription);
                    this.setToolTipText(attribute.faultDescription);
                }
            }
            return this;
        }

        private Color getBackground(int row, int column) {
            switch (column) {
                case 0: {
                    return firstColumnBackground;
                }
            }
            if (FaultyAttributesDialog.this.selectedRow >= 0 && row == FaultyAttributesDialog.this.selectedRow) {
                return selectionBackground;
            }
            return Color.white;
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return FaultyAttributesDialog.this.filteredFaultyAttributes.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            String title = columnIndex >= this.getColumnCount() ? columnNames[this.getColumnCount() - 1] : columnNames[columnIndex];
            if (title.startsWith("tango://")) {
                int index = title.indexOf(47, "tango://".length());
                title = title.substring(index + 1);
            }
            return title;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 2) {
                return ((FaultyAttribute)((FaultyAttributesDialog)FaultyAttributesDialog.this).filteredFaultyAttributes.get((int)row)).selected;
            }
            return "";
        }

        public Class getColumnClass(int column) {
            if (FaultyAttributesDialog.this.isVisible()) {
                if (column == 2) {
                    return Boolean.class;
                }
                return this.getValueAt(0, column).getClass();
            }
            return null;
        }
    }

    private class FaultyAttribute {
        String attributeName;
        String faultDescription;
        String shortFaultDescription;
        Subscriber subscriber;
        boolean selected = true;
        private boolean useDefaultTangoHost = false;

        FaultyAttribute(Subscriber subscriber, String attributeName, String faultDescription) {
            this.subscriber = subscriber;
            this.attributeName = attributeName;
            this.faultDescription = faultDescription;
            String tangoHost = TangoUtils.getOnlyTangoHost(attributeName);
            for (String defaultTangoHost : defaultTangoHosts) {
                if (!tangoHost.equals(defaultTangoHost)) continue;
                this.useDefaultTangoHost = true;
            }
            String attName = attributeName.substring(attributeName.lastIndexOf(47) + 1);
            int start = faultDescription.toLowerCase().indexOf(attName.toLowerCase());
            if (start > 0) {
                int end = start + attName.length();
                this.shortFaultDescription = faultDescription.substring(0, start) + " XXX " + faultDescription.substring(end);
            } else {
                this.shortFaultDescription = faultDescription;
            }
        }

        private void configureEvent() {
            String deviceName = TangoUtils.getOnlyDeviceName(this.attributeName);
            deviceName = deviceName.substring(0, deviceName.lastIndexOf(47));
            Utils.startJiveForDevice(deviceName);
        }

        private void stopStorage() throws DevFailed {
            DeviceData argIn = new DeviceData();
            argIn.insert(this.attributeName);
            this.subscriber.command_inout("AttributeStop", argIn);
        }
    }

    private class RefreshThread
    extends Thread {
        private int nb;

        private RefreshThread(int nb) {
            this.nb = nb;
        }

        @Override
        public void run() {
            try {
                long t = this.nb * 50;
                if (t < 1000L) {
                    t = 1000L;
                }
                RefreshThread.sleep(t);
            }
            catch (InterruptedException e) {
                System.err.println(e.toString());
            }
            FaultyAttributesDialog.this.updateItemActionPerformed(null);
            SplashUtils.getInstance().stopSplash();
        }
    }

    private class AttributeErrorMessage {
        private String message;
        private int counter = 0;

        private AttributeErrorMessage(String message) {
            this.message = message;
        }
    }
}

