/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.diagnostics;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.diagnostics.FaultyAttributesDialog;
import org.tango.hdb_configurator.diagnostics.StatisticsDialog;

public class DistributionDialog
extends JDialog {
    private JFrame parent;
    private JDialog thisDialog;
    private SubscriberMap subscriberMap;
    private DeviceProxy configuratorProxy;
    private AttributeChart attributeChartChart;
    private PerformancesChart performancesChart;
    private List<Archiver> archivers = new ArrayList<Archiver>();
    private JTable table;
    private int selectedColumn = 0;
    private static final int SUBSCRIBER_NAME = 0;
    private static final int ATTRIBUTE_NUMBER = 1;
    private static final int EVENT_NUMBER = 2;
    private static final int STORE_TIME = 3;
    private static final int MAX_PENDING = 4;
    private static final int RESET_TIME = 5;
    private static final int RESET_DURATION = 6;
    private static final String[] columnNames = new String[]{"Subscriber", "Attributes", "Nb Events", "Max Store", "Max Pending", "Reset Time", "Duration"};
    private static final int[] columnWidth = new int[]{250, 60, 60, 60, 60, 100, 120};
    private static final Dimension chartDimension = new Dimension(800, 650);
    private static final String Space = "&nbsp;";
    private JPanel attributesPanel;
    private JLabel globalLabel;
    private JPanel globalPanel;
    private JPanel performancesPanel;
    private JPanel tablePanel;
    private JLabel titleLabel;

    public DistributionDialog(JFrame parent, SubscriberMap subscriberMap) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.thisDialog = this;
        SplashUtils.getInstance().startSplash();
        this.initComponents();
        try {
            this.subscriberMap = subscriberMap;
            this.configuratorProxy = subscriberMap.getConfiguratorProxy();
            this.attributeChartChart = new AttributeChart();
            this.attributesPanel.add((Component)((Object)this.attributeChartChart), "Center");
            this.performancesChart = new PerformancesChart();
            this.performancesPanel.add((Component)((Object)this.performancesChart), "Center");
            this.buildTable();
            if (this.resetsAtSameTime()) {
                this.displayGlobalStatistics();
            } else {
                this.globalPanel.setVisible(false);
            }
            this.titleLabel.setText(this.attributeChartChart.attributeCount + " Attributes   distributed   in " + subscriberMap.getLabelList().size() + " Subscribers");
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
            SplashUtils.getInstance().stopSplash();
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            throw e;
        }
    }

    private void buildTable() {
        DataTableModel model = new DataTableModel();
        this.table = new JTable(model){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                if (this.isVisible()) {
                    Point p = e.getPoint();
                    int column = this.columnAtPoint(p);
                    int row = this.rowAtPoint(p);
                    if (column == 0) {
                        Archiver archiver = (Archiver)DistributionDialog.this.archivers.get(row);
                        String text = "<b>" + archiver.subscriber.getLabel() + "</b>" + DistributionDialog.Space + DistributionDialog.Space + DistributionDialog.Space + "( " + archiver.subscriber.name() + ")";
                        tip = Utils.buildTooltip(text);
                    }
                }
                return tip;
            }
        };
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setDragEnabled(false);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.table.setDefaultRenderer(String.class, new LabelCellRenderer());
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DistributionDialog.this.tableHeaderActionPerformed(evt);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        model.fireTableDataChanged();
        this.tablePanel.add((Component)scrollPane, "Center");
        Enumeration<TableColumn> columnEnum = this.table.getColumnModel().getColumns();
        int i = 0;
        while (columnEnum.hasMoreElements()) {
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(columnWidth[i++]);
        }
        Collections.sort(this.archivers, new ArchiverComparator());
    }

    private void tableHeaderActionPerformed(MouseEvent event) {
        this.selectedColumn = this.table.getTableHeader().columnAtPoint(new Point(event.getX(), event.getY()));
        Collections.sort(this.archivers, new ArchiverComparator());
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JPanel topTopPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.globalPanel = new JPanel();
        this.globalLabel = new JLabel();
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        this.attributesPanel = new JPanel();
        JPanel jPanel1 = new JPanel();
        JRadioButton notOkButton = new JRadioButton();
        JLabel jLabel1 = new JLabel();
        JRadioButton OkButton = new JRadioButton();
        JLabel jLabel2 = new JLabel();
        JRadioButton eventsButton = new JRadioButton();
        this.performancesPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JRadioButton processButton = new JRadioButton();
        JLabel jLabel3 = new JLabel();
        JRadioButton storeButton = new JRadioButton();
        JLabel jLabel4 = new JLabel();
        JRadioButton pendingButton = new JRadioButton();
        this.tablePanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DistributionDialog.this.closeDialog(evt);
            }
        });
        topPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Attributes Distribution");
        topTopPanel.add(this.titleLabel);
        topPanel.add((Component)topTopPanel, "First");
        this.globalLabel.setFont(new Font("Dialog", 1, 14));
        this.globalLabel.setText("jLabel5");
        this.globalPanel.add(this.globalLabel);
        topPanel.add((Component)this.globalPanel, "Center");
        this.getContentPane().add((Component)topPanel, "North");
        this.attributesPanel.setLayout(new BorderLayout());
        notOkButton.setSelected(true);
        notOkButton.setText("Attributes Not OK");
        notOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistributionDialog.this.notOkButtonActionPerformed(evt);
            }
        });
        jPanel1.add(notOkButton);
        jLabel1.setText("          ");
        jPanel1.add(jLabel1);
        OkButton.setSelected(true);
        OkButton.setText("Attributes OK");
        OkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistributionDialog.this.OkButtonActionPerformed(evt);
            }
        });
        jPanel1.add(OkButton);
        jLabel2.setText("          ");
        jPanel1.add(jLabel2);
        eventsButton.setSelected(true);
        eventsButton.setText("Events Received");
        eventsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistributionDialog.this.eventsButtonActionPerformed(evt);
            }
        });
        jPanel1.add(eventsButton);
        this.attributesPanel.add((Component)jPanel1, "North");
        jTabbedPane1.addTab("Attributes", this.attributesPanel);
        this.performancesPanel.setLayout(new BorderLayout());
        processButton.setSelected(true);
        processButton.setText("Process Time");
        processButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistributionDialog.this.processButtonActionPerformed(evt);
            }
        });
        jPanel2.add(processButton);
        jLabel3.setText("          ");
        jPanel2.add(jLabel3);
        storeButton.setSelected(true);
        storeButton.setText("Store Time");
        storeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistributionDialog.this.storeButtonActionPerformed(evt);
            }
        });
        jPanel2.add(storeButton);
        jLabel4.setText("          ");
        jPanel2.add(jLabel4);
        pendingButton.setSelected(true);
        pendingButton.setText("Pending");
        pendingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistributionDialog.this.pendingButtonActionPerformed(evt);
            }
        });
        jPanel2.add(pendingButton);
        this.performancesPanel.add((Component)jPanel2, "North");
        jTabbedPane1.addTab("Performances", this.performancesPanel);
        this.tablePanel.setLayout(new BorderLayout());
        jTabbedPane1.addTab("Table", this.tablePanel);
        this.getContentPane().add((Component)jTabbedPane1, "Center");
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistributionDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void notOkButtonActionPerformed(ActionEvent evt) {
        JRadioButton btn = (JRadioButton)evt.getSource();
        this.attributeChartChart.setVisibleCurve(btn.isSelected(), this.attributeChartChart.failedDataView);
    }

    private void OkButtonActionPerformed(ActionEvent evt) {
        JRadioButton btn = (JRadioButton)evt.getSource();
        this.attributeChartChart.setVisibleCurve(btn.isSelected(), this.attributeChartChart.okDataView);
    }

    private void eventsButtonActionPerformed(ActionEvent evt) {
        JRadioButton btn = (JRadioButton)evt.getSource();
        this.attributeChartChart.setVisibleCurve(btn.isSelected(), this.attributeChartChart.eventDataView);
    }

    private void processButtonActionPerformed(ActionEvent evt) {
        JRadioButton btn = (JRadioButton)evt.getSource();
        this.performancesChart.setVisibleCurve(btn.isSelected(), this.performancesChart.processDataView);
    }

    private void storeButtonActionPerformed(ActionEvent evt) {
        JRadioButton btn = (JRadioButton)evt.getSource();
        this.performancesChart.setVisibleCurve(btn.isSelected(), this.performancesChart.storeDataView);
    }

    private void pendingButtonActionPerformed(ActionEvent evt) {
        JRadioButton btn = (JRadioButton)evt.getSource();
        this.performancesChart.setVisibleCurve(btn.isSelected(), this.performancesChart.pendingDataView);
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void displayGlobalStatistics() {
        long nbEvents = 0L;
        for (Archiver archiver : this.archivers) {
            nbEvents += (long)archiver.totalEvents;
        }
        Archiver archiver = this.archivers.get(0);
        double average = (double)nbEvents / (double)(archiver.sinceReset / 1000L);
        String statistics = Long.toString(nbEvents) + "  events received during " + archiver.getResetDuration() + "  ->  average = " + String.format("%.3f", average) + " ev/sec.";
        this.globalLabel.setText(statistics);
    }

    private boolean resetsAtSameTime() {
        long maxTime = 0L;
        long minTime = System.currentTimeMillis();
        for (Archiver archiver : this.archivers) {
            if (archiver.resetTime > maxTime) {
                maxTime = archiver.resetTime;
            }
            if (archiver.resetTime >= minTime) continue;
            minTime = archiver.resetTime;
        }
        long delta = maxTime - minTime;
        System.out.println("Delta reset time = " + delta + " ms");
        return delta < 5000L;
    }

    private class ArchiverComparator
    implements Comparator<Archiver> {
        private ArchiverComparator() {
        }

        @Override
        public int compare(Archiver archiver1, Archiver archiver2) {
            switch (DistributionDialog.this.selectedColumn) {
                case 1: {
                    return this.valueSort(archiver2.attributeCount(), archiver1.attributeCount());
                }
                case 2: {
                    return this.valueSort(archiver2.totalEvents, archiver1.totalEvents);
                }
                case 3: {
                    return this.valueSort(archiver2.maxStore, archiver1.maxStore);
                }
                case 4: {
                    return this.valueSort(archiver2.pending, archiver1.pending);
                }
                case 5: {
                    return this.valueSort(archiver1.resetTime, archiver2.resetTime);
                }
                case 6: {
                    return this.valueSort(archiver1.sinceReset, archiver2.sinceReset);
                }
            }
            return this.alphabeticalSort(archiver1.subscriber.getLabel(), archiver2.subscriber.getLabel());
        }

        private int alphabeticalSort(String s1, String s2) {
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }

        private int valueSort(double d1, double d2) {
            if (d1 == d2) {
                return 0;
            }
            if (d1 < 0.0) {
                return 1;
            }
            if (d2 < 0.0) {
                return -1;
            }
            return d1 > d2 ? 1 : -1;
        }
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(this.getBackground(column));
            Archiver archiver = (Archiver)DistributionDialog.this.archivers.get(row);
            switch (column) {
                case 0: {
                    this.setText(archiver.subscriber.getLabel());
                    break;
                }
                case 1: {
                    this.setText(Integer.toString(archiver.attributeCount()));
                    break;
                }
                case 2: {
                    this.setText(Integer.toString(archiver.totalEvents));
                    break;
                }
                case 3: {
                    this.setText(Utils.strPeriod(archiver.maxStore));
                    break;
                }
                case 4: {
                    this.setText(Integer.toString(archiver.pending));
                    break;
                }
                case 5: {
                    if (archiver.resetTime > 0L) {
                        this.setText(archiver.getResetTime());
                        break;
                    }
                    this.setText("Not available");
                    break;
                }
                case 6: {
                    if (archiver.resetTime > 0L) {
                        this.setText(archiver.getResetDuration());
                        break;
                    }
                    this.setText("Not available");
                }
            }
            return this;
        }

        private Color getBackground(int column) {
            switch (column) {
                case 0: {
                    return Utils.firstColumnBackground;
                }
            }
            return Color.white;
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return DistributionDialog.this.archivers.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            String title = columnIndex >= this.getColumnCount() ? columnNames[this.getColumnCount() - 1] : columnNames[columnIndex];
            if (title.startsWith("tango://")) {
                int index = title.indexOf(47, "tango://".length());
                title = title.substring(index + 1);
            }
            return title;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return "";
        }

        public Class getColumnClass(int column) {
            if (DistributionDialog.this.isVisible()) {
                return this.getValueAt(0, column).getClass();
            }
            return null;
        }
    }

    private class Archiver {
        private Subscriber subscriber;
        private String title;
        private String[] attributeOk;
        private String[] attributeFailed;
        private int totalEvents = 0;
        private int pending;
        private double maxProcess;
        private double minProcess;
        private double maxStore;
        private double minStore;
        private long resetTime = -1L;
        private long sinceReset = 0L;

        private Archiver(Subscriber subscriber) throws DevFailed {
            this.subscriber = subscriber;
            this.title = subscriber.getLabel() + "  (" + TangoUtils.getOnlyDeviceName(subscriber.getName()) + ") :";
            this.update();
        }

        private void update() {
            try {
                DeviceAttribute[] attributes = this.subscriber.read_attribute(new String[]{"AttributeOkList", "AttributeNOkList", "AttributeEventNumberList", "AttributeMinProcessingTime", "AttributeMaxProcessingTime", "AttributeMaxStoreTime", "AttributeMinStoreTime", "AttributeMaxPendingNumber"});
                int i = 0;
                DeviceAttribute attribute = attributes[i++];
                this.attributeOk = attribute.hasFailed() ? new String[0] : attribute.extractStringArray();
                attribute = attributes[i++];
                this.attributeFailed = attribute.hasFailed() ? new String[0] : attribute.extractStringArray();
                attribute = attributes[i++];
                if (!attribute.hasFailed()) {
                    int[] nbEvents = attribute.extractLongArray();
                    this.totalEvents = 0;
                    for (int nb : nbEvents) {
                        this.totalEvents += nb;
                    }
                }
                this.resetTime = this.subscriber.getStatisticsResetTime();
                if (this.resetTime > 0L) {
                    this.sinceReset = System.currentTimeMillis() - this.resetTime;
                }
                this.maxProcess = (attribute = attributes[i++]).hasFailed() ? 0.0 : attribute.extractDouble();
                if (this.maxProcess < 0.0) {
                    this.maxProcess = 0.0;
                }
                this.minProcess = (attribute = attributes[i++]).hasFailed() ? 0.0 : attribute.extractDouble();
                if (this.minProcess < 0.0) {
                    this.minProcess = 0.0;
                }
                this.maxStore = (attribute = attributes[i++]).hasFailed() ? 0.0 : attribute.extractDouble();
                if (this.maxStore < 0.0) {
                    this.maxStore = 0.0;
                }
                this.minStore = (attribute = attributes[i++]).hasFailed() ? 0.0 : attribute.extractDouble();
                if (this.minStore < 0.0) {
                    this.minStore = 0.0;
                }
                this.pending = (attribute = attributes[i]).hasFailed() ? 0 : attribute.extractLong();
            }
            catch (DevFailed e) {
                this.attributeOk = new String[0];
                this.attributeFailed = new String[0];
            }
        }

        private int attributeCount() {
            return this.attributeOk.length + this.attributeFailed.length;
        }

        public String getResetTime() {
            return StatisticsDialog.formatResetTime(this.resetTime);
        }

        public String getResetDuration() {
            return Utils.strPeriod(this.sinceReset / 1000L);
        }

        public String toString() {
            return this.subscriber.getLabel();
        }
    }

    private class PerformancesChart
    extends DistributionChart
    implements IJLChartListener {
        private JLDataView processDataView;
        private JLDataView storeDataView;
        private JLDataView pendingDataView;
        private final String[] axisNames;
        private final String[] curveNames;

        private PerformancesChart() throws DevFailed {
            this.axisNames = new String[]{"Archivers", "Time (millis)", "Attributes"};
            this.curveNames = new String[]{"Process Time", "Store Time", "Max Pending"};
            this.setJLChartListener(this);
            this.buildAxises(this.axisNames);
            int i = 0;
            this.processDataView = this.buildCurve(this.curveNames[i++], Color.red, this.getY1Axis());
            this.storeDataView = this.buildCurve(this.curveNames[i++], new Color(43520), this.getY1Axis());
            this.pendingDataView = this.buildCurve(this.curveNames[i], new Color(170), this.getY2Axis());
            this.updateValues();
            this.getXAxis().setMaximum((double)DistributionDialog.this.archivers.size() + 0.6);
        }

        private void updateValues() throws DevFailed {
            this.resetDataViews();
            DistributionDialog.this.archivers.clear();
            List<String> labels = DistributionDialog.this.subscriberMap.getLabelList();
            SplashUtils.getInstance().reset();
            int x = 0;
            for (String label : labels) {
                SplashUtils.getInstance().increaseSplashProgressForLoop(labels.size(), "Reading " + label);
                Archiver archiver = new Archiver(DistributionDialog.this.subscriberMap.getSubscriberByLabel(label));
                this.processDataView.add((double)x, archiver.maxProcess * 1000.0);
                this.storeDataView.add((double)x + 0.2, archiver.maxStore * 1000.0);
                this.pendingDataView.add((double)x + 0.4, (double)archiver.pending);
                DistributionDialog.this.archivers.add(archiver);
                ++x;
            }
        }

        public String[] clickOnChart(JLChartEvent event) {
            int index = event.getDataViewIndex();
            Archiver archiver = (Archiver)DistributionDialog.this.archivers.get(index);
            if (archiver != null) {
                MouseEvent mouseEvent = event.getMouseEvent();
                if (archiver.attributeFailed.length > 0 && mouseEvent != null && (mouseEvent.getModifiers() & 1) != 0) {
                    return null;
                }
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(archiver.title);
                if (archiver.resetTime > 0L) {
                    lines.add("Since " + archiver.getResetTime() + "  (" + archiver.getResetDuration() + ")");
                }
                lines.add(archiver.totalEvents + " Events Received");
                lines.add(" - Max process time: " + Utils.strPeriod(archiver.maxProcess));
                lines.add(" - Max store time: " + Utils.strPeriod(archiver.maxStore));
                lines.add(" - Min store time: " + Utils.strPeriod(archiver.minStore));
                lines.add(" - Max pending:    " + archiver.pending + " att.");
                String[] array = new String[lines.size()];
                for (int i = 0; i < lines.size(); ++i) {
                    array[i] = (String)lines.get(i);
                }
                return array;
            }
            return new String[0];
        }
    }

    private class AttributeChart
    extends DistributionChart
    implements IJLChartListener {
        private JLDataView failedDataView;
        private JLDataView okDataView;
        private JLDataView eventDataView;
        private int attributeCount;
        private final String[] axisNames;
        private final String[] curveNames;

        private AttributeChart() throws DevFailed {
            this.axisNames = new String[]{"Archivers", "Attributes", "Events Number"};
            this.curveNames = new String[]{"Attributes Not OK", "Attributes OK", "Events Received"};
            this.setJLChartListener(this);
            this.buildAxises(this.axisNames);
            int i = 0;
            this.failedDataView = this.buildCurve(this.curveNames[i++], Color.red, this.getY1Axis());
            this.okDataView = this.buildCurve(this.curveNames[i++], new Color(43520), this.getY1Axis());
            this.eventDataView = this.buildCurve(this.curveNames[i], new Color(170), this.getY2Axis());
            this.updateValues();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    AttributeChart.this.chartMouseClicked(event);
                }
            });
            this.getXAxis().setMaximum((double)DistributionDialog.this.archivers.size() + 0.6);
        }

        private void updateValues() throws DevFailed {
            this.resetDataViews();
            DistributionDialog.this.archivers.clear();
            List<String> labels = DistributionDialog.this.subscriberMap.getLabelList();
            SplashUtils.getInstance().reset();
            this.attributeCount = 0;
            int x = 0;
            for (String label : labels) {
                SplashUtils.getInstance().increaseSplashProgressForLoop(labels.size(), "Reading " + label);
                Archiver archiver = new Archiver(DistributionDialog.this.subscriberMap.getSubscriberByLabel(label));
                this.okDataView.add((double)x, (double)archiver.attributeOk.length);
                this.failedDataView.add((double)x + 0.2, (double)archiver.attributeFailed.length);
                this.eventDataView.add((double)x + 0.4, (double)archiver.totalEvents);
                this.attributeCount += archiver.attributeCount();
                DistributionDialog.this.archivers.add(archiver);
                ++x;
            }
        }

        private void chartMouseClicked(MouseEvent event) {
            int mask = event.getModifiers();
            if (event.getClickCount() == 2 && (mask & 0x10) != 0 && this.selectedArchiver != null) {
                try {
                    String[] attributeList = ArchiverUtils.getAttributeList(this.selectedArchiver.subscriber, "Nok");
                    if (attributeList.length > 0) {
                        new FaultyAttributesDialog(DistributionDialog.this.thisDialog, this.selectedArchiver.subscriber).setVisible(true);
                    }
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)((Object)this), (String)e.getMessage(), (DevFailed)e);
                }
            }
        }

        public String[] clickOnChart(JLChartEvent event) {
            Archiver archiver;
            int index = event.getDataViewIndex();
            this.selectedArchiver = archiver = (Archiver)DistributionDialog.this.archivers.get(index);
            if (archiver != null) {
                MouseEvent mouseEvent = event.getMouseEvent();
                if (archiver.attributeFailed.length > 0 && mouseEvent != null && (mouseEvent.getModifiers() & 1) != 0) {
                    return null;
                }
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(archiver.title);
                if (archiver.resetTime > 0L) {
                    lines.add("Since " + archiver.getResetTime() + "  (" + archiver.getResetDuration() + ")");
                }
                lines.add(archiver.totalEvents + " Events Received");
                if (archiver.attributeOk.length == 0) {
                    lines.add(" - NO  Attribute OK");
                } else {
                    lines.add(" - " + archiver.attributeOk.length + " attributes are OK");
                }
                if (archiver.attributeFailed.length == 0) {
                    lines.add(" - NO  Attribute Failed");
                } else {
                    lines.add(" - " + archiver.attributeFailed.length + " attributes Failed");
                }
                int cnt = 0;
                for (String attribute : archiver.attributeFailed) {
                    lines.add("    - " + attribute);
                    if (cnt++ <= 15) continue;
                    lines.add("       - - - - -");
                    lines.add("       Use double click for Full List");
                    break;
                }
                String[] array = new String[lines.size()];
                for (int i = 0; i < lines.size(); ++i) {
                    array[i] = (String)lines.get(i);
                }
                return array;
            }
            return new String[0];
        }
    }

    private class DistributionChart
    extends JLChart {
        protected List<JLDataView> dataViews = new ArrayList<JLDataView>();
        protected Archiver selectedArchiver = null;
        protected final String[] labels = new String[]{"========================", "Update from archivers"};
        protected static final int SEPARATOR = 0;
        protected static final int UPDATE_DATA = 1;

        protected DistributionChart() {
            this.setPreferredSize(chartDimension);
            this.addMenuItem(new JMenuItem(this.labels[0]));
            JMenuItem updateItem = new JMenuItem(this.labels[1]);
            updateItem.setSelected(true);
            updateItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DistributionChart.this.menuActionPerformed(evt);
                }
            });
            this.addMenuItem(updateItem);
        }

        protected JLDataView buildCurve(String name, Color color, JLAxis axis) {
            JLDataView dataView = new JLDataView();
            dataView.setColor(color);
            dataView.setFillColor(color);
            dataView.setName(name);
            dataView.setFill(false);
            dataView.setLabelVisible(true);
            dataView.setViewType(1);
            dataView.setBarWidth(6);
            dataView.setFillStyle(1);
            axis.addDataView(dataView);
            this.dataViews.add(dataView);
            return dataView;
        }

        protected void buildAxises(String[] names) {
            int i = 0;
            this.getXAxis().setName(names[i++]);
            this.getXAxis().setAnnotation(2);
            this.getXAxis().setGridVisible(true);
            this.getXAxis().setSubGridVisible(true);
            this.getXAxis().setAutoScale(false);
            this.getXAxis().setMinimum(0.0);
            this.getY1Axis().setName(names[i++]);
            this.getY1Axis().setAutoScale(true);
            this.getY1Axis().setScale(0);
            this.getY1Axis().setGridVisible(true);
            this.getY1Axis().setSubGridVisible(true);
            this.getY2Axis().setName(names[i]);
            this.getY2Axis().setAutoScale(true);
            this.getY2Axis().setScale(0);
            this.getY2Axis().setGridVisible(true);
            this.getY2Axis().setSubGridVisible(true);
        }

        private void menuActionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            if (cmd.equals(this.labels[1])) {
                try {
                    SplashUtils.getInstance().startSplash();
                    DistributionDialog.this.subscriberMap = new SubscriberMap(DistributionDialog.this.configuratorProxy);
                    DistributionDialog.this.attributeChartChart.updateValues();
                    DistributionDialog.this.performancesChart.updateValues();
                    SplashUtils.getInstance().stopSplash();
                }
                catch (DevFailed e) {
                    SplashUtils.getInstance().stopSplash();
                    ErrorPane.showErrorMessage((Component)((Object)this), null, (DevFailed)e);
                }
            }
            this.repaint();
        }

        protected void setVisibleCurve(boolean b, JLDataView dataView) {
            int i = 0;
            for (JLDataView dv : this.dataViews) {
                if (dv == dataView) {
                    if (!b) {
                        dataView.getAxis().removeDataView(dataView);
                    } else if (i == 0 || i == 1) {
                        this.getY1Axis().addDataView(dataView);
                    } else {
                        this.getY2Axis().addDataView(dataView);
                    }
                }
                ++i;
            }
            this.repaint();
        }

        protected void resetDataViews() {
            for (JLDataView dataView : this.dataViews) {
                dataView.reset();
            }
        }
    }
}

