/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.diagnostics;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.Utils;

public class AttributesTableDialog
extends JDialog {
    private List<ExtendedAttribute> filteredAttributes = new ArrayList<ExtendedAttribute>();
    private List<ExtendedAttribute> attributeList = new ArrayList<ExtendedAttribute>();
    private DataTableModel model;
    private Subscriber subscriber;
    private ImageIcon greenBall = null;
    private ImageIcon orangeBall = null;
    private String[] columnName = new String[]{"Attribute Names", "Strategy"};
    private static final int[] columnWidth = new int[]{500, 100};
    private static final int ATTRIBUTE_NAME = 0;
    private static final int ATTRIBUTE_STRATEGY = 1;
    private static final Color firstColumnBackground = new Color(0xE0E0E0);
    private JLabel contextLabel;
    private JTextField filterTextField;

    public AttributesTableDialog(JFrame parent, Subscriber subscriber, int attributeType) throws DevFailed {
        super((Frame)parent, false);
        this.subscriber = subscriber;
        SplashUtils.getInstance().startSplash();
        try {
            this.initComponents();
            List<HdbAttribute> hdbAttributeList = subscriber.getAttributeList(attributeType, false);
            for (HdbAttribute attribute : hdbAttributeList) {
                ExtendedAttribute extendedAttribute = new ExtendedAttribute(attribute);
                this.attributeList.add(extendedAttribute);
                this.filteredAttributes.add(extendedAttribute);
            }
            this.manageTitle(attributeType);
            this.buildTableComponent();
            this.contextLabel.setText(subscriber.getContext());
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            throw e;
        }
        SplashUtils.getInstance().stopSplash();
    }

    private void manageTitle(int attributeType) throws DevFailed {
        String title = this.subscriber.getLabel();
        switch (attributeType) {
            case 0: {
                title = title + ": started";
                this.checkAttributeFaulty();
                this.orangeBall = Utils.getOrangeBall();
                this.greenBall = Utils.getGreenBall();
                break;
            }
            case 2: {
                title = title + ": stopped";
                break;
            }
            case 1: {
                title = title + ": paused";
            }
        }
        this.columnName[0] = title + " attribute" + (this.attributeList.size() > 1 ? "s" : "");
        this.setTitle(title);
    }

    private void checkAttributeFaulty() throws DevFailed {
        String[] faultyAttributes;
        DeviceAttribute deviceAttribute = this.subscriber.read_attribute("AttributeNokList");
        for (String faultyAttribute : faultyAttributes = deviceAttribute.extractStringArray()) {
            for (ExtendedAttribute attribute : this.attributeList) {
                if (!faultyAttribute.equalsIgnoreCase(attribute.hdbAttribute.getName())) continue;
                attribute.isFaulty = true;
            }
        }
    }

    private void buildTableComponent() throws DevFailed {
        try {
            this.model = new DataTableModel();
            JTable table = new JTable(this.model);
            table.setRowSelectionAllowed(true);
            table.setColumnSelectionAllowed(true);
            table.setDragEnabled(false);
            table.setSelectionMode(0);
            table.getTableHeader().setFont(new Font("Dialog", 1, 14));
            table.setDefaultRenderer(String.class, new LabelCellRenderer());
            Enumeration<TableColumn> columnEnum = table.getColumnModel().getColumns();
            int i = 0;
            int tableWidth = 0;
            while (columnEnum.hasMoreElements()) {
                tableWidth += columnWidth[i];
                TableColumn tableColumn = columnEnum.nextElement();
                tableColumn.setPreferredWidth(columnWidth[i++]);
            }
            JScrollPane scrollPane = new JScrollPane(table);
            this.getContentPane().add((Component)scrollPane, "Center");
            this.pack();
            int height = table.getHeight();
            if (height > 800) {
                height = 800;
            }
            scrollPane.setPreferredSize(new Dimension(tableWidth, height + 30));
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)e.toString());
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel1 = new JLabel();
        this.filterTextField = new JTextField();
        JButton applyButton = new JButton();
        JLabel jLabel4 = new JLabel();
        this.contextLabel = new JLabel();
        JMenuBar jMenuBar1 = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem dismissItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AttributesTableDialog.this.closeDialog(evt);
            }
        });
        jLabel2.setText("            ");
        topPanel.add(jLabel2);
        jLabel1.setText("Filter:   ");
        topPanel.add(jLabel1);
        this.filterTextField.setColumns(25);
        this.filterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesTableDialog.this.filterTextFieldActionPerformed(evt);
            }
        });
        topPanel.add(this.filterTextField);
        applyButton.setText("Apply");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesTableDialog.this.applyButtonActionPerformed(evt);
            }
        });
        topPanel.add(applyButton);
        jLabel4.setText("               Context:");
        topPanel.add(jLabel4);
        this.contextLabel.setText("  ");
        topPanel.add(this.contextLabel);
        this.getContentPane().add((Component)topPanel, "North");
        fileMenu.setText("File");
        dismissItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        dismissItem.setMnemonic('D');
        dismissItem.setText("Dismiss");
        dismissItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributesTableDialog.this.dismissItemActionPerformed(evt);
            }
        });
        fileMenu.add(dismissItem);
        jMenuBar1.add(fileMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void dismissItemActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.applyFilter();
    }

    private void filterTextFieldActionPerformed(ActionEvent evt) {
        this.applyFilter();
    }

    private void applyFilter() {
        String filter = this.filterTextField.getText();
        this.filteredAttributes = new ArrayList<ExtendedAttribute>();
        for (ExtendedAttribute attribute : this.attributeList) {
            if (!attribute.hdbAttribute.getName().contains(filter)) continue;
            this.filteredAttributes.add(attribute);
        }
        this.model.fireTableDataChanged();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ExtendedAttribute attribute = (ExtendedAttribute)AttributesTableDialog.this.filteredAttributes.get(row);
            this.setIcon(null);
            switch (column) {
                case 0: {
                    this.setBackground(firstColumnBackground);
                    this.setText(attribute.hdbAttribute.getName());
                    break;
                }
                case 1: {
                    this.setBackground(Color.white);
                    this.setText(attribute.hdbAttribute.strategyToString());
                }
            }
            this.setIcon(attribute.getIcon(column));
            return this;
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return AttributesTableDialog.this.columnName.length;
        }

        @Override
        public int getRowCount() {
            return AttributesTableDialog.this.filteredAttributes.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    String attName = AttributesTableDialog.this.columnName[0];
                    if (attName.startsWith("tango://")) {
                        int index = attName.indexOf(47, "tango://".length());
                        attName = attName.substring(index + 1);
                    }
                    return attName;
                }
                case 1: {
                    return AttributesTableDialog.this.columnName[1];
                }
            }
            return " ? ? ";
        }

        @Override
        public Object getValueAt(int row, int column) {
            return "";
        }

        public Class getColumnClass(int column) {
            if (AttributesTableDialog.this.isVisible()) {
                return this.getValueAt(0, column).getClass();
            }
            return null;
        }
    }

    private class ExtendedAttribute {
        private HdbAttribute hdbAttribute;
        private boolean isFaulty = false;

        private ExtendedAttribute(HdbAttribute hdbAttribute) {
            this.hdbAttribute = hdbAttribute;
        }

        private ImageIcon getIcon(int column) {
            if (column == 0 && AttributesTableDialog.this.orangeBall != null && AttributesTableDialog.this.greenBall != null) {
                if (this.isFaulty) {
                    return AttributesTableDialog.this.orangeBall;
                }
                return AttributesTableDialog.this.greenBall;
            }
            return null;
        }
    }
}

