/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.diagnostics;

import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.Gradient;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.tango.hdb_configurator.common.SplashUtils;

public class AtkMoniTrend
extends Trend {
    private String title;
    private static final Dimension trendSize = new Dimension(1024, 640);
    private MyGradient gradient = null;
    private static final String atkMoniConfigHeader = "graph_title:'TITLE'\nlabel_visible:false\ngraph_background:204,204,204\ntitle_font:dialog,1,24\ndisplay_duration:14400000\nrefresh_time:1000\nxsubgrid:false\nxgrid:true\nxgrid_style:1\nxmin:0.0\nxmax:100.0\nxautoscale:true\nxfit_display_duration:false\nxscale:0\nxformat:0\nxtitle:null\nxcolor:0,0,0\nxlabel_font:dialog,1,11\nxpercentscrollback:10.0\ny1grid:true\ny1subgrid:true\ny1grid_style:1\ny1min:0.0\ny1max:1.0\ny1autoscale:true\ny1scale:1\ny1format:1\ny1title:'Events / second'\ny1color:0,0,0\ny1label_font:dialog,1,11\ndv_number:NB_CURVES\n";
    private static final String atkMoniLinearAttributeConfig = "dv0_name:ATTRIBUTE\ndv0_selected:3\ndv0_linecolor:COLOR\ndv0_linewidth:1\ndv0_linestyle:0\ndv0_markercolor:255,0,0\ndv0_markersize:6\ndv0_markerstyle:0\ndv0_A0:0.0\ndv0_A1:1.0\ndv0_A2:0.0\n";

    public AtkMoniTrend(String title, List<String> attributeNames) {
        this.title = title;
        String config = this.buildAtkMoniConfig(attributeNames);
        this.setSetting(config);
        this.setPreferredSize(trendSize);
        DeviceFactory.getInstance().startRefresher();
    }

    private String buildAtkMoniConfig(String attributeName, int curveNumber) {
        String code = atkMoniLinearAttributeConfig;
        code = AtkMoniTrend.replace(code, "dv0", "dv" + curveNumber);
        code = AtkMoniTrend.replace(code, "ATTRIBUTE", "'" + attributeName + "'");
        String newColor = this.getNewColorString();
        code = AtkMoniTrend.replace(code, "COLOR", newColor);
        if (curveNumber == 0) {
            code = AtkMoniTrend.replace(code, "dv0_selected:3\n", "dv0_selected:2\n");
        }
        return code;
    }

    private String buildAtkMoniConfig(List<String> attributeNames) {
        String code = AtkMoniTrend.replace(atkMoniConfigHeader, "TITLE", this.title);
        int curveNumber = 0;
        for (String attributeName : attributeNames) {
            SplashUtils.getInstance().increaseSplashProgress(2, "Create configuration");
            code = code + this.buildAtkMoniConfig(attributeName, curveNumber++);
        }
        return AtkMoniTrend.replace(code, "NB_CURVES", Integer.toString(curveNumber));
    }

    public static String replace(String code, String oldSrc, String newSrc) {
        int start;
        int end = 0;
        while ((start = code.indexOf(oldSrc, end)) >= 0) {
            end = start + oldSrc.length();
            code = code.substring(0, start) + newSrc + code.substring(end);
        }
        return code;
    }

    private String getNewColorString() {
        Color color = this.getNewColor();
        return "" + color.getRed() + ',' + color.getGreen() + ',' + color.getBlue();
    }

    private Color getNewColor() {
        if (this.gradient == null) {
            this.gradient = new MyGradient();
        }
        return this.gradient.getNextColor();
    }

    private class MyGradient
    extends Gradient {
        private final int nbColors = 256;
        private int step = 128;
        private int colorIdx = -this.step;
        private int[] colorMap;
        private ArrayList<Integer> colors = new ArrayList();

        private MyGradient() {
            this.buildRainbowGradient();
            this.colorMap = this.buildColorMap(256);
        }

        private boolean alreadyUsed(int idx) {
            for (int i : this.colors) {
                if (i != idx) continue;
                return true;
            }
            return false;
        }

        private Color getNextColor() {
            if (this.colors.size() == 256) {
                this.colors.clear();
                this.step = 128;
                this.colorIdx = -this.step;
            }
            do {
                this.colorIdx += this.step;
                if (this.colorIdx < this.colorMap.length) continue;
                this.colorIdx = this.step;
                this.step /= 2;
            } while (this.alreadyUsed(this.colorIdx));
            this.colors.add(this.colorIdx);
            return new Color(this.colorMap[this.colorIdx]);
        }
    }
}

