/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator.strategy;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.tango.hdb_configurator.common.Context;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.strategy.SelectionStrategiesDialog;
import org.tango.hdb_configurator.configurator.strategy.StrategyAttributeTree;

public class StrategyMainPanel
extends JDialog {
    private Component parent;
    private SubscriberMap subscriberMap;
    private Hashtable<String, List<HdbAttribute>> strategyMap;
    private List<StrategyAttributeTree> attributeTreeList;
    private static final String[] expandLevels = new String[]{"Tango database", "Domain", "Family", "Member", "Attribute"};
    private static final Dimension treeDimension = new Dimension(500, 600);
    private JTabbedPane tabbedPane;

    public StrategyMainPanel(JFrame parent, String configuratorDeviceName) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.buildForm(configuratorDeviceName);
    }

    public StrategyMainPanel(JDialog parent) throws DevFailed {
        super((Dialog)parent, true);
        this.parent = parent;
        this.buildForm(null);
    }

    private void buildForm(String configuratorDeviceName) throws DevFailed {
        SplashUtils.getInstance().startSplash();
        SplashUtils.getInstance().increaseSplashProgress(10, "Building GUI");
        this.setTitle(Utils.getInstance().getApplicationName());
        this.initComponents();
        this.setIconImage(Utils.getInstance().getIcon("hdb++.gif").getImage());
        if (configuratorDeviceName == null) {
            configuratorDeviceName = TangoUtils.getConfiguratorDeviceName();
        }
        this.subscriberMap = Utils.getSubscriberMap(configuratorDeviceName);
        this.buildStrategyLists();
        this.buildTabbedPanes();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        SplashUtils.getInstance().stopSplash();
    }

    void setPane(String strategyStr) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            String title = this.tabbedPane.getTitleAt(i);
            if (!title.startsWith(strategyStr)) continue;
            this.tabbedPane.setSelectedIndex(i);
        }
    }

    String hasAttributeUsingContext(Context context) {
        Set<String> strategies = this.strategyMap.keySet();
        for (String strategyStr : strategies) {
            StringTokenizer stk = new StringTokenizer(strategyStr, "|");
            while (stk.hasMoreTokens()) {
                String contextName = stk.nextToken();
                if (!contextName.equalsIgnoreCase(context.getName())) continue;
                return strategyStr;
            }
        }
        return null;
    }

    private void buildTabbedPanes() {
        this.tabbedPane.removeAll();
        this.attributeTreeList = new ArrayList<StrategyAttributeTree>();
        Set<String> strategies = this.strategyMap.keySet();
        int progress = 25;
        int i = 0;
        for (String strategy : strategies) {
            SplashUtils.getInstance().increaseSplashProgress(progress += 25, "Building tree for " + strategy);
            List<HdbAttribute> attributeList = this.strategyMap.get(strategy);
            JPanel panel = new JPanel(new BorderLayout());
            JComboBox<String> comboBox = new JComboBox<String>(expandLevels);
            comboBox.setSelectedIndex(1);
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StrategyMainPanel.this.comboBoxActionPerformed(evt);
                }
            });
            JPanel topPanel = new JPanel();
            topPanel.add(new JLabel("Expand Level:  "));
            topPanel.add(comboBox);
            panel.add((Component)topPanel, "North");
            JButton btn = new JButton("Change selection strategy");
            btn.setToolTipText("Select attributes, members or families to change strategy");
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StrategyMainPanel.this.changeStrategyActionPerformed();
                }
            });
            topPanel.add(new JLabel("       "));
            topPanel.add(btn);
            StrategyAttributeTree tree = new StrategyAttributeTree(this, strategy, attributeList);
            this.attributeTreeList.add(tree);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(tree);
            scrollPane.setPreferredSize(treeDimension);
            panel.add((Component)scrollPane, "Center");
            this.tabbedPane.add(panel);
            this.tabbedPane.setTitleAt(i++, strategy + " (" + attributeList.size() + ")");
        }
    }

    private void buildStrategyLists() throws DevFailed {
        SplashUtils.getInstance().increaseSplashProgress(25, "Reading devices");
        this.strategyMap = new Hashtable();
        List<Subscriber> subscriberList = this.subscriberMap.getSubscriberList();
        for (Subscriber subscriber : subscriberList) {
            try {
                String[] attributeNames = new String[]{"AttributeList", "AttributeStrategyList"};
                DeviceAttribute[] attributes = subscriber.read_attribute(attributeNames);
                this.buildStrategyLists(subscriber.getStrategy(), attributes[0].extractStringArray(), attributes[1].extractStringArray());
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
        if (this.strategyMap.size() == 0) {
            Except.throw_exception((String)"EmptyStrategies", (String)"No strategy defined.");
        }
    }

    private void buildStrategyLists(Strategy strategy, String[] attributeNames, String[] strategyNames) {
        for (int i = 0; i < strategyNames.length; ++i) {
            List<HdbAttribute> list = this.strategyMap.get(strategyNames[i]);
            if (list == null) {
                list = new ArrayList<HdbAttribute>();
                this.strategyMap.put(strategyNames[i], list);
            }
            HdbAttribute attribute = new HdbAttribute(attributeNames[i]);
            attribute.clear();
            attribute.setStrategy(strategy, strategyNames[i]);
            list.add(attribute);
        }
    }

    private void changeStrategyActionPerformed() {
        int selection;
        block11: {
            selection = this.tabbedPane.getSelectedIndex();
            List<HdbAttribute> attributeList = this.attributeTreeList.get(selection).getSelectedAttributes();
            if (attributeList.isEmpty()) {
                ErrorPane.showErrorMessage((Component)this, (String)"No selection", (Exception)new Exception("Select attributes, members or families to change strategy"));
                return;
            }
            try {
                ArrayList<Strategy> strategyCopies = new ArrayList<Strategy>();
                for (HdbAttribute attribute : attributeList) {
                    strategyCopies.add(attribute.getStrategyCopy());
                }
                Strategy strategy = this.checkSubscriberStrategies(attributeList);
                if (strategy == null) {
                    return;
                }
                SelectionStrategiesDialog dialog = new SelectionStrategiesDialog(this, attributeList, strategy, Utils.getConfiguratorProxy());
                if (dialog.showDialog() == 0) {
                    SplashUtils.getInstance().startSplash();
                    SplashUtils.getInstance().setSplashProgress(5, "Setting attribute strategy");
                    SplashUtils.getInstance().startAutoUpdate();
                    dialog.setAttributeStrategy();
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    break block11;
                }
                for (int i = 0; i < attributeList.size(); ++i) {
                    attributeList.get(i).updateUsedContexts((Strategy)strategyCopies.get(i));
                }
                return;
            }
            catch (Exception e) {
                SplashUtils.getInstance().stopSplash();
                ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (Exception)e);
            }
        }
        try {
            this.buildStrategyLists();
            new ReInitializePanesThread(selection).start();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private Strategy checkSubscriberStrategies(List<HdbAttribute> attributeList) {
        List<Subscriber> subscriberList = this.subscriberMap.getSubscriberList();
        ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>();
        for (HdbAttribute attribute : attributeList) {
            for (Subscriber subscriber : subscriberList) {
                if (subscribers.contains((Object)subscriber) || !subscriber.manageAttribute(attribute.getName())) continue;
                subscribers.add(subscriber);
            }
        }
        Strategy strategy = ((Subscriber)((Object)subscribers.get(0))).getStrategy();
        for (Subscriber subscriber : subscribers) {
            Strategy strategy2 = subscriber.getStrategy();
            boolean ok = strategy.size() == strategy2.size();
            for (int i = 0; ok && i < strategy.size(); ++i) {
                ok = ((Context)strategy.get(i)).getName().equalsIgnoreCase(((Context)strategy2.get(i)).getName());
            }
            if (ok) continue;
            ErrorPane.showErrorMessage((Component)this, null, (Exception)new Exception("Subscribers have different strategies"));
            return null;
        }
        return strategy;
    }

    private void comboBoxActionPerformed(ActionEvent event) {
        JComboBox comboBox = (JComboBox)event.getSource();
        int index = comboBox.getSelectedIndex();
        this.attributeTreeList.get(this.tabbedPane.getSelectedIndex()).expandChildren(index);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        JPanel jPanel1 = new JPanel();
        JButton dismissButton = new JButton();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StrategyMainPanel.this.exitForm(evt);
            }
        });
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        dismissButton.setText("Dismiss");
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StrategyMainPanel.this.dismissButtonActionPerformed(evt);
            }
        });
        jPanel1.add(dismissButton);
        this.getContentPane().add((Component)jPanel1, "South");
        jLabel1.setFont(new Font("Dialog", 1, 18));
        jLabel1.setText("Strategies");
        jPanel2.add(jLabel1);
        this.getContentPane().add((Component)jPanel2, "First");
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void dismissButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            new StrategyMainPanel(null, null).setVisible(true);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    private class ReInitializePanesThread
    extends Thread {
        private int selection;

        private ReInitializePanesThread(int selection) {
            this.selection = selection;
        }

        @Override
        public void run() {
            StrategyMainPanel.this.buildTabbedPanes();
            while (this.selection >= StrategyMainPanel.this.tabbedPane.getTabCount() && this.selection > 0) {
                --this.selection;
            }
            StrategyMainPanel.this.tabbedPane.setSelectedIndex(this.selection);
            SplashUtils.getInstance().stopSplash();
        }
    }
}

