/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator.strategy;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Utils;

class StrategyAttributeTree
extends JTree
implements TangoConst {
    private DefaultMutableTreeNode root;
    private List<HdbAttribute> attributeList;
    private Component parent;
    private static final int TG_HOST = 0;
    private static final int DOMAIN = 1;
    private static final int FAMILY = 2;
    private static final int MEMBER = 3;
    private static final int ATTRIBUTE = 4;
    private static ImageIcon hdbIcon;
    private static ImageIcon deviceIcon;
    private static ImageIcon attributeIcon;

    StrategyAttributeTree(Component parent, String strategyName, List<HdbAttribute> attributeList) {
        this.parent = parent;
        this.attributeList = attributeList;
        this.setBackground(Color.white);
        this.buildTree(strategyName);
        this.expandChildren(this.root, 1);
        this.setSelectionPath(null);
    }

    private void buildTree(String root_name) {
        this.root = new DefaultMutableTreeNode(root_name);
        this.createNodes();
        this.getSelectionModel().setSelectionMode(4);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer renderer = new TangoRenderer();
        this.setCellRenderer(renderer);
    }

    private void createNodes() {
        this.addNodes(this.root, this.attributeList, 0);
    }

    private List<NameComponent> getNodeNames(List<HdbAttribute> attributes, int level) {
        Hashtable<String, ArrayList<HdbAttribute>> hashTable = new Hashtable<String, ArrayList<HdbAttribute>>();
        for (HdbAttribute attribute : attributes) {
            String key = attribute.getNameComponents().get(level);
            ArrayList<HdbAttribute> list = (ArrayList<HdbAttribute>)hashTable.get(key);
            if (list == null) {
                list = new ArrayList<HdbAttribute>();
                hashTable.put(key, list);
            }
            list.add(attribute);
        }
        ArrayList<NameComponent> nameComponents = new ArrayList<NameComponent>();
        Set strategies = hashTable.keySet();
        for (String strategy : strategies) {
            nameComponents.add(new NameComponent(level, strategy, (List)hashTable.get(strategy)));
        }
        Collections.sort(nameComponents, new ComponentComparator());
        return nameComponents;
    }

    private void addNodes(DefaultMutableTreeNode srcNode, List<HdbAttribute> attributes, int level) {
        List<NameComponent> nameComponents = this.getNodeNames(attributes, level);
        for (NameComponent nameComponent : nameComponents) {
            List hdbAttributes = nameComponent.attributeList;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(nameComponent);
            srcNode.add(node);
            if (level >= 4) continue;
            this.addNodes(node, hdbAttributes, level + 1);
        }
    }

    List<HdbAttribute> getSelectedAttributes() {
        ArrayList<HdbAttribute> attributes = new ArrayList<HdbAttribute>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                NameComponent component;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node == this.root || !(node.getUserObject() instanceof NameComponent) || (component = (NameComponent)node.getUserObject()).level <= 1) continue;
                attributes.addAll(component.attributeList);
            }
        }
        return attributes;
    }

    void expandChildren(int level) {
        if (level < 0 || level > 4) {
            ErrorPane.showErrorMessage((Component)this, (String)"Bad Value", (Exception)new Exception("Bad level to expand !"));
        }
        this.collapseChildren();
        this.expandChildren(this.root, level);
    }

    private void collapseChildren() {
        for (int row = this.getRowCount() - 1; row >= 0; --row) {
            this.collapseRow(row);
        }
    }

    private void expandChildren(DefaultMutableTreeNode node, int maxLevel) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            NameComponent nameComponent = (NameComponent)child.getUserObject();
            if (nameComponent.level < maxLevel) {
                this.expandChildren(child, maxLevel);
                continue;
            }
            this.expandNode(child);
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>();
        nodeList.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            nodeList.add(0, node);
        }
        Object[] tn = new DefaultMutableTreeNode[nodeList.size()];
        for (int i = 0; i < nodeList.size(); ++i) {
            tn[i] = (TreeNode)nodeList.get(i);
        }
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private class ComponentComparator
    implements Comparator<NameComponent> {
        private ComponentComparator() {
        }

        @Override
        public int compare(NameComponent component1, NameComponent component2) {
            if (component1 == null) {
                return 1;
            }
            if (component2 == null) {
                return -1;
            }
            return component1.name.compareTo(component2.name);
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font rootFont = new Font("Dialog", 1, 18);
        private Font nodeFont = new Font("Dialog", 1, 12);
        private Font attributeFont = new Font("Dialog", 0, 12);

        private TangoRenderer() {
            try {
                Utils utils = Utils.getInstance();
                hdbIcon = utils.getIcon("hdb++.gif", 0.4);
                deviceIcon = utils.getIcon("device.gif");
                attributeIcon = utils.getIcon("attribute.gif");
            }
            catch (DevFailed e) {
                SplashUtils.getInstance().stopSplash();
                ErrorPane.showErrorMessage((Component)StrategyAttributeTree.this.parent, null, (DevFailed)e);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(Color.white);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.rootFont);
                this.setIcon(hdbIcon);
            } else if (leaf) {
                this.setIcon(attributeIcon);
                this.setFont(this.attributeFont);
            } else {
                this.setIcon(deviceIcon);
                this.setFont(this.nodeFont);
            }
            return this;
        }
    }

    private class NameComponent {
        private int level;
        private String name;
        private List<HdbAttribute> attributeList = null;

        private NameComponent(int level, String name, List<HdbAttribute> attributeList) {
            this.level = level;
            this.name = name;
            this.attributeList = attributeList;
        }

        public String toString() {
            if (this.level == 2 || this.level == 3) {
                return this.name + " (" + this.attributeList.size() + ")";
            }
            return this.name;
        }
    }
}

