/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator.strategy;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.Utils;

public class StartStopArchiving
extends JFrame {
    private SubscriberMap subscriberMap;
    private boolean modified = false;
    private List<JRadioButton> radioButtonList = new ArrayList<JRadioButton>();
    private static final int Start = 0;
    private static final int Stop = 1;
    private static final String[] actionNames = new String[]{"Start", "Stop"};
    private JPanel centerPanel;

    private StartStopArchiving() throws DevFailed {
        SplashUtils.getInstance().startSplash();
        SplashUtils.getInstance().setSplashProgress(20, "Building GUI");
        this.initComponents();
        this.subscriberMap = new SubscriberMap(Utils.getConfiguratorProxy());
        SplashUtils.getInstance().setSplashProgress(30, "Building GUI");
        DbDatum datum = ApiUtil.get_db_obj().get_property("HdbConfigurator", "ShutdownArchivers");
        if (datum.is_empty()) {
            Except.throw_exception((String)"NoProperty", (String)"Free property 'HdbConfigurator/ShutdownArchivers' is not set");
        }
        String[] defaultSubscriberNames = datum.extractStringArray();
        List<String> labelList = this.subscriberMap.getLabelList();
        this.buildRadioButtons(labelList, defaultSubscriberNames);
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        SplashUtils.getInstance().stopSplash();
    }

    private void buildRadioButtons(List<String> labelList, String[] defaultSubscriberNames) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 0, 10);
        this.centerPanel.add((Component)new JSeparator(), gbc);
        gbc.gridwidth = 1;
        SplashUtils.getInstance().setSplashProgress(50, "Building GUI");
        int x1 = 0;
        int x2 = 1;
        int y1 = 1;
        int y2 = 2;
        ++gbc.gridy;
        for (String label : labelList) {
            JRadioButton radioButton = new JRadioButton(label);
            radioButton.setFont(new Font("Dialog", 1, 12));
            boolean inList = this.labelInList(label, defaultSubscriberNames);
            radioButton.setSelected(inList);
            this.radioButtonList.add(radioButton);
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StartStopArchiving.this.radioButtonActionPerformed();
                }
            });
            if (inList) {
                gbc.gridx = x1;
                gbc.gridy = y1++;
            } else {
                gbc.gridx = x2;
                gbc.gridy = y2++;
            }
            this.centerPanel.add((Component)radioButton, gbc);
        }
        gbc.gridx = x1;
        gbc.gridy = y1 > y2 ? y1 : y2;
        gbc.gridwidth = 2;
        this.centerPanel.add((Component)new JSeparator(), gbc);
    }

    private boolean labelInList(String label, String[] stringList) {
        for (String string : stringList) {
            if (!string.equals(label)) continue;
            return true;
        }
        return false;
    }

    private void radioButtonActionPerformed() {
        this.modified = true;
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        JPanel topPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton startButton = new JButton();
        JLabel dummyLabel = new JLabel();
        JButton stopButton = new JButton();
        JLabel dummyLabel1 = new JLabel();
        JButton cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StartStopArchiving.this.exitForm(evt);
            }
        });
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        jLabel1.setFont(new Font("Dialog", 1, 18));
        jLabel1.setText("Select Subscribers");
        topPanel.add(jLabel1);
        this.getContentPane().add((Component)topPanel, "First");
        startButton.setText("Start All");
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartStopArchiving.this.startButtonActionPerformed(evt);
            }
        });
        bottomPanel.add(startButton);
        dummyLabel.setText("   ");
        dummyLabel.setToolTipText("");
        bottomPanel.add(dummyLabel);
        stopButton.setText("Stop All");
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartStopArchiving.this.stopButtonActionPerformed(evt);
            }
        });
        bottomPanel.add(stopButton);
        dummyLabel1.setText("                             ");
        dummyLabel1.setToolTipText("");
        bottomPanel.add(dummyLabel1);
        cancelButton.setText("Dismiss");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartStopArchiving.this.cancelButtonActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelButton);
        this.getContentPane().add((Component)bottomPanel, "Last");
        this.pack();
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        List<String> subscriberNames = this.getSelectedSubscribers(0);
        if (subscriberNames == null || subscriberNames.isEmpty()) {
            return;
        }
        try {
            SplashUtils.getInstance().startSplash();
            int ratio = 90 / (subscriberNames.size() + 1);
            for (String subscriberName : subscriberNames) {
                SplashUtils.getInstance().setSplashProgress(ratio, "Start " + subscriberName + " attributes");
                this.doAction(subscriberName, 0);
            }
            SplashUtils.getInstance().stopSplash();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        List<String> subscriberNames = this.getSelectedSubscribers(1);
        if (subscriberNames == null || subscriberNames.isEmpty()) {
            return;
        }
        try {
            SplashUtils.getInstance().startSplash();
            int ratio = 90 / (subscriberNames.size() + 1);
            for (String subscriberName : subscriberNames) {
                SplashUtils.getInstance().setSplashProgress(ratio, "Stop " + subscriberName + " attributes");
                this.doAction(subscriberName, 1);
            }
            SplashUtils.getInstance().stopSplash();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.modified && JOptionPane.showConfirmDialog(this, "Save default selected archivers in database?", "Confirm", 0) == 0) {
            ArrayList<String> subscribers = new ArrayList<String>();
            for (JRadioButton button : this.radioButtonList) {
                if (!button.isSelected()) continue;
                subscribers.add(button.getText());
            }
            for (String subscriber : subscribers) {
                System.out.println(subscriber);
            }
            try {
                DbDatum datum = new DbDatum("ShutdownArchivers");
                datum.insert(subscribers.toArray(new String[subscribers.size()]));
                ApiUtil.get_db_obj().put_property("HdbConfigurator", new DbDatum[]{datum});
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
            }
        }
        System.exit(0);
    }

    private List<String> getSelectedSubscribers(int action) {
        ArrayList<String> subscriberNames = new ArrayList<String>();
        String message = actionNames[action] + " archiving for all attributes for:";
        for (JRadioButton radioButton : this.radioButtonList) {
            if (!radioButton.isSelected()) continue;
            String name = radioButton.getText();
            subscriberNames.add(name);
            message = message + "\n - " + name;
        }
        if (JOptionPane.showConfirmDialog(this, message, "Confirm", 0, 3) == 1) {
            return null;
        }
        return subscriberNames;
    }

    private void doAction(String subscriberLabel, int action) throws DevFailed {
        Subscriber subscriber = this.subscriberMap.getSubscriberByLabel(subscriberLabel);
        String[] attributeNames = action == 0 ? this.getAttributes(subscriber, "StoppedList") : this.getAttributes(subscriber, "StartedList");
        for (String attributeName : attributeNames) {
            DeviceData argIn = new DeviceData();
            argIn.insert(attributeName);
            subscriber.command_inout("Attribute" + actionNames[action], argIn);
        }
    }

    private String[] getAttributes(Subscriber subscriber, String actionName) throws DevFailed {
        String attributeName = "Attribute" + actionName;
        DeviceAttribute attribute = subscriber.read_attribute(attributeName);
        if (attribute.hasFailed()) {
            throw new DevFailed(attribute.getErrStack());
        }
        return attribute.extractStringArray();
    }

    public static void main(String[] args) {
        try {
            new StartStopArchiving().setVisible(true);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
    }
}

