/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator.strategy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.Context;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.common.Utils;

public class SelectionStrategiesPanel
extends JPanel {
    private List<HdbAttribute> hdbAttributeList;
    private List<String> columnNames = new ArrayList<String>();
    private Strategy strategy;
    private static final int NAME = 0;
    private static final int ALWAYS_COLUMN = 1;
    private static final String howTo = "\nSelect strategies to be used for each attribute";

    public SelectionStrategiesPanel(Strategy strategy, List<HdbAttribute> attributeList) {
        this.hdbAttributeList = attributeList;
        this.strategy = strategy;
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        JLabel label = new JLabel("HDB Strategies Selection");
        label.setFont(new Font("Dialog", 1, 14));
        panel.add(label);
        this.add((Component)panel, "North");
        this.columnNames.add("Attributes");
        for (Context context : strategy) {
            this.columnNames.add(context.getName());
        }
        this.buildTable();
    }

    private void buildTable() {
        StrategyTableModel model = new StrategyTableModel();
        JTable table = new JTable(model){

            @Override
            public String getToolTipText(MouseEvent event) {
                return SelectionStrategiesPanel.this.manageTooltip(event);
            }
        };
        table.setDefaultRenderer(String.class, new LabelCellRenderer());
        table.getTableHeader().setFont(new Font("Dialog", 1, 14));
        table.getTableHeader().setToolTipText(Utils.buildTooltip(howTo));
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SelectionStrategiesPanel.this.tableActionPerformed(evt);
            }
        });
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SelectionStrategiesPanel.this.headerActionPerformed(evt);
            }
        });
        JScrollPane scrollPane = new JScrollPane(table);
        this.add((Component)scrollPane, "Center");
        int nameWidth = this.getNameColumnWidth();
        Enumeration<TableColumn> columnEnum = table.getColumnModel().getColumns();
        int i = 0;
        int width = 0;
        while (columnEnum.hasMoreElements()) {
            width += i == 0 ? nameWidth : SelectionStrategiesPanel.getColumnWidth(this.columnNames.get(i));
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(i == 0 ? nameWidth : SelectionStrategiesPanel.getColumnWidth(this.columnNames.get(i)));
            ++i;
        }
        scrollPane.setPreferredSize(new Dimension(width, 40 + this.hdbAttributeList.size() * 16));
    }

    private String manageTooltip(MouseEvent event) {
        JTable table = (JTable)event.getSource();
        String tip = null;
        if (this.isVisible()) {
            Point p = event.getPoint();
            switch (table.columnAtPoint(p)) {
                case 0: {
                    tip = Utils.buildTooltip(howTo);
                    break;
                }
                default: {
                    Context context = (Context)this.strategy.get(table.columnAtPoint(p) - 1);
                    tip = Utils.buildTooltip(context.getHtmlDescription());
                }
            }
        }
        return tip;
    }

    public List<HdbAttribute> getHdbAttributeList() {
        return this.hdbAttributeList;
    }

    private void headerActionPerformed(MouseEvent event) {
        JTableHeader tableHeader = (JTableHeader)event.getSource();
        int column = tableHeader.columnAtPoint(event.getPoint());
        if ((event.getModifiers() & 0x10) != 0) {
            for (int row = 0; row < this.hdbAttributeList.size(); ++row) {
                this.manageCellClicked(row, column);
            }
        }
    }

    private void tableActionPerformed(MouseEvent event) {
        JTable table = (JTable)event.getSource();
        Point clickedPoint = new Point(event.getX(), event.getY());
        int selectedRow = table.rowAtPoint(clickedPoint);
        int column = table.columnAtPoint(clickedPoint);
        if ((event.getModifiers() & 0x10) != 0) {
            this.manageCellClicked(selectedRow, column);
        }
    }

    private void manageCellClicked(int row, int column) {
        if (column != 0) {
            HdbAttribute attribute = this.hdbAttributeList.get(row);
            switch (column) {
                case 1: {
                    ((Context)attribute.get(0)).setUsed(true);
                    for (int i = 1; i < attribute.size(); ++i) {
                        ((Context)attribute.get(i)).setUsed(false);
                    }
                    break;
                }
                default: {
                    ((Context)attribute.get(0)).setUsed(false);
                    ((Context)attribute.get(column - 1)).toggleUsed();
                    boolean used = ((Context)attribute.get(column - 1)).isUsed();
                    if (used) {
                        ((Context)attribute.get(0)).setUsed(false);
                        break;
                    }
                    used = false;
                    for (int i = 1; i < attribute.size() && !used; ++i) {
                        used = ((Context)attribute.get(i)).isUsed();
                    }
                    if (used) break;
                    ((Context)attribute.get(0)).setUsed(true);
                }
            }
        }
        this.repaint();
    }

    private int getNameColumnWidth() {
        ArrayList<String> names = new ArrayList<String>();
        for (HdbAttribute attribute : this.hdbAttributeList) {
            names.add(attribute.getName());
        }
        return Utils.getTableColumnWidth(names);
    }

    public static int getColumnWidth(String str) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(str);
        return Utils.getTableColumnWidth(list);
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setFont(new Font("Dialog", 1, 12));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(((HdbAttribute)SelectionStrategiesPanel.this.hdbAttributeList.get(row)).getName());
            return this;
        }
    }

    public class StrategyTableModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return SelectionStrategiesPanel.this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return SelectionStrategiesPanel.this.hdbAttributeList.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex >= this.getColumnCount()) {
                return (String)SelectionStrategiesPanel.this.columnNames.get(this.getColumnCount() - 1);
            }
            return (String)SelectionStrategiesPanel.this.columnNames.get(columnIndex);
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((HdbAttribute)SelectionStrategiesPanel.this.hdbAttributeList.get(row)).getName();
            }
            return ((Context)((HdbAttribute)SelectionStrategiesPanel.this.hdbAttributeList.get(row)).get(column - 1)).isUsed();
        }

        public Class getColumnClass(int column) {
            if (SelectionStrategiesPanel.this.isVisible()) {
                if (column == 0) {
                    return String.class;
                }
                return Boolean.class;
            }
            return null;
        }
    }
}

