/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator.strategy;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.configurator.strategy.SelectionStrategiesPanel;

public class SelectionStrategiesDialog
extends JDialog {
    private SelectionStrategiesPanel selectionPanel;
    private DeviceProxy configuratorProxy;
    private int returnedValue = 2;
    private static final int maxHeight = 400;

    public SelectionStrategiesDialog(JFrame parent, List<HdbAttribute> attributeList, Strategy strategy) throws DevFailed {
        this(parent, attributeList, strategy, null);
    }

    public SelectionStrategiesDialog(JFrame parent, List<HdbAttribute> attributeList, Strategy strategy, DeviceProxy configuratorProxy) throws DevFailed {
        super((Frame)parent, true);
        this.initForm(attributeList, strategy, configuratorProxy);
    }

    public SelectionStrategiesDialog(JDialog parent, List<HdbAttribute> attributeList, Strategy strategy, DeviceProxy configuratorProxy) throws DevFailed {
        super((Dialog)parent, true);
        this.initForm(attributeList, strategy, configuratorProxy);
    }

    private void initForm(List<HdbAttribute> attributeList, Strategy strategy, DeviceProxy configuratorProxy) throws DevFailed {
        this.configuratorProxy = configuratorProxy;
        this.initComponents();
        if (strategy == null) {
            strategy = Strategy.getContextsFromDB();
        }
        this.selectionPanel = new SelectionStrategiesPanel(strategy, attributeList);
        this.getContentPane().add((Component)this.selectionPanel, "Center");
        this.pack();
        int height = this.selectionPanel.getHeight();
        if (height > 400) {
            this.selectionPanel.setPreferredSize(new Dimension(this.selectionPanel.getWidth() + 20, 400));
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SelectionStrategiesDialog.this.closeDialog(evt);
            }
        });
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionStrategiesDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionStrategiesDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.returnedValue = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnedValue;
    }

    public List<HdbAttribute> getHdbAttributeList() {
        return this.selectionPanel.getHdbAttributeList();
    }

    public void setAttributeStrategy() throws DevFailed {
        if (this.configuratorProxy == null) {
            Except.throw_exception((String)"NotInitialized", (String)"configuratorProxy has not been initialized");
        }
        List<HdbAttribute> hdbAttributes = this.selectionPanel.getHdbAttributeList();
        for (HdbAttribute attribute : hdbAttributes) {
            String[] inArray = new String[]{attribute.getName(), attribute.strategyToString()};
            DeviceData argIn = new DeviceData();
            argIn.insert(inArray);
            this.configuratorProxy.command_inout("SetAttributeStrategy", argIn);
        }
    }
}

