/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator.strategy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.Context;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.common.Utils;

public class SelectionContextPanel
extends JPanel {
    private Strategy strategy;
    private int[] columnWidth = new int[]{100, 50};
    private static final String[] columnNames = new String[]{"Strategy", "Use It"};
    private static final int NAME = 0;
    private static final String howTo = "\nSelect strategies to be used for HDB storage";

    public SelectionContextPanel(Strategy strategy) {
        this.strategy = strategy;
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        JLabel label = new JLabel("HDB Strategy Selection");
        label.setFont(new Font("Dialog", 1, 14));
        panel.add(label);
        this.add((Component)panel, "North");
        this.buildTable();
    }

    private void buildTable() {
        StrategyTableModel model = new StrategyTableModel();
        JTable table = new JTable(model){

            @Override
            public String getToolTipText(MouseEvent event) {
                return SelectionContextPanel.this.manageTooltip(event);
            }
        };
        table.setDefaultRenderer(String.class, new LabelCellRenderer());
        table.getTableHeader().setFont(new Font("Dialog", 1, 14));
        table.getTableHeader().setToolTipText(Utils.buildTooltip(howTo));
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SelectionContextPanel.this.tableActionPerformed(evt);
            }
        });
        JScrollPane scrollPane = new JScrollPane(table);
        this.add((Component)scrollPane, "Center");
        int nameWidth = this.getNameColumnWidth();
        if (nameWidth > this.columnWidth[0]) {
            this.columnWidth[0] = nameWidth;
        }
        Enumeration<TableColumn> columnEnum = table.getColumnModel().getColumns();
        int i = 0;
        int width = 0;
        while (columnEnum.hasMoreElements()) {
            width += this.columnWidth[i];
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(this.columnWidth[i++]);
        }
        scrollPane.setPreferredSize(new Dimension(width, 40 + this.strategy.size() * 16));
    }

    private String manageTooltip(MouseEvent event) {
        JTable table = (JTable)event.getSource();
        String tip = null;
        if (this.isVisible()) {
            Point p = event.getPoint();
            switch (table.columnAtPoint(p)) {
                case 0: {
                    Context context = (Context)this.strategy.get(table.rowAtPoint(p));
                    tip = Utils.buildTooltip(context.getHtmlDescription());
                    break;
                }
                default: {
                    tip = Utils.buildTooltip(howTo);
                }
            }
        }
        return tip;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    private void tableActionPerformed(MouseEvent event) {
        JTable table = (JTable)event.getSource();
        Point clickedPoint = new Point(event.getX(), event.getY());
        int selectedRow = table.rowAtPoint(clickedPoint);
        int column = table.columnAtPoint(clickedPoint);
        int mask = event.getModifiers();
        if ((mask & 0x10) != 0 && column > 0) {
            Context context = (Context)this.strategy.get(selectedRow);
            context.toggleUsed();
            switch (selectedRow) {
                case 0: {
                    if (!context.isUsed()) break;
                    for (int i = 1; i < this.strategy.size(); ++i) {
                        ((Context)this.strategy.get(i)).setUsed(false);
                    }
                    break;
                }
                default: {
                    if (context.isUsed()) {
                        ((Context)this.strategy.get(0)).setUsed(false);
                        break;
                    }
                    boolean used = false;
                    for (int i = 1; i < this.strategy.size() && !used; ++i) {
                        used = ((Context)this.strategy.get(i)).isUsed();
                    }
                    if (used) break;
                    ((Context)this.strategy.get(0)).setUsed(true);
                }
            }
            this.repaint();
        }
    }

    private int getNameColumnWidth() {
        ArrayList<String> names = new ArrayList<String>();
        for (Context context : this.strategy) {
            names.add(context.getName());
        }
        return Utils.getTableColumnWidth(names);
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setFont(new Font("Dialog", 1, 12));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(((Context)SelectionContextPanel.this.strategy.get(row)).getName());
            return this;
        }
    }

    public class StrategyTableModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return SelectionContextPanel.this.strategy.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex >= this.getColumnCount()) {
                return columnNames[this.getColumnCount() - 1];
            }
            return columnNames[columnIndex];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((Context)SelectionContextPanel.this.strategy.get(row)).getName();
            }
            return ((Context)SelectionContextPanel.this.strategy.get(row)).isUsed();
        }

        public Class getColumnClass(int column) {
            if (SelectionContextPanel.this.isVisible()) {
                if (column == 0) {
                    return String.class;
                }
                return Boolean.class;
            }
            return null;
        }
    }
}

