/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator.strategy;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tango.hdb_configurator.common.Context;
import org.tango.hdb_configurator.common.Strategy;

class OneContextDialog
extends JDialog {
    private Strategy strategy;
    private Context context;
    private int returnValue = 0;
    private JTextArea descriptionTextArea;
    private JTextField nameTextField;

    OneContextDialog(JDialog parent, Strategy strategy) {
        this(parent, new Context("", "", false), true);
        this.strategy = strategy;
    }

    OneContextDialog(JDialog parent, Context context, boolean editName) {
        super((Dialog)parent, true);
        this.context = context;
        this.initComponents();
        this.nameTextField.setText(context.getName());
        this.nameTextField.setEnabled(editName);
        this.setDescription(context.getDescription());
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void setDescription(String description) {
        int end;
        String str = "";
        int start = 0;
        while ((end = description.indexOf("\\n", start)) > 0) {
            str = str + description.substring(start, end) + "\n";
            start = end + 2;
        }
        this.descriptionTextArea.setText(str + description.substring(start));
    }

    private String getDescription() {
        int end;
        String description = this.descriptionTextArea.getText().trim();
        String str = "";
        int start = 0;
        while ((end = description.indexOf("\n", start)) > 0) {
            str = str + description.substring(start, end) + "\\n";
            start = end + 1;
        }
        return str + description.substring(start);
    }

    private void initComponents() {
        JPanel centerPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.nameTextField = new JTextField();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OneContextDialog.this.closeDialog(evt);
            }
        });
        centerPanel.setLayout(new GridBagLayout());
        jLabel1.setText("Context Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        centerPanel.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("Context Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        centerPanel.add((Component)jLabel2, gridBagConstraints);
        this.nameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        centerPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.descriptionTextArea.setColumns(30);
        this.descriptionTextArea.setRows(10);
        jScrollPane1.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        centerPanel.add((Component)jScrollPane1, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OneContextDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OneContextDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String name = this.nameTextField.getText().trim();
        String desc = this.getDescription();
        String error = this.checkName(name);
        if (error == null) {
            this.context.setName(name);
            this.context.setDescription(desc);
            this.returnValue = 0;
            this.doClose();
        } else {
            JOptionPane.showMessageDialog(this, error, "Error", 0);
        }
    }

    private String checkName(String name) {
        if (name.isEmpty()) {
            return "Invalid name !";
        }
        if (this.strategy != null) {
            for (Context context : this.strategy) {
                if (!context.getName().equalsIgnoreCase(name)) continue;
                return name + " already exists";
            }
        }
        return null;
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    Context getContext() {
        return this.context;
    }

    int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }
}

