/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator.strategy;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.strategy.EditContextsDialog;
import org.tango.hdb_configurator.configurator.strategy.EditContextsPanel;

public class EditStrategiesDialog
extends JDialog {
    private JFrame parent;
    private List<Subscriber> subscriberList;
    private Strategy defaultStrategy;
    private EditContextsPanel editPanel;
    private JTable table;
    private DataTableModel dataTableModel;
    private int tableWidth;
    private TablePopupMenu popupMenu = new TablePopupMenu();
    private int returnValue = 0;
    private static final String[] columnNames = new String[]{"Subscriber", "Strategy", "Default"};
    private static final int[] columnWidth = new int[]{230, 450, 70};
    private static final int maxHeight = 800;
    private static final int SUBSCRIBER = 0;
    private static final int STRATEGY = 1;
    private static final int DEFAULT = 2;
    private static final int SUBSCRIBER_STRATEGIES = 1;
    private JPanel classPropertyPanel;
    private JPanel subscriberPropertyPanel;
    private JLabel title1Label;
    private JLabel title2Label;
    private static final int EDIT = 0;
    private static final int SET_DEFAULT = 1;
    private static final int COPY_STRATEGY = 2;
    private static final int PASTE_STRATEGY = 3;
    private static final int OFFSET = 2;
    private Subscriber selectedSubscriber;
    private Subscriber copiedSubscriber = null;
    private static String[] menuLabels = new String[]{"Edit Strategy", "Set strategy from class property", "Copy Strategy", "Paste Strategy"};

    public EditStrategiesDialog(JFrame parent, List<Subscriber> subscriberList) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.subscriberList = subscriberList;
        this.initComponents();
        this.title1Label.setText("HDB contexts as class property");
        this.defaultStrategy = Strategy.getContextsFromDB();
        this.editPanel = new EditContextsPanel(this, this.defaultStrategy, null);
        this.classPropertyPanel.add((Component)this.editPanel, "Center");
        this.title2Label.setText("Subscriber strategies");
        this.buildSubscriberTable();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void buildSubscriberTable() {
        this.dataTableModel = new DataTableModel();
        this.table = new JTable(this.dataTableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setDragEnabled(false);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setFont(new Font("Dialog", 1, 14));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EditStrategiesDialog.this.tableActionPerformed(evt);
            }
        });
        Enumeration<TableColumn> columnEnum = this.table.getColumnModel().getColumns();
        int i = 0;
        this.tableWidth = 0;
        while (columnEnum.hasMoreElements()) {
            this.tableWidth += columnWidth[i];
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(columnWidth[i++]);
        }
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.subscriberPropertyPanel.add((Component)scrollPane, "Center");
        this.setTableResize();
    }

    private void tableActionPerformed(MouseEvent event) {
        Point clickedPoint = new Point(event.getX(), event.getY());
        int row = this.table.rowAtPoint(clickedPoint);
        Subscriber subscriber = this.subscriberList.get(row);
        if (event.getClickCount() == 2) {
            this.editSubscriberStrategy(subscriber);
        } else if ((event.getModifiers() & 4) != 0) {
            this.popupMenu.showMenu(event, subscriber);
        }
    }

    private void setTableResize() {
        this.pack();
        JScrollPane scrollPane = (JScrollPane)this.table.getParent().getParent();
        int height = this.table.getHeight() + this.table.getTableHeader().getHeight() + 10;
        if (height > 800) {
            height = 800;
        }
        scrollPane.setPreferredSize(new Dimension(this.tableWidth + 20, height));
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JTabbedPane tabbedPane = new JTabbedPane();
        this.classPropertyPanel = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.title1Label = new JLabel();
        this.subscriberPropertyPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.title2Label = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditStrategiesDialog.this.closeDialog(evt);
            }
        });
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditStrategiesDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditStrategiesDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                EditStrategiesDialog.this.tabbedPaneStateChanged(evt);
            }
        });
        this.classPropertyPanel.setLayout(new BorderLayout());
        this.title1Label.setFont(new Font("Dialog", 1, 14));
        this.title1Label.setText("jLabel1");
        jPanel1.add(this.title1Label);
        this.classPropertyPanel.add((Component)jPanel1, "North");
        tabbedPane.addTab("Contexts Class Property", this.classPropertyPanel);
        this.subscriberPropertyPanel.setLayout(new BorderLayout());
        this.title2Label.setFont(new Font("Dialog", 1, 14));
        this.title2Label.setText("jLabel1");
        jPanel2.add(this.title2Label);
        this.subscriberPropertyPanel.add((Component)jPanel2, "North");
        tabbedPane.addTab("Subscriber Strategies", this.subscriberPropertyPanel);
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.editPanel != null) {
            try {
                Strategy strategy = Strategy.getContextsFromDB();
                if (strategy.different(this.defaultStrategy)) {
                    Strategy.putStrategiesToDB(this.defaultStrategy, null);
                    System.out.println("Put new strategy as class : " + this.defaultStrategy);
                }
                for (Subscriber subscriber : this.subscriberList) {
                    this.saveStrategyIfChanged(subscriber);
                }
                this.returnValue = 0;
                this.doClose();
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
            }
        }
    }

    private void saveStrategyIfChanged(Subscriber subscriber) throws DevFailed {
        if (subscriber.getStrategy().isClassProperty()) {
            System.out.println("Remove properties");
            subscriber.delete_property(new String[]{"ContextsList", "DefaultStrategy"});
        } else {
            Strategy strategy = subscriber.getStrategy();
            if (strategy.different(Strategy.getContextsFromDB(subscriber))) {
                Strategy.putStrategiesToDB(strategy, subscriber);
                System.out.println("Put new strategy for " + subscriber.getLabel() + " : " + strategy);
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        JTabbedPane tabbedPane;
        int index;
        if (this.isVisible() && (index = (tabbedPane = (JTabbedPane)evt.getSource()).getSelectedIndex()) == 1) {
            for (Subscriber subscriber : this.subscriberList) {
                if (!subscriber.getStrategy().isClassProperty()) continue;
                subscriber.setStrategy(this.defaultStrategy);
            }
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    private void editSubscriberStrategy(Subscriber subscriber) {
        try {
            EditContextsDialog dialog = new EditContextsDialog(this.parent, subscriber);
            if (dialog.showDialog() == 0) {
                Strategy strategy = dialog.getStrategy();
                subscriber.setStrategy(strategy);
                this.dataTableModel.fireTableDataChanged();
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    public static void main(String[] args) {
        try {
            SubscriberMap subscriberMap = new SubscriberMap(Utils.getConfiguratorProxy());
            Subscriber subscriber = subscriberMap.getSubscriberByLabel("SR 1");
            if (subscriber == null) {
                Except.throw_exception((String)"", (String)"Subscriber not found !");
            }
            new EditStrategiesDialog(null, subscriberMap.getSubscriberList()).setVisible(true);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (Exception)e);
        }
        System.exit(0);
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private JLabel title = new JLabel();

        private TablePopupMenu() {
            this.title.setFont(new Font("Dialog", 1, 12));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TablePopupMenu.this.menuActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        private void showMenu(MouseEvent event, Subscriber subscriber) {
            EditStrategiesDialog.this.selectedSubscriber = subscriber;
            this.title.setText(subscriber.getLabel());
            this.getComponent(3).setEnabled(!subscriber.getStrategy().isClassProperty());
            this.getComponent(5).setEnabled(EditStrategiesDialog.this.copiedSubscriber != null);
            this.show(EditStrategiesDialog.this.table, event.getX(), event.getY());
        }

        private void menuActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int itemIndex = -1;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                itemIndex = i;
            }
            switch (itemIndex) {
                case 0: {
                    EditStrategiesDialog.this.editSubscriberStrategy(EditStrategiesDialog.this.selectedSubscriber);
                    break;
                }
                case 1: {
                    EditStrategiesDialog.this.selectedSubscriber.setStrategy(EditStrategiesDialog.this.defaultStrategy);
                    EditStrategiesDialog.this.selectedSubscriber.getStrategy().setClassProperty(true);
                    break;
                }
                case 2: {
                    EditStrategiesDialog.this.copiedSubscriber = EditStrategiesDialog.this.selectedSubscriber;
                    break;
                }
                case 3: {
                    EditStrategiesDialog.this.selectedSubscriber.setStrategy(EditStrategiesDialog.this.copiedSubscriber.getStrategy());
                    EditStrategiesDialog.this.selectedSubscriber.getStrategy().setClassProperty(false);
                }
            }
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return EditStrategiesDialog.this.subscriberList.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            String title = columnIndex >= this.getColumnCount() ? columnNames[this.getColumnCount() - 1] : columnNames[columnIndex];
            return title;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return ((Subscriber)((Object)EditStrategiesDialog.this.subscriberList.get(row))).getLabel();
                }
                case 1: {
                    return ((Subscriber)((Object)EditStrategiesDialog.this.subscriberList.get(row))).getStrategy().toString();
                }
                case 2: {
                    return ((Subscriber)((Object)EditStrategiesDialog.this.subscriberList.get(row))).getStrategy().isClassProperty();
                }
            }
            return "? ?";
        }

        public Class getColumnClass(int column) {
            if (EditStrategiesDialog.this.isVisible()) {
                switch (column) {
                    case 0: 
                    case 1: {
                        return String.class;
                    }
                }
                return Boolean.class;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

