/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator.strategy;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.Context;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.strategy.OneContextDialog;
import org.tango.hdb_configurator.configurator.strategy.StrategyMainPanel;

public class EditContextsPanel
extends JPanel {
    private JDialog parent;
    private Strategy strategy;
    private int selectedRow = 0;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private StrategyTableModel model;
    private JTable table;
    private static final int[] columnWidth = new int[]{180, 500, 70};
    private static final String[] columnNames = new String[]{"Contexts", "Descriptions", "As Default"};
    private static final int CONTEXT = 0;
    private static final int DESCRIPTION = 1;
    private static final int DEFAULT_COL = 2;
    private static final String howTo = "\nDouble click to edit a context\n or use buttons to Add/Remove one";

    public EditContextsPanel(JDialog parent, Strategy strategy, String title) {
        this.parent = parent;
        this.strategy = strategy;
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        if (title != null && !title.isEmpty()) {
            JLabel label = new JLabel(title);
            label.setFont(new Font("Dialog", 1, 14));
            panel.add(label);
        }
        this.addButtons(panel);
        this.add((Component)panel, "North");
        this.buildTable();
    }

    private void buttonActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        if (btn.getText().trim().equals("+")) {
            OneContextDialog contextDialog = new OneContextDialog(this.parent, this.strategy);
            if (contextDialog.showDialog() == 0) {
                this.strategy.add(contextDialog.getContext());
            }
        } else if (btn.getText().trim().equals("-")) {
            try {
                Context context = (Context)this.strategy.get(this.selectedRow);
                if (this.attributesUseContext(context)) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, "remove context '" + context.getName() + "'  ?", "Confirm", 0) != 0) {
                    return;
                }
                this.strategy.remove(this.selectedRow);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                return;
            }
        } else if (btn == this.upButton) {
            Context context = (Context)this.strategy.remove(this.selectedRow);
            this.strategy.add(--this.selectedRow, context);
        } else if (btn == this.downButton) {
            Context context = (Context)this.strategy.remove(this.selectedRow);
            this.strategy.add(++this.selectedRow, context);
        }
        this.model.fireTableDataChanged();
        this.table.getSelectionModel().setSelectionInterval(this.selectedRow, this.selectedRow);
        this.manageButtons();
    }

    private boolean attributesUseContext(Context context) throws DevFailed {
        StrategyMainPanel strategyMainPanel = new StrategyMainPanel(this.parent);
        String strategyStr = strategyMainPanel.hasAttributeUsingContext(context);
        if (strategyStr != null) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)new Exception("This context is used by attribute(s).\nPlease, change attribute(s) strategy"));
            strategyMainPanel.setPane(strategyStr);
            strategyMainPanel.setVisible(true);
            return true;
        }
        return false;
    }

    private void buildTable() {
        this.model = new StrategyTableModel();
        this.table = new JTable(this.model){

            @Override
            public String getToolTipText(MouseEvent event) {
                return EditContextsPanel.this.manageTooltip(event);
            }
        };
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setFont(new Font("Dialog", 1, 14));
        this.table.getTableHeader().setToolTipText(Utils.buildTooltip(howTo));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EditContextsPanel.this.tableActionPerformed(evt);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        int nameWidth = this.getNameColumnWidth();
        if (nameWidth > columnWidth[0]) {
            EditContextsPanel.columnWidth[0] = nameWidth;
        }
        Enumeration<TableColumn> columnEnum = this.table.getColumnModel().getColumns();
        int i = 0;
        int width = 0;
        while (columnEnum.hasMoreElements()) {
            width += columnWidth[i];
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(columnWidth[i++]);
        }
        scrollPane.setPreferredSize(new Dimension(width, 40 + this.strategy.size() * 16));
    }

    private String manageTooltip(MouseEvent event) {
        JTable table = (JTable)event.getSource();
        String tip = null;
        if (this.isVisible()) {
            Point p = event.getPoint();
            switch (table.columnAtPoint(p)) {
                case 0: {
                    Context context = (Context)this.strategy.get(table.rowAtPoint(p));
                    tip = Utils.buildTooltip(context.getHtmlDescription());
                    break;
                }
                case 2: {
                    tip = Utils.buildTooltip("Select for context as default");
                    break;
                }
                default: {
                    tip = Utils.buildTooltip(howTo);
                }
            }
        }
        return tip;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    private void tableActionPerformed(MouseEvent event) {
        JTable table = (JTable)event.getSource();
        Point clickedPoint = new Point(event.getX(), event.getY());
        this.selectedRow = table.rowAtPoint(clickedPoint);
        int selectedColumn = table.columnAtPoint(clickedPoint);
        int mask = event.getModifiers();
        this.manageButtons();
        if (event.getClickCount() == 1 && (mask & 0x10) != 0) {
            if (selectedColumn == 2) {
                ((Context)this.strategy.get(this.selectedRow)).setDefault(!((Context)this.strategy.get(this.selectedRow)).isDefault());
                boolean isDefault = ((Context)this.strategy.get(this.selectedRow)).isDefault();
                switch (this.selectedRow) {
                    case 0: {
                        if (!isDefault) break;
                        for (int i = 1; i < this.strategy.size(); ++i) {
                            ((Context)this.strategy.get(i)).setDefault(false);
                        }
                        break;
                    }
                    default: {
                        if (isDefault) {
                            ((Context)this.strategy.get(0)).setDefault(false);
                            break;
                        }
                        isDefault = false;
                        for (int i = 1; i < this.strategy.size() && !isDefault; ++i) {
                            isDefault = ((Context)this.strategy.get(i)).isDefault();
                        }
                        if (isDefault) break;
                        ((Context)this.strategy.get(0)).setDefault(true);
                    }
                }
                this.model.fireTableDataChanged();
            }
        } else if (event.getClickCount() == 2 && (mask & 0x10) != 0) {
            new OneContextDialog(this.parent, (Context)this.strategy.get(this.selectedRow), this.selectedRow != 0).setVisible(true);
            this.model.fireTableDataChanged();
        }
    }

    private int getNameColumnWidth() {
        ArrayList<String> names = new ArrayList<String>();
        for (Context context : this.strategy) {
            names.add(context.getName());
        }
        return Utils.getTableColumnWidth(names);
    }

    private void manageButtons() {
        this.removeButton.setEnabled(this.selectedRow > 0);
        this.upButton.setEnabled(this.selectedRow > 1);
        this.downButton.setEnabled(this.selectedRow > 0 && this.selectedRow < this.strategy.size() - 1);
    }

    private void addButtons(JPanel panel) {
        JButton addButton = new JButton(" + ");
        addButton.setToolTipText("Add new context");
        addButton.setForeground(new Color(0, 160, 0));
        addButton.setFont(new Font("Dialog", 1, 18));
        addButton.setBorder(null);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditContextsPanel.this.buttonActionPerformed(evt);
            }
        });
        panel.add(new JLabel("       "));
        panel.add(addButton);
        this.removeButton = new JButton(" - ");
        this.removeButton.setToolTipText("Remove selection");
        this.removeButton.setForeground(Color.red);
        this.removeButton.setFont(new Font("Dialog", 1, 18));
        this.removeButton.setBorder(null);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditContextsPanel.this.buttonActionPerformed(evt);
            }
        });
        panel.add(this.removeButton);
        try {
            this.upButton = new JButton(Utils.getInstance().getIcon("up.gif"));
            this.upButton.setToolTipText("Add new context");
            this.upButton.setForeground(new Color(0, 160, 0));
            this.upButton.setFont(new Font("Dialog", 1, 18));
            this.upButton.setBorder(null);
            this.upButton.setEnabled(false);
            this.upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditContextsPanel.this.buttonActionPerformed(evt);
                }
            });
            panel.add(new JLabel("    "));
            panel.add(this.upButton);
            this.downButton = new JButton(Utils.getInstance().getIcon("down.gif"));
            this.downButton.setToolTipText("Add new context");
            this.downButton.setForeground(new Color(0, 160, 0));
            this.downButton.setFont(new Font("Dialog", 1, 18));
            this.downButton.setBorder(null);
            this.downButton.setEnabled(false);
            this.downButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditContextsPanel.this.buttonActionPerformed(evt);
                }
            });
            panel.add(this.downButton);
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
    }

    public class StrategyTableModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return EditContextsPanel.this.strategy.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex >= this.getColumnCount()) {
                return columnNames[this.getColumnCount() - 1];
            }
            return columnNames[columnIndex];
        }

        @Override
        public Object getValueAt(int row, int column) {
            Context context = (Context)EditContextsPanel.this.strategy.get(row);
            switch (column) {
                case 0: {
                    return " " + context.getName();
                }
                case 1: {
                    return " " + ((Context)EditContextsPanel.this.strategy.get(row)).getDescription();
                }
            }
            return context.isDefault();
        }

        public Class getColumnClass(int column) {
            if (EditContextsPanel.this.isVisible()) {
                switch (column) {
                    case 0: 
                    case 1: {
                        return String.class;
                    }
                }
                return Boolean.class;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

