/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.HdbConfigurator;

public class TtlTableDialog
extends JDialog {
    private JFrame parent;
    private SubscriberMap subscriberMap;
    private List<TtlTable> ttlTableList = new ArrayList<TtlTable>();
    private static final int ATTRIBUTE_NAME = 0;
    private static final String[] columnNames = new String[]{"Attribute Names", "TTL"};
    private static final int[] columnWidth = new int[]{500, 60};
    private JTabbedPane tabbedPane;
    private JLabel titleLabel;

    public TtlTableDialog(JFrame parent, SubscriberMap subscriberMap) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.subscriberMap = subscriberMap;
        this.initComponents();
        this.initializeTtlTables();
        if (this.ttlTableList.isEmpty()) {
            Except.throw_exception((String)"NoTTL", (String)"No TTL attribute found");
        }
        this.buildTabbedTables();
        this.titleLabel.setText("TTL Attributes");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        SplashUtils.getInstance().stopSplash();
    }

    private void buildTabbedTables() {
        int idx = 0;
        for (TtlTable ttlTable : this.ttlTableList) {
            JScrollPane scrollPane = new JScrollPane(ttlTable);
            this.tabbedPane.add(scrollPane);
            this.tabbedPane.setTitleAt(idx++, ttlTable.subscriber.getLabel());
            scrollPane.setPreferredSize(new Dimension(ttlTable.tableWidth, 300));
        }
    }

    private void initializeTtlTables() {
        for (Subscriber subscriber : this.subscriberMap.getSubscriberList()) {
            Set<String> keys = subscriber.getHdbAttributeMap().keySet();
            ArrayList<HdbAttribute> attributeList = new ArrayList<HdbAttribute>();
            for (String attributeName : keys) {
                long ttl;
                HdbAttribute hdbAttribute = subscriber.getHdbAttributeMap().get(attributeName);
                if (hdbAttribute == null || (ttl = hdbAttribute.getTTL()) <= 0L) continue;
                attributeList.add(hdbAttribute);
            }
            if (attributeList.isEmpty()) continue;
            this.ttlTableList.add(new TtlTable(subscriber, attributeList));
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton cancelBtn = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TtlTableDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TtlTableDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            SplashUtils.getInstance().startSplash();
            SplashUtils.getInstance().increaseSplashProgress(10, "Building GUI");
            SubscriberMap subscriberMap = new SubscriberMap(Utils.getConfiguratorProxy());
            new TtlTableDialog(null, subscriberMap).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    public class TtlTableModel
    extends AbstractTableModel {
        private TtlTable ttlTable;

        private TtlTableModel(TtlTable ttlTable) {
            this.ttlTable = ttlTable;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.ttlTable.ttlAttributes.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            String title = columnIndex >= this.getColumnCount() ? columnNames[this.getColumnCount() - 1] : columnNames[columnIndex];
            if (title.startsWith("tango://")) {
                int index = title.indexOf(47, "tango://".length());
                title = title.substring(index + 1);
            }
            return title;
        }

        @Override
        public Object getValueAt(int row, int column) {
            HdbAttribute hdbAttribute = (HdbAttribute)this.ttlTable.ttlAttributes.get(row);
            switch (column) {
                case 0: {
                    return hdbAttribute.getName();
                }
            }
            return "  " + hdbAttribute.getTtlString();
        }

        public Class getColumnClass(int column) {
            if (TtlTableDialog.this.isVisible()) {
                return this.getValueAt(0, column).getClass();
            }
            return null;
        }
    }

    private class TtlTable
    extends JTable {
        private Subscriber subscriber;
        private List<HdbAttribute> ttlAttributes;
        private int tableWidth = 0;

        private TtlTable(Subscriber subscriber, List<HdbAttribute> ttlAttributes) {
            this.subscriber = subscriber;
            this.ttlAttributes = ttlAttributes;
            TtlTableModel model = new TtlTableModel(this);
            this.setModel(model);
            this.setRowSelectionAllowed(true);
            this.setDragEnabled(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    TtlTable.this.tableActionPerformed(event);
                }
            });
            Enumeration<TableColumn> columnEnum = this.getColumnModel().getColumns();
            int i = 0;
            while (columnEnum.hasMoreElements()) {
                this.tableWidth += columnWidth[i];
                TableColumn tableColumn = columnEnum.nextElement();
                tableColumn.setPreferredWidth(columnWidth[i++]);
            }
        }

        private void tableActionPerformed(MouseEvent event) {
            if (event.getClickCount() == 2 && TtlTableDialog.this.parent instanceof HdbConfigurator) {
                ((HdbConfigurator)TtlTableDialog.this.parent).selectArchiver(this.subscriber.getLabel());
                ((HdbConfigurator)TtlTableDialog.this.parent).selectAttributeInList(this.ttlAttributes.get(this.getSelectedRow()).getName());
                TtlTableDialog.this.doClose();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.subscriber.getLabel() + '\n');
            for (HdbAttribute ttlAttribute : this.ttlAttributes) {
                sb.append("    ").append(ttlAttribute).append('\n');
            }
            return sb.toString();
        }
    }
}

