/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;

public class TTLDialog
extends JDialog {
    private JFrame parent;
    private String nbDayStr = null;
    private List<HdbAttribute> hdbAttributeList;
    private Subscriber subscriber;
    private int returnValue = 0;
    private JRadioButton ttlButton;
    private JTextField ttlTextField;

    TTLDialog(JFrame parent, List<HdbAttribute> hdbAttributeList, Subscriber subscriber) {
        super((Frame)parent, true);
        this.parent = parent;
        this.hdbAttributeList = hdbAttributeList;
        this.subscriber = subscriber;
        this.initComponents();
        this.ttlTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTLDialog.this.okBtnActionPerformed(evt);
            }
        });
        for (HdbAttribute hdbAttribute : hdbAttributeList) {
            if (hdbAttribute.getTTL() <= 0L) continue;
            this.nbDayStr = Long.toString(hdbAttribute.getTTL() / 24L);
            this.ttlButton.setSelected(true);
            this.ttlTextField.setText(this.nbDayStr);
            break;
        }
        if (this.nbDayStr == null) {
            this.nbDayStr = Long.toString(TangoUtils.getDefaultTTL());
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        JPanel centerPanel = new JPanel();
        this.ttlButton = new JRadioButton();
        this.ttlTextField = new JTextField();
        JLabel jLabel2 = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TTLDialog.this.closeDialog(evt);
            }
        });
        titleLabel.setFont(new Font("Dialog", 1, 18));
        titleLabel.setText("   Attribute Time To Live   ");
        topPanel.add(titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        centerPanel.setLayout(new GridBagLayout());
        this.ttlButton.setText("Set TTL  ");
        this.ttlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTLDialog.this.ttlButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 0);
        centerPanel.add((Component)this.ttlButton, gridBagConstraints);
        this.ttlTextField.setColumns(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 20, 0);
        centerPanel.add((Component)this.ttlTextField, gridBagConstraints);
        jLabel2.setText(" days");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 20, 20);
        centerPanel.add((Component)jLabel2, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTLDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTLDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        long nbDays = this.getNbDays();
        if (nbDays < 0L) {
            ErrorPane.showErrorMessage((Component)this, (String)"NumberFormatException", (Exception)new Exception("Invalid TTL value"));
            return;
        }
        try {
            long ttl = nbDays * 24L;
            this.subscriber.setTTL(this.hdbAttributeList, ttl);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.toString(), (DevFailed)e);
        }
        this.returnValue = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void ttlButtonActionPerformed(ActionEvent evt) {
        JRadioButton button = (JRadioButton)evt.getSource();
        if (button.isSelected()) {
            this.ttlTextField.setText(this.nbDayStr);
        } else {
            this.nbDayStr = this.ttlTextField.getText();
            this.ttlTextField.setText("");
        }
        this.ttlTextField.setEnabled(button.isSelected());
    }

    private long getNbDays() {
        if (this.ttlButton.isSelected()) {
            try {
                return Long.parseLong(this.ttlTextField.getText());
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return 0L;
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    public static void main(String[] args) {
        try {
            HdbAttribute attribute = new HdbAttribute("tango://orion.esrf.fr:10000/sy/ps-rips/manager/state");
            attribute.setTTL(480L);
            ArrayList<HdbAttribute> attributeList = new ArrayList<HdbAttribute>();
            attributeList.add(attribute);
            SubscriberMap subscriberMap = new SubscriberMap(Utils.getConfiguratorProxy());
            Subscriber subscriber = subscriberMap.getSubscriberList().get(0);
            new TTLDialog(null, attributeList, subscriber).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
    }
}

