/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Selector
extends JDialog {
    private String selection = "";
    private JComboBox<String> comboBox;
    private JLabel questionLabel;
    private JLabel titleLabel;

    public Selector(JFrame parent, String title, String question, List<String> values, String defaultValue) {
        super((Frame)parent, true);
        this.createDialog(title, question, values, defaultValue);
    }

    public Selector(JDialog parent, String title, String question, List<String> values, String defaultValue) {
        super((Dialog)parent, true);
        this.createDialog(title, question, values, defaultValue);
    }

    public void createDialog(String title, String question, List<String> values, String defaultValue) {
        this.initComponents();
        this.comboBox.addItem("");
        for (int i = 0; values != null && i < values.size(); ++i) {
            this.comboBox.addItem(values.get(i));
            if (!values.get(i).equals(defaultValue)) continue;
            this.comboBox.setSelectedIndex(i + 1);
        }
        this.comboBox.setEditable(true);
        this.titleLabel.setText(title);
        if (question == null) {
            this.questionLabel.setVisible(false);
        } else {
            this.questionLabel.setText(question);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel centerPanel = new JPanel();
        this.comboBox = new JComboBox();
        this.questionLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Selector.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        centerPanel.setLayout(new GridBagLayout());
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Selector.this.comboBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(30, 5, 30, 30);
        centerPanel.add(this.comboBox, gridBagConstraints);
        this.questionLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(30, 30, 30, 0);
        centerPanel.add((Component)this.questionLabel, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Selector.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Selector.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void comboBoxActionPerformed(ActionEvent evt) {
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.selection = (String)this.comboBox.getSelectedItem();
        if (this.selection != null && !this.selection.isEmpty()) {
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.selection = null;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.selection = null;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
    }

    public String showDialog() {
        this.setVisible(true);
        return this.selection;
    }
}

