/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tango.hdb_configurator.common.Context;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.strategy.SelectionContextPanel;

public class PropertyDialog
extends JDialog
implements TangoConst {
    private JFrame parent;
    private SubscriberMap subscriberMap;
    private List<HdbAttribute> attributeList = new ArrayList<HdbAttribute>();
    private AttributeProxy attributeProxy = null;
    private AttributeInfoEx attributeInfoEx;
    private boolean manageProperties;
    private SelectionContextPanel strategyPanel;
    private String nbDayStr;
    private boolean canceled = false;
    private static final int MaxRows = 30;
    private int pollingPeriod = 0;
    private JTextField absTxt;
    private JLabel archiverLabel;
    private JTextArea attributeListArea;
    private JScrollPane attributeListScrollPane;
    private JTextField eventPeriodTxt;
    private JTextField pollingPeriodTxt;
    private JPanel propertyPanel;
    private JRadioButton pushedByCodeButton;
    private JTextField relTxt;
    private JRadioButton startArchivingButton;
    private JComboBox<String> subscriberComboBox;
    private JPanel subscriptionPanel;
    private JLabel titleLabel;
    private JRadioButton ttlButton;
    private JTextField ttlTextField;

    public PropertyDialog(JFrame parent, HdbAttribute attributeList, SubscriberMap subscriberMap, String defaultItem) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.subscriberMap = subscriberMap;
        this.attributeList.add(attributeList);
        this.initComponents();
        this.initOwnComponents(defaultItem);
        this.manageProperties = true;
        this.displayProperty();
        this.titleLabel.setText(attributeList.getName());
        this.attributeListScrollPane.setVisible(false);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public PropertyDialog(JFrame parent, List<HdbAttribute> attributeList, SubscriberMap subscriberMap, String defaultItem) {
        super((Frame)parent, true);
        this.parent = parent;
        this.subscriberMap = subscriberMap;
        this.attributeList = attributeList;
        this.initComponents();
        this.initOwnComponents(defaultItem);
        this.manageProperties = false;
        this.propertyPanel.setVisible(false);
        this.titleLabel.setVisible(false);
        StringBuilder sb = new StringBuilder();
        int length = 0;
        for (HdbAttribute attribute : attributeList) {
            sb.append(attribute.getName()).append("\n");
            if (attribute.getName().length() <= length) continue;
            length = attribute.getName().length();
        }
        int nbRows = attributeList.size();
        if (attributeList.size() > 30) {
            nbRows = 30;
        }
        this.attributeListArea.setRows(nbRows);
        this.attributeListArea.setColumns(length + 1);
        this.attributeListArea.setText(sb.toString().trim());
        this.attributeListArea.setEditable(false);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initOwnComponents(String defaultItem) {
        this.ttlTextField.setEnabled(false);
        this.nbDayStr = Long.toString(TangoUtils.getDefaultTTL());
        this.propertyPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Event Properties"));
        this.subscriptionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Events Subscription"));
        this.pushedByCodeButton.setToolTipText(Utils.buildTooltip("Select if event is pushed by code"));
        this.startArchivingButton.setToolTipText(Utils.buildTooltip("Select to start archiving at subscription"));
        this.archiverLabel.setToolTipText(Utils.buildTooltip("Select archiver to manage storage"));
        this.subscriberComboBox.setToolTipText(Utils.buildTooltip("Select archiver to manage storage"));
        this.subscriberComboBox.removeAllItems();
        List<String> subscriberNames = this.subscriberMap.getLabelList();
        for (String subscriberName : subscriberNames) {
            this.subscriberComboBox.addItem(subscriberName);
        }
        this.subscriberComboBox.setSelectedItem(defaultItem);
        try {
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel((String)this.subscriberComboBox.getSelectedItem());
            this.addStrategyPanel(subscriber);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void addStrategyPanel(Subscriber subscriber) throws DevFailed {
        Strategy strategy = Strategy.getContextsFromDB(subscriber);
        this.strategyPanel = new SelectionContextPanel(strategy);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.insets = new Insets(0, 30, 0, 0);
        this.subscriptionPanel.add((Component)this.strategyPanel, gbc);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JPanel jPanel5 = new JPanel();
        JLabel titleLabel1 = new JLabel();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.attributeListScrollPane = new JScrollPane();
        this.attributeListArea = new JTextArea();
        JPanel centerPanel = new JPanel();
        this.subscriptionPanel = new JPanel();
        this.startArchivingButton = new JRadioButton();
        this.pushedByCodeButton = new JRadioButton();
        this.subscriberComboBox = new JComboBox();
        this.archiverLabel = new JLabel();
        this.ttlButton = new JRadioButton();
        this.ttlTextField = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.propertyPanel = new JPanel();
        JLabel absLbl = new JLabel();
        JLabel relLbl = new JLabel();
        JLabel periodLbl = new JLabel();
        this.absTxt = new JTextField();
        this.relTxt = new JTextField();
        this.eventPeriodTxt = new JTextField();
        JButton resetAbsBtn = new JButton();
        JButton resetRelBtn = new JButton();
        JButton resetPerBtn = new JButton();
        JLabel jLabel4 = new JLabel();
        this.pollingPeriodTxt = new JTextField();
        JLabel dummyLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton subscribeBtn = new JButton();
        JLabel jLabel1 = new JLabel();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PropertyDialog.this.closeDialog(evt);
            }
        });
        topPanel.setLayout(new BorderLayout());
        titleLabel1.setFont(new Font("Dialog", 1, 18));
        titleLabel1.setText("Archive  Events  for");
        jPanel5.add(titleLabel1);
        topPanel.add((Component)jPanel5, "North");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Attribute Name");
        jPanel2.add(this.titleLabel);
        this.attributeListArea.setBackground(new Color(240, 240, 240));
        this.attributeListArea.setColumns(20);
        this.attributeListArea.setFont(new Font("Dialog", 1, 14));
        this.attributeListArea.setRows(5);
        this.attributeListScrollPane.setViewportView(this.attributeListArea);
        jPanel2.add(this.attributeListScrollPane);
        topPanel.add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)topPanel, "North");
        centerPanel.setLayout(new BorderLayout());
        this.subscriptionPanel.setLayout(new GridBagLayout());
        this.startArchivingButton.setFont(new Font("Tahoma", 1, 12));
        this.startArchivingButton.setSelected(true);
        this.startArchivingButton.setText("Start Archiving");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.subscriptionPanel.add((Component)this.startArchivingButton, gridBagConstraints);
        this.pushedByCodeButton.setText("Event pushed by code");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.subscriptionPanel.add((Component)this.pushedByCodeButton, gridBagConstraints);
        this.subscriberComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.subscriberComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.subscriptionPanel.add(this.subscriberComboBox, gridBagConstraints);
        this.archiverLabel.setFont(new Font("Tahoma", 1, 12));
        this.archiverLabel.setText("Archiver: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 22, 0, 0);
        this.subscriptionPanel.add((Component)this.archiverLabel, gridBagConstraints);
        this.ttlButton.setText("Set TTL  ");
        this.ttlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.ttlButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.subscriptionPanel.add((Component)this.ttlButton, gridBagConstraints);
        this.ttlTextField.setColumns(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.subscriptionPanel.add((Component)this.ttlTextField, gridBagConstraints);
        jLabel2.setText(" days");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.subscriptionPanel.add((Component)jLabel2, gridBagConstraints);
        centerPanel.add((Component)this.subscriptionPanel, "North");
        this.propertyPanel.setLayout(new GridBagLayout());
        absLbl.setText("absolute change:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.propertyPanel.add((Component)absLbl, gridBagConstraints);
        relLbl.setText("relative change:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.propertyPanel.add((Component)relLbl, gridBagConstraints);
        periodLbl.setText("event period (ms):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 20, 10);
        this.propertyPanel.add((Component)periodLbl, gridBagConstraints);
        this.absTxt.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.propertyPanel.add((Component)this.absTxt, gridBagConstraints);
        this.relTxt.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.propertyPanel.add((Component)this.relTxt, gridBagConstraints);
        this.eventPeriodTxt.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 20, 10);
        this.propertyPanel.add((Component)this.eventPeriodTxt, gridBagConstraints);
        resetAbsBtn.setText("Reset");
        resetAbsBtn.setMargin(new Insets(2, 2, 2, 2));
        resetAbsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.resetAbsBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.propertyPanel.add((Component)resetAbsBtn, gridBagConstraints);
        resetRelBtn.setText("Reset");
        resetRelBtn.setMargin(new Insets(2, 2, 2, 2));
        resetRelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.resetRelBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.propertyPanel.add((Component)resetRelBtn, gridBagConstraints);
        resetPerBtn.setText("Reset");
        resetPerBtn.setMargin(new Insets(2, 2, 2, 2));
        resetPerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.resetPerBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 20, 10);
        this.propertyPanel.add((Component)resetPerBtn, gridBagConstraints);
        jLabel4.setText("Attribute polling period (ms):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 15, 10);
        this.propertyPanel.add((Component)jLabel4, gridBagConstraints);
        this.pollingPeriodTxt.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 15, 10);
        this.propertyPanel.add((Component)this.pollingPeriodTxt, gridBagConstraints);
        centerPanel.add((Component)this.propertyPanel, "South");
        dummyLabel.setText("     ");
        centerPanel.add((Component)dummyLabel, "Center");
        this.getContentPane().add((Component)centerPanel, "Center");
        subscribeBtn.setText("Subscribe");
        subscribeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.subscribeBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(subscribeBtn);
        jLabel1.setText("        ");
        bottomPanel.add(jLabel1);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void resetPerBtnActionPerformed(ActionEvent evt) {
        this.eventPeriodTxt.setText("Not specified");
    }

    private void resetRelBtnActionPerformed(ActionEvent evt) {
        this.relTxt.setText("Not specified");
    }

    private void resetAbsBtnActionPerformed(ActionEvent evt) {
        this.absTxt.setText("Not specified");
    }

    private boolean checkValues() {
        if (this.getNbDays() < 0L) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)new Exception("TTL input syntax error"));
            return false;
        }
        if (this.manageProperties) {
            try {
                String strValue = this.absTxt.getText().trim();
                if (!strValue.equals("Not specified")) {
                    Double.parseDouble(strValue);
                }
                if (!(strValue = this.relTxt.getText().trim()).equals("Not specified")) {
                    Double.parseDouble(strValue);
                }
                if (!(strValue = this.eventPeriodTxt.getText().trim()).equals("Not specified")) {
                    Integer.parseInt(strValue);
                }
                if (!(strValue = this.pollingPeriodTxt.getText().trim()).equals("Not Polled")) {
                    Integer.parseInt(strValue);
                }
            }
            catch (Exception e) {
                ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
                return false;
            }
        }
        return true;
    }

    private boolean writeValues() {
        if (this.manageProperties) {
            try {
                String s;
                boolean changed = false;
                if (this.attributeInfoEx.events.arch_event.abs_change != null && !this.attributeInfoEx.events.arch_event.abs_change.equals(this.absTxt.getText().trim())) {
                    this.attributeInfoEx.events.arch_event.abs_change = this.absTxt.getText().trim();
                    changed = true;
                }
                if (this.attributeInfoEx.events.arch_event.rel_change != null && !this.attributeInfoEx.events.arch_event.rel_change.equals(this.relTxt.getText().trim())) {
                    this.attributeInfoEx.events.arch_event.rel_change = this.relTxt.getText().trim();
                    changed = true;
                }
                if (this.attributeInfoEx.events.arch_event.period != null && !this.attributeInfoEx.events.arch_event.period.equals(this.eventPeriodTxt.getText().trim())) {
                    this.attributeInfoEx.events.arch_event.period = this.eventPeriodTxt.getText().trim();
                    changed = true;
                }
                if (changed) {
                    this.attributeProxy.set_info(new AttributeInfoEx[]{this.attributeInfoEx});
                }
                if (!(s = this.pollingPeriodTxt.getText().trim()).equals("Not Polled")) {
                    try {
                        int value = Integer.parseInt(s);
                        if (value != this.pollingPeriod) {
                            this.attributeProxy.poll(value);
                        }
                    }
                    catch (NumberFormatException e) {
                        Except.throw_exception((String)"SyntaxError", (String)e.getMessage());
                    }
                }
                return true;
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                return false;
            }
        }
        return true;
    }

    private void subscribeBtnActionPerformed(ActionEvent evt) {
        if (this.checkValues()) {
            if (this.writeValues()) {
                this.canceled = false;
            }
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.canceled = true;
        this.doClose();
    }

    private void subscriberComboBoxActionPerformed(ActionEvent evt) {
        if (this.isVisible()) {
            try {
                System.out.println(this.subscriberComboBox.getSelectedItem());
                Subscriber subscriber = this.subscriberMap.getSubscriberByLabel((String)this.subscriberComboBox.getSelectedItem());
                Strategy strategy = this.strategyPanel.getStrategy();
                Strategy deviceContext = Strategy.getContextsFromDB(subscriber);
                if (this.listHasChanged(strategy, deviceContext)) {
                    System.out.println("Change it");
                    this.subscriptionPanel.remove(this.strategyPanel);
                    this.addStrategyPanel(subscriber);
                    this.pack();
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
            }
        }
    }

    private void ttlButtonActionPerformed(ActionEvent evt) {
        JRadioButton button = (JRadioButton)evt.getSource();
        if (button.isSelected()) {
            this.ttlTextField.setText(this.nbDayStr);
        } else {
            this.nbDayStr = this.ttlTextField.getText();
            this.ttlTextField.setText("");
        }
        this.ttlTextField.setEnabled(button.isSelected());
    }

    private long getNbDays() {
        if (this.ttlButton.isSelected()) {
            try {
                return Long.parseLong(this.ttlTextField.getText());
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return 0L;
    }

    private boolean listHasChanged(Strategy strategy1, Strategy strategy2) {
        if (strategy1.size() != strategy2.size()) {
            return true;
        }
        for (Context context1 : strategy1) {
            boolean found = false;
            for (Context context2 : strategy2) {
                if (!context1.getName().equalsIgnoreCase(context2.getName())) continue;
                found = true;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void displayProperty() throws DevFailed {
        String period;
        String rel_change;
        String abs_change;
        if (!this.manageProperties) {
            return;
        }
        if (this.attributeProxy == null) {
            this.attributeProxy = new AttributeProxy(this.attributeList.get(0).getName());
        }
        this.attributeInfoEx = this.attributeProxy.get_info_ex();
        if (this.attributeInfoEx.events != null && this.attributeInfoEx.events.arch_event != null) {
            abs_change = this.attributeInfoEx.events.arch_event.abs_change;
            rel_change = this.attributeInfoEx.events.arch_event.rel_change;
            period = this.attributeInfoEx.events.arch_event.period;
        } else {
            abs_change = "Not specified";
            rel_change = "Not specified";
            period = "Not specified";
        }
        this.absTxt.setText(abs_change);
        this.relTxt.setText(rel_change);
        this.eventPeriodTxt.setText(period);
        try {
            this.pollingPeriod = this.attributeProxy.get_polling_period();
            this.pollingPeriodTxt.setText(Integer.toString(this.pollingPeriod));
        }
        catch (DevFailed e) {
            if (e.errors[0].desc.contains("not polled")) {
                this.pollingPeriodTxt.setText("Not Polled");
            }
            throw e;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<HdbAttribute> getHdbAttributes() {
        for (HdbAttribute attribute : this.attributeList) {
            attribute.setPushedByCode(this.pushedByCodeButton.isSelected());
            Strategy strategy = this.strategyPanel.getStrategy();
            attribute.updateUsedContexts(strategy);
            attribute.setTTL(this.getNbDays() * 24L);
        }
        return this.attributeList;
    }

    public String getSubscriber() {
        return (String)this.subscriberComboBox.getSelectedItem();
    }

    public static void main(String[] args) {
        try {
            HdbAttribute attribute = new HdbAttribute("tango://orion.esrf.fr:10000/sy/ps-rips/manager/state");
            SubscriberMap subscriberMap = new SubscriberMap(Utils.getConfiguratorProxy());
            Subscriber subscriber = subscriberMap.getSubscriberList().get(2);
            new PropertyDialog(null, attribute, subscriberMap, subscriber.getLabel()).setVisible(true);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage(null, null, (Exception)e);
        }
    }
}

