/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.NamedDevFailed;
import fr.esrf.TangoDs.NamedDevFailedList;
import java.util.ArrayList;
import java.util.List;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.TangoUtils;

public class ManageAttributes {
    private static boolean display = false;

    public static void setDisplay(boolean b) {
        display = b;
    }

    public static void addAttributes(DeviceProxy configuratorProxy, String subscriberName, List<HdbAttribute> hdbAttributes) throws DevFailed {
        if (hdbAttributes.size() == 0) {
            return;
        }
        if (display) {
            SplashUtils.getInstance().startSplash();
            SplashUtils.getInstance().setSplashProgress(1, "Adding attributes");
        }
        double step = 100.0 / (double)hdbAttributes.size();
        DeviceProxy subscriber = ManageAttributes.getSubscriber(configuratorProxy, subscriberName);
        StringBuilder errors = new StringBuilder();
        ArchiverUtils.lockDevice(configuratorProxy);
        int cnt = 1;
        for (HdbAttribute hdbAttribute : hdbAttributes) {
            if (display) {
                SplashUtils.getInstance().setSplashProgress((int)(step * (double)cnt++), "Adding " + hdbAttribute.getName());
            } else {
                System.out.println("Adding " + hdbAttribute.getName() + "\tto " + subscriberName);
            }
            try {
                new AttributeProxy(hdbAttribute.getName());
                ArchiverUtils.addAttribute(configuratorProxy, subscriberName, hdbAttribute, false);
            }
            catch (DevFailed e) {
                errors.append(hdbAttribute.getName());
                if (e instanceof NamedDevFailedList) {
                    NamedDevFailedList devFailedList = (NamedDevFailedList)e;
                    for (int i = 0; i < devFailedList.get_faulty_attr_nb(); ++i) {
                        NamedDevFailed namedDevFailed = devFailedList.elementAt(i);
                        errors.append("\n  (").append(namedDevFailed.err_stack[0].origin).append(" : ").append(namedDevFailed.err_stack[0].desc).append(")\n");
                    }
                    continue;
                }
                errors.append("\n  (").append(e.errors[0].origin).append(" : ").append(e.errors[0].desc).append(")\n");
            }
        }
        if (display) {
            SplashUtils.getInstance().stopSplash();
        }
        configuratorProxy.unlock();
        if (errors.length() > 0) {
            Except.throw_exception((String)"AddingFailed", (String)errors.toString());
        }
    }

    public static void startAttribute(DeviceProxy configuratorProxy, HdbAttribute attribute) throws DevFailed {
        ArrayList<HdbAttribute> attributes = new ArrayList<HdbAttribute>();
        attributes.add(attribute);
        ManageAttributes.changeAttributeStates(configuratorProxy, attributes, 0);
    }

    public static void startAttributes(DeviceProxy configuratorProxy, List<HdbAttribute> attributes) throws DevFailed {
        ManageAttributes.changeAttributeStates(configuratorProxy, attributes, 0);
    }

    public static void stopAttribute(DeviceProxy configuratorProxy, HdbAttribute attribute) throws DevFailed {
        ArrayList<HdbAttribute> attributes = new ArrayList<HdbAttribute>();
        attributes.add(attribute);
        ManageAttributes.changeAttributeStates(configuratorProxy, attributes, 2);
    }

    public static void stopAttributes(DeviceProxy configuratorProxy, List<HdbAttribute> attributes) throws DevFailed {
        ManageAttributes.changeAttributeStates(configuratorProxy, attributes, 2);
    }

    public static void pauseAttribute(DeviceProxy configuratorProxy, HdbAttribute attribute) throws DevFailed {
        ArrayList<HdbAttribute> attributes = new ArrayList<HdbAttribute>();
        attributes.add(attribute);
        ManageAttributes.changeAttributeStates(configuratorProxy, attributes, 1);
    }

    public static void pauseAttributes(DeviceProxy configuratorProxy, List<HdbAttribute> attributes) throws DevFailed {
        ManageAttributes.changeAttributeStates(configuratorProxy, attributes, 1);
    }

    private static void changeAttributeStates(DeviceProxy configurator, List<HdbAttribute> attributes, int action) throws DevFailed {
        int step;
        if (action < 0 || action > 2) {
            Except.throw_exception((String)"", (String)("Action " + action + " Not Supported"));
        }
        String[] strAttributeStates = new String[]{"Staring ", " Pause ", "Stopping "};
        String strAction = strAttributeStates[action];
        if (display) {
            SplashUtils.getInstance().startSplash();
            SplashUtils.getInstance().setSplashProgress(10, strAction + "attributes");
        }
        if ((step = 90 / attributes.size()) < 1) {
            step = 1;
        }
        try {
            String previous = null;
            DeviceProxy archiver = null;
            for (HdbAttribute attribute : attributes) {
                if (display) {
                    SplashUtils.getInstance().increaseSplashProgress(step, strAction + attribute);
                } else {
                    System.out.println(strAction + attribute);
                }
                String archiverName = ArchiverUtils.getArchiver(configurator, attribute.getName());
                if (archiver == null || !archiverName.equals(previous)) {
                    previous = archiverName;
                    archiver = new DeviceProxy(archiverName);
                }
                switch (action) {
                    case 0: {
                        ArchiverUtils.startAttribute(configurator, TangoUtils.fullName(attribute.getName()));
                        break;
                    }
                    case 2: {
                        ArchiverUtils.stopAttribute(configurator, TangoUtils.fullName(attribute.getName()));
                        break;
                    }
                    case 1: {
                        ArchiverUtils.pauseAttribute(configurator, TangoUtils.fullName(attribute.getName()));
                    }
                }
            }
            if (display) {
                SplashUtils.getInstance().stopSplash();
            }
        }
        catch (DevFailed e) {
            if (display) {
                SplashUtils.getInstance().stopSplash();
            }
            throw e;
        }
    }

    public static void removeAttributes(DeviceProxy configuratorProxy, HdbAttribute[] attributes) throws DevFailed {
        ArrayList<String> names = new ArrayList<String>();
        for (HdbAttribute attribute : attributes) {
            names.add(attribute.getName());
        }
        ManageAttributes.removeAttributes(configuratorProxy, names);
    }

    public static void removeAttributes(DeviceProxy configuratorProxy, List<String> attributes) throws DevFailed {
        int step;
        if (display) {
            SplashUtils.getInstance().startSplash();
            SplashUtils.getInstance().setSplashProgress(10, "Removing attributes");
        }
        if ((step = 90 / attributes.size()) < 1) {
            step = 1;
        }
        try {
            for (String attribute : attributes) {
                if (display) {
                    SplashUtils.getInstance().increaseSplashProgress(step, "Removing " + attribute);
                } else {
                    System.out.println("Removing " + attribute);
                }
                ArchiverUtils.removeAttribute(configuratorProxy, TangoUtils.fullName(attribute));
            }
            if (display) {
                SplashUtils.getInstance().stopSplash();
            }
        }
        catch (DevFailed e) {
            if (display) {
                SplashUtils.getInstance().stopSplash();
            }
            throw e;
        }
    }

    private static DeviceProxy getSubscriber(DeviceProxy configurator, String subscriber) throws DevFailed {
        String[] subscriberNames = ArchiverUtils.getSubscriberList();
        String fullName = TangoUtils.fullName(subscriber.toLowerCase());
        boolean found = false;
        for (String subscriberName : subscriberNames) {
            if (!subscriberName.toLowerCase().equals(fullName)) continue;
            found = true;
            break;
        }
        if (!found) {
            Except.throw_exception((String)"SubscriberNotExists", (String)("Subscriber \"" + subscriber + "\" is not managed by " + configurator.name()));
        }
        return new DeviceProxy(subscriber);
    }

    public static void main(String[] args) {
        System.exit(0);
    }
}

