/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.HdbAttributeComparator;
import org.tango.hdb_configurator.common.PopupHtml;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.ArchiverAliasesDialog;
import org.tango.hdb_configurator.configurator.AttributeTable;
import org.tango.hdb_configurator.configurator.AttributeTree;
import org.tango.hdb_configurator.configurator.CreateSubscriberPanel;
import org.tango.hdb_configurator.configurator.ManageAttributes;
import org.tango.hdb_configurator.configurator.PropertyDialog;
import org.tango.hdb_configurator.configurator.Selector;
import org.tango.hdb_configurator.configurator.TTLDialog;
import org.tango.hdb_configurator.configurator.TtlTableDialog;
import org.tango.hdb_configurator.configurator.strategy.EditStrategiesDialog;
import org.tango.hdb_configurator.configurator.strategy.SelectionStrategiesDialog;
import org.tango.hdb_configurator.configurator.strategy.StrategyMainPanel;

public class HdbConfigurator
extends JFrame {
    private JFrame parent;
    private DeviceProxy configuratorProxy;
    private ListPopupMenu menu = new ListPopupMenu();
    private JScrollPane treeScrollPane;
    private AttributeTree attributeTree;
    private List<AttributeTable> attributeTableList = new ArrayList<AttributeTable>();
    private SubscriberMap subscriberMap;
    private JFileChooser fileChooser = null;
    private JFrame diagnosticsPanel = null;
    private List<String> tangoHostList;
    private UpdateListThread updateListThread;
    private static final String[] strAttributeState = new String[]{"Started Attributes", "Paused Attributes", "Stopped Attributes"};
    private static final Dimension treeDimension = new Dimension(350, 400);
    private static final Dimension tableDimension = new Dimension(600, 400);
    private JButton addAttributeButton;
    private JMenuItem addSubscriberItem;
    private JComboBox<String> archiverComboBox;
    private JLabel archiverLabel;
    private JPanel attrTreePanel;
    private JTextField attributeField;
    private JMenuItem changeCsItem;
    private JMenuItem contextsItem;
    private JTextField deviceFilterText;
    private JMenuItem manageAliasesItem;
    private JLabel pausedAttrLabel;
    private JTextField pausedFilterText;
    private JScrollPane pausedScrollPane;
    private JTextArea propertiesArea;
    private JMenuItem removeSubscriberItem;
    private JButton searchButton;
    private JLabel startedAttrLabel;
    private JTextField startedFilterText;
    private JScrollPane startedScrollPane;
    private JLabel stoppedAttrLabel;
    private JTextField stoppedFilterText;
    private JScrollPane stoppedScrollPane;
    private JTabbedPane tabbedPane;
    private JLabel titleLabel;
    private static final int ARCHIVING_STRATEGY = 0;
    private static final int ARCHIVING_TTL = 1;
    private static final int START_ARCHIVING = 2;
    private static final int STOP_ARCHIVING = 3;
    private static final int PAUSE_ARCHIVING = 4;
    private static final int REMOVE_ATTRIBUTE = 5;
    private static final int MOVE_TO = 6;
    private static final int COPY_AS_TEXT = 7;
    private static final int OFFSET = 2;
    private static String[] menuLabels = new String[]{"Change Archiving Strategy", "Change Archiving TTL", "Start Archiving", "Stop Archiving", "Pause Archiving", "Remove Attribute", "Move Attribute To ", "Copy as Text"};
    private static final int executionTime = 15000;

    public HdbConfigurator(JFrame parent) throws DevFailed {
        this(parent, false);
    }

    public HdbConfigurator(JFrame parent, boolean parentIsDiagnostic) throws DevFailed {
        String onlyOnCS;
        this.parent = parent;
        SplashUtils.getInstance().startSplash();
        SplashUtils.getInstance().increaseSplashProgress(10, "Building GUI");
        this.setTitle(Utils.getInstance().getApplicationName());
        this.initComponents();
        this.initOwnComponents();
        if (parentIsDiagnostic) {
            this.diagnosticsPanel = parent;
        }
        ManageAttributes.setDisplay(true);
        this.updateListThread = new UpdateListThread();
        this.updateListThread.start();
        String expert = System.getenv("EXPERT_MODE");
        if (expert != null && expert.equals("false")) {
            this.addSubscriberItem.setVisible(false);
            this.removeSubscriberItem.setVisible(false);
            this.manageAliasesItem.setVisible(false);
            this.contextsItem.setVisible(false);
        }
        if ((onlyOnCS = System.getenv("SingleControlSystem")) != null && onlyOnCS.equals("true")) {
            this.changeCsItem.setVisible(false);
        }
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        SplashUtils.getInstance().stopSplash();
    }

    private void initOwnComponents() throws DevFailed {
        this.buildTable();
        this.initSubscribers();
        this.buildAttributeTree();
        String title = this.titleLabel.getText();
        String archiveName = TangoUtils.getArchiveName(this.configuratorProxy);
        if (!archiveName.isEmpty()) {
            title = title + "  (" + archiveName + ")";
            this.titleLabel.setText(title);
            String s = System.getenv("HdbExtraction");
            if (s != null && s.equals("true")) {
                System.setProperty("HDB_TYPE", archiveName);
            }
        }
        ImageIcon icon = Utils.getInstance().getIcon("hdb++.gif", 0.75);
        this.titleLabel.setIcon(icon);
        this.setIconImage(icon.getImage());
        String filter = System.getenv("DeviceFilter");
        if (filter != null && !filter.isEmpty()) {
            this.deviceFilterText.setText(filter);
            this.deviceFilterTextActionPerformed(null);
        } else {
            this.deviceFilterText.setText("*/*/*");
        }
    }

    private void buildTable() {
        SplashUtils.getInstance().increaseSplashProgress(15, "Reading devices");
        JScrollPane[] scrollPanes = new JScrollPane[]{this.startedScrollPane, this.pausedScrollPane, this.stoppedScrollPane};
        for (int i = 0; i <= 2; ++i) {
            AttributeTable table = new AttributeTable();
            scrollPanes[i].setViewportView(table);
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    HdbConfigurator.this.tableActionPerformed(evt);
                }
            });
            this.attributeTableList.add(table);
        }
        HdbConfigurator.tableDimension.width = this.attributeTableList.get(0).getTableWidth();
        this.startedScrollPane.setPreferredSize(tableDimension);
    }

    private void initSubscribers() throws DevFailed {
        SplashUtils.getInstance().increaseSplashProgress(25, "Reading devices");
        this.configuratorProxy = Utils.getConfiguratorProxy();
        this.subscriberMap = Utils.getSubscriberMap(this.configuratorProxy.name(), true);
        if (this.subscriberMap.size() == 0) {
            this.addSubscriber();
        }
        this.archiverComboBox.removeAllItems();
        for (String subscriberName : this.subscriberMap.getLabelList()) {
            this.archiverComboBox.addItem(subscriberName);
        }
        this.tangoHostList = this.subscriberMap.getTangoHostList();
        if (this.subscriberMap.size() == 0) {
            this.archiverLabel.setText("No subscriber defined ");
        } else if (this.subscriberMap.size() == 1) {
            this.archiverLabel.setText("1 subscriber: ");
        } else {
            this.archiverLabel.setText(this.subscriberMap.size() + " subscribers: ");
        }
    }

    private void buildAttributeTree() throws DevFailed {
        SplashUtils.getInstance().increaseSplashProgress(50, "Building Tree");
        this.attributeTree = new AttributeTree(this, TangoUtils.getEventTangoHost());
        this.treeScrollPane = new JScrollPane();
        this.treeScrollPane.setViewportView(this.attributeTree);
        this.treeScrollPane.setPreferredSize(treeDimension);
        this.attrTreePanel.add((Component)this.treeScrollPane, "Center");
        this.searchButton.setText("");
        this.searchButton.setIcon(Utils.getInstance().getIcon("search.gif"));
        this.addAttributeButton.setEnabled(false);
    }

    public DeviceProxy getConfiguratorProxy() {
        return this.configuratorProxy;
    }

    public void changeTangoHost(String tangoHost) {
        try {
            Selector selector = new Selector(this, "Change Control System", "TANGO_HOST ?", this.tangoHostList, tangoHost);
            String newTangoHost = selector.showDialog();
            if (newTangoHost != null && !newTangoHost.isEmpty() && !newTangoHost.equals(tangoHost)) {
                tangoHost = TangoUtils.getTangoHost(newTangoHost);
                if (!this.tangoHostList.contains(tangoHost)) {
                    this.tangoHostList.add(tangoHost);
                }
                if (this.attributeTree != null) {
                    this.attributeTree.removeAll();
                    this.treeScrollPane.remove(this.attributeTree);
                }
                this.attributeTree = new AttributeTree(this, tangoHost);
                this.treeScrollPane.setViewportView(this.attributeTree);
                this.deviceFilterText.setText("*/*/*");
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void tableActionPerformed(MouseEvent event) {
        block9: {
            int[] rows;
            try {
                Subscriber subscriber = this.subscriberMap.getSubscriberByLabel((String)this.archiverComboBox.getSelectedItem());
                if (subscriber.isFaulty()) {
                    return;
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
            }
            AttributeTable table = (AttributeTable)event.getSource();
            Point clickedPoint = new Point(event.getX(), event.getY());
            int selectedRow = table.rowAtPoint(clickedPoint);
            int selectedCol = table.columnAtPoint(clickedPoint);
            int mask = event.getModifiers();
            if ((mask & 0x10) != 0 && event.getClickCount() == 2) {
                try {
                    if (selectedCol == 2) {
                        this.changeAttributeTTL(table, selectedRow);
                        break block9;
                    }
                    this.changeArchivingStrategy(table, selectedRow);
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
                }
            } else if ((event.getModifiers() & 4) != 0 && (rows = table.getSelectedRows()).length > 0) {
                this.menu.showMenu(event, table.getSelectedAttributes());
            }
        }
    }

    private void changeAttributeTTL(AttributeTable table, int row) throws DevFailed {
        ArrayList<HdbAttribute> attributes = new ArrayList<HdbAttribute>(1);
        attributes.add(table.getAttribute(row));
        this.changeAttributeTTL(attributes);
    }

    private void changeAttributeTTL(List<HdbAttribute> hdbAttributeList) throws DevFailed {
        String subscriberName = (String)this.archiverComboBox.getSelectedItem();
        Subscriber subscriber = this.subscriberMap.getSubscriberByLabel(subscriberName);
        new TTLDialog(this, hdbAttributeList, subscriber).setVisible(true);
    }

    private void changeArchivingStrategy(AttributeTable table, int row) {
        ArrayList<HdbAttribute> attributes = new ArrayList<HdbAttribute>(1);
        attributes.add(table.getAttribute(row));
        this.changeArchivingStrategy(attributes);
    }

    private void changeArchivingStrategy(List<HdbAttribute> attributeList) {
        try {
            ArrayList<Strategy> strategyCopies = new ArrayList<Strategy>();
            for (HdbAttribute attribute : attributeList) {
                strategyCopies.add(attribute.getStrategyCopy());
            }
            String subscriberName = (String)this.archiverComboBox.getSelectedItem();
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel(subscriberName);
            SelectionStrategiesDialog dialog = new SelectionStrategiesDialog(this, attributeList, subscriber.getStrategy(), this.configuratorProxy);
            if (dialog.showDialog() == 0) {
                dialog.setAttributeStrategy();
                this.attributeTableList.get(this.tabbedPane.getSelectedIndex()).fireTableDataChanged();
            } else {
                for (int i = 0; i < attributeList.size(); ++i) {
                    attributeList.get(i).updateUsedContexts((Strategy)strategyCopies.get(i));
                }
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (Exception)e);
        }
    }

    private void updateAttributeList(Subscriber subscriber) {
        JLabel[] labels = new JLabel[]{this.startedAttrLabel, this.pausedAttrLabel, this.stoppedAttrLabel};
        int selection = this.tabbedPane.getSelectedIndex();
        List<HdbAttribute> attributeList = subscriber.getAttributeList(selection, true);
        AttributeTable table = this.attributeTableList.get(selection);
        this.updateAttributeList(table, attributeList, labels[selection], this.startedScrollPane);
        for (int i = 0; i <= 2; ++i) {
            this.updatePaneTitle(subscriber, i);
        }
    }

    private void updatePaneTitle(Subscriber subscriber, int index) {
        int nb = subscriber.getAttributeList(index, false).size();
        this.tabbedPane.setTitleAt(index, nb + " " + strAttributeState[index]);
    }

    private void updateAttributeList(AttributeTable attributeTable, List<HdbAttribute> attributes, JLabel jLabel, JScrollPane scrollPane) {
        HdbAttributeComparator.sort(attributes);
        attributeTable.updateAttributeList(attributes);
        String s = attributes.size() > 1 ? "s" : "";
        jLabel.setText(Integer.toString(attributes.size()) + " attribute" + s);
        JScrollBar horizontal = scrollPane.getVerticalScrollBar();
        horizontal.setValue(horizontal.getMaximum());
    }

    public void displayPathInfo(String tangoHost, String attributeName) {
        StringTokenizer stk = new StringTokenizer(attributeName, "/");
        this.addAttributeButton.setEnabled(stk.countTokens() == 4);
        if (stk.countTokens() < 4) {
            this.attributeField.setText(attributeName);
            this.propertiesArea.setText("");
            return;
        }
        String s = this.attributeField.getText();
        if (!s.equals(attributeName)) {
            this.attributeField.setText(attributeName);
            if (!attributeName.isEmpty()) {
                try {
                    this.propertiesArea.setText(TangoUtils.getAttPollingInfo(tangoHost, attributeName) + "\n" + TangoUtils.getEventProperties(tangoHost, attributeName));
                }
                catch (DevFailed e) {
                    this.propertiesArea.setText(Except.str_exception((Exception)((Object)e)));
                }
            }
        }
    }

    private void moveAttributeToSubscriber(String targetSubscriberLabel, List<HdbAttribute> attributeList) {
        block5: {
            try {
                System.out.println("Move to " + targetSubscriberLabel);
                Subscriber targetSubscriber = this.subscriberMap.getSubscriberByLabel(targetSubscriberLabel);
                targetSubscriber.ping();
                if (!this.checkStrategyCompatibility(attributeList, targetSubscriber)) break block5;
                SplashUtils.getInstance().startSplash();
                SplashUtils.getInstance().setSplashProgress(10, "Removing/Adding attributes");
                for (HdbAttribute attribute : attributeList) {
                    SplashUtils.getInstance().increaseSplashProgressForLoop(attributeList.size(), "Removing/adding " + attribute.getName());
                    ArchiverUtils.moveAttribute(this.configuratorProxy, attribute, targetSubscriber.name);
                }
                SplashUtils.getInstance().setSplashProgress(30, "Wait a while");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.archiverComboBox.setSelectedItem(targetSubscriberLabel);
                this.manageSubscriberChanged(targetSubscriberLabel);
                SplashUtils.getInstance().stopSplash();
            }
            catch (DevFailed e) {
                SplashUtils.getInstance().stopSplash();
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private boolean checkStrategyCompatibility(List<HdbAttribute> attributeList, Subscriber targetSubscriber) throws DevFailed {
        List<HdbAttribute> unCompatibleList = targetSubscriber.checkAttributeStrategies(attributeList);
        if (unCompatibleList.isEmpty()) {
            return true;
        }
        SelectionStrategiesDialog dialog = new SelectionStrategiesDialog(this, unCompatibleList, targetSubscriber.getStrategy());
        if (dialog.showDialog() == 2) {
            return false;
        }
        unCompatibleList = dialog.getHdbAttributeList();
        for (HdbAttribute attribute : attributeList) {
            for (HdbAttribute unCompatible : unCompatibleList) {
                if (!attribute.getName().equals(unCompatible.getName())) continue;
                attribute.clear();
                attribute.addAll(unCompatible);
            }
        }
        return true;
    }

    private void initComponents() {
        JSplitPane jSplitPane1 = new JSplitPane();
        this.attrTreePanel = new JPanel();
        JPanel addingPanel = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.titleLabel = new JLabel();
        this.attributeField = new JTextField();
        this.addAttributeButton = new JButton();
        this.searchButton = new JButton();
        JPanel statusPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.deviceFilterText = new JTextField();
        JScrollPane propertiesScrollPane = new JScrollPane();
        this.propertiesArea = new JTextArea();
        JPanel rightPanel = new JPanel();
        JPanel archiverPanel = new JPanel();
        this.archiverLabel = new JLabel();
        this.archiverComboBox = new JComboBox();
        this.tabbedPane = new JTabbedPane();
        JPanel startedPanel = new JPanel();
        JPanel startedTopPanel = new JPanel();
        JLabel filterLabel = new JLabel();
        this.startedFilterText = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.startedAttrLabel = new JLabel();
        this.startedScrollPane = new JScrollPane();
        JPanel pausedPanel = new JPanel();
        JPanel pausedTopPanel = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.pausedFilterText = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.pausedAttrLabel = new JLabel();
        this.pausedScrollPane = new JScrollPane();
        JPanel stoppedPanel = new JPanel();
        JPanel stoppedTopPanel = new JPanel();
        JLabel jLabel5 = new JLabel();
        this.stoppedFilterText = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.stoppedAttrLabel = new JLabel();
        this.stoppedScrollPane = new JScrollPane();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem openItem = new JMenuItem();
        this.changeCsItem = new JMenuItem();
        JMenuItem exitItem = new JMenuItem();
        JMenu viewMenu = new JMenu();
        JMenuItem diagnosticsItem = new JMenuItem();
        JMenuItem jMenuItem1 = new JMenuItem();
        JMenu toolMenu = new JMenu();
        this.addSubscriberItem = new JMenuItem();
        this.removeSubscriberItem = new JMenuItem();
        this.manageAliasesItem = new JMenuItem();
        this.contextsItem = new JMenuItem();
        JMenuItem byStrategiesItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem principleItem = new JMenuItem();
        JMenuItem releaseNoteItem = new JMenuItem();
        JMenuItem aboutItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HdbConfigurator.this.exitForm(evt);
            }
        });
        this.attrTreePanel.setMinimumSize(new Dimension(400, 167));
        this.attrTreePanel.setLayout(new BorderLayout());
        addingPanel.setLayout(new GridBagLayout());
        this.titleLabel.setFont(new Font("Tahoma", 1, 18));
        this.titleLabel.setText("HDB++ Configurator");
        jPanel4.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        addingPanel.add((Component)jPanel4, gridBagConstraints);
        this.attributeField.setColumns(26);
        this.attributeField.setFont(new Font("Tahoma", 1, 12));
        this.attributeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.attributeFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        addingPanel.add((Component)this.attributeField, gridBagConstraints);
        this.addAttributeButton.setFont(new Font("Tahoma", 1, 14));
        this.addAttributeButton.setText(" + ");
        this.addAttributeButton.setToolTipText("Add selection to HDB");
        this.addAttributeButton.setBorder(BorderFactory.createBevelBorder(0));
        this.addAttributeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.addAttributeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(10, 5, 10, 10);
        addingPanel.add((Component)this.addAttributeButton, gridBagConstraints);
        this.searchButton.setText("Search");
        this.searchButton.setBorder(BorderFactory.createBevelBorder(0));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        addingPanel.add((Component)this.searchButton, gridBagConstraints);
        this.attrTreePanel.add((Component)addingPanel, "North");
        statusPanel.setLayout(new GridBagLayout());
        jLabel1.setText("Device Filter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        statusPanel.add((Component)jLabel1, gridBagConstraints);
        this.deviceFilterText.setColumns(20);
        this.deviceFilterText.setFont(new Font("Tahoma", 1, 12));
        this.deviceFilterText.setText("*/*/*");
        this.deviceFilterText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.deviceFilterTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        statusPanel.add((Component)this.deviceFilterText, gridBagConstraints);
        this.propertiesArea.setEditable(false);
        this.propertiesArea.setColumns(35);
        this.propertiesArea.setFont(new Font("Monospaced", 1, 12));
        this.propertiesArea.setRows(6);
        propertiesScrollPane.setViewportView(this.propertiesArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        statusPanel.add((Component)propertiesScrollPane, gridBagConstraints);
        this.attrTreePanel.add((Component)statusPanel, "South");
        jSplitPane1.setLeftComponent(this.attrTreePanel);
        rightPanel.setLayout(new BorderLayout());
        this.archiverLabel.setFont(new Font("Tahoma", 1, 12));
        this.archiverLabel.setText("Archivers:");
        archiverPanel.add(this.archiverLabel);
        this.archiverComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.archiverComboBoxActionPerformed(evt);
            }
        });
        archiverPanel.add(this.archiverComboBox);
        rightPanel.add((Component)archiverPanel, "North");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HdbConfigurator.this.tabbedPaneStateChanged(evt);
            }
        });
        startedPanel.setLayout(new BorderLayout());
        filterLabel.setText("Filter    tango://");
        startedTopPanel.add(filterLabel);
        this.startedFilterText.setColumns(25);
        this.startedFilterText.setFont(new Font("Tahoma", 1, 12));
        this.startedFilterText.setText("*/*/*/*/*");
        this.startedFilterText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.startedFilterTextActionPerformed(evt);
            }
        });
        startedTopPanel.add(this.startedFilterText);
        jLabel2.setText("   ");
        startedTopPanel.add(jLabel2);
        this.startedAttrLabel.setText("Attributes");
        startedTopPanel.add(this.startedAttrLabel);
        startedPanel.add((Component)startedTopPanel, "North");
        startedPanel.add((Component)this.startedScrollPane, "Center");
        this.tabbedPane.addTab("Started Attributes", startedPanel);
        pausedPanel.setLayout(new BorderLayout());
        jLabel4.setText("Filter    tango://");
        pausedTopPanel.add(jLabel4);
        this.pausedFilterText.setColumns(25);
        this.pausedFilterText.setFont(new Font("Tahoma", 1, 12));
        this.pausedFilterText.setText("*/*/*/*/*");
        this.pausedFilterText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.pausedFilterTextActionPerformed(evt);
            }
        });
        pausedTopPanel.add(this.pausedFilterText);
        jLabel6.setText("   ");
        pausedTopPanel.add(jLabel6);
        this.pausedAttrLabel.setText("Attributes");
        pausedTopPanel.add(this.pausedAttrLabel);
        pausedPanel.add((Component)pausedTopPanel, "North");
        pausedPanel.add((Component)this.pausedScrollPane, "Center");
        this.tabbedPane.addTab("Paused Attributes", pausedPanel);
        stoppedPanel.setLayout(new BorderLayout());
        jLabel5.setText("Filter    tango://");
        stoppedTopPanel.add(jLabel5);
        this.stoppedFilterText.setColumns(25);
        this.stoppedFilterText.setFont(new Font("Tahoma", 1, 12));
        this.stoppedFilterText.setText("*/*/*/*/*");
        this.stoppedFilterText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.stoppedFilterTextActionPerformed(evt);
            }
        });
        stoppedTopPanel.add(this.stoppedFilterText);
        jLabel7.setText("   ");
        stoppedTopPanel.add(jLabel7);
        this.stoppedAttrLabel.setText("Attributes");
        stoppedTopPanel.add(this.stoppedAttrLabel);
        stoppedPanel.add((Component)stoppedTopPanel, "North");
        stoppedPanel.add((Component)this.stoppedScrollPane, "Center");
        this.tabbedPane.addTab("Stopped Attributes", stoppedPanel);
        rightPanel.add((Component)this.tabbedPane, "Center");
        jSplitPane1.setRightComponent(rightPanel);
        this.getContentPane().add((Component)jSplitPane1, "Center");
        fileMenu.setMnemonic('F');
        fileMenu.setText("File");
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        openItem.setMnemonic('O');
        openItem.setText("Open Attribute List");
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.openItemActionPerformed(evt);
            }
        });
        fileMenu.add(openItem);
        this.changeCsItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.changeCsItem.setMnemonic('T');
        this.changeCsItem.setText("Change TANGO_HOST");
        this.changeCsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.changeCsItemActionPerformed(evt);
            }
        });
        fileMenu.add(this.changeCsItem);
        exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        exitItem.setMnemonic('E');
        exitItem.setText("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.exitItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
        viewMenu.setMnemonic('V');
        viewMenu.setText("View");
        diagnosticsItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        diagnosticsItem.setMnemonic('D');
        diagnosticsItem.setText("HDB++ Diagnostics");
        diagnosticsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.diagnosticsItemActionPerformed(evt);
            }
        });
        viewMenu.add(diagnosticsItem);
        jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        jMenuItem1.setMnemonic('T');
        jMenuItem1.setText("TTL attribute list");
        jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.jMenuItem1ActionPerformed(evt);
            }
        });
        viewMenu.add(jMenuItem1);
        menuBar.add(viewMenu);
        toolMenu.setText("Tools");
        this.addSubscriberItem.setAccelerator(KeyStroke.getKeyStroke(107, 2));
        this.addSubscriberItem.setMnemonic('A');
        this.addSubscriberItem.setText("Add Subscriber");
        this.addSubscriberItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.addSubscriberItemActionPerformed(evt);
            }
        });
        toolMenu.add(this.addSubscriberItem);
        this.removeSubscriberItem.setAccelerator(KeyStroke.getKeyStroke(109, 2));
        this.removeSubscriberItem.setMnemonic('R');
        this.removeSubscriberItem.setText("Remove Subscriber");
        this.removeSubscriberItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.removeSubscriberItemActionPerformed(evt);
            }
        });
        toolMenu.add(this.removeSubscriberItem);
        this.manageAliasesItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.manageAliasesItem.setMnemonic('M');
        this.manageAliasesItem.setText("Manage Subscriber Aliases");
        this.manageAliasesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.manageAliasesItemActionPerformed(evt);
            }
        });
        toolMenu.add(this.manageAliasesItem);
        this.contextsItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.contextsItem.setMnemonic('x');
        this.contextsItem.setText("Manage Strategies & Contexts");
        this.contextsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.contextsItemActionPerformed(evt);
            }
        });
        toolMenu.add(this.contextsItem);
        byStrategiesItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        byStrategiesItem.setMnemonic('x');
        byStrategiesItem.setText("Manage Attributes by Strategies");
        byStrategiesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.byStrategiesItemActionPerformed(evt);
            }
        });
        toolMenu.add(byStrategiesItem);
        menuBar.add(toolMenu);
        helpMenu.setMnemonic('H');
        helpMenu.setText("help");
        principleItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        principleItem.setMnemonic('P');
        principleItem.setText("HDB++ Principle");
        principleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.principleItemActionPerformed(evt);
            }
        });
        helpMenu.add(principleItem);
        releaseNoteItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        releaseNoteItem.setMnemonic('A');
        releaseNoteItem.setText("Release Notes");
        releaseNoteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.releaseNoteItemActionPerformed(evt);
            }
        });
        helpMenu.add(releaseNoteItem);
        aboutItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        aboutItem.setMnemonic('A');
        aboutItem.setText("About");
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HdbConfigurator.this.aboutItemActionPerformed(evt);
            }
        });
        helpMenu.add(aboutItem);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
        this.pack();
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
        String message = "This application is able to configure HDB++\nIt is used to Add attributes to subscriber and\nStart and Stop HDB filling for selected attributes\n\nIt manages " + this.subscriberMap.size() + " event subscriber devices\n" + "\nPascal Verdier - ESRF - Software Group";
        JOptionPane.showMessageDialog(this, message, "Help Window", 1);
    }

    private void archiverComboBoxActionPerformed(ActionEvent evt) {
        String archiverLabel = (String)this.archiverComboBox.getSelectedItem();
        if (archiverLabel == null) {
            return;
        }
        this.manageSubscriberChanged(archiverLabel);
    }

    private void manageSubscriberChanged(String archiverLabel) {
        try {
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel(archiverLabel);
            this.startedFilterText.setText(subscriber.getStartedFilter());
            this.stoppedFilterText.setText(subscriber.getStoppedFilter());
            this.pausedFilterText.setText(subscriber.getPausedFilter());
            this.updateAttributeList(this.subscriberMap.getSubscriberByLabel(archiverLabel));
        }
        catch (DevFailed e) {
            ArrayList<HdbAttribute> attributes = new ArrayList<HdbAttribute>();
            for (AttributeTable table : this.attributeTableList) {
                table.updateAttributeList(attributes);
            }
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void attributeFieldActionPerformed(ActionEvent evt) {
        String attributeName = this.attributeField.getText();
        StringTokenizer stk = new StringTokenizer(attributeName, "/");
        if (stk.countTokens() == 4) {
            this.addSpecifiedAttribute();
        } else {
            this.searchPath();
        }
    }

    private void addAttributeButtonActionPerformed(ActionEvent evt) {
        List<String> attributeNames = this.attributeTree.getSelectedAttributes();
        if (attributeNames.size() == 0) {
            return;
        }
        if (attributeNames.size() == 1) {
            this.addSpecifiedAttribute();
        } else {
            this.addAttributeList(attributeNames);
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.searchPath();
    }

    private void releaseNoteItemActionPerformed(ActionEvent evt) {
        new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<html>\n<head>\n<title> Release Notes </title>\n</head>\n<body text=\"#000000\" bgColor=\"#FFFFFF\" link=\"#0000FF\" vLink=\"#7F00FF\" aLink=\"#FF0000\">\n<p><!-------TITLE------></p>\n<center><h2> Release Notes </h2>\ngenerated: 28-05-2018  09:38</center>\n<li><b>hdb_configurator-3.5 - 28/05/18:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem in double click on Diagnostics Frequency column.<br>&nbsp; &nbsp; &nbsp; Subscribe event is now stateless.<br><li><b>hdb_configurator-3.4 - 04/05/18:</b><br>&nbsp; &nbsp; &nbsp; Improve ServerInfoTable management.<br><li><b>hdb_configurator-3.3 - 25/04/18:</b><br>&nbsp; &nbsp; &nbsp; Improve attribute selection in table.<br><li><b>hdb_configurator-3.2 - 25/04/18:</b><br>&nbsp; &nbsp; &nbsp; TTL attribute table added.<br><li><b>hdb_configurator-3.1 - 15/03/18:</b><br>&nbsp; &nbsp; &nbsp; TTL tested in real control system.<br>&nbsp; &nbsp; &nbsp; Problem on No Heartbeat display fixed.<br><li><b>hdb_configurator-3.0 - 25/09/17:</b><br>&nbsp; &nbsp; &nbsp; TTL management added.<br><li><b>hdb_configurator-2.2 - 23/05/17:</b><br>&nbsp; &nbsp; &nbsp; Moved to gitub.<br><li><b>hdb_configurator-2.1 - 28/02/17:</b><br>&nbsp; &nbsp; &nbsp; First release installed with strategies<br><li><b>hdb_configurator-2.0a - 14/12/16:</b><br>&nbsp; &nbsp; &nbsp; Moved to maven project<br><li><b>hdb_configurator-2.0 - 02/11/16:</b><br>&nbsp; &nbsp; &nbsp; Context management added.<br><li><b>hdb_configurator-1.5a - 21/09/16:</b><br>&nbsp; &nbsp; &nbsp; Change date format in daily saving.<br><li><b>hdb_configurator-1.5 - 05/09/16:</b><br>&nbsp; &nbsp; &nbsp; Server information table added.<br>&nbsp; &nbsp; &nbsp; Add global statistics on distribution frame.<br>&nbsp; &nbsp; &nbsp; Fix a small problem when sort statistics<br>&nbsp; &nbsp; &nbsp; Add a copy attributeList name in statistics window.<br><li><b>hdb_configurator-1.4 - 24/08/16:</b><br>&nbsp; &nbsp; &nbsp; Add a litle tool to manage Stat/Stop all attributes on specified subscribers.<br>&nbsp; &nbsp; &nbsp; Fix a small problem in distribution display.<br>&nbsp; &nbsp; &nbsp; Add a copy error message added in diagnostics.<br><li><b>hdb_configurator-1.3 - 06/06/16:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem on default TANGO_HOST<br><li><b>hdb_configurator-1.2 - 27/05/16:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem for DevFailed/NamedDevFailedList exception<br><li><b>hdb_configurator-1.1 - 13/05/16:</b><br>&nbsp; &nbsp; &nbsp; Fix problem of refreshing in attributeList tree.<br><li><b>hdb_configurator-1.0 - 12/05/16:</b><br>&nbsp; &nbsp; &nbsp; Change package name (reset revision number)<br><li><b>jhdbcpp-2.7 - 03/05/16:</b><br>&nbsp; &nbsp; &nbsp; few methods added for external class.<br><li><b>jhdbcpp-2.6 - 19/12/15:</b><br>&nbsp; &nbsp; &nbsp; Remove event tester launch in StatisticsDialog menu (does not work fine).<br><li><b>jhdbcpp-2.5 - 16/12/15:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem when moving paused attributes<br><li><b>jhdbcpp-2.4 - 26/11/15:</b><br>&nbsp; &nbsp; &nbsp; Refactor to remove cross links.<br><li><b>jhdbcpp-2.3 - 26/11/15:</b><br>&nbsp; &nbsp; &nbsp; Interface with jhdbvewer to read attributeList in hdb.<br><li><b>jhdbcpp-2.2 - 24/09/15:</b><br>&nbsp; &nbsp; &nbsp; Fix a little bug on plain/bold attributeList display<br><li><b>jhdbcpp-2.1 - 19/05/15:</b><br>&nbsp; &nbsp; &nbsp; Subscriber alias management added.<br>&nbsp; &nbsp; &nbsp; Performance view added in distribution<br>&nbsp; &nbsp; &nbsp; Compatibility with Java-7<br><li><b>jhdbcpp-2.0 - 23/04/15:</b><br>&nbsp; &nbsp; &nbsp; Change GUI look and feel.<br>&nbsp; &nbsp; &nbsp; Add pause attributeList state.<br>&nbsp; &nbsp; &nbsp; Attribute lists are updated from events<br><li><b>jhdbcpp-1.13 - 08/04/15:</b><br>&nbsp; &nbsp; &nbsp; small chamges.<br><li><b>jhdbcpp-1.12 - 03/03/15:</b><br>&nbsp; &nbsp; &nbsp; Info on attributeList failure frequency and on E.S. manager added.<br>&nbsp; &nbsp; &nbsp; Trend on HDB storage frequency added.<br><li><b>jhdbcpp-1.11 - 06/02/15:</b><br>&nbsp; &nbsp; &nbsp; Add a table to view all attribues on error.<br><li><b>jhdbcpp-1.10 - 20/01/15:</b><br>&nbsp; &nbsp; &nbsp; Table added to distribution dialog<br><li><b>jhdbcpp-1.9 - 16/01/15:</b><br>&nbsp; &nbsp; &nbsp; Events number added to distribution chart.<br><li><b>jhdbcpp-1.8 - 19/12/14:</b><br>&nbsp; &nbsp; &nbsp; Improve attributeList error window.<br>&nbsp; &nbsp; &nbsp; Add a selector to change TANGO_HOST<br>&nbsp; &nbsp; &nbsp; Event tester call added.<br><li><b>jhdbcpp-1.7 - 06/11/14:</b><br>&nbsp; &nbsp; &nbsp; FQDN event subscriber name to be added to manager.<br>&nbsp; &nbsp; &nbsp; Events since reset added.<br>&nbsp; &nbsp; &nbsp; Save statistics added.<br><li><b>jhdbcpp-1.6 - 30/10/14:</b><br>&nbsp; &nbsp; &nbsp; Display event frequency added.<br><li><b>jhdbcpp-1.5 - 13/10/14:</b><br>&nbsp; &nbsp; &nbsp; Display error message on failed attributeList list.<br>&nbsp; &nbsp; &nbsp; Display HDB name if property set.<br><li><b>jhdbcpp-1.4 - 24/09/14:</b><br>&nbsp; &nbsp; &nbsp; Diag viewers are now in a JTable object.<br>&nbsp; &nbsp; &nbsp; A double click on table cell displays attributeList list.<br><li><b>jhdbcpp-1.3 - 22/09/14:</b><br>&nbsp; &nbsp; &nbsp; Fix a bug in archiver device creation<br><li><b>jhdbcpp-1.2 - 05/09/14:</b><br>&nbsp; &nbsp; &nbsp; Add a graph chart to display distribution.<br><li><b>jhdbcpp-1.1 - 28/08/14:</b><br>&nbsp; &nbsp; &nbsp; Add/Remove subscriber added.<br><li><b>jhdbcpp-1.0 - 06/08/14:</b><br>&nbsp; &nbsp; &nbsp; Initial Revision<br></body>\n</html>\n");
    }

    private void openItemActionPerformed(ActionEvent evt) {
        File file;
        if (this.subscriberMap.size() == 0) {
            Utils.popupError(this, "No Subscriber defined");
            return;
        }
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(new File("").getAbsolutePath());
        }
        if (this.fileChooser.showOpenDialog(this) == 0 && (file = this.fileChooser.getSelectedFile()) != null && file.isFile()) {
            try {
                String filename = file.getAbsolutePath();
                List<String> attributeNames = Utils.readFileLines(filename);
                this.addAttributeList(attributeNames);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private void stoppedFilterTextActionPerformed(ActionEvent evt) {
        try {
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel((String)this.archiverComboBox.getSelectedItem());
            subscriber.setStoppedFilter(this.stoppedFilterText.getText());
            this.updateAttributeList(subscriber);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void pausedFilterTextActionPerformed(ActionEvent evt) {
        try {
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel((String)this.archiverComboBox.getSelectedItem());
            subscriber.setPausedFilter(this.pausedFilterText.getText());
            this.updateAttributeList(subscriber);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void startedFilterTextActionPerformed(ActionEvent evt) {
        try {
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel((String)this.archiverComboBox.getSelectedItem());
            subscriber.setStartedFilter(this.startedFilterText.getText());
            this.updateAttributeList(subscriber);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void deviceFilterTextActionPerformed(ActionEvent evt) {
        try {
            if (this.attributeTree == null) {
                return;
            }
            String tangoHost = this.attributeTree.getTangoHost();
            this.attributeTree.removeAll();
            this.treeScrollPane.remove(this.attributeTree);
            String filter = this.deviceFilterText.getText();
            StringTokenizer stk = new StringTokenizer(filter, "/");
            if (stk.countTokens() < 3) {
                Except.throw_exception((String)"SyntaxError", (String)("Syntax error in device filter: " + filter + "\n" + "Device name needs 3 fields : <domain>/<family>/<member>"));
            }
            this.attributeTree = new AttributeTree(this, tangoHost, filter);
            this.treeScrollPane.setViewportView(this.attributeTree);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void diagnosticsItemActionPerformed(ActionEvent evt) {
        try {
            if (this.diagnosticsPanel == null) {
                this.diagnosticsPanel = (JFrame)Utils.getInstance().startExternalApplication(this, "org.tango.hdb_configurator.diagnostics.HdbDiagnostics");
            }
            this.diagnosticsPanel.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.toString(), (DevFailed)e);
        }
    }

    private void addSubscriberItemActionPerformed(ActionEvent evt) {
        this.addSubscriber();
    }

    private void addSubscriber() {
        try {
            if (new CreateSubscriberPanel(this, this.configuratorProxy, 0).showDialog() == 0) {
                this.restartApplication();
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void removeSubscriberItemActionPerformed(ActionEvent evt) {
        try {
            if (this.subscriberMap.size() == 0) {
                Utils.popupError(this, "No Subscriber to remove");
                return;
            }
            if (new CreateSubscriberPanel(this, this.configuratorProxy, 1).showDialog() == 0) {
                this.restartApplication();
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void changeCsItemActionPerformed(ActionEvent evt) {
        this.changeTangoHost(this.attributeTree.getTangoHost());
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        if (this.subscriberMap == null) {
            return;
        }
        try {
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel((String)this.archiverComboBox.getSelectedItem());
            this.updateAttributeList(subscriber);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void manageAliasesItemActionPerformed(ActionEvent evt) {
        try {
            ArchiverAliasesDialog aliasesDialog = new ArchiverAliasesDialog(this, this.subscriberMap);
            if (aliasesDialog.showDialog() == 0) {
                this.restartApplication();
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void contextsItemActionPerformed(ActionEvent evt) {
        try {
            new EditStrategiesDialog(this, this.subscriberMap.getSubscriberList()).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void byStrategiesItemActionPerformed(ActionEvent evt) {
        try {
            new StrategyMainPanel(this, this.configuratorProxy.name()).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void principleItemActionPerformed(ActionEvent evt) {
        try {
            JOptionPane.showMessageDialog(this, null, "HDB++ Principle", 1, Utils.getInstance().getIcon("Principle.png"));
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        try {
            SplashUtils.getInstance().startSplash();
            SplashUtils.getInstance().increaseSplashProgress(10, "Building GUI");
            new TtlTableDialog(this, this.subscriberMap).setVisible(true);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void restartApplication() {
        try {
            new HdbConfigurator(this.parent).setVisible(true);
            if (this.diagnosticsPanel != null) {
                this.diagnosticsPanel.setVisible(false);
                this.diagnosticsPanel.dispose();
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void searchPath() {
        String path = this.attributeField.getText();
        this.attributeTree.goToNode(path);
    }

    private void addAttributeList(List<String> attributeNames) {
        try {
            Strategy strategy = Strategy.getContextsFromDB(null);
            ArrayList<HdbAttribute> attributeList = new ArrayList<HdbAttribute>();
            for (String attributeName : attributeNames) {
                attributeList.add(new HdbAttribute(attributeName, strategy));
            }
            PropertyDialog propertyDialog = new PropertyDialog((JFrame)this, attributeList, this.subscriberMap, (String)this.archiverComboBox.getSelectedItem());
            propertyDialog.setVisible(true);
            if (propertyDialog.isCanceled()) {
                return;
            }
            String archiverName = propertyDialog.getSubscriber();
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel(archiverName);
            List<HdbAttribute> attributes = propertyDialog.getHdbAttributes();
            ManageAttributes.addAttributes(this.configuratorProxy, subscriber.getName(), attributes);
            this.selectArchiver(archiverName);
            new UpdateSubscribedThread(attributes).start();
        }
        catch (DevFailed e) {
            if (e.errors[0].desc.contains("\n")) {
                new PopupHtml(this).show(PopupHtml.toHtml(e.errors[0].desc), "Cannot Add Attributes");
            }
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    public void selectArchiver(String archiverName) {
        this.archiverComboBox.setSelectedItem(archiverName);
        this.manageSubscriberChanged(archiverName);
    }

    private int attributeRow(AttributeTable table, String attributeName) {
        List<HdbAttribute> attributeList = table.getAttributeList();
        int row = 0;
        for (HdbAttribute attribute : attributeList) {
            if (attribute.getName().equalsIgnoreCase(attributeName)) {
                return row;
            }
            ++row;
        }
        return -1;
    }

    public void selectAttributeInList(String attributeName) {
        AttributeTable table = this.attributeTableList.get(0);
        int row = this.attributeRow(table, attributeName);
        if (row < 0 && (row = this.attributeRow(table = this.attributeTableList.get(2), attributeName)) < 0 && (row = this.attributeRow(table = this.attributeTableList.get(1), attributeName)) < 0) {
            return;
        }
        table.setSelectedRow(row);
    }

    private void addSpecifiedAttribute() {
        String attributeName = this.attributeField.getText();
        String fullName = TangoUtils.fullName(this.attributeTree.getTangoHost(), attributeName);
        this.addSpecifiedAttribute(fullName);
    }

    public void addSpecifiedAttribute(String attributeName) {
        try {
            HdbAttribute hdbAttribute = new HdbAttribute(attributeName);
            PropertyDialog propertyDialog = new PropertyDialog((JFrame)this, hdbAttribute, this.subscriberMap, (String)this.archiverComboBox.getSelectedItem());
            propertyDialog.setVisible(true);
            if (propertyDialog.isCanceled()) {
                return;
            }
            hdbAttribute = propertyDialog.getHdbAttributes().get(0);
            Subscriber subscriber = this.subscriberMap.getSubscriberByLabel(propertyDialog.getSubscriber());
            boolean lock = true;
            ArchiverUtils.addAttribute(this.configuratorProxy, subscriber.getName(), hdbAttribute, true);
            if (hdbAttribute.needsStart()) {
                subscriber.startAttribute(hdbAttribute);
            }
            this.updateAttributeList(subscriber);
            new UpdateSubscribedThread(hdbAttribute).start();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    public String getArchiverLabel(String deviceName) {
        return this.subscriberMap.getLabel(deviceName);
    }

    private void doClose() {
        this.updateListThread.stopIt = true;
        if (this.parent != null && this.parent.isVisible() || this.diagnosticsPanel != null && this.diagnosticsPanel.isVisible()) {
            this.setVisible(false);
            this.dispose();
        } else {
            try {
                this.updateListThread.join();
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
            }
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.put("ToolTip.foreground", new ColorUIResource(Color.black));
            UIManager.put("ToolTip.background", new ColorUIResource(Utils.toolTipBackground));
            new HdbConfigurator(null).setVisible(true);
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().stopSplash();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
        catch (Exception e) {
            SplashUtils.getInstance().stopSplash();
            e.printStackTrace();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (Exception)e);
            System.exit(0);
        }
        catch (Error e) {
            SplashUtils.getInstance().stopSplash();
            e.printStackTrace();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (Exception)new Exception(e));
            System.exit(0);
        }
    }

    private class UpdateSubscribedThread
    extends Thread {
        private boolean stopIt = false;
        private long t0 = System.currentTimeMillis();
        private List<HdbAttribute> attributes;

        private UpdateSubscribedThread(List<HdbAttribute> attributes) {
            this.attributes = attributes;
        }

        private UpdateSubscribedThread(HdbAttribute attribute) {
            this.attributes = new ArrayList<HdbAttribute>();
            this.attributes.add(attribute);
        }

        @Override
        public void run() {
            while (!this.stopIt) {
                try {
                    UpdateSubscribedThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.attributes.size() == 1) {
                    HdbConfigurator.this.attributeTree.updateAttributeInfo(this.attributes.get(0).getName());
                } else {
                    HdbConfigurator.this.attributeTree.updateAttributeInfo(this.attributes);
                }
                if (System.currentTimeMillis() - this.t0 <= 15000L) continue;
                this.stopIt = true;
            }
        }
    }

    private class UpdateListThread
    extends Thread {
        private List<HdbAttribute> displayedList = null;
        private boolean stopIt = false;

        private UpdateListThread() {
        }

        @Override
        public void run() {
            while (!this.stopIt) {
                String archiverLabel;
                try {
                    UpdateListThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((archiverLabel = (String)HdbConfigurator.this.archiverComboBox.getSelectedItem()) == null) continue;
                try {
                    Subscriber subscriber = HdbConfigurator.this.subscriberMap.getSubscriberByLabel(archiverLabel);
                    int selection = HdbConfigurator.this.tabbedPane.getSelectedIndex();
                    List<HdbAttribute> hdbAttributes = subscriber.getAttributeList(selection, false);
                    if (hdbAttributes != this.displayedList) {
                        this.displayedList = hdbAttributes;
                        HdbConfigurator.this.updateAttributeList(subscriber);
                    }
                    if (!subscriber.needsRepaint()) continue;
                    ((AttributeTable)HdbConfigurator.this.attributeTableList.get(selection)).fireTableDataChanged();
                }
                catch (DevFailed e) {
                    System.err.println(e.errors[0].desc);
                }
            }
        }
    }

    private class ListPopupMenu
    extends JPopupMenu {
        private JLabel title;
        private AttributeTable table;
        private JMenu subscriberMenu = new JMenu(HdbConfigurator.access$3000()[6]);

        private ListPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 12));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            int i = 0;
            for (String menuLabel : menuLabels) {
                if (i++ == 6) {
                    this.add(this.subscriberMenu);
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ListPopupMenu.this.menuActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        private void setSubscriberMenu() {
            List<String> subscriberList = HdbConfigurator.this.subscriberMap.getLabelList();
            String selected = (String)HdbConfigurator.this.archiverComboBox.getSelectedItem();
            this.subscriberMenu.removeAll();
            for (String subscriber : subscriberList) {
                if (subscriber.equals(selected)) continue;
                JMenuItem item = new JMenuItem(subscriber);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ListPopupMenu.this.menuActionPerformed(evt);
                    }
                });
                this.subscriberMenu.add(item);
            }
            this.subscriberMenu.setVisible(subscriberList.size() > 1);
        }

        private void showMenu(MouseEvent event, List<HdbAttribute> attributes) {
            String str = attributes.size() == 1 ? attributes.get(0).getName() : attributes.size() + " attributes";
            this.title.setText(str);
            this.setSubscriberMenu();
            this.table = (AttributeTable)event.getSource();
            if (this.table == HdbConfigurator.this.attributeTableList.get(0)) {
                this.getComponent(4).setVisible(false);
                this.getComponent(5).setVisible(true);
                this.getComponent(6).setVisible(true);
            } else if (this.table == HdbConfigurator.this.attributeTableList.get(2)) {
                this.getComponent(4).setVisible(true);
                this.getComponent(5).setVisible(false);
                this.getComponent(6).setVisible(false);
            } else if (this.table == HdbConfigurator.this.attributeTableList.get(1)) {
                this.getComponent(4).setVisible(true);
                this.getComponent(5).setVisible(true);
                this.getComponent(6).setVisible(false);
            }
            this.show(this.table, event.getX(), event.getY());
        }

        private void menuActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int itemIndex = -1;
            String targetSubscriber = null;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                itemIndex = i;
            }
            if (itemIndex < 0) {
                JMenuItem item = (JMenuItem)evt.getSource();
                targetSubscriber = item.getText();
                itemIndex = 6;
            }
            try {
                Subscriber archiver = HdbConfigurator.this.subscriberMap.getSubscriberByLabel((String)HdbConfigurator.this.archiverComboBox.getSelectedItem());
                List<HdbAttribute> attributeList = this.table.getSelectedAttributes();
                switch (itemIndex) {
                    case 0: {
                        HdbConfigurator.this.changeArchivingStrategy(attributeList);
                        break;
                    }
                    case 1: {
                        HdbConfigurator.this.changeAttributeTTL(attributeList);
                        break;
                    }
                    case 2: {
                        ManageAttributes.startAttributes(HdbConfigurator.this.configuratorProxy, attributeList);
                        HdbConfigurator.this.updateAttributeList(archiver);
                        break;
                    }
                    case 3: {
                        ManageAttributes.stopAttributes(HdbConfigurator.this.configuratorProxy, attributeList);
                        HdbConfigurator.this.updateAttributeList(archiver);
                        break;
                    }
                    case 4: {
                        ManageAttributes.pauseAttributes(HdbConfigurator.this.configuratorProxy, attributeList);
                        HdbConfigurator.this.updateAttributeList(archiver);
                        break;
                    }
                    case 5: {
                        if (JOptionPane.showConfirmDialog(this, "Remove selected attributes ?", "Confirm", 0, 3) != 0) break;
                        ManageAttributes.removeAttributes(HdbConfigurator.this.configuratorProxy, attributeList.toArray(new HdbAttribute[0]));
                        HdbConfigurator.this.updateAttributeList(archiver);
                        new UpdateSubscribedThread(attributeList).start();
                        HdbConfigurator.this.attributeTree.updateAttributeInfo(attributeList);
                        break;
                    }
                    case 6: {
                        HdbConfigurator.this.moveAttributeToSubscriber(targetSubscriber, attributeList);
                        new UpdateSubscribedThread(attributeList).start();
                        HdbConfigurator.this.attributeTree.updateAttributeInfo(attributeList);
                        break;
                    }
                    case 7: {
                        this.copyAttributeAsText();
                    }
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }

        private void copyAttributeAsText() {
            List<HdbAttribute> attributes = this.table.getSelectedAttributes();
            StringBuilder sb = new StringBuilder();
            for (HdbAttribute attribute : attributes) {
                sb.append(attribute.getName()).append('\n');
            }
            JTextArea textArea = new JTextArea(sb.toString());
            textArea.setSelectionStart(0);
            textArea.setSelectionEnd(sb.length());
            textArea.copy();
        }
    }
}

