/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.Selector;

public class CreateSubscriberPanel
extends JDialog {
    private JFrame parent;
    private DeviceProxy configuratorProxy;
    private List<String> instances = new ArrayList<String>();
    private List<String> archivers = new ArrayList<String>();
    private List<String> labels;
    private SubscriberMap subscriberMap;
    private int action;
    private int option = 0;
    private String managerName;
    private String subscriberName;
    private static final String CLASS_NAME = "HdbEventSubscriber";
    public static final int CREATE = 0;
    public static final int REMOVE = 1;
    private JPanel classPanel;
    private JTextArea classPropertyTextArea;
    private JComboBox<String> deviceComboBox;
    private JLabel deviceLabel;
    private JRadioButton inManagerButton;
    private JComboBox<String> instanceComboBox;
    private JLabel instanceLabel;
    private JComboBox<String> labelComboBox;
    private JLabel titleLabel;

    public CreateSubscriberPanel(JFrame parent, DeviceProxy configuratorProxy, int action) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.configuratorProxy = configuratorProxy;
        this.action = action;
        this.initComponents();
        this.classPanel.setVisible(false);
        this.managerName = configuratorProxy.get_server_name();
        this.managerName = this.managerName.substring(0, this.managerName.indexOf(47));
        this.subscriberName = TangoUtils.getServerNameForClass(CLASS_NAME);
        this.subscriberMap = new SubscriberMap(configuratorProxy);
        if (action == 0) {
            this.titleLabel.setText("Create a Subscriber on " + configuratorProxy.name());
            String[] archiverDevices = ArchiverUtils.getSubscriberList();
            this.deviceComboBox.addItem("");
            this.instanceComboBox.addItem("");
            this.labelComboBox.addItem("");
            for (String archiver : archiverDevices) {
                this.archivers.add(archiver);
                this.deviceComboBox.addItem(TangoUtils.getOnlyDeviceName(archiver));
                String instance = this.getServerInstance(archiver);
                if (this.instances.contains(instance)) continue;
                this.instances.add(instance);
                this.instanceComboBox.addItem(instance);
            }
            if (archiverDevices.length == 0) {
                this.classPanel.setVisible(true);
                this.classPropertyTextArea.setToolTipText(Utils.buildTooltip("Fill LibConfiguration class property\nwith information about your history database.\nSee HDB++ documentation."));
                DbDatum dbDatum = new DbClass(CLASS_NAME).get_property("LibConfiguration");
                if (!dbDatum.is_empty()) {
                    this.classPropertyTextArea.setText(this.arrayToString(dbDatum.extractStringArray()));
                }
            }
        } else {
            this.titleLabel.setText("Remove a Subscriber from " + configuratorProxy.name());
            this.instanceComboBox.setVisible(false);
            this.instanceLabel.setVisible(false);
            this.deviceComboBox.setVisible(false);
            this.deviceLabel.setVisible(false);
            this.labelComboBox.setEditable(false);
            this.inManagerButton.setVisible(false);
        }
        this.labels = this.subscriberMap.getLabelList();
        for (String label : this.labels) {
            this.labelComboBox.addItem(label);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private String getServerInstance(String deviceName) throws DevFailed {
        String serverName = new DeviceProxy(deviceName).get_server_name();
        int idx = serverName.indexOf(47);
        if (idx > 0) {
            this.subscriberName = serverName.substring(0, idx);
            return serverName.substring(idx + 1);
        }
        this.subscriberName = deviceName;
        return serverName;
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel centerPanel = new JPanel();
        this.instanceLabel = new JLabel();
        this.deviceLabel = new JLabel();
        JLabel aliasLabel = new JLabel();
        this.instanceComboBox = new JComboBox();
        this.deviceComboBox = new JComboBox();
        this.labelComboBox = new JComboBox();
        this.inManagerButton = new JRadioButton();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.classPanel = new JPanel();
        JLabel classLabel = new JLabel();
        JLabel classLabel1 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.classPropertyTextArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CreateSubscriberPanel.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Create a new Subscriber");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        centerPanel.setLayout(new GridBagLayout());
        this.instanceLabel.setFont(new Font("Tahoma", 1, 12));
        this.instanceLabel.setText("Server instance:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        centerPanel.add((Component)this.instanceLabel, gridBagConstraints);
        this.deviceLabel.setFont(new Font("Tahoma", 1, 12));
        this.deviceLabel.setText("Device name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 12, 8, 12);
        centerPanel.add((Component)this.deviceLabel, gridBagConstraints);
        aliasLabel.setFont(new Font("Tahoma", 1, 12));
        aliasLabel.setText("Label:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 12, 12);
        centerPanel.add((Component)aliasLabel, gridBagConstraints);
        this.instanceComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        centerPanel.add(this.instanceComboBox, gridBagConstraints);
        this.deviceComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 12, 8, 12);
        centerPanel.add(this.deviceComboBox, gridBagConstraints);
        this.labelComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 12, 12);
        centerPanel.add(this.labelComboBox, gridBagConstraints);
        this.inManagerButton.setText("Inside manager server");
        this.inManagerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateSubscriberPanel.this.inManagerButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        centerPanel.add((Component)this.inManagerButton, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateSubscriberPanel.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateSubscriberPanel.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.classPanel.setLayout(new GridBagLayout());
        classLabel.setFont(new Font("Tahoma", 1, 12));
        classLabel.setText("Class Properties:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 5, 12);
        this.classPanel.add((Component)classLabel, gridBagConstraints);
        classLabel1.setFont(new Font("Tahoma", 0, 12));
        classLabel1.setText("LibConfiguration: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 30, 0, 5);
        this.classPanel.add((Component)classLabel1, gridBagConstraints);
        this.classPropertyTextArea.setColumns(25);
        this.classPropertyTextArea.setRows(8);
        jScrollPane1.setViewportView(this.classPropertyTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.classPanel.add((Component)jScrollPane1, gridBagConstraints);
        this.getContentPane().add((Component)this.classPanel, "After");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            if (this.action == 0) {
                if (this.addSubscriber()) {
                    this.doClose();
                }
            } else if (this.removeSubscriber()) {
                this.doClose();
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private boolean removeSubscriber() throws DevFailed {
        String label = ((String)this.labelComboBox.getSelectedItem()).trim();
        if (label.isEmpty()) {
            Except.throw_exception((String)"SyntaxError", (String)"Label is not defined");
        }
        Subscriber subscriber = this.subscriberMap.getSubscriberByLabel(label);
        this.checkManagedAttributes(subscriber);
        String message = "Remove subscriber  " + label + "  (" + subscriber.name + ") ?";
        if (JOptionPane.showConfirmDialog(this, message, "Confirmation", 2) == 0) {
            DeviceData argIn = new DeviceData();
            argIn.insert(subscriber.name);
            this.configuratorProxy.command_inout("ArchiverRemove", argIn);
            this.manageArchiveLabels(TangoUtils.getOnlyDeviceName(subscriber.name), label);
            message = "Subscriber  " + label + "  (" + subscriber.name + " has been removed.\n\n" + "WARNING: device " + subscriber.name + "  still exists in TANGO database";
            JOptionPane.showMessageDialog(this, message);
            return true;
        }
        return false;
    }

    private void checkManagedAttributes(Subscriber subscriber) throws DevFailed {
        DbDatum datum = subscriber.get_property("AttributeList");
        if (!datum.is_empty()) {
            Except.throw_exception((String)"NotEmpty", (String)(subscriber.getLabel() + " still manage attribute(s).\nRemove attribute(s) before"));
        }
    }

    private boolean checkExeFile() {
        if (this.inManagerButton.isSelected()) {
            this.managerName = JOptionPane.showInputDialog(this, "Manager executable name ?", this.managerName);
        } else {
            List<String> exeFiles = this.subscriberMap.getSubscriberExeFiles();
            Selector selector = new Selector(this, "Subscriber executable name ?", "", exeFiles, "");
            this.subscriberName = selector.showDialog();
        }
        return this.subscriberName != null;
    }

    private String[] stringToArray(String str) {
        StringTokenizer stk = new StringTokenizer(str, "\n");
        String[] array = new String[stk.countTokens()];
        int i = 0;
        while (stk.hasMoreTokens()) {
            array[i] = stk.nextToken();
            ++i;
        }
        return array;
    }

    private String arrayToString(String[] lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append('\n');
        }
        return sb.toString().trim();
    }

    private void putClassProperties() throws DevFailed {
        String[] libConfiguration = this.stringToArray(this.classPropertyTextArea.getText().trim());
        DbDatum dbDatum = new DbDatum("LibConfiguration", libConfiguration);
        DbClass dbClass = new DbClass(CLASS_NAME);
        dbClass.put_property(new DbDatum[]{dbDatum});
    }

    private boolean addSubscriber() throws DevFailed {
        if (this.classPanel.isVisible()) {
            this.putClassProperties();
        }
        String deviceName = ((String)this.deviceComboBox.getSelectedItem()).trim();
        String label = ((String)this.labelComboBox.getSelectedItem()).trim();
        if (deviceName.isEmpty()) {
            Except.throw_exception((String)"SyntaxError", (String)"Device is not defined");
        }
        if (label.isEmpty()) {
            Except.throw_exception((String)"SyntaxError", (String)"Label is not defined");
        }
        if (!this.checkExeFile()) {
            return false;
        }
        for (String archiver : this.archivers) {
            if (!TangoUtils.getOnlyDeviceName(archiver).equals(deviceName)) continue;
            Except.throw_exception((String)"AlreadyExists", (String)("Device " + deviceName + " already defined as subscriber"));
        }
        if (this.labels.contains(label)) {
            Except.throw_exception((String)"AlreadyExists", (String)("Label " + label + " already defined"));
        }
        if (this.inManagerButton.isSelected()) {
            return this.createSubscriberDeviceToManager(deviceName, label);
        }
        return this.createSubscriberDeviceAndServer(deviceName, label);
    }

    private boolean createSubscriberDeviceToManager(String deviceName, String label) throws DevFailed {
        String message = "Device  " + deviceName + " will be added to  ";
        message = message + this.configuratorProxy.name() + "\n";
        message = message + "This device will be used with " + label + " label.";
        String configuratorName = this.configuratorProxy.get_server_name();
        if (JOptionPane.showConfirmDialog(this, message, "Confirmation", 2) == 0) {
            this.createArchiverDevice(configuratorName, deviceName, true);
            this.manageArchiveLabels(deviceName, label);
            this.addToManager(TangoUtils.fullName(deviceName));
            new DeviceProxy("dserver/" + configuratorName).command_inout("RestartServer");
            message = configuratorName + "  has been updated.\n     And restarted.";
            JOptionPane.showMessageDialog(this, message);
            return true;
        }
        return false;
    }

    private boolean createSubscriberDeviceAndServer(String deviceName, String label) throws DevFailed {
        String instance = ((String)this.instanceComboBox.getSelectedItem()).trim();
        if (instance.isEmpty()) {
            Except.throw_exception((String)"SyntaxError", (String)"Instance is not defined");
        }
        boolean serverExists = this.instances.contains(instance);
        System.out.println(instance);
        String message = "Device " + deviceName + " will be created ";
        message = serverExists ? message + "in existing " : message + "in new ";
        message = message + this.subscriberName + '/' + instance + " server as " + CLASS_NAME + " class\n";
        message = message + "This device will be used with " + label + " label.";
        if (JOptionPane.showConfirmDialog(this, message, "Confirmation", 2) == 0) {
            this.createArchiverDevice(this.subscriberName + '/' + instance, deviceName, serverExists);
            this.manageArchiveLabels(deviceName, label);
            this.addToManager(TangoUtils.fullName(deviceName));
            message = serverExists ? this.subscriberName + '/' + instance + "  has been updated.\nYou can re-start it." : this.subscriberName + '/' + instance + "  has been created.\nYou can start it.";
            JOptionPane.showMessageDialog(this, message);
            return true;
        }
        return false;
    }

    private void addToManager(String deviceName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(deviceName);
        this.configuratorProxy.command_inout("ArchiverAdd", argIn);
    }

    private void manageArchiveLabels(String deviceName, String archiverLabel) throws DevFailed {
        List<String[]> labelList = TangoUtils.getSubscriberLabels();
        for (String[] line : labelList) {
            if (!line[0].equalsIgnoreCase(deviceName)) continue;
            labelList.remove(line);
            break;
        }
        if (this.action == 0) {
            labelList.add(new String[]{deviceName, archiverLabel});
            Collections.sort(labelList, new StringArrayComparator());
        }
        TangoUtils.setSubscriberLabels(labelList);
    }

    private void createArchiverDevice(String serverName, String deviceName, boolean severExists) throws DevFailed {
        try {
            new DeviceProxy(deviceName).ping();
            return;
        }
        catch (DevFailed devFailed) {
            if (!severExists) {
                String adminName = "dserver/" + serverName.toLowerCase();
                ApiUtil.get_db_obj().add_device(new DbDevInfo(adminName, "DServer", serverName));
            }
            ApiUtil.get_db_obj().add_device(new DbDevInfo(deviceName, CLASS_NAME, serverName));
            DeviceProxy archiverProxy = new DeviceProxy(deviceName);
            if (this.archivers.size() > 0) {
                String[] propertyNames;
                DeviceProxy anotherDevice = new DeviceProxy(this.archivers.get(0));
                for (String propertyName : propertyNames = anotherDevice.get_property_list("*")) {
                    if (propertyName.equalsIgnoreCase("AttributeList") || propertyName.startsWith("__")) continue;
                    archiverProxy.put_property(anotherDevice.get_property(propertyName));
                }
            }
            System.out.println(serverName + " Created");
            return;
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.option = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.option = 2;
        this.doClose();
    }

    private void inManagerButtonActionPerformed(ActionEvent evt) {
        JRadioButton button = (JRadioButton)evt.getSource();
        this.instanceLabel.setVisible(!button.isSelected());
        this.instanceComboBox.setVisible(!button.isSelected());
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.option;
    }

    public static void main(String[] args) {
        try {
            String deviceName = System.getenv("HdbManager");
            if (deviceName == null) {
                Except.throw_exception((String)"DeviceNotDefined", (String)"HDB manager device not defined");
            }
            new CreateSubscriberPanel(null, new DeviceProxy(deviceName), 1).showDialog();
        }
        catch (DevFailed e) {
            e.printStackTrace();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    private class StringArrayComparator
    implements Comparator<String[]> {
        private StringArrayComparator() {
        }

        @Override
        public int compare(String[] a1, String[] a2) {
            if (a1 == null) {
                return 1;
            }
            if (a2 == null) {
                return -1;
            }
            return a1[0].compareTo(a2[0]);
        }
    }
}

