/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.HdbConfigurator;

public class AttributeTree
extends JTree {
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode selectedNode = null;
    private AttributeTreePopupMenu menu;
    private HdbConfigurator parent;
    private String tangoHost;
    private String[] deviceNames;
    private boolean useDefaultTangoHost;
    private boolean multiTangoHosts;
    private static final int DOMAIN = 0;
    private static final int FAMILY = 1;
    private static final int MEMBER = 2;
    private static ImageIcon tangoIcon;
    private static ImageIcon deviceIcon;
    private static ImageIcon selectedIcon;
    private static ImageIcon unselectedIcon;
    private static final Font titleFont;
    private static final Font deviceFont;
    private static final Font attributeFont;
    private static final int CHANGE_TANGO_HOST = 0;
    private static final int ADD_ATTRIBUTE = 1;
    private static final int CONFIGURE = 2;
    private static final int TEST_EVENT = 3;
    private static final int SELECT_ARCHIVER = 4;
    private static final int OFFSET = 2;
    private static String[] menuLabels;

    public AttributeTree(HdbConfigurator parent, String tangoHost) throws DevFailed {
        this(parent, tangoHost, null);
    }

    public AttributeTree(HdbConfigurator parent, String tangoHost, String wildcard) throws DevFailed {
        this.parent = parent;
        this.tangoHost = tangoHost;
        if (wildcard != null) {
            this.deviceNames = TangoUtils.getFilteredDeviceNames(tangoHost, wildcard);
        }
        this.buildTree();
        List<String> defaultTangoHosts = TangoUtils.getDefaultTangoHostList();
        for (String defaultTangoHost : defaultTangoHosts) {
            if (!tangoHost.equals(defaultTangoHost)) continue;
            this.useDefaultTangoHost = true;
        }
        String onlyOnCS = System.getenv("SingleControlSystem");
        this.multiTangoHosts = onlyOnCS == null || !onlyOnCS.equals("true");
        this.menu = new AttributeTreePopupMenu(this);
        this.setSelectionPath(null);
    }

    public String getTangoHost() {
        return this.tangoHost;
    }

    private void buildTree() throws DevFailed {
        this.root = new DefaultMutableTreeNode(this.tangoHost);
        this.createDomainNodes();
        this.getSelectionModel().setSelectionMode(4);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer renderer = new TangoRenderer();
        this.setCellRenderer(renderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                AttributeTree.this.expandedPerformed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AttributeTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object userObject = node.getUserObject();
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2 && (mask & 0x10) != 0) {
            this.addAttribute();
        } else if ((mask & 4) != 0) {
            if (node == this.root && this.multiTangoHosts) {
                this.menu.showMenu(evt, (String)node.getUserObject());
            } else if (userObject instanceof Member) {
                this.menu.showMenu(evt, (Member)userObject);
            } else if (userObject instanceof Attribute) {
                this.menu.showMenu(evt, (Attribute)userObject);
            }
        }
    }

    private void expandedPerformed(TreeExpansionEvent evt) {
        TreePath treePath = evt.getPath();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object userObject = parentNode.getUserObject();
        try {
            int childCount = parentNode.getChildCount();
            if (userObject instanceof Domain) {
                String[] families = this.deviceNames != null ? TangoUtils.getFilteredDeviceField(1, userObject.toString(), this.deviceNames) : TangoUtils.getFamilies(this.tangoHost, userObject.toString());
                this.createFamilyNodes(parentNode, families);
            } else if (userObject instanceof Family) {
                Family family = (Family)userObject;
                String[] member = this.deviceNames != null ? TangoUtils.getFilteredDeviceField(2, family.path, this.deviceNames) : TangoUtils.getMembers(this.tangoHost, family.path);
                this.createMemberNodes(parentNode, member);
            } else if (userObject instanceof Member) {
                Member member = (Member)userObject;
                this.createAttributeNodes(parentNode, TangoUtils.getDeviceAttributes(this.tangoHost, member.path));
            } else {
                return;
            }
            for (int i = 0; i < childCount; ++i) {
                this.treeModel.removeNodeFromParent((MutableTreeNode)parentNode.getChildAt(0));
            }
        }
        catch (DevFailed e) {
            this.collapsePath(treePath);
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void createFamilyNodes(DefaultMutableTreeNode domainNode, String[] families) {
        for (String family : families) {
            DefaultMutableTreeNode familyNode = new DefaultMutableTreeNode(new Family(family, (Domain)domainNode.getUserObject()));
            this.treeModel.insertNodeInto(familyNode, domainNode, domainNode.getChildCount());
            this.treeModel.insertNodeInto(new DummyNode(), familyNode, 0);
        }
    }

    private void createMemberNodes(DefaultMutableTreeNode familyNode, String[] members) {
        for (String member : members) {
            DefaultMutableTreeNode memberNode = new DefaultMutableTreeNode(new Member(member, (Family)familyNode.getUserObject()));
            this.treeModel.insertNodeInto(memberNode, familyNode, familyNode.getChildCount());
            this.treeModel.insertNodeInto(new DummyNode(), memberNode, 0);
        }
    }

    private void createAttributeNodes(DefaultMutableTreeNode memberNode, String[] attributes) {
        for (String attribute : attributes) {
            DefaultMutableTreeNode attributeNode = new DefaultMutableTreeNode(new Attribute(attribute, (Member)memberNode.getUserObject()));
            this.treeModel.insertNodeInto(attributeNode, memberNode, memberNode.getChildCount());
        }
    }

    private void createDomainNodes() throws DevFailed {
        String[] domains = this.deviceNames != null ? TangoUtils.getFilteredDeviceField(0, null, this.deviceNames) : TangoUtils.getDomains(this.tangoHost);
        for (String domain : domains) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new Domain(domain));
            this.root.add(node);
            node.add(new DummyNode());
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    public List<String> getSelectedAttributes() {
        ArrayList<String> attributes = new ArrayList<String>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(node.getUserObject() instanceof Attribute)) continue;
                Attribute attribute = (Attribute)node.getUserObject();
                attributes.add(TangoUtils.fullName(this.tangoHost, attribute.path));
            }
        }
        return attributes;
    }

    public void goToNode(String path) {
        DefaultMutableTreeNode memberNode;
        DefaultMutableTreeNode familyNode;
        StringTokenizer stk = new StringTokenizer(path, "/");
        ArrayList<String> fields = new ArrayList<String>(stk.countTokens());
        while (stk.hasMoreTokens()) {
            fields.add(stk.nextToken().toLowerCase());
        }
        if (fields.isEmpty()) {
            return;
        }
        DefaultMutableTreeNode domainNode = this.gotoNode(this.root, (String)fields.get(0));
        if (domainNode != null && fields.size() > 1 && (familyNode = this.gotoNode(domainNode, (String)fields.get(1))) != null && fields.size() > 2 && (memberNode = this.gotoNode(familyNode, (String)fields.get(2))) != null && fields.size() > 3) {
            this.gotoNode(memberNode, (String)fields.get(3));
        }
    }

    private DefaultMutableTreeNode gotoNode(DefaultMutableTreeNode parentNode, String name) {
        if (parentNode.getChildCount() > 0) {
            this.expandNode((DefaultMutableTreeNode)parentNode.getChildAt(0));
        }
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            if (!node.toString().toLowerCase().equals(name)) continue;
            TreePath treePath = new TreePath(node.getPath());
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(new TreePath(node.getPath()));
            return node;
        }
        return null;
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean levelDone = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (levelDone) continue;
                this.expandNode(child);
                levelDone = true;
                continue;
            }
            this.expandChildren(child);
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        nodes.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            nodes.add(0, node);
        }
        Object[] treeNodes = new DefaultMutableTreeNode[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            treeNodes[i] = (TreeNode)nodes.get(i);
        }
        TreePath treePath = new TreePath(treeNodes);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void testEvent() {
        Object userObject = this.getSelectedObject();
        if (userObject instanceof Attribute) {
            Attribute attribute = (Attribute)userObject;
            Utils.getTestEvents().add("tango://" + this.tangoHost + '/' + attribute.path);
        }
    }

    private void addAttribute() {
        Object userObject = this.getSelectedObject();
        if (userObject instanceof Attribute) {
            Attribute attribute = (Attribute)userObject;
            this.parent.addSpecifiedAttribute(TangoUtils.fullName(this.tangoHost, attribute.path));
            attribute.checkIfSubscribedLater();
        }
    }

    private void selectArchiver() {
        Object userObject = this.getSelectedObject();
        if (userObject instanceof Attribute) {
            Attribute attribute = (Attribute)userObject;
            this.parent.selectArchiver(attribute.archiver);
            this.parent.selectAttributeInList(TangoUtils.fullName(this.tangoHost, attribute.path));
        }
    }

    private void configureAttribute() {
        Object userObject = this.getSelectedObject();
        if (userObject instanceof Attribute) {
            String deviceName = ((Attribute)userObject).member.path;
            Utils.startJiveForDevice(deviceName);
        } else if (userObject instanceof Member) {
            String deviceName = ((Member)userObject).path;
            Utils.startJiveForDevice(deviceName);
        }
    }

    private void updateSelectedPathInfo() {
        Runnable doItLater = new Runnable(){

            @Override
            public void run() {
                Object userObject = AttributeTree.this.selectedNode.getUserObject();
                if (userObject instanceof PathComponent) {
                    AttributeTree.this.parent.displayPathInfo(AttributeTree.this.tangoHost, ((PathComponent)userObject).path);
                } else {
                    AttributeTree.this.parent.displayPathInfo(AttributeTree.this.tangoHost, "");
                }
            }
        };
        SwingUtilities.invokeLater(doItLater);
    }

    public void updateAttributeInfo(List<HdbAttribute> attributes) {
        for (HdbAttribute attribute : attributes) {
            this.updateAttributeInfo(attribute.getName());
        }
    }

    public void updateAttributeInfo(String attributeName) {
        DefaultMutableTreeNode attributeNode = this.getAttributeNode(attributeName);
        if (attributeNode != null) {
            Attribute attribute = (Attribute)attributeNode.getUserObject();
            attribute.checkIfSubscribedLater();
        }
    }

    private DefaultMutableTreeNode getAttributeNode(String attributeName) {
        String[] fields = TangoUtils.getAttributeFields(attributeName);
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode domainNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            if (!domainNode.toString().equalsIgnoreCase(fields[0])) continue;
            for (int j = 0; j < domainNode.getChildCount(); ++j) {
                DefaultMutableTreeNode familyNode = (DefaultMutableTreeNode)domainNode.getChildAt(j);
                if (!familyNode.toString().equalsIgnoreCase(fields[1])) continue;
                for (int k = 0; k < familyNode.getChildCount(); ++k) {
                    DefaultMutableTreeNode memberNode = (DefaultMutableTreeNode)familyNode.getChildAt(k);
                    if (!memberNode.toString().equalsIgnoreCase(fields[2])) continue;
                    for (int n = 0; n < memberNode.getChildCount(); ++n) {
                        DefaultMutableTreeNode attributeNode = (DefaultMutableTreeNode)memberNode.getChildAt(n);
                        if (!attributeNode.toString().equalsIgnoreCase(fields[3])) continue;
                        return attributeNode;
                    }
                }
            }
        }
        return null;
    }

    static {
        titleFont = new Font("Dialog", 1, 18);
        deviceFont = new Font("Dialog", 1, 12);
        attributeFont = new Font("Dialog", 0, 12);
        menuLabels = new String[]{"Change Tango Host", "Add Attribute to Subscriber", "Configure Polling/Events", "Test Event", "Select Archiver"};
    }

    private class AttributeTreePopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private AttributeTreePopupMenu(JTree tree) {
            this.tree = tree;
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        AttributeTreePopupMenu.this.hostActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        private void showMenu(MouseEvent evt, String name) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(name);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(2).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void showMenu(MouseEvent evt, Attribute attribute) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(attribute.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(3).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.getComponent(4).setEnabled(AttributeTree.this.useDefaultTangoHost);
            this.getComponent(5).setVisible(Utils.getTestEvents() != null);
            this.getComponent(3).setEnabled(attribute.archiver == null);
            if (attribute.archiver != null) {
                this.getComponent(6).setVisible(true);
                ((JMenuItem)this.getComponent(6)).setText(menuLabels[4] + ":   " + attribute.archiver);
            }
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void showMenu(MouseEvent evt, Member member) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(member.path);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(4).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void hostActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int itemIndex = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                itemIndex = i;
            }
            switch (itemIndex) {
                case 0: {
                    AttributeTree.this.parent.changeTangoHost(AttributeTree.this.tangoHost);
                    break;
                }
                case 1: {
                    AttributeTree.this.addAttribute();
                    break;
                }
                case 4: {
                    AttributeTree.this.selectArchiver();
                    break;
                }
                case 3: {
                    AttributeTree.this.testEvent();
                    break;
                }
                case 2: {
                    AttributeTree.this.configureAttribute();
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private TangoRenderer() {
            try {
                Utils utils = Utils.getInstance();
                tangoIcon = utils.getIcon("TangoLogo.gif", 0.25);
                deviceIcon = utils.getIcon("device.gif");
                selectedIcon = utils.getIcon("selected.gif", 0.75);
                unselectedIcon = utils.getIcon("unselected.gif", 0.75);
            }
            catch (DevFailed e) {
                SplashUtils.getInstance().stopSplash();
                ErrorPane.showErrorMessage((Component)AttributeTree.this.parent, null, (DevFailed)e);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object object, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, object, selected, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(Color.white);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            this.setToolTipText(null);
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                if (selected && node != AttributeTree.this.selectedNode) {
                    AttributeTree.this.selectedNode = node;
                    AttributeTree.this.updateSelectedPathInfo();
                }
                if (row == 0) {
                    this.setFont(titleFont);
                    this.setIcon(tangoIcon);
                } else if (node.getUserObject() instanceof Attribute) {
                    Attribute attribute = (Attribute)node.getUserObject();
                    this.setIcon(attribute.getIcon());
                    this.setToolTipText(attribute.getToolTip());
                    if (!attribute.checked) {
                        this.setFont(deviceFont);
                    } else if (attribute.archiver != null) {
                        this.setFont(deviceFont);
                    } else {
                        this.setFont(attributeFont);
                    }
                } else {
                    this.setFont(deviceFont);
                    this.setIcon(deviceIcon);
                }
            }
            return this;
        }
    }

    private class DummyNode
    extends DefaultMutableTreeNode {
        private DummyNode() {
        }

        @Override
        public String toString() {
            return "? ?";
        }
    }

    private class Attribute
    extends PathComponent {
        Member member;
        String archiver;
        boolean checked;

        private Attribute(String name, Member member) {
            this.archiver = null;
            this.checked = false;
            this.name = name;
            this.member = member;
            this.path = member.path + "/" + name;
            this.checkIfSubscribedLater();
        }

        private void checkIfSubscribedLater() {
            Runnable doItLater = new Runnable(){

                @Override
                public void run() {
                    AttributeTree.this.parent.setCursor(new Cursor(3));
                    Attribute.this.checked = false;
                    Attribute.this.checkIfSubscribed();
                    Attribute.this.checked = true;
                    AttributeTree.this.repaint();
                    AttributeTree.this.parent.setCursor(new Cursor(0));
                }
            };
            SwingUtilities.invokeLater(doItLater);
        }

        private void checkIfSubscribed() {
            try {
                this.archiver = ArchiverUtils.getArchiver(AttributeTree.this.parent.getConfiguratorProxy(), TangoUtils.fullName(AttributeTree.this.tangoHost, this.path));
                this.archiver = this.archiver.isEmpty() ? null : AttributeTree.this.parent.getArchiverLabel(this.archiver);
            }
            catch (Exception e) {
                this.archiver = null;
            }
        }

        ImageIcon getIcon() {
            if (this.archiver == null) {
                return unselectedIcon;
            }
            return selectedIcon;
        }

        String getToolTip() {
            if (this.archiver == null) {
                return "Not Subscribed";
            }
            return "Subscribed on " + this.archiver;
        }

        public String toString() {
            return this.name;
        }
    }

    private class Member
    extends PathComponent {
        Family family;

        private Member(String name, Family family) {
            this.name = name;
            this.family = family;
            this.path = family.path + "/" + name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class Family
    extends PathComponent {
        Domain domain;

        private Family(String name, Domain domain) {
            this.name = name;
            this.domain = domain;
            this.path = domain.name + "/" + name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class Domain
    extends PathComponent {
        private Domain(String name) {
            this.name = name;
            this.path = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class PathComponent {
        String name;
        String path;

        private PathComponent() {
        }
    }
}

