/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.HdbAttribute;

public class AttributeTable
extends JTable {
    private List<HdbAttribute> attributeList = new ArrayList<HdbAttribute>();
    private int tableWidth = 0;
    private DataTableModel model = new DataTableModel();
    private static final String[] columnNames = new String[]{"Attribute", "Strategy", "TTL"};
    private static final int[] columnWidth = new int[]{500, 100, 60};
    private static final int ATTRIBUTE_NAME = 0;
    private static final int ATTRIBUTE_STRATEGY = 1;
    static final int ATTRIBUTE_TTL = 2;

    public AttributeTable() {
        this.setModel(this.model);
        this.setRowSelectionAllowed(true);
        this.setDragEnabled(false);
        this.setSelectionMode(2);
        this.getTableHeader().setFont(new Font("Dialog", 1, 12));
        Enumeration<TableColumn> columnEnum = this.getColumnModel().getColumns();
        int i = 0;
        while (columnEnum.hasMoreElements()) {
            this.tableWidth += columnWidth[i];
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(columnWidth[i++]);
        }
    }

    void setSelectedRow(int row) {
        new SelectionThread(this, row).start();
    }

    List<HdbAttribute> getSelectedAttributes() {
        int[] rows = this.getSelectedRows();
        ArrayList<HdbAttribute> attributes = new ArrayList<HdbAttribute>(rows.length);
        for (int row : rows) {
            attributes.add(this.attributeList.get(row));
        }
        return attributes;
    }

    HdbAttribute getAttribute(int index) {
        return this.attributeList.get(index);
    }

    List<HdbAttribute> getAttributeList() {
        return this.attributeList;
    }

    int getTableWidth() {
        return this.tableWidth;
    }

    void fireTableDataChanged() {
        this.model.fireTableDataChanged();
    }

    void updateAttributeList(List<HdbAttribute> attributeList) {
        this.attributeList = attributeList;
        this.model.fireTableDataChanged();
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return AttributeTable.this.attributeList.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            String title = columnIndex >= this.getColumnCount() ? columnNames[this.getColumnCount() - 1] : columnNames[columnIndex];
            if (title.startsWith("tango://")) {
                int index = title.indexOf(47, "tango://".length());
                title = title.substring(index + 1);
            }
            return title;
        }

        @Override
        public Object getValueAt(int row, int column) {
            HdbAttribute hdbAttribute = (HdbAttribute)AttributeTable.this.attributeList.get(row);
            switch (column) {
                case 0: {
                    return hdbAttribute.getName();
                }
                case 1: {
                    return "  " + hdbAttribute.strategyToString();
                }
            }
            return "  " + hdbAttribute.getTtlString();
        }

        public Class getColumnClass(int column) {
            if (AttributeTable.this.isVisible()) {
                return this.getValueAt(0, column).getClass();
            }
            return null;
        }
    }

    private class SelectionThread
    extends Thread {
        private JTable table;
        private int row;

        private SelectionThread(JTable table, int row) {
            this.table = table;
            this.row = row;
        }

        @Override
        public void run() {
            try {
                SelectionThread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.table.setRowSelectionInterval(this.row, this.row);
            JScrollPane scrollPane = (JScrollPane)this.table.getParent().getParent();
            JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
            double ratio = (double)this.row / (double)AttributeTable.this.attributeList.size() * (double)scrollBar.getMaximum();
            if (ratio > 2.0) {
                ratio -= 2.0;
            }
            scrollBar.setValue((int)ratio);
            this.table.repaint();
        }
    }
}

