/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.configurator;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;

public class ArchiverAliasesDialog
extends JDialog {
    private JFrame parent;
    private ArrayList<Archiver> archivers = new ArrayList();
    private JTable table;
    private int tableWidth;
    private int returnValue = 0;
    private static final String[] columnNames = new String[]{"Subscriber", "Aliases"};
    private static final int maxHeight = 800;
    private static final int DEVICE_NAME = 0;
    private static final int ALIAS_NAME = 1;
    private Archiver selectedArchiver;
    private JLabel titleLabel;

    public ArchiverAliasesDialog(JFrame parent, SubscriberMap subscriberMap) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        List<String> labels = subscriberMap.getLabelList();
        for (String label : labels) {
            this.archivers.add(new Archiver(subscriberMap.getSubscriberByLabel((String)label).name, label));
        }
        this.buildTable();
        this.titleLabel.setText(this.archivers.size() + " Subscriber Aliases");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void buildTable() {
        this.table = new JTable(new DataTableModel());
        this.table.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ArchiverAliasesDialog.this.tableActionPerformed(evt);
            }
        });
        int[] columnWidth = this.getColumnWidths();
        Enumeration<TableColumn> columnEnum = this.table.getColumnModel().getColumns();
        int i = 0;
        this.tableWidth = 0;
        while (columnEnum.hasMoreElements()) {
            this.tableWidth += columnWidth[i];
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(columnWidth[i++]);
        }
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.setTableResize();
    }

    private int[] getColumnWidths() {
        int[] widths = new int[columnNames.length];
        ArrayList<String> devices = new ArrayList<String>();
        ArrayList<String> aliases = new ArrayList<String>();
        for (Archiver subscriber : this.archivers) {
            devices.add(subscriber.deviceName);
            aliases.add(subscriber.alias);
        }
        widths[0] = Utils.getTableColumnWidth(devices);
        widths[1] = Utils.getTableColumnWidth(aliases);
        return widths;
    }

    private void setTableResize() {
        this.pack();
        JScrollPane scrollPane = (JScrollPane)this.table.getParent().getParent();
        int height = this.table.getHeight() + this.table.getTableHeader().getHeight() + 10;
        if (height > 800) {
            height = 800;
        }
        scrollPane.setPreferredSize(new Dimension(this.tableWidth + 20, height));
    }

    private void tableActionPerformed(MouseEvent event) {
        Point clickedPoint = new Point(event.getX(), event.getY());
        int row = this.table.rowAtPoint(clickedPoint);
        this.selectedArchiver = this.archivers.get(row);
        this.table.repaint();
    }

    private void changeAlias(String newAlias) {
        try {
            this.checkNewAliasName(newAlias);
            this.selectedArchiver.alias = newAlias;
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
        }
    }

    private void checkNewAliasName(String aliasName) throws Exception {
        for (Archiver archiver : this.archivers) {
            if (archiver == this.selectedArchiver || !aliasName.equalsIgnoreCase(archiver.alias)) continue;
            throw new Exception("\"" + aliasName + "\"  is already an alias for  " + archiver.deviceName);
        }
    }

    private void updateDatabase() throws DevFailed {
        List<String[]> labels = TangoUtils.getSubscriberLabels();
        if (labels.isEmpty()) {
            for (Archiver archiver : this.archivers) {
                labels.add(new String[]{archiver.deviceName, archiver.alias});
            }
        } else {
            for (String[] label : labels) {
                String deviceName = label[0];
                String alias = label[1];
                for (Archiver archiver : this.archivers) {
                    if (!deviceName.equalsIgnoreCase(archiver.deviceName) || alias.equals(archiver.alias)) continue;
                    label[1] = archiver.alias;
                    System.out.println(deviceName + " --> " + archiver.alias);
                }
            }
        }
        TangoUtils.setSubscriberLabels(labels);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ArchiverAliasesDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArchiverAliasesDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArchiverAliasesDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            this.updateDatabase();
            this.returnValue = 0;
            this.doClose();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)e.getMessage(), (DevFailed)e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ArchiverAliasesDialog.this.archivers.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            String title = columnIndex >= this.getColumnCount() ? columnNames[this.getColumnCount() - 1] : columnNames[columnIndex];
            return title;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            ArchiverAliasesDialog.this.changeAlias((String)value);
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((Archiver)((ArchiverAliasesDialog)ArchiverAliasesDialog.this).archivers.get((int)row)).deviceName;
            }
            return ((Archiver)((ArchiverAliasesDialog)ArchiverAliasesDialog.this).archivers.get((int)row)).alias;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }
    }

    private class Archiver {
        String deviceName;
        String alias;

        private Archiver(String deviceName, String alias) {
            this.deviceName = TangoUtils.getOnlyDeviceName(deviceName);
            this.alias = alias;
        }
    }
}

