/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

import HDBViewer.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.SubscriberMap;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.TestEvents;

public class Utils {
    private static Hashtable<String, SubscriberMap> subscriberTable = new Hashtable();
    private static Hashtable<String, DeviceProxy> configuratorProxyTable = new Hashtable();
    private static Utils instance = new Utils();
    private static final String DefaultImagePath = "/org/tango/hdb_configurator/img/";
    private static jive3.MainPanel jive = null;
    private static ImageIcon redBall = null;
    private static ImageIcon orangeBall = null;
    private static ImageIcon greenBall = null;
    private static final boolean trace = System.getenv("trace") != null && System.getenv("trace").equals("true");
    public static final Color selectionBackground = new Color(0xE0E0FF);
    public static final Color firstColumnBackground = new Color(0xE0E0E0);
    public static final Color toolTipBackground = new Color(0xFFFFD0);
    private static TestEvents testEvents;
    private static final int hPadding = 20;
    private static final JTextArea textField;

    private Utils() {
    }

    public static Utils getInstance() {
        return instance;
    }

    public String getApplicationName() {
        String applicationName = this.getClass().getPackage().getImplementationTitle();
        String release = this.getClass().getPackage().getImplementationVersion();
        if (release != null) {
            applicationName = applicationName + "-" + release;
        }
        return applicationName;
    }

    public ImageIcon getIcon(String filename) throws DevFailed {
        URL url = this.getClass().getResource(DefaultImagePath + filename);
        if (url == null) {
            Except.throw_exception((String)"FILE_NOT_FOUND", (String)("Icon file  " + filename + "  not found"));
        }
        return new ImageIcon(url);
    }

    public ImageIcon getIcon(String filename, double ratio) throws DevFailed {
        ImageIcon icon = this.getIcon(filename);
        return this.getIcon(icon, ratio);
    }

    public ImageIcon getIcon(ImageIcon icon, double ratio) {
        if (icon != null) {
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            width = (int)(ratio * (double)width);
            height = (int)(ratio * (double)height);
            icon = new ImageIcon(icon.getImage().getScaledInstance(width, height, 4));
        }
        return icon;
    }

    public static ImageIcon getOrangeBall() throws DevFailed {
        if (orangeBall == null) {
            orangeBall = Utils.getInstance().getIcon("orangeBall.gif");
        }
        return orangeBall;
    }

    public static ImageIcon getGreenBall() throws DevFailed {
        if (greenBall == null) {
            greenBall = Utils.getInstance().getIcon("greenBall.gif");
        }
        return greenBall;
    }

    public static ImageIcon getRedBall() throws DevFailed {
        if (redBall == null) {
            redBall = Utils.getInstance().getIcon("redBall.gif");
        }
        return redBall;
    }

    public static DeviceProxy getConfiguratorProxy() throws DevFailed {
        String configuratorDeviceName = TangoUtils.getConfiguratorDeviceName();
        DeviceProxy configuratorProxy = configuratorProxyTable.get(configuratorDeviceName);
        if (configuratorProxy == null) {
            configuratorProxy = new DeviceProxy(configuratorDeviceName);
            configuratorProxyTable.put(configuratorDeviceName, configuratorProxy);
        }
        return configuratorProxy;
    }

    public static SubscriberMap getSubscriberMap(String configuratorDeviceName) throws DevFailed {
        return Utils.getSubscriberMap(configuratorDeviceName, false);
    }

    public static SubscriberMap getSubscriberMap(String configuratorDeviceName, boolean reInit) throws DevFailed {
        SubscriberMap subscriberMap = subscriberTable.get(configuratorDeviceName);
        if (subscriberMap == null) {
            subscriberMap = new SubscriberMap(configuratorDeviceName);
            subscriberTable.put(configuratorDeviceName, subscriberMap);
        }
        if (reInit) {
            subscriberMap = new SubscriberMap(configuratorDeviceName);
        }
        return subscriberMap;
    }

    public static boolean isTraceMode() {
        return trace;
    }

    public static void startJiveForDevice(String deviceName) {
        if (jive == null) {
            jive = new jive3.MainPanel(false, false);
        }
        jive.setVisible(true);
        jive.goToDeviceNode(deviceName);
    }

    public Component startExternalApplication(JFrame parent, String className) throws DevFailed {
        return this.startExternalApplication(parent, className, null);
    }

    public Component startExternalApplication(JFrame parent, String className, Object parameter) throws DevFailed {
        try {
            Constructor<?>[] constructors;
            Class<?> _class = Class.forName(className);
            for (Constructor<?> constructor : constructors = _class.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameter == null) {
                    if (parameterTypes.length != 1 || parameterTypes[0] != JFrame.class) continue;
                    Component component = (Component)constructor.newInstance(parent);
                    component.setVisible(true);
                    return component;
                }
                if (parameterTypes.length != 2 || parameterTypes[0] != JFrame.class) continue;
                if (parameterTypes[1] == String.class && parameter instanceof String) {
                    Component component = (Component)constructor.newInstance(parent, parameter);
                    component.setVisible(true);
                    return component;
                }
                if (parameterTypes[1] != String[].class || !(parameter instanceof String[])) continue;
                Component component = (Component)constructor.newInstance(parent, parameter);
                component.setVisible(true);
                return component;
            }
            throw new Exception("Cannot find constructor for " + className);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable throwable = ite.getTargetException();
                System.err.println(throwable.getMessage());
                if (throwable instanceof DevFailed) {
                    throw (DevFailed)throwable;
                }
                Except.throw_exception((String)throwable.toString(), (String)throwable.getMessage());
            }
            Except.throw_exception((String)e.toString(), (String)e.toString());
            return null;
        }
    }

    public static List<String> readFileLines(String fileName) throws DevFailed {
        ArrayList<String> lines = new ArrayList<String>();
        String code = Utils.readFile(fileName);
        StringTokenizer stringTokenizer = new StringTokenizer(code, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            lines.add(stringTokenizer.nextToken());
        }
        return lines;
    }

    public static String readFile(String fileName) throws DevFailed {
        String str = "";
        try {
            FileInputStream fid = new FileInputStream(fileName);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            nb = fid.read(inStr);
            fid.close();
            if (nb > 0) {
                str = new String(inStr);
            }
        }
        catch (Exception e) {
            Except.throw_exception((String)e.getMessage(), (String)e.toString());
        }
        return str;
    }

    public static void writeFile(String fileName, String code) throws DevFailed {
        try {
            FileOutputStream fid = new FileOutputStream(fileName);
            fid.write(code.getBytes());
            fid.close();
        }
        catch (Exception e) {
            Except.throw_exception((String)e.getMessage(), (String)e.toString());
        }
    }

    public static List<HdbAttribute> matchFilter(List<HdbAttribute> attributes, String pattern) {
        ArrayList<HdbAttribute> hdbAttributes = new ArrayList<HdbAttribute>();
        for (HdbAttribute attribute : attributes) {
            if (!Utils.matches(attribute.getName().substring("tango://".length()), pattern)) continue;
            hdbAttributes.add(attribute);
        }
        return hdbAttributes;
    }

    public static boolean matches(String attributeName, String pattern) {
        StringTokenizer stk = new StringTokenizer(attributeName, "/");
        ArrayList<String> attributeTokens = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            attributeTokens.add(stk.nextToken());
        }
        stk = new StringTokenizer(pattern, "/");
        ArrayList<String> patternTokens = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            patternTokens.add(stk.nextToken());
        }
        int index = 0;
        for (String attributeToken : attributeTokens) {
            String patternToken;
            if (index > patternTokens.size() - 1) {
                return true;
            }
            if (Utils.matchField(attributeToken, patternToken = (String)patternTokens.get(index++))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchField(String field, String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.contains("*")) {
            int pos;
            if (pattern.startsWith("*")) {
                pattern = pattern.substring(1);
            }
            if ((pos = pattern.indexOf(42)) > 0) {
                String patternStart = pattern.substring(0, pos);
                if (field.contains(patternStart)) {
                    String patternEnd = pattern.substring(++pos);
                    if ((pos = pattern.indexOf(42, pos)) > 0) {
                        patternEnd = pattern.substring(pos);
                        return field.endsWith(patternEnd);
                    }
                    return field.endsWith(patternEnd);
                }
                return false;
            }
            return field.endsWith(pattern);
        }
        return pattern.equals(field);
    }

    public static String strPeriod(double period) {
        if (period < 0.002) {
            return String.format("%.2f us", 1000000.0 * period);
        }
        if (period < 1.0) {
            return String.format("%.2f ms.", 1000.0 * period);
        }
        if (period < 60.0) {
            return String.format("%.2f sec.", period);
        }
        int intPeriod = (int)period;
        if (intPeriod < 3600) {
            int mn = intPeriod / 60;
            int sec = intPeriod - 60 * mn;
            return "" + mn + " mn " + (sec < 10 ? "0" : "") + sec + " sec.";
        }
        if (intPeriod < 86400) {
            int h = intPeriod / 3600;
            int mn = (intPeriod -= h * 3600) / 60;
            int sec = intPeriod - 60 * mn;
            return "" + h + " h " + (mn < 10 ? "0" : "") + mn + " mn " + (sec < 10 ? "0" : "") + sec + " sec.";
        }
        int days = intPeriod / 86400;
        return "" + days + " day" + (days > 1 ? "s " : " ") + Utils.strPeriod((double)intPeriod - (double)(days * 24 * 3600));
    }

    public static String buildTooltip(String text) {
        StringBuilder sb = new StringBuilder("<html><BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFD0\">\n");
        if (text.contains("\n")) {
            sb.append(Utils.splitTextLines(text));
        } else {
            sb.append("<table border=0 cellSpacing=2>\n");
            sb.append("<tr>").append(text).append("</tr>\n");
            sb.append("</table>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    private static String splitTextLines(String text) {
        StringTokenizer stk = new StringTokenizer(text, "\n");
        StringBuilder sb = new StringBuilder();
        while (stk.hasMoreTokens()) {
            sb.append(stk.nextToken()).append("<br>\n");
        }
        return sb.toString().trim();
    }

    public static void popupError(Component component, String message) {
        ErrorPane.showErrorMessage((Component)component, (String)"Error", (Exception)new Exception(message));
    }

    public static TestEvents getTestEvents() {
        if (testEvents == null) {
            try {
                testEvents = TestEvents.getInstance(new JFrame());
            }
            catch (NoClassDefFoundError e) {
                System.err.println(e.getMessage());
            }
            catch (DevFailed e) {
                System.err.println(e.errors[0].desc);
            }
        }
        return testEvents;
    }

    public static void startHdbViewer(String fullAttributeName) throws DevFailed {
        String tangoHost = TangoUtils.getOnlyTangoHost(fullAttributeName);
        String attributeName = TangoUtils.getOnlyDeviceName(fullAttributeName);
        System.out.println(attributeName);
        System.out.println(tangoHost);
        try {
            MainPanel hdbViewer = new MainPanel(false, true);
            hdbViewer.setTimeInterval(3);
            hdbViewer.addAttribute(tangoHost, attributeName);
            hdbViewer.setVisible(true);
            hdbViewer.performSearch();
        }
        catch (Error | Exception e) {
            Except.throw_exception((String)"HdbFailed", (String)e.toString());
        }
    }

    public static String getLongestLine(List<String> lines) {
        return Utils.getLongestLine(lines.toArray(new String[0]));
    }

    public static String getLongestLine(String[] lines) {
        String longest = "";
        for (String line : lines) {
            if (line.length() <= longest.length()) continue;
            longest = line;
        }
        return longest;
    }

    public static int getTableColumnWidth(List<String> lines) {
        return Utils.getLongestLine(lines).length() * 8 + 20;
    }

    public static void copyToClipboard(String message) {
        textField.setText(message);
        textField.setSelectionStart(0);
        textField.setSelectionEnd(message.length());
        textField.copy();
    }

    static {
        textField = new JTextArea();
    }
}

