/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import jive.ExecDev;

public class TangoUtils {
    private static boolean ttlRead = false;
    private static long defaultTTL = 31L;
    public static final String deviceHeader = "tango://";

    public static String getDefaultTangoHost() throws DevFailed {
        return new TangoUrl().getTangoHost();
    }

    public static String getEventTangoHost() throws DevFailed {
        String eventTangoHost = System.getProperty("EVENT_TANGO_HOST");
        if (eventTangoHost == null) {
            eventTangoHost = System.getenv("EVENT_TANGO_HOST");
        }
        if (eventTangoHost == null || eventTangoHost.isEmpty()) {
            return ApiUtil.get_db_obj().get_tango_host();
        }
        return TangoUtils.getTangoHost(eventTangoHost);
    }

    public static String getTangoHost(String tangoHost) throws DevFailed {
        String hostName;
        String newTangoHost;
        int p = tangoHost.indexOf(46);
        if (p < 0) {
            p = tangoHost.indexOf(58);
        }
        if (p < 0) {
            Except.throw_exception((String)"SyntaxError", (String)"Bad syntax for TANGO_HOST (host:port)");
        }
        if ((newTangoHost = ApiUtil.get_db_obj((String)tangoHost).get_tango_host()).startsWith((hostName = tangoHost.substring(0, p)) + '.')) {
            return newTangoHost;
        }
        p = newTangoHost.indexOf(46);
        if (p > 0) {
            return hostName + newTangoHost.substring(p);
        }
        try {
            String alias = InetAddress.getByName(hostName).getCanonicalHostName();
            int idx = alias.indexOf(46);
            String fqdn = "";
            if (idx > 0) {
                fqdn = alias.substring(idx);
            }
            p = tangoHost.indexOf(58);
            return hostName + fqdn + tangoHost.substring(p);
        }
        catch (UnknownHostException e) {
            Except.throw_exception((String)e.toString(), (String)e.toString());
            return "";
        }
    }

    public static String fullName(String attributeName) throws DevFailed {
        if (attributeName.startsWith(deviceHeader)) {
            return TangoUtils.checkFQDN(attributeName);
        }
        return deviceHeader + TangoUtils.getDefaultTangoHost() + "/" + attributeName;
    }

    private static String checkFQDN(String attributeName) {
        int idx = attributeName.indexOf(58, deviceHeader.length());
        String host = attributeName.substring(deviceHeader.length(), idx);
        if (host.contains(".")) {
            return attributeName;
        }
        try {
            String alias = InetAddress.getByName(host).getCanonicalHostName();
            int idx2 = alias.indexOf(46);
            String fqdn = "";
            if (idx2 < 0) {
                System.err.println("Cannot parse FQDN !");
            } else {
                fqdn = alias.substring(idx2);
                System.out.println("----------> " + fqdn);
            }
            return deviceHeader + host + fqdn + attributeName.substring(idx);
        }
        catch (UnknownHostException e) {
            System.err.println(e.toString());
            return attributeName;
        }
    }

    public static String fullName(String tangoHost, String name) {
        return deviceHeader + tangoHost + "/" + name;
    }

    public static String getOnlyTangoHost(String fullName) {
        String tangoHost = fullName;
        if (fullName.startsWith(deviceHeader)) {
            int idx = fullName.indexOf(47, deviceHeader.length());
            tangoHost = fullName.substring(deviceHeader.length(), idx);
        }
        return tangoHost;
    }

    public static String getOnlyDeviceName(String fullName) {
        String deviceName = fullName;
        if (fullName.startsWith(deviceHeader)) {
            int idx = fullName.indexOf(47, deviceHeader.length());
            deviceName = fullName.substring(idx + 1);
        }
        return deviceName;
    }

    public static String[] getAttributeFields(String attributeName) {
        if (attributeName.startsWith(deviceHeader)) {
            int idx = attributeName.indexOf(47, deviceHeader.length());
            attributeName = attributeName.substring(idx + 1);
        }
        StringTokenizer stk = new StringTokenizer(attributeName, "/");
        String[] fields = new String[]{stk.nextToken(), stk.nextToken(), stk.nextToken(), stk.nextToken()};
        return fields;
    }

    public static String[] getDomains(String tangoHost) throws DevFailed {
        return ApiUtil.get_db_obj((String)tangoHost).get_device_domain("*");
    }

    public static String[] getFamilies(String tangoHost, String domain) throws DevFailed {
        return ApiUtil.get_db_obj((String)tangoHost).get_device_family(domain + "/*");
    }

    public static String[] getMembers(String tangoHost, String path) throws DevFailed {
        return ApiUtil.get_db_obj((String)tangoHost).get_device_member(path + "/*");
    }

    public static String[] getDeviceAttributes(String tangoHost, String deviceName) throws DevFailed {
        return new DeviceProxy(TangoUtils.fullName(tangoHost, deviceName)).get_attribute_list();
    }

    public static String getConfiguratorDeviceName() throws DevFailed {
        String deviceName = System.getProperty("HdbManager");
        if (deviceName == null || deviceName.isEmpty()) {
            deviceName = System.getenv("HdbManager");
        }
        if (deviceName == null || deviceName.isEmpty()) {
            Except.throw_exception((String)"DeviceNotDefined", (String)"No Configuration Manager Found in environment");
        }
        return deviceName;
    }

    public static String getEventProperties(String tangoHost, String attributeName) throws DevFailed {
        AttributeProxy attributeProxy = new AttributeProxy(TangoUtils.fullName(tangoHost, attributeName));
        int idlVersion = attributeProxy.get_idl_version();
        if (idlVersion < 3) {
            return "Device_" + idlVersion + "Impl not supported.";
        }
        AttributeInfoEx info = attributeProxy.get_info_ex();
        StringBuilder sb = new StringBuilder();
        if (info.events != null) {
            sb.append("Archive event properties:\n");
            if (info.events.arch_event != null) {
                sb.append(" abs_change: ").append(info.events.arch_event.abs_change).append("\n");
                sb.append(" rel_change: ").append(info.events.arch_event.rel_change).append("\n");
                sb.append(" period    : ").append(info.events.arch_event.period);
            } else {
                sb.append(" rel_change: ").append("Not specified").append("\n");
                sb.append(" abs_change: ").append("Not specified").append("\n");
                sb.append(" period    : ").append("Not specified");
            }
        }
        return sb.toString();
    }

    public static String getAttPollingInfo(String tangoHost, String attributeName) throws DevFailed {
        String[] globalPollingStatus;
        String header = "Polled attribute name = ";
        String deviceName = attributeName.substring(0, attributeName.lastIndexOf(47));
        attributeName = attributeName.substring(attributeName.lastIndexOf(47) + 1);
        for (String attPollingStatus : globalPollingStatus = new DeviceProxy(TangoUtils.fullName(tangoHost, deviceName)).polling_status()) {
            int end;
            int start;
            String name = attPollingStatus.substring(header.length(), attPollingStatus.indexOf(10));
            if (!name.toLowerCase().equals(attributeName.toLowerCase()) || (start = attPollingStatus.indexOf("Polling period")) <= 0 || (end = attPollingStatus.indexOf(10, start)) <= start) continue;
            return attPollingStatus.substring(start, end).trim();
        }
        return "Attribute Not Polled";
    }

    public static List<String[]> getSubscriberLabels() throws DevFailed {
        String[] lines;
        DbDatum datum = ApiUtil.get_db_obj().get_property("HdbConfigurator", "ArchiverLabels");
        ArrayList<String[]> labels = new ArrayList<String[]>();
        if (datum.is_empty()) {
            return labels;
        }
        for (String line : lines = datum.extractStringArray()) {
            StringTokenizer stk = new StringTokenizer(line, ":");
            if (stk.countTokens() <= 1) continue;
            labels.add(new String[]{stk.nextToken().trim(), stk.nextToken().trim()});
        }
        return labels;
    }

    public static void setSubscriberLabels(List<String[]> labels) throws DevFailed {
        String[] lines = new String[labels.size()];
        int i = 0;
        for (String[] label : labels) {
            lines[i++] = label[0] + ":  " + label[1];
        }
        DbDatum datum = new DbDatum("ArchiverLabels");
        datum.insert(lines);
        ApiUtil.get_db_obj().put_property("HdbConfigurator", new DbDatum[]{datum});
    }

    public static String[] getFilteredDeviceField(int fieldIndex, String header, String[] deviceNames) {
        if (header == null) {
            header = "";
        }
        if (!header.isEmpty() && !header.endsWith("/")) {
            header = header + "/";
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (String deviceName : deviceNames) {
            StringTokenizer stk;
            String field;
            if (!deviceName.startsWith(header) || !TangoUtils.mustBeAdded(field = TangoUtils.getToken(stk = new StringTokenizer(deviceName, "/"), fieldIndex), fields)) continue;
            fields.add(field);
        }
        String[] array = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            array[i] = (String)fields.get(i);
        }
        return array;
    }

    private static boolean mustBeAdded(String str, List<String> list) {
        if (str == null) {
            return false;
        }
        for (String s : list) {
            if (!s.toLowerCase().equals(str.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private static String getToken(StringTokenizer stk, int index) {
        String token = null;
        for (int i = 0; stk.hasMoreTokens() && i <= index; ++i) {
            String str = stk.nextToken();
            if (i != index) continue;
            token = str;
        }
        return token;
    }

    public static String[] getFilteredDeviceNames(String tangoHost, String wildcard) throws DevFailed {
        return ApiUtil.get_db_obj((String)tangoHost).get_device_list(wildcard);
    }

    public static void testDevice(Component parent, String deviceName) throws DevFailed {
        JDialog dialog = parent instanceof JFrame ? new JDialog((Frame)((JFrame)parent), false) : new JDialog((Dialog)((JDialog)parent), false);
        dialog.setTitle(deviceName + " Device Panel");
        dialog.setContentPane((Container)new ExecDev(deviceName));
        dialog.pack();
        ATKGraphicsUtils.centerDialog((Dialog)dialog);
        dialog.setVisible(true);
    }

    public static String getArchiveName(DeviceProxy deviceProxy) {
        try {
            DbDatum datum = deviceProxy.get_property("ArchiveName");
            if (datum.is_empty()) {
                return "";
            }
            return datum.extractString();
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
            return "";
        }
    }

    public static List<String> getDefaultTangoHostList() throws DevFailed {
        ArrayList<String> list = new ArrayList<String>();
        Database database = ApiUtil.get_db_obj();
        String[] tangoHosts = database.getPossibleTangoHosts();
        Collections.addAll(list, tangoHosts);
        return list;
    }

    public static String[] getServersForClass(String className) throws DevFailed {
        String mysqlCommand = "server from device where class=\"" + className + "\"";
        DeviceData argIn = new DeviceData();
        argIn.insert(mysqlCommand);
        System.out.println(mysqlCommand);
        DeviceData argOut = ApiUtil.get_db_obj().command_inout("DbMySqlSelect", argIn);
        DevVarLongStringArray lsa = argOut.extractLongStringArray();
        if (lsa.svalue.length > 0) {
            return lsa.svalue;
        }
        return new String[0];
    }

    public static String getServerNameForClass(String className) throws DevFailed {
        String[] servers = TangoUtils.getServersForClass(className);
        if (servers.length == 0) {
            return null;
        }
        return servers[0].substring(0, servers[0].indexOf(47));
    }

    public static long getDefaultTTL() {
        if (!ttlRead) {
            try {
                DbDatum datum = ApiUtil.get_db_obj().get_property("HdbConfigurator", "DefaultTTL");
                if (!datum.is_empty()) {
                    defaultTTL = datum.extractLong();
                }
                ttlRead = true;
            }
            catch (DevFailed e) {
                System.err.println(e.errors[0].desc);
            }
        }
        return defaultTTL;
    }

    public static void main(String[] args) {
        try {
            List<String> list = TangoUtils.getDefaultTangoHostList();
            for (String s : list) {
                System.out.println(s);
            }
            String tangoHost = TangoUtils.getOnlyTangoHost("tango://hal:2001/a/b/c/d");
            System.out.println(tangoHost);
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }
}

