/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JFrame;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.SplashUtils;
import org.tango.hdb_configurator.common.StringComparator;
import org.tango.hdb_configurator.common.Subscriber;
import org.tango.hdb_configurator.common.TangoUtils;

public class SubscriberMap {
    private List<String> labelList = new ArrayList<String>();
    private Hashtable<String, Subscriber> label2device = new Hashtable();
    private Hashtable<String, String> deviceName2label = new Hashtable();
    private List<String> tangoHostList = new ArrayList<String>();
    private DeviceProxy configuratorProxy;

    public SubscriberMap(String configuratorDeviceName) throws DevFailed {
        this(new DeviceProxy(configuratorDeviceName));
    }

    public SubscriberMap(DeviceProxy configuratorProxy) throws DevFailed {
        this.configuratorProxy = configuratorProxy;
        List<String[]> labels = TangoUtils.getSubscriberLabels();
        String[] subscriberNames = ArchiverUtils.getSubscriberList();
        String theSubscriberName = System.getenv("Subscriber");
        if (theSubscriberName == null || theSubscriberName.isEmpty()) {
            for (String subscriberName : subscriberNames) {
                SplashUtils.getInstance().increaseSplashProgressForLoop(subscriberNames.length, "Building object " + subscriberName);
                this.put(subscriberName, labels, configuratorProxy);
            }
            StringComparator.sort(this.labelList);
        } else {
            for (String[] array : labels) {
                if (array[0].equalsIgnoreCase(theSubscriberName)) {
                    this.put(array[0], labels, configuratorProxy);
                    continue;
                }
                if (!array[1].equalsIgnoreCase(theSubscriberName)) continue;
                this.put(array[0], labels, configuratorProxy);
            }
        }
    }

    public SubscriberMap(List<String[]> list) throws DevFailed {
        List<String[]> labels = TangoUtils.getSubscriberLabels();
        String theSubscriberName = System.getenv("Subscriber");
        if (theSubscriberName == null || theSubscriberName.isEmpty()) {
            for (String[] strings : list) {
                SplashUtils.getInstance().increaseSplashProgressForLoop(list.size(), "Building object " + strings[0]);
                this.put(strings[0], labels, new DeviceProxy(strings[1]));
            }
            StringComparator.sort(this.labelList);
        }
    }

    public DeviceProxy getConfiguratorProxy() {
        return this.configuratorProxy;
    }

    public void add(Subscriber subscriber) {
        this.labelList.add(subscriber.getLabel());
        this.label2device.put(subscriber.getLabel(), subscriber);
        this.deviceName2label.put(subscriber.getName(), subscriber.getLabel());
    }

    private void put(String deviceName, List<String[]> labels, DeviceProxy managerProxy) {
        try {
            boolean found = false;
            String tgHost = "";
            if (deviceName.startsWith("tango://")) {
                int index = deviceName.indexOf(47, "tango://".length());
                tgHost = deviceName.substring(0, index) + '/';
            }
            for (String[] label : labels) {
                if (label.length > 1) {
                    String devName = tgHost + label[0].toLowerCase();
                    if (!deviceName.toLowerCase().equals(devName)) continue;
                    this.label2device.put(label[1], new Subscriber(deviceName, label[1], managerProxy));
                    this.labelList.add(label[1]);
                    this.deviceName2label.put(deviceName, label[1]);
                    found = true;
                    continue;
                }
                System.err.println("Syntax problem in 'SubscriberLabel' property");
            }
            if (!found) {
                this.label2device.put(deviceName, new Subscriber(deviceName, deviceName, managerProxy));
                this.labelList.add(deviceName);
                this.deviceName2label.put(deviceName, deviceName);
            }
        }
        catch (DevFailed e) {
            SplashUtils.getInstance().showSplash(false);
            e.printStackTrace();
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)e.getMessage(), (DevFailed)e);
            SplashUtils.getInstance().showSplash(true);
        }
    }

    public int size() {
        return this.labelList.size();
    }

    public List<String> getLabelList() {
        return this.labelList;
    }

    public String getLabel(String deviceName) {
        return this.deviceName2label.get(deviceName);
    }

    public Subscriber getSubscriberByLabel(String label) throws DevFailed {
        Subscriber subscriber = this.label2device.get(label);
        if (subscriber == null) {
            Except.throw_exception((String)"NO_ARCHIVER", (String)("Subscriber \"" + label + "\" not found !"));
        }
        return subscriber;
    }

    public Subscriber getSubscriberByDevice(String deviceName) throws DevFailed {
        String label = this.getLabel(deviceName);
        if (label == null) {
            Except.throw_exception((String)"NO_ARCHIVER", (String)("Subscriber \"" + deviceName + "\" not found !"));
        }
        return this.getSubscriberByLabel(label);
    }

    public List<Subscriber> getSubscriberList() {
        Collection<Subscriber> collection = this.label2device.values();
        return new ArrayList<Subscriber>(collection);
    }

    public void updateStrategies() throws DevFailed {
        Collection<Subscriber> collection = this.label2device.values();
        for (Subscriber subscriber : collection) {
            subscriber.updateStrategy();
        }
    }

    public List<String> getTangoHostList() {
        if (this.tangoHostList.isEmpty()) {
            Collection<Subscriber> collection = this.label2device.values();
            for (Subscriber subscriber : collection) {
                List<String> csList = subscriber.getTangoHostList();
                for (String cs : csList) {
                    if (this.tangoHostList.contains(cs)) continue;
                    this.tangoHostList.add(cs);
                }
            }
        }
        return this.tangoHostList;
    }

    public List<String> getSubscriberExeFiles() {
        ArrayList<String> exeFiles = new ArrayList<String>();
        List<Subscriber> subscribers = this.getSubscriberList();
        for (Subscriber subscriber : subscribers) {
            try {
                String file;
                String serverName = subscriber.get_server_name();
                if (serverName == null || !serverName.contains("/") || exeFiles.contains(file = serverName.substring(0, serverName.indexOf(47)))) continue;
                exeFiles.add(file);
            }
            catch (DevFailed e) {
                System.err.println(e.errors[0].desc);
            }
        }
        return exeFiles;
    }
}

