/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.Context;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.Strategy;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;
import org.tango.hdb_configurator.configurator.ManageAttributes;

public class Subscriber
extends DeviceProxy {
    public String name;
    protected String label;
    protected String startedFilter;
    protected String stoppedFilter;
    protected String pausedFilter;
    protected List<HdbAttribute> startedAttributes = new ArrayList<HdbAttribute>();
    protected List<HdbAttribute> stoppedAttributes = new ArrayList<HdbAttribute>();
    protected List<HdbAttribute> pausedAttributes = new ArrayList<HdbAttribute>();
    protected Hashtable<String, HdbAttribute> hdbAttributeMap = new Hashtable();
    private Strategy strategy;
    private boolean faulty = false;
    private DeviceProxy configuratorProxy;
    public static final int ATTRIBUTE_STARTED = 0;
    public static final int ATTRIBUTE_PAUSED = 1;
    public static final int ATTRIBUTE_STOPPED = 2;
    public static final String CLASS_NAME = "HdbEventSubscriber";
    private boolean mustBeRepaint = false;
    private String[] attributeNames = new String[0];

    public Subscriber(String deviceName, String label, DeviceProxy configuratorProxy) throws DevFailed {
        super(deviceName.toLowerCase());
        this.name = deviceName.toLowerCase();
        this.label = label;
        this.configuratorProxy = configuratorProxy;
        this.startedFilter = "*/*/*/*/*";
        this.stoppedFilter = "*/*/*/*/*";
        this.pausedFilter = "*/*/*/*/*";
        this.updateStrategy();
        TangoEventsAdapter adapter = new TangoEventsAdapter((DeviceProxy)this);
        ChangeEventListener changeListener = new ChangeEventListener();
        adapter.addTangoChangeListener((ITangoChangeListener)changeListener, "AttributeList", true);
        adapter.addTangoChangeListener((ITangoChangeListener)changeListener, "AttributeStrategyList", true);
        adapter.addTangoChangeListener((ITangoChangeListener)changeListener, "AttributeTTLList", true);
        adapter.addTangoChangeListener((ITangoChangeListener)changeListener, "AttributeStartedList", true);
        adapter.addTangoChangeListener((ITangoChangeListener)changeListener, "AttributeStoppedList", true);
        adapter.addTangoChangeListener((ITangoChangeListener)changeListener, "AttributePausedList", true);
    }

    public Hashtable<String, HdbAttribute> getHdbAttributeMap() {
        return this.hdbAttributeMap;
    }

    public DeviceProxy getConfiguratorProxy() {
        return this.configuratorProxy;
    }

    public void setStrategy(Strategy strategy) {
        if (this.strategy != strategy) {
            this.strategy.clear();
            for (Context context : strategy) {
                this.strategy.add(new Context(context.getName(), context.getDescription(), context.isDefault()));
            }
        }
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void updateStrategy() throws DevFailed {
        this.strategy = Strategy.getContextsFromDB(this);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getStartedFilter() {
        return this.startedFilter;
    }

    public void setStartedFilter(String startedFilter) {
        this.startedFilter = startedFilter;
    }

    public String getStoppedFilter() {
        return this.stoppedFilter;
    }

    public void setStoppedFilter(String stoppedFilter) {
        this.stoppedFilter = stoppedFilter;
    }

    public String getPausedFilter() {
        return this.pausedFilter;
    }

    public void setPausedFilter(String pausedFilter) {
        this.pausedFilter = pausedFilter;
    }

    public long getStatisticsResetTime() {
        try {
            DeviceAttribute attribute = this.read_attribute("StatisticsResetTime");
            if (attribute.hasFailed()) {
                return 0L;
            }
            double nbSeconds = attribute.extractDouble();
            long nbMillis = (long)nbSeconds * 1000L;
            long now = System.currentTimeMillis();
            return now - nbMillis;
        }
        catch (DevFailed e) {
            return 0L;
        }
    }

    public void setContext(String context) throws DevFailed {
        DeviceAttribute deviceAttribute = new DeviceAttribute("Context");
        deviceAttribute.insert(context);
        this.write_attribute(deviceAttribute);
    }

    public String getContext() throws DevFailed {
        DeviceAttribute deviceAttribute = this.read_attribute("Context");
        return deviceAttribute.extractString();
    }

    public boolean hasFaultyAttribute() {
        try {
            DeviceAttribute attribute = this.read_attribute("AttributeNokList");
            return !attribute.hasFailed() && attribute.extractStringArray().length != 0;
        }
        catch (DevFailed e) {
            return false;
        }
    }

    public int getStatisticsTimeWindow() throws DevFailed {
        int value = 7200;
        String propertyName = "StatisticsTimeWindow";
        DbDatum datum = new DbClass(CLASS_NAME).get_property(propertyName);
        if (!datum.is_empty()) {
            try {
                value = datum.extractLong();
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
            }
        }
        if (!(datum = this.get_property(propertyName)).is_empty()) {
            try {
                value = datum.extractLong();
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
            }
        }
        return value;
    }

    List<String> getTangoHostList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String[] attributeList;
            for (String attributeName : attributeList = ArchiverUtils.getAttributeList(this, "")) {
                String csName = TangoUtils.getOnlyTangoHost(attributeName);
                if (list.contains(csName)) continue;
                list.add(csName);
            }
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
        return list;
    }

    public String toString() {
        return this.name;
    }

    public boolean hasAttribute(int attributeState) {
        return !this.getAttributeList(attributeState, false).isEmpty();
    }

    public List<HdbAttribute> getAttributeList(int attributeState, boolean filtered) {
        switch (attributeState) {
            case 0: {
                if (filtered) {
                    return Utils.matchFilter(this.startedAttributes, this.startedFilter);
                }
                return this.startedAttributes;
            }
            case 2: {
                if (filtered) {
                    return Utils.matchFilter(this.stoppedAttributes, this.stoppedFilter);
                }
                return this.stoppedAttributes;
            }
            case 1: {
                if (filtered) {
                    return Utils.matchFilter(this.pausedAttributes, this.pausedFilter);
                }
                return this.pausedAttributes;
            }
        }
        return null;
    }

    public void startAttribute(HdbAttribute attribute) throws DevFailed {
        ManageAttributes.startAttribute(this.configuratorProxy, attribute);
    }

    public void stopAttribute(HdbAttribute attribute) throws DevFailed {
        ManageAttributes.stopAttribute(this.configuratorProxy, attribute);
    }

    public void pauseAttribute(HdbAttribute attribute) throws DevFailed {
        ManageAttributes.pauseAttribute(this.configuratorProxy, attribute);
    }

    public String getAttributeStatus(String attributeName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(attributeName);
        DeviceData argOut = this.command_inout("AttributeStatus", argIn);
        return argOut.extractString();
    }

    public boolean isFaulty() {
        return this.faulty;
    }

    public List<HdbAttribute> checkAttributeStrategies(List<HdbAttribute> attributeList) throws DevFailed {
        ArrayList<HdbAttribute> unCompatibleAttributes = new ArrayList<HdbAttribute>();
        block0: for (HdbAttribute attribute : attributeList) {
            for (Context attributeContext : attribute) {
                if (!attributeContext.isUsed()) continue;
                boolean found = false;
                for (Context context : this.strategy) {
                    if (!context.getName().equalsIgnoreCase(attributeContext.getName())) continue;
                    found = true;
                }
                if (found) continue;
                HdbAttribute newAttribute = new HdbAttribute(attribute.getName(), this.strategy);
                ((Context)newAttribute.get(0)).setUsed(true);
                unCompatibleAttributes.add(newAttribute);
                continue block0;
            }
        }
        return unCompatibleAttributes;
    }

    public void setTTL(List<HdbAttribute> attributeList, long ttl) throws DevFailed {
        for (HdbAttribute attribute : attributeList) {
            DeviceData argIn = new DeviceData();
            argIn.insert(new String[]{attribute.getName(), Long.toString(ttl)});
            this.command_inout("SetAttributeTTL", argIn);
        }
    }

    public boolean needsRepaint() {
        boolean b = this.mustBeRepaint;
        this.mustBeRepaint = false;
        return b;
    }

    private void manageAttributeMap(DeviceAttribute deviceAttribute) throws DevFailed {
        switch (deviceAttribute.getName()) {
            case "AttributeList": {
                for (String attributeName : this.attributeNames = deviceAttribute.extractStringArray()) {
                    HdbAttribute attribute = this.hdbAttributeMap.get(attributeName);
                    if (attribute != null) continue;
                    attribute = new HdbAttribute(attributeName);
                    this.hdbAttributeMap.put(attributeName, attribute);
                }
                break;
            }
            case "AttributeStrategyList": {
                String[] strategiesStr = deviceAttribute.extractStringArray();
                for (int i = 0; i < this.attributeNames.length && i < strategiesStr.length; ++i) {
                    HdbAttribute attribute = this.hdbAttributeMap.get(this.attributeNames[i]);
                    if (attribute == null) continue;
                    attribute.clear();
                    attribute.setStrategy(this.strategy, strategiesStr[i]);
                }
                this.mustBeRepaint = true;
                break;
            }
            case "AttributeTTLList": {
                long[] ttlList = deviceAttribute.extractULongArray();
                for (int i = 0; i < this.attributeNames.length && i < ttlList.length; ++i) {
                    HdbAttribute attribute = this.hdbAttributeMap.get(this.attributeNames[i]);
                    if (attribute == null) continue;
                    attribute.setTTL(ttlList[i]);
                }
                this.mustBeRepaint = true;
            }
        }
    }

    private List<HdbAttribute> buildHdbAttributeList(String[] attributeNames) {
        ArrayList<HdbAttribute> list = new ArrayList<HdbAttribute>();
        for (String attributeName : attributeNames) {
            HdbAttribute attribute = this.hdbAttributeMap.get(attributeName);
            if (attribute == null) continue;
            list.add(attribute);
        }
        return list;
    }

    public boolean manageAttribute(String attributeName) {
        return this.hdbAttributeMap.get(attributeName) != null;
    }

    public class ChangeEventListener
    implements ITangoChangeListener {
        private void setError(String message) {
            if (!Subscriber.this.faulty) {
                Subscriber.this.startedAttributes = new ArrayList<HdbAttribute>();
                Subscriber.this.pausedAttributes = new ArrayList<HdbAttribute>();
                Subscriber.this.stoppedAttributes = new ArrayList<HdbAttribute>();
                Subscriber.this.startedAttributes.add(new HdbAttribute("!!! " + message));
                Subscriber.this.stoppedAttributes.add(new HdbAttribute("!!! " + message));
                Subscriber.this.pausedAttributes.add(new HdbAttribute("!!! " + message));
                Subscriber.this.faulty = true;
            }
        }

        public void change(TangoChangeEvent event) {
            try {
                DeviceAttribute attribute = event.getValue();
                if (attribute.hasFailed()) {
                    this.setError(attribute.getErrStack()[0].desc);
                } else if (attribute.getQuality() == AttrQuality.ATTR_VALID) {
                    switch (attribute.getName()) {
                        case "AttributeStartedList": {
                            Subscriber.this.startedAttributes = Subscriber.this.buildHdbAttributeList(attribute.extractStringArray());
                            Subscriber.this.faulty = false;
                            break;
                        }
                        case "AttributeStoppedList": {
                            Subscriber.this.stoppedAttributes = Subscriber.this.buildHdbAttributeList(attribute.extractStringArray());
                            Subscriber.this.faulty = false;
                            break;
                        }
                        case "AttributePausedList": {
                            Subscriber.this.pausedAttributes = Subscriber.this.buildHdbAttributeList(attribute.extractStringArray());
                            Subscriber.this.faulty = false;
                            break;
                        }
                        case "AttributeList": 
                        case "AttributeStrategyList": 
                        case "AttributeTTLList": {
                            Subscriber.this.manageAttributeMap(attribute);
                        }
                    }
                } else {
                    this.setError(attribute.getName() + " is invalid");
                }
            }
            catch (DevFailed e) {
                if (e.errors[0].desc.startsWith("No heartbeat from")) {
                    System.out.println(e.errors[0].desc);
                } else {
                    this.setError(e.errors[0].desc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setError(e.getMessage());
            }
        }
    }
}

