/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.tango.hdb_configurator.common.Context;
import org.tango.hdb_configurator.common.Subscriber;

public class Strategy
extends ArrayList<Context> {
    private boolean classProperty;
    public static final int ALWAYS_INDEX = 0;
    private static final String ALWAYS_CONTEXT = "ALWAYS";
    private static final String ContextsPropertyName = "ContextsList";
    private static final String DefaultPropertyName = "DefaultStrategy";
    private static final String SubscriberClassName = "HdbEventSubscriber";
    private static final String AlwaysDescription = "Store in HDB++ under any circumstances";
    private static final String SEPARATOR = ":";

    public String[] getNames() {
        String[] names = new String[this.size()];
        int i = 0;
        for (Context context : this) {
            names[i++] = context.getName();
        }
        return names;
    }

    public boolean isClassProperty() {
        return this.classProperty;
    }

    public boolean different(Strategy strategy) {
        if (strategy.size() != this.size()) {
            return true;
        }
        if (strategy.isClassProperty() != this.classProperty) {
            return true;
        }
        for (int i = 0; i < this.size() && i < strategy.size(); ++i) {
            Context context = (Context)strategy.get(i);
            if (!context.different((Context)this.get(i))) continue;
            return true;
        }
        return false;
    }

    public void setClassProperty(boolean classProperty) {
        this.classProperty = classProperty;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Context context : this) {
            if (context.isUsed()) {
                sb.append("[");
            }
            sb.append(context);
            if (context.isUsed()) {
                sb.append("]");
            }
            if (i++ >= this.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static Strategy getContextsFromDB(Subscriber subscriber) throws DevFailed {
        if (subscriber == null) {
            return Strategy.getContextsFromDB();
        }
        DbDatum dbDatum = subscriber.get_property(ContextsPropertyName);
        if (dbDatum.is_empty()) {
            return Strategy.getContextsFromDB();
        }
        return Strategy.buildStrategy(dbDatum, Strategy.getDefaultContexts(subscriber), false);
    }

    public static Strategy getContextsFromDB() throws DevFailed {
        DbDatum dbDatum = new DbClass(SubscriberClassName).get_property(ContextsPropertyName);
        return Strategy.buildStrategy(dbDatum, Strategy.getDefaultContexts(), true);
    }

    private static Strategy manageDefaultContexts(Strategy strategy) {
        if (strategy.isEmpty()) {
            strategy.add(new Context(ALWAYS_CONTEXT, AlwaysDescription, true));
            return strategy;
        }
        boolean found = false;
        for (int i = 0; i < strategy.size(); ++i) {
            String context = ((Context)strategy.get(i)).getName();
            if (!context.equalsIgnoreCase(ALWAYS_CONTEXT)) continue;
            found = true;
            if (i <= 0) continue;
            strategy.add(0, strategy.remove(i));
            break;
        }
        if (!found) {
            strategy.add(0, new Context(ALWAYS_CONTEXT, AlwaysDescription, true));
        }
        return strategy;
    }

    private static Strategy buildStrategy(DbDatum dbDatum, String[] defaultContexts, boolean classProperty) throws DevFailed {
        Strategy strategy = new Strategy();
        if (!dbDatum.is_empty()) {
            String[] lines;
            for (String line : lines = dbDatum.extractStringArray()) {
                StringTokenizer stk = new StringTokenizer(line, SEPARATOR);
                if (stk.countTokens() <= 0) continue;
                String name = stk.nextToken().trim();
                String desc = "";
                if (stk.hasMoreTokens()) {
                    desc = stk.nextToken().trim();
                }
                boolean isDefault = false;
                for (String str : defaultContexts) {
                    if (!name.equalsIgnoreCase(str)) continue;
                    isDefault = true;
                }
                strategy.add(new Context(name, desc, isDefault));
            }
        }
        strategy = Strategy.manageDefaultContexts(strategy);
        strategy.setClassProperty(classProperty);
        return strategy;
    }

    public static String[] getDefaultContexts() throws DevFailed {
        return Strategy.getDefaultContexts(null);
    }

    public static String[] getDefaultContexts(Subscriber subscriber) throws DevFailed {
        DbDatum dbDatum = null;
        if (subscriber != null) {
            dbDatum = subscriber.get_property(DefaultPropertyName);
        }
        if (subscriber == null || dbDatum == null || dbDatum.is_empty()) {
            dbDatum = new DbClass(SubscriberClassName).get_property(DefaultPropertyName);
        }
        if (dbDatum.is_empty()) {
            return new String[]{ALWAYS_CONTEXT};
        }
        return dbDatum.extractStringArray();
    }

    public static void putStrategiesToDB(Strategy strategy, Subscriber subscriber) throws DevFailed {
        String[] array = new String[strategy.size()];
        int i = 0;
        for (Context context : strategy) {
            array[i++] = context.getName() + SEPARATOR + " " + context.getDescription();
        }
        ArrayList<String> defaultNames = new ArrayList<String>();
        for (Context context : strategy) {
            if (!context.isDefault()) continue;
            defaultNames.add(context.getName());
        }
        DbDatum[] dbData = new DbDatum[]{new DbDatum(ContextsPropertyName, array), new DbDatum(DefaultPropertyName, defaultNames.toArray(new String[defaultNames.size()]))};
        if (subscriber == null) {
            new DbClass(SubscriberClassName).put_property(dbData);
        } else {
            subscriber.put_property(dbData);
        }
    }
}

