/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import javax.swing.ImageIcon;
import org.tango.hdb_configurator.common.Utils;

public class SplashUtils {
    private static Splash splash = null;
    private static int splashProgress = 0;
    private static boolean splashActive = false;
    private static SplashUtils instance = new SplashUtils();
    private static final String imageFile = "FullTangoLogo.gif";

    public static SplashUtils getInstance() {
        return instance;
    }

    public void startSplash() {
        if (splash != null) {
            splash.setVisible(false);
        }
        JSmoothProgressBar myBar = new JSmoothProgressBar();
        myBar.setStringPainted(true);
        myBar.setBackground(Color.lightGray);
        myBar.setProgressBarColors(Color.gray, Color.lightGray, Color.darkGray);
        try {
            ImageIcon icon = Utils.getInstance().getIcon(imageFile);
            splash = new Splash(icon, Color.black, myBar);
            splash.setTitle(Utils.getInstance().getApplicationName());
            splash.setMessage("Starting....");
            splash.setVisible(true);
            splashProgress = 0;
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
    }

    public void increaseSplashProgress(int i, String message) {
        if (splash == null) {
            return;
        }
        if ((splashProgress += i) > 98) {
            splashProgress = 1;
        }
        splash.progress(splashProgress);
        if (message != null) {
            splash.setMessage(message);
        }
    }

    public void increaseSplashProgressForLoop(int size, String message) {
        if (splash == null) {
            return;
        }
        if ((splashProgress += this.getStep(size)) > 98) {
            splashProgress = 1;
        }
        splash.progress(splashProgress);
        if (message != null) {
            splash.setMessage(message);
        }
    }

    public void reset() {
        splashProgress = 1;
    }

    private int getStep(int size) {
        int step = 98 / size;
        if (step < 1) {
            step = 1;
        }
        return step;
    }

    public void setSplashProgress(int i, String message) {
        if (splash == null) {
            return;
        }
        splashProgress = i;
        if (splashProgress > 98) {
            splashProgress = 98;
        }
        splash.progress(splashProgress);
        if (message != null) {
            splash.setMessage(message);
        }
    }

    public void showSplash(boolean b) {
        if (splash != null) {
            splash.setVisible(b);
        }
    }

    public void stopSplash() {
        if (splash != null) {
            splashProgress = 100;
            splash.progress(splashProgress);
            splash.setVisible(false);
        }
    }

    public boolean getSplashActive() {
        return splashActive;
    }

    public void setSplashActive(boolean b) {
        splashActive = b;
    }

    public void startAutoUpdate() {
        new UpdateThread().start();
    }

    private class UpdateThread
    extends Thread {
        private UpdateThread() {
        }

        @Override
        public void run() {
            while (splash.isVisible()) {
                SplashUtils.this.increaseSplashProgress(1, null);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

