/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PopupHtml
extends JDialog
implements TangoConst {
    protected JFrame parent;
    protected JEditorPane pane;
    private String urlFile;
    private static final String header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> title </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n";
    private static final String footer = "</Body>\n</Html>\n";
    public static final String Space = "&nbsp;";

    public PopupHtml(JFrame parent) {
        this(parent, true);
    }

    public PopupHtml(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this.parent = parent;
        this.pack();
    }

    private void setScreenPosition() {
        if (this.parent != null && this.parent.isVisible() && this.parent.getWidth() > 0) {
            Point p = this.parent.getLocationOnScreen();
            p.x += 50;
            p.y += this.parent.getHeight() / 2 - this.getHeight() / 2;
            if (p.y < 10) {
                p.y = 10;
            }
            this.setLocation(p);
        }
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JButton cancelBtn = new JButton();
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PopupHtml.this.closeDialog(evt);
            }
        });
        jPanel1.setLayout(new FlowLayout(2, 5, 5));
        jLabel1.setText("                     ");
        jPanel1.add(jLabel1);
        cancelBtn.setText("Dismiss");
        cancelBtn.setHorizontalAlignment(2);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupHtml.this.dismissBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
    }

    protected synchronized void setPage(URL url) {
        try {
            this.pane.setCursor(new Cursor(3));
            this.pane.setPage(url);
        }
        catch (IOException e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (Exception)e);
        }
        this.pane.setCursor(new Cursor(0));
    }

    private String buildTmpFile(String code) {
        String urlstr = null;
        try {
            int random_value = new Random().nextInt(30000);
            String tmpdir = System.getProperty("java.io.tmpdir");
            this.urlFile = tmpdir + "/html." + random_value;
            FileOutputStream fidout = new FileOutputStream(this.urlFile);
            fidout.write((header + code + footer).getBytes());
            fidout.close();
            urlstr = "file:" + this.urlFile;
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (Exception)e);
            e.printStackTrace();
        }
        return urlstr;
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void doClose() {
        try {
            if (this.urlFile != null && !new File(this.urlFile).delete()) {
                System.err.println("Cannot delete " + this.urlFile);
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (Exception)e);
        }
        this.setVisible(false);
        this.dispose();
    }

    private String htmlTitle(String title) {
        return "<b><u>" + title + "</u></b>\n<ul>";
    }

    public void show(String code) {
        this.show(code, null, 700, 750);
    }

    public void show(String code, String title) {
        this.show(code, title, 700, 750);
    }

    public void show(String code, String title, int width, int height) {
        try {
            if (title != null) {
                code = this.htmlTitle(title) + code;
            }
            this.pane = new JEditorPane();
            this.pane.setEditable(false);
            this.pane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                }
            });
            this.getContentPane().add((Component)new JScrollPane(this.pane), "Center");
            URL url = new URL(this.buildTmpFile(code));
            this.setPage(url);
            this.setSize(width, height);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return;
        }
        this.setScreenPosition();
        this.setVisible(true);
    }

    public void show(URL url, int width, int height) {
        this.pane = new JEditorPane();
        this.pane.setEditable(false);
        this.pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
            }
        });
        this.getContentPane().add((Component)new JScrollPane(this.pane), "Center");
        this.setSize(width, height);
        this.setPage(url);
        this.setScreenPosition();
        this.setVisible(true);
    }

    public static String toHtml(String code) {
        int idx = 0;
        while ((idx = code.indexOf(10, idx)) > 0) {
            code = code.substring(0, idx) + "<br>" + code.substring(idx);
            idx += 5;
        }
        idx = 0;
        while ((idx = code.indexOf(40, idx)) > 0) {
            code = code.substring(0, idx) + Space + Space + code.substring(idx);
            idx += "&nbsp;&nbsp;".length() + 1;
        }
        return code;
    }
}

