/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

import fr.esrf.Tango.DevFailed;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tango.hdb_configurator.common.ArchiverUtils;
import org.tango.hdb_configurator.common.Context;
import org.tango.hdb_configurator.common.Strategy;

public class HdbAttribute
extends Strategy {
    private String name;
    private boolean pushedByCode;
    private boolean startIt;
    private boolean isError = false;
    private long ttl = 0L;
    private AttributeNameComponents nameComponents = null;

    public HdbAttribute(String name, Strategy strategy) throws DevFailed {
        this.name = name;
        try {
            String attributeStrategy = ArchiverUtils.getAttributeStrategy(name);
            this.setStrategy(strategy, attributeStrategy);
        }
        catch (DevFailed e) {
            this.setStrategy(strategy);
            System.err.println(e.errors[0].desc);
        }
    }

    public HdbAttribute(String name) {
        this.name = name;
        this.isError = true;
    }

    public HdbAttribute(String name, Strategy strategy, boolean pushedByCode) {
        this.name = name;
        this.setStrategy(strategy);
        this.pushedByCode = pushedByCode;
    }

    public String getName() {
        return this.name;
    }

    public void setPushedByCode(boolean pushedByCode) {
        this.pushedByCode = pushedByCode;
    }

    public boolean isPushedByCode() {
        return this.pushedByCode;
    }

    public boolean needsStart() {
        return this.startIt;
    }

    public void setStrategy(Strategy strategy) {
        this.addAll(strategy);
    }

    public void updateUsedContexts(Strategy strategy) {
        if (this.isEmpty()) {
            this.addAll(strategy);
        } else {
            for (int i = 0; i < this.size() && i < strategy.size(); ++i) {
                Context context = (Context)this.get(i);
                context.setUsed(((Context)strategy.get(i)).isUsed());
            }
        }
    }

    public void setStrategy(Strategy strategy, String contextNames) {
        StringTokenizer stk = new StringTokenizer(contextNames, "|");
        ArrayList<String> contextList = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            contextList.add(stk.nextToken());
        }
        for (Context context : strategy) {
            boolean used = false;
            for (String contextName : contextList) {
                if (!context.getName().equalsIgnoreCase(contextName)) continue;
                used = true;
            }
            Context newContext = new Context(context.getName(), used, context.getDescription());
            this.add(newContext);
        }
    }

    public Strategy getStrategyCopy() {
        Strategy strategy = new Strategy();
        for (Context context : this) {
            Context newContext = new Context(context.getName(), context.getDescription(), context.isDefault());
            newContext.setUsed(context.isUsed());
            strategy.add(newContext);
        }
        return strategy;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    public long getTTL() {
        return this.ttl;
    }

    public String getTtlString() {
        if (this.ttl == 0L) {
            return "- - -";
        }
        return Long.toString(this.ttl / 24L) + " day" + (this.ttl > 24L ? "s" : "");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name + "     " + this.strategyToString());
        if (this.ttl > 0L) {
            sb.append("  (ttl=").append(this.getTtlString()).append(")");
        }
        return sb.toString();
    }

    public String strategyToString() {
        StringBuilder sb = new StringBuilder();
        for (Context context : this) {
            if (!context.isUsed()) continue;
            sb.append(context.getName()).append("|");
        }
        String str = sb.toString();
        if (str.endsWith("|")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public boolean isError() {
        return this.isError;
    }

    public List<String> getNameComponents() {
        if (this.nameComponents == null) {
            this.nameComponents = new AttributeNameComponents(this.name);
        }
        return this.nameComponents;
    }

    private class AttributeNameComponents
    extends ArrayList<String> {
        private AttributeNameComponents(String name) {
            int start = name.lastIndexOf(47);
            String attributeName = name.substring(start + 1);
            int end = start;
            start = name.lastIndexOf(47, end - 1);
            String member = name.substring(start + 1, end);
            end = start;
            start = name.lastIndexOf(47, end - 1);
            String family = name.substring(start + 1, end);
            end = start;
            start = name.lastIndexOf(47, end - 1);
            String domain = name.substring(start + 1, end);
            end = start;
            start = name.lastIndexOf(47, end - 1);
            String tangoHost = name.substring(start + 1, end);
            this.add(tangoHost);
            this.add(domain);
            this.add(family);
            this.add(member);
            this.add(attributeName);
        }

        @Override
        public String toString() {
            String str = "";
            for (String s : this) {
                str = str + " - " + s + "\n";
            }
            return str;
        }
    }
}

