/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

public class Context {
    private String name;
    private Boolean used = false;
    private String description = null;
    private boolean isDefault = false;

    public Context(String name, String description, boolean isDefault) {
        this(name, isDefault, description);
        this.isDefault = isDefault;
    }

    public Context(String name, boolean used, String description) {
        this.name = name;
        this.used = used;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean b) {
        this.isDefault = b;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(Boolean used) {
        this.used = used;
    }

    public void toggleUsed() {
        this.used = this.used == false;
    }

    public String getHtmlDescription() {
        int end;
        StringBuilder sb = new StringBuilder("<b><u>" + this.toString() + ":</u></b><br>\n");
        if (this.description == null) {
            return sb.toString() + "....";
        }
        int start = 0;
        String target = "\\n";
        while ((end = this.description.indexOf(target, start + 1)) > 0) {
            sb.append(this.description.substring(start, end)).append("<br>");
            start = end + target.length();
        }
        sb.append(this.description.substring(start));
        return sb.toString();
    }

    public boolean different(Context context) {
        return !context.getName().equals(this.name) || !context.getDescription().equals(this.description) || context.isUsed() != this.used.booleanValue() || context.isDefault() != this.isDefault;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }
}

