/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.common;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tango.hdb_configurator.common.HdbAttribute;
import org.tango.hdb_configurator.common.StringComparator;
import org.tango.hdb_configurator.common.TangoUtils;
import org.tango.hdb_configurator.common.Utils;

public class ArchiverUtils {
    public static String[] getSubscriberList() throws DevFailed {
        DeviceAttribute deviceAttribute = Utils.getConfiguratorProxy().read_attribute("ArchiverList");
        String[] archiverNames = deviceAttribute.extractStringArray();
        if (archiverNames.length == 1) {
            String archiverName = archiverNames[0];
            StringTokenizer stk = new StringTokenizer(archiverName, "/");
            if (archiverName.startsWith("tango://") ? stk.countTokens() < 5 : stk.countTokens() < 2) {
                return new String[0];
            }
        }
        return archiverNames;
    }

    public static String[] getAttributeList(DeviceProxy subscriberProxy, String attrType) throws DevFailed {
        DeviceAttribute deviceAttribute = subscriberProxy.read_attribute("Attribute" + attrType + "List");
        return StringComparator.sortArray(deviceAttribute.extractStringArray());
    }

    public static List<String[]> readStringAttributes(DeviceProxy subscriberProxy, String[] attributeNames) throws DevFailed {
        DeviceAttribute[] deviceAttributes = subscriberProxy.read_attribute(attributeNames);
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (DeviceAttribute deviceAttribute : deviceAttributes) {
            if (deviceAttribute.hasFailed()) {
                list.add(new String[0]);
                continue;
            }
            list.add(deviceAttribute.extractStringArray());
        }
        return list;
    }

    public static void lockDevice(DeviceProxy proxy) throws DevFailed {
        boolean ok = false;
        for (int oneTry = 0; !ok && oneTry < 2; ++oneTry) {
            try {
                proxy.lock();
                ok = true;
                continue;
            }
            catch (DevFailed e) {
                System.err.println(e.errors[0].desc);
                if (e.errors[0].reason.equals("API_DeviceLocked")) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw e;
            }
        }
        System.out.println(proxy.get_name() + " locked");
    }

    public static void addAttribute(DeviceProxy configureProxy, String subscriberName, HdbAttribute hdbAttribute, boolean lockIt) throws DevFailed {
        if (lockIt) {
            ArchiverUtils.lockDevice(configureProxy);
        }
        if (Utils.isTraceMode()) {
            System.out.println("Add attribute:");
            System.out.println("  - Archiver:\t" + subscriberName);
            System.out.println("  - Attribute:\t" + hdbAttribute.getName());
            System.out.println("  - Strategy:\t" + hdbAttribute.strategyToString());
            System.out.println("  - Push evt:\t" + hdbAttribute.isPushedByCode());
            System.out.println("  - TTL:     \t" + hdbAttribute.getTtlString());
        }
        try {
            DeviceAttribute[] deviceAttributeList = new DeviceAttribute[5];
            int i = 0;
            deviceAttributeList[i++] = new DeviceAttribute("SetAttributeName", hdbAttribute.getName());
            deviceAttributeList[i++] = new DeviceAttribute("SetArchiver", subscriberName);
            deviceAttributeList[i++] = new DeviceAttribute("SetStrategy", hdbAttribute.strategyToString());
            deviceAttributeList[i++] = new DeviceAttribute("SetCodePushedEvent", hdbAttribute.isPushedByCode());
            deviceAttributeList[i] = new DeviceAttribute("SetTTL");
            deviceAttributeList[i].insert_ul(hdbAttribute.getTTL());
            configureProxy.write_attribute(deviceAttributeList);
            configureProxy.command_inout("AttributeAdd");
        }
        catch (DevFailed e) {
            if (lockIt) {
                configureProxy.unlock();
                System.out.println(configureProxy.get_name() + " unlocked");
            }
            throw e;
        }
        if (lockIt) {
            configureProxy.unlock();
            System.out.println(configureProxy.get_name() + " unlocked");
        }
    }

    public static void moveAttribute(DeviceProxy managerProxy, HdbAttribute attribute, String subscriberName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{attribute.getName(), subscriberName, attribute.strategyToString(), Long.toString(attribute.getTTL())});
        System.out.println(subscriberName + ":\n" + attribute.getName() + " : " + attribute.strategyToString());
        managerProxy.command_inout("AttributeAssign", argIn);
    }

    public static void startAttribute(DeviceProxy subscriberProxy, String attributeName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(attributeName);
        subscriberProxy.command_inout("AttributeStart", argIn);
    }

    public static void stopAttribute(DeviceProxy subscriberProxy, String attributeName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(attributeName);
        subscriberProxy.command_inout("AttributeStop", argIn);
    }

    public static void pauseAttribute(DeviceProxy subscriberProxy, String attributeName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(attributeName);
        subscriberProxy.command_inout("AttributePause", argIn);
    }

    public static void removeAttribute(DeviceProxy managerProxy, String attributeName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(attributeName);
        managerProxy.command_inout("AttributeRemove", argIn);
    }

    public static String getArchiver(DeviceProxy configurator, String attributeName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(TangoUtils.fullName(attributeName));
        DeviceData argOut = configurator.command_inout("AttributeGetArchiver", argIn);
        return argOut.extractString();
    }

    public static String getAttributeStrategy(String attributeName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(attributeName);
        DeviceData argOut = Utils.getConfiguratorProxy().command_inout("GetAttributeStrategy", argIn);
        return argOut.extractString();
    }
}

