/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.atktable;

import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JWindow;
import org.tango.hdb_configurator.atktable.ScrolledScalarViewer;
import org.tango.hdb_configurator.atktable.TableConfig;

public class TableScalarViewer
extends JPanel {
    private ScrolledScalarViewer viewer = null;
    private JButton errorBtn;
    private JLabel titleLabel;

    public TableScalarViewer(List<String> rowNameList, String[] columnNames, List<String[]> attributeList, int[] columnWidths) {
        String[] rowNames = new String[rowNameList.size()];
        for (int i = 0; i < rowNameList.size(); ++i) {
            rowNames[i] = rowNameList.get(i);
        }
        String[][] attributeNames = new String[attributeList.size()][];
        for (int i = 0; i < attributeList.size(); ++i) {
            attributeNames[i] = new String[attributeList.get(i).length];
            for (int j = 0; j < attributeList.get(i).length; ++j) {
                attributeNames[i][j] = attributeList.get(i)[j];
            }
        }
        this.initComponents(rowNames, columnNames, attributeNames, columnWidths);
    }

    private void initComponents(String[] rowNames, String[] columnNames, String[][] attributeNames, int[] columnWidths) {
        TableConfig config = new TableConfig(rowNames, columnNames, attributeNames, columnWidths);
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(new TableConfig().title);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.errorBtn = new JButton("");
        this.errorBtn.setBorderPainted(false);
        this.errorBtn.setContentAreaFilled(false);
        this.errorBtn.setMargin(new Insets(0, 0, 0, 0));
        this.errorBtn.setVisible(false);
        this.errorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableScalarViewer.this.errorBtnActionPerformed();
            }
        });
        JPanel panel = new JPanel();
        panel.add(this.titleLabel);
        panel.add(new JLabel("      "));
        panel.add(this.errorBtn);
        this.add((Component)panel, "North");
        this.viewer = new ScrolledScalarViewer(this);
        this.add((Component)this.viewer, "Center");
        this.initScalarViewer(config);
        this.titleLabel.setText(config.title);
    }

    public void errorChanged(boolean on_error) {
        this.errorBtn.setVisible(on_error);
    }

    public void setPanelTitle(String title) {
        if (this.viewer != null) {
            this.viewer.getTableConfig().title = title;
            this.titleLabel.setText(title);
        }
    }

    public void setPanelTitleFont(Font font) {
        this.titleLabel.setFont(font);
    }

    public void setPanelTitleVisible(boolean b) {
        this.titleLabel.getParent().setVisible(b);
    }

    public void setDimension(Dimension dimension) {
        this.viewer.setDimension(dimension);
        TableScalarViewer.getMainContainer(this).pack();
    }

    public Dimension getDimension() {
        return this.viewer.getSize();
    }

    private void initScalarViewer(TableConfig config) {
        this.viewer.initializeViewer(config);
        this.titleLabel.setText(config.title);
    }

    private void errorBtnActionPerformed() {
        this.showErrorHistory();
    }

    static Window getMainContainer(Component c) {
        Container parent = c.getParent();
        while (!(parent instanceof JFrame || parent instanceof JDialog || parent instanceof JWindow)) {
            parent = parent.getParent();
        }
        return (Window)parent;
    }

    void atkDiagnostic() {
        ATKDiagnostic.showDiagnostic();
    }

    public void showErrorHistory() {
        this.viewer.showErrorHistory();
    }

    public void setColWidth(int title_width, int[] col_width) {
        this.viewer.getTableConfig().setColWidth(title_width, col_width);
        this.viewer.setColWidth(title_width, col_width);
    }

    public void setColWidth(int[] columnWidth) {
        int title_width = columnWidth[0];
        int[] col_width = new int[columnWidth.length - 1];
        System.arraycopy(columnWidth, 1, col_width, 0, columnWidth.length - 1);
        this.setColWidth(title_width, col_width);
    }

    public JTable getJTable() {
        return this.viewer.getJTable();
    }

    public void setTableFont(Font font) {
        this.viewer.setTableFont(font);
    }
}

