/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.atktable;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.common.Utils;

class TableConfig {
    String title = "ATK Table Panel";
    String[] columnNames = new String[0];
    String[] rowNames = new String[0];
    int period = 1000;
    int height = -1;
    int width = -1;
    private int[] columnWidth;
    private int rowTitleWidth = 200;
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public TableConfig() {
    }

    public TableConfig(String[] rowNames, String[] columnNames, String[][] attributeNames, int[] columnWidth) {
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        this.columnWidth = columnWidth;
        for (int row = 0; row < rowNames.length; ++row) {
            for (int col = 0; col < columnNames.length; ++col) {
                this.add(attributeNames[row][col], row, col);
            }
        }
    }

    void checkSize(JTable table) {
        if (this.columnWidth != null) {
            TableColumn tableColumn;
            Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
            this.width = 0;
            this.rowTitleWidth = Utils.getLongestLine(this.rowNames).length() * 7 + 30;
            if (columns.hasMoreElements()) {
                tableColumn = columns.nextElement();
                tableColumn.setPreferredWidth(this.rowTitleWidth);
                this.width += this.rowTitleWidth;
            }
            for (int i = 0; columns.hasMoreElements() && i < this.columnWidth.length; ++i) {
                tableColumn = columns.nextElement();
                if (this.columnWidth[i] == 0) {
                    this.columnWidth[i] = 80;
                }
                tableColumn.setPreferredWidth(this.columnWidth[i]);
                this.width += this.columnWidth[i];
            }
        } else if (this.width < 0) {
            this.width = (this.nbColumns() + 1) * 180;
        }
        int h = table.getRowHeight();
        if (this.height < 0) {
            this.height = this.nbRows() * h + 10;
        }
    }

    void setColWidth(int title_width, int[] col_width) {
        this.rowTitleWidth = title_width;
        this.columnWidth = col_width;
    }

    int nbRows() {
        return this.rowNames.length;
    }

    int nbColumns() {
        return this.columnNames.length;
    }

    public Attribute attributeAt(int idx) {
        return this.attributes.get(idx);
    }

    private Attribute getAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute att = this.attributeAt(i);
            if (att.name == null || !att.name.equals(name)) continue;
            return att;
        }
        return null;
    }

    public boolean add(String name, int row, int col) {
        return this.attributes.add(new Attribute(name, row, col));
    }

    public void setError(String attname, boolean b) {
        Attribute att;
        if (attname != null && (att = this.getAttribute(attname)) != null) {
            att.on_error = b;
        }
    }

    public boolean onError() {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute att = this.attributeAt(i);
            if (att.name == null || !att.on_error) continue;
            return true;
        }
        return false;
    }

    public void resetConnection() {
        for (int i = 0; i < this.attributes.size(); ++i) {
            this.attributeAt(i).connected = false;
        }
    }

    public int size() {
        return this.attributes.size();
    }

    public void remove(Attribute attribute) {
        this.attributes.remove(attribute);
    }

    class Attribute {
        private String name;
        private int row;
        private int col;
        private boolean connected = false;
        private boolean on_error = true;

        private Attribute(String name, int row, int col) {
            this.name = name;
            this.row = row;
            this.col = col;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public void setConnected(boolean connected) {
            this.connected = connected;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

