/*
 * Decompiled with CFR 0.152.
 */
package org.tango.hdb_configurator.atktable;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.attribute.MultiScalarTableViewer;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.tango.hdb_configurator.atktable.TableConfig;
import org.tango.hdb_configurator.atktable.TableScalarViewer;

class ScrolledScalarViewer
extends JScrollPane
implements IErrorListener,
INumberScalarListener,
IStringScalarListener,
IBooleanScalarListener,
IEnumScalarListener {
    private TableScalarViewer parent;
    private TableConfig config;
    private AttributeList attlist;
    private MultiScalarTableViewer table;
    private ErrorHistory err_history;
    private boolean on_error = false;
    private ScrolledScalarViewer thisViewer;

    ScrolledScalarViewer(TableScalarViewer parent) {
        this.parent = parent;
        this.thisViewer = this;
        this.config = new TableConfig();
        this.err_history = new ErrorHistory();
        this.table = new MultiScalarTableViewer();
        this.table.setFont(new Font("Dialog", 1, 12));
        this.table.setUnitVisible(false);
        this.table.setEnabled(false);
        this.attlist = new AttributeList();
        this.attlist.addErrorListener((IErrorListener)this.err_history);
        this.attlist.addErrorListener((IErrorListener)this);
    }

    JTable getJTable() {
        return this.table;
    }

    void setDimension(Dimension dimension) {
        this.table.setPreferredScrollableViewportSize(dimension);
    }

    TableConfig getTableConfig() {
        return this.config;
    }

    void showErrorHistory() {
        this.err_history.setVisible(true);
    }

    void setTableFont(Font font) {
        this.table.setFont(font);
    }

    void resetTable() {
        this.table.clearModel();
        this.config.resetConnection();
        this.attlist.removeAllElements();
        this.attlist.stopRefresher();
    }

    void initializeViewer(TableConfig config) {
        this.resetTable();
        this.config = config;
        this.table.setNbColumns(config.columnNames.length);
        this.table.setNbRows(config.rowNames.length);
        this.table.setColumnIdents(config.columnNames);
        this.table.setRowIdents(config.rowNames);
        if (config.period > 1000) {
            this.attlist.setRefreshInterval(config.period);
        } else {
            this.attlist.setRefreshInterval(1000);
        }
        this.attlist.startRefresher();
        config.checkSize((JTable)this.table);
        Dimension dimension = new Dimension(config.width, config.height);
        this.table.setPreferredScrollableViewportSize(dimension);
        this.setViewportView((Component)this.table);
        new AddAttr().start();
    }

    void setColWidth(int title_width, int[] col_width) {
        TableColumn tc;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        if (enumeration.hasMoreElements()) {
            tc = enumeration.nextElement();
            tc.setPreferredWidth(title_width);
        }
        for (int i = 0; enumeration.hasMoreElements() && i < col_width.length; ++i) {
            tc = enumeration.nextElement();
            if (col_width[i] == 0) {
                col_width[i] = 80;
            }
            tc.setPreferredWidth(col_width[i]);
        }
    }

    public void errorChange(ErrorEvent evt) {
        this.config.setError(evt.getSource().toString(), true);
        if (!this.on_error) {
            this.on_error = true;
            this.parent.errorChanged(this.on_error);
            new EndErrorCheck().start();
        }
    }

    public void stringScalarChange(StringScalarEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    public void booleanScalarChange(BooleanScalarEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    public void enumScalarChange(EnumScalarEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    public void stateChange(AttributeStateEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    class AddAttr
    extends Thread {
        AddAttr() {
        }

        private boolean connectAttribute(TableConfig.Attribute attribute) {
            if (attribute.getName() == null) {
                attribute.setConnected(true);
                return false;
            }
            try {
                IAttribute iAttribute = (IAttribute)ScrolledScalarViewer.this.attlist.add(attribute.getName());
                if (iAttribute instanceof INumberScalar) {
                    ((INumberScalar)iAttribute).addNumberScalarListener((INumberScalarListener)ScrolledScalarViewer.this.thisViewer);
                } else if (iAttribute instanceof IStringScalar) {
                    ((IStringScalar)iAttribute).addStringScalarListener((IStringScalarListener)ScrolledScalarViewer.this.thisViewer);
                } else if (iAttribute instanceof IEnumScalar) {
                    ((IEnumScalar)iAttribute).addEnumScalarListener((IEnumScalarListener)ScrolledScalarViewer.this.thisViewer);
                } else if (iAttribute instanceof IBooleanScalar) {
                    ((IBooleanScalar)iAttribute).addBooleanScalarListener((IBooleanScalarListener)ScrolledScalarViewer.this.thisViewer);
                } else {
                    System.out.println(attribute.getName() + "  Not Supported Type !!");
                }
                ScrolledScalarViewer.this.table.setModelAt(iAttribute, attribute.getRow(), attribute.getCol());
                attribute.setConnected(true);
                return true;
            }
            catch (Exception e) {
                attribute.setConnected(false);
                return false;
            }
        }

        @Override
        public void run() {
            int nbConnected = 0;
            while (nbConnected < ScrolledScalarViewer.this.config.size()) {
                nbConnected = 0;
                for (int i = 0; i < ScrolledScalarViewer.this.config.size(); ++i) {
                    TableConfig.Attribute attribute = ScrolledScalarViewer.this.config.attributeAt(i);
                    if (!attribute.isConnected()) {
                        this.connectAttribute(attribute);
                    }
                    if (!attribute.isConnected()) continue;
                    ++nbConnected;
                }
                try {
                    AddAttr.sleep(2000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    class EndErrorCheck
    extends Thread {
        @Override
        public void run() {
            boolean end = false;
            while (!end) {
                if (!ScrolledScalarViewer.this.config.onError()) {
                    ScrolledScalarViewer.this.on_error = false;
                    ScrolledScalarViewer.this.parent.errorChanged(ScrolledScalarViewer.this.on_error);
                    end = true;
                    continue;
                }
                try {
                    EndErrorCheck.sleep(2000L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

