@ECHO OFF


set CLASS_NAME=Serial


REM -------------------------------------------------------------
REM be sure TANGO_ROOT is defined
REM -------------------------------------------------------------

IF NOT DEFINED TANGO_ROOT (
 ECHO TANGO_ROOT is not defined. Aborting!
 ECHO Please define a TANGO_ROOT env. var. pointing to your TANGO installation directory.
 PAUSE
 GOTO SCRIPT_END
)

ECHO Going to install class %CLASS_NAME% under:
ECHO %TANGO_ROOT%
PAUSE


ECHO  #############################################################
ECHO Install the include files:

mkdir "%TANGO_ROOT%\classes\win32_vc8\win32_dll\include
copy SerialLine\src\%CLASS_NAME%.h "%TANGO_ROOT%\classes\win32_vc8\win32_dll\include\."
copy SerialLine\src\%CLASS_NAME%Class.h "%TANGO_ROOT%\classes\win32_vc8\win32_dll\include\."


ECHO  ############################################################## 
ECHO Install the dynamic libraries:

mkdir "%TANGO_ROOT%\classes\win32_vc8\win32_dll\lib

copy classes\win32_vc8\win32_dll\lib\%CLASS_NAME%.lib  "%TANGO_ROOT%\classes\win32_vc8\win32_dll\lib\."
copy classes\win32_vc8\win32_dll\lib\%CLASS_NAME%.dll  "%TANGO_ROOT%\classes\win32_vc8\win32_dll\lib\."
copy classes\win32_vc8\win32_dll\lib\%CLASS_NAME%d.lib "%TANGO_ROOT%\classes\win32_vc8\win32_dll\lib\."
copy classes\win32_vc8\win32_dll\lib\%CLASS_NAME%d.dll "%TANGO_ROOT%\classes\win32_vc8\win32_dll\lib\."
copy classes\win32_vc8\win32_dll\lib\%CLASS_NAME%d.pdb "%TANGO_ROOT%\classes\win32_vc8\win32_dll\lib\."


ECHO  #############################################################
ECHO Install the dynamic executables:

mkdir "%TANGO_ROOT%\classes\win32_vc8\win32_dll\bin
copy classes\win32_vc8\win32_dll\bin\%CLASS_NAME%.exe "%TANGO_ROOT%\classes\win32_vc8\win32_dll\bin\."

mkdir "%TANGO_ROOT%\classes\win32_vc8\win32_dll\bin\debug
copy classes\win32_vc8\win32_dll\bin\debug\%CLASS_NAME%.exe "%TANGO_ROOT%\classes\win32_vc8\win32_dll\bin\debug."
copy classes\win32_vc8\win32_dll\bin\debug\%CLASS_NAME%.pdb "%TANGO_ROOT%\classes\win32_vc8\win32_dll\bin\debug."


ECHO  #############################################################
ECHO Install the documentation:

mkdir "%TANGO_ROOT%\classes\win32_vc8\win32_dll\doc
copy doc\TangoClassesDocumentation.html "%TANGO_ROOT%\classes\win32_vc8\win32_dll\doc\."

:SCRIPT_END
