static const char *RcsId = "$Header: /cvsroot/tango-ds/Communication/SerialLine/src/main.cpp,v 1.4 2004/11/02 11:40:23 xavela Exp $";

//+=============================================================================

//

// file :        main.cpp

//

// description : C++ source for a TANGO device server main.

//               The main rule is to initialise (and create) the Tango

//               system and to create the DServerClass singleton.

//               The main should be the same for every Tango device server.

//

// project :     TANGO Device Server

//

// $Author: xavela $

//

// $Revision: 1.4 $ $

//

// $Log: main.cpp,v $
// Revision 1.4  2004/11/02 11:40:23  xavela
// xavier :
// in Serial.cpp :
// add a delete to avoid memory leaks in Serial::Dev_Ser_Read_Char method.
// add, in Serial::Dev_Ser_Flush, | PURGE_RXABORT and | PURGE_TXABORT for the Win32 part.
//
// Revision 1.3  2004/10/22 14:17:01  xavela
// xavier : only in win32 part, possibility to open a port COM higher than 9.
// changed TANGO_ROOT_WIN32 by SOLEIL_ROOT in the makefile.vc.
//
// Revision 1.2  2004/06/30 09:22:48  xavela
// xavier : ajout de la methode dev_ser_read_nretry()
// pour la partie win32
//
// Revision 1.1.1.1  2004/04/07 14:30:53  syldup
// initial import
//

// Revision 1.3  2003/02/05 09:27:33  perez

// Makefile ported to omniORB

//

// Revision 1.2  2002/04/16 10:42:17  perez

// Port Makefile to libtango 2.0 and SuSE7.2

//

// Revision 1.1  2001/12/07 08:48:10  perez

// Fix cout bug + fix no update serialdevice.newline bug

//

// Revision 1.0  2001/11/26 14:38:12  perez

// Initial Revision (ported to TANGO2)

//

//

// copyleft :    European Synchrotron Radiation Facility

//               BP 220, Grenoble 38043

//               FRANCE

//

//-=============================================================================

//

//  		This file is generated by POGO

//	(Program Obviously used to Generate tango Object)

//

//         (c) - Software Engineering Group - ESRF

//=============================================================================



#include <tango.h>





int main(int argc,char *argv[])

{



	Tango::Util *tg;

	try

	{

		// Initialise the device server

		//----------------------------------------

		tg = Tango::Util::init(argc,argv);



		// Create the device server singleton 

		//	which will create everything

		//----------------------------------------

		tg->server_init(false);



		// Run the endless loop

		//----------------------------------------

		cout << "Ready to accept request" << endl;

		tg->server_run();

	}

	catch (bad_alloc)

	{

		cout << "Can't allocate memory to store device object !!!" << endl;

		cout << "Exiting" << endl;

	}

	catch (CORBA::Exception &e)

	{

		Tango::Except::print_exception(e);

		

		cout << "Received a CORBA_Exception" << endl;

		cout << "Exiting" << endl;

	}

	return(0);

}

