//+*********************************************************************
//
// File:        ModbusCoreSL.cpp
//
// Project:     Device Servers in C++
//
// Description: public include file containing definitions and declarations
//		of serial line access function.
//
// Author(s);   Andy Gotz
//
// Original:    August 2001
//
// $Log: ModbusCoreSL.h,v $
// Revision 1.2  2005/03/31 15:07:05  jlpons
// Changed namespace name
//
// Revision 1.1  2005/01/14 15:36:55  jlpons
// Initial import
//
// Revision 2.0  2004/12/02 14:24:06  perez
// Split Modbus.cpp
//
//
//
//
//
// Copyright (c) 2001 by European Synchrotron Radiation Facility,
//                       Grenoble, France
//
//
//
//-*********************************************************************

#ifndef _ModbusCoreSL_H
#define _ModbusCoreSL_H

#ifdef TACOSL
#include <DevServer.h>
#else
#include <tango.h>
#endif
#include <Serial.h>

//+=====================================================================
// Global definitions
//-=====================================================================
#ifndef OK
#define OK              0
#define NOTOK           (-1)
#endif


//+=====================================================================
// Class definition
//-=====================================================================

class ModbusCoreSL {


//
// public members
//
public:

   ModbusCoreSL (
        char  *serialline_name,
        long  *error);
   ~ModbusCoreSL ();
   
   long write(
	unsigned char *frameout, 
	long int ncharout, 
	long *error);
   long read (
	unsigned char *framein,  
	long int ncharexp, 
	long int *ncharin,  
	long *error);

//
// private members
//
private:
#ifdef TACOSL
   Serial               *serialline_device;     /* file descriptor */
   devserver            serialline_ds;          /* device server */
#else
   Tango::DeviceProxy   *serialline_device;     /* Tango device handle */
#endif

//
// protected members
//
protected:
};

#endif /* _ModbusCoreSL_H */
