static const char *TagName   = "$Name: Modbus-Release_2_0 $";
static const char *HttpServer= "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/";
static const char *RcsId = "$Header: /cvsroot/tango-ds/Communication/Modbus/ModbusClass.cpp,v 1.4 2006/12/01 15:04:31 jensmeyer Exp $";
//+=============================================================================
//
// file :        ModbusClass.cpp
//
// description : C++ source for the ModbusClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the Modbus once per process.
//
// project :     TANGO Device Server
//
// $Author: jensmeyer $
//
// $Revision: 1.4 $
//
// $Log: ModbusClass.cpp,v $
// Revision 1.4  2006/12/01 15:04:31  jensmeyer
// Added the command ReadMultipleCoilsStatus to read several coils (bits)
// at the same time.
//
// Revision 1.3  2005/03/31 15:07:05  jlpons
// Changed namespace name
//
// Revision 1.2  2005/03/01 17:53:35  jlpons
// Few updates.
//
// Revision 1.1  2005/01/14 15:36:55  jlpons
// Initial import
//
//
// copyleft :   European Synchrotron Radiation Facility
//              BP 220, Grenoble 38043
//              FRANCE
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================


#include <tango.h>

#include <Modbus.h>
#include <ModbusClass.h>


namespace Modbus_ns
{
//+----------------------------------------------------------------------------
//
// method : 		ReadMultipleCoilsStatusCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ReadMultipleCoilsStatusCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ReadMultipleCoilsStatusCmd::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<Modbus *>(device))->read_multiple_coils_status(argin));
}



//+----------------------------------------------------------------------------
//
// method : 		ForceSingleCoilClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ForceSingleCoilClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ForceSingleCoilClass::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	((static_cast<Modbus *>(device))->force_single_coil(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		ReadCoilStatusClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ReadCoilStatusClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ReadCoilStatusClass::execute(): arrived" << endl;

	Tango::DevShort	argin;
	extract(in_any, argin);

	return insert((static_cast<Modbus *>(device))->read_coil_status(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		ReadInputStatusClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ReadInputStatusClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ReadInputStatusClass::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<Modbus *>(device))->read_input_status(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		ReadHoldingRegistersClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ReadHoldingRegistersClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ReadHoldingRegistersClass::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<Modbus *>(device))->read_holding_registers(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		ReadInputRegistersClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ReadInputRegistersClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ReadInputRegistersClass::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<Modbus *>(device))->read_input_registers(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		PresetSingleRegisterClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *PresetSingleRegisterClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "PresetSingleRegisterClass::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	((static_cast<Modbus *>(device))->preset_single_register(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		ReadExceptionStatusClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ReadExceptionStatusClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ReadExceptionStatusClass::execute(): arrived" << endl;

	return insert((static_cast<Modbus *>(device))->read_exception_status());
}

//+----------------------------------------------------------------------------
//
// method : 		FetchCommEventCtrClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *FetchCommEventCtrClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "FetchCommEventCtrClass::execute(): arrived" << endl;

	return insert((static_cast<Modbus *>(device))->fetch_comm_event_ctr());
}

//+----------------------------------------------------------------------------
//
// method : 		ForceMultipleCoilsClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ForceMultipleCoilsClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ForceMultipleCoilsClass::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	((static_cast<Modbus *>(device))->force_multiple_coils(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		PresetMultipleRegistersClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *PresetMultipleRegistersClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "PresetMultipleRegistersClass::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	((static_cast<Modbus *>(device))->preset_multiple_registers(argin));
	return new CORBA::Any();
}




//+----------------------------------------------------------------------------
//
// method : 		MaskWriteRegisterClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *MaskWriteRegisterClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "MaskWriteRegisterClass::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	((static_cast<Modbus *>(device))->mask_write_register(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		ReadWriteRegisterClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ReadWriteRegisterClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ReadWriteRegisterClass::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<Modbus *>(device))->read_write_register(argin));
}

//
//----------------------------------------------------------------
//	Initialize pointer for singleton pattern
//----------------------------------------------------------------
//
ModbusClass *ModbusClass::_instance = NULL;

//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::ModbusClass(string &s)
// 
// description : 	constructor for the ModbusClass
//
// in : - s : The class name
//
//-----------------------------------------------------------------------------
ModbusClass::ModbusClass(string &s):DeviceClass(s)
{

	cout2 << "Entering ModbusClass constructor" << endl;
	set_default_property();
	get_class_property();
	write_class_property();
	
	cout2 << "Leaving ModbusClass constructor" << endl;

}
//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::~ModbusClass()
// 
// description : 	destructor for the ModbusClass
//
//-----------------------------------------------------------------------------
ModbusClass::~ModbusClass()
{
	_instance = NULL;
}

//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::instance
// 
// description : 	Create the object if not already done. Otherwise, just
//			return a pointer to the object
//
// in : - name : The class name
//
//-----------------------------------------------------------------------------
ModbusClass *ModbusClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			string s(name);
			_instance = new ModbusClass(s);
		}
		catch (bad_alloc)
		{
			throw;
		}		
	}		
	return _instance;
}

ModbusClass *ModbusClass::instance()
{
	if (_instance == NULL)
	{
		cerr << "Class is not initialised !!" << endl;
		exit(-1);
	}
	return _instance;
}

//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::command_factory
// 
// description : 	Create the command object(s) and store them in the 
//			command list
//
//-----------------------------------------------------------------------------
void ModbusClass::command_factory()
{
	command_list.push_back(new ForceSingleCoilClass("ForceSingleCoil",
		Tango::DEVVAR_SHORTARRAY, Tango::DEV_VOID,
		"coil address, 0/1",
		"",
		Tango::OPERATOR));
	command_list.push_back(new ReadCoilStatusClass("ReadCoilStatus",
		Tango::DEV_SHORT, Tango::DEV_SHORT,
		"coil address",
		"Coil status",
		Tango::OPERATOR));
	command_list.push_back(new ReadInputStatusClass("ReadInputStatus",
		Tango::DEVVAR_SHORTARRAY, Tango::DEVVAR_CHARARRAY,
		"input address, no. of inputs",
		"Input status.",
		Tango::OPERATOR));
	command_list.push_back(new ReadHoldingRegistersClass("ReadHoldingRegisters",
		Tango::DEVVAR_SHORTARRAY, Tango::DEVVAR_SHORTARRAY,
		"register address, no. of registers",
		"Holding 16bits register.",
		Tango::OPERATOR));
	command_list.push_back(new ReadInputRegistersClass("ReadInputRegisters",
		Tango::DEVVAR_SHORTARRAY, Tango::DEVVAR_SHORTARRAY,
		"register address, no. of registers",
		"Input 16bits registers",
		Tango::OPERATOR));
	command_list.push_back(new PresetSingleRegisterClass("PresetSingleRegister",
		Tango::DEVVAR_SHORTARRAY, Tango::DEV_VOID,
		"Register address, register value.",
		"",
		Tango::OPERATOR));
	command_list.push_back(new ReadExceptionStatusClass("ReadExceptionStatus",
		Tango::DEV_VOID, Tango::DEV_SHORT,
		"",
		"exception status",
		Tango::OPERATOR));
	command_list.push_back(new FetchCommEventCtrClass("FetchCommEventCtr",
		Tango::DEV_VOID, Tango::DEVVAR_SHORTARRAY,
		"",
		"status, event count",
		Tango::OPERATOR));
	command_list.push_back(new ForceMultipleCoilsClass("ForceMultipleCoils",
		Tango::DEVVAR_SHORTARRAY, Tango::DEV_VOID,
		"coil address, nb of coils, coil states",
		"",
		Tango::OPERATOR));
	command_list.push_back(new ReadMultipleCoilsStatusCmd("ReadMultipleCoilsStatus",
		Tango::DEVVAR_SHORTARRAY, Tango::DEVVAR_SHORTARRAY,
		"coil address, nb of coils",
		"Status of coils",
		Tango::OPERATOR));
	command_list.push_back(new PresetMultipleRegistersClass("PresetMultipleRegisters",
		Tango::DEVVAR_SHORTARRAY, Tango::DEV_VOID,
		"register address, nb of registers, register data",
		"",
		Tango::OPERATOR));
	command_list.push_back(new MaskWriteRegisterClass("MaskWriteRegister",
		Tango::DEVVAR_SHORTARRAY, Tango::DEV_VOID,
		"register address, AND mask, OR mask",
		"",
		Tango::OPERATOR));
	command_list.push_back(new ReadWriteRegisterClass("ReadWriteRegister",
		Tango::DEVVAR_SHORTARRAY, Tango::DEVVAR_SHORTARRAY,
		"read address, no. to read, write address, nb.of write, write data",
		"read registers",
		Tango::OPERATOR));

	//	add polling if any
	for (unsigned int i=0 ; i<command_list.size(); i++)
	{
	}
}

//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::get_class_property
// 
// description : 	Get the class property for specified name.
//
// in :		string	name : The property name
//
//+----------------------------------------------------------------------------
Tango::DbDatum ModbusClass::get_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == prop_name)
			return cl_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}
//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::get_default_device_property()
// 
// description : 	Return the default value for device property.
//
//-----------------------------------------------------------------------------
Tango::DbDatum ModbusClass::get_default_device_property(string &prop_name)
{
	for (unsigned int i=0 ; i<dev_def_prop.size() ; i++)
		if (dev_def_prop[i].name == prop_name)
			return dev_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::get_default_class_property()
// 
// description : 	Return the default value for class property.
//
//-----------------------------------------------------------------------------
Tango::DbDatum ModbusClass::get_default_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_def_prop.size() ; i++)
		if (cl_def_prop[i].name == prop_name)
			return cl_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}
//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::device_factory
// 
// description : 	Create the device object(s) and store them in the 
//			device list
//
// in :		Tango::DevVarStringArray *devlist_ptr : The device name list
//
//-----------------------------------------------------------------------------
void ModbusClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{

	//	Create all devices.(Automatic code generation)
	//-------------------------------------------------------------
	for (unsigned long i=0 ; i < devlist_ptr->length() ; i++)
	{
		cout4 << "Device name : " << (*devlist_ptr)[i].in() << endl;
						
		// Create devices and add it into the device list
		//----------------------------------------------------
		device_list.push_back(new Modbus(this, (*devlist_ptr)[i]));							 

		// Export device to the outside world
		// Check before if database used.
		//---------------------------------------------
		if ((Tango::Util::_UseDb == true) && (Tango::Util::_FileDb == false))
			export_device(device_list.back());
		else
			export_device(device_list.back(), (*devlist_ptr)[i]);
	}
	//	End of Automatic code generation
	//-------------------------------------------------------------

}






//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::get_class_property()
// 
// description : 	Read the class properties from database.
//
//-----------------------------------------------------------------------------
void ModbusClass::get_class_property()
{
	//	Initialize your default values here (if not done with  POGO).
	//------------------------------------------------------------------

	//	Read class properties from database.(Automatic code generation)
	//------------------------------------------------------------------

	//	Call database and extract values
	//--------------------------------------------
	if (Tango::Util::instance()->_UseDb==true)
		get_db_class()->get_property(cl_prop);
	Tango::DbDatum	def_prop;
	int	i = -1;


	//	End of Automatic code generation
	//------------------------------------------------------------------

}

//+----------------------------------------------------------------------------
//
// method : 	ModbusClass::set_default_property
// 
// description: Set default property (class and device) for wizard.
//              For each property, add to wizard property name and description
//              If default value has been set, add it to wizard property and
//              store it in a DbDatum.
//
//-----------------------------------------------------------------------------
void ModbusClass::set_default_property()
{
	string	prop_name;
	string	prop_desc;
	string	prop_def;

	vector<string>	vect_data;
	//	Set Default Class Properties
	//	Set Default Device Properties
	prop_name = "Protocol";
	prop_desc = "RTU'' : Binary serial communication.\n''TCP'' : Communication over ethernet.";
	prop_def  = "RTU";
	vect_data.clear();
	vect_data.push_back("RTU");
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);

	prop_name = "Iphost";
	prop_desc = "The host IP address  used with the TCP protocol in the form\naa.bb.cc.dd.";
	prop_def  = "";
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);

	prop_name = "Serialline";
	prop_desc = "The name of the serial line device used with RTU protocol.\nThis can be any device name of a Serial Class object in the Tango\nsystem.\n";
	prop_def  = "";
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);

	prop_name = "Address";
	prop_desc = "Node index used with the RTU protocol \nwhen several controllers are chained on one serial line";
	prop_def  = "1";
	vect_data.clear();
	vect_data.push_back("1");
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);

}
//+----------------------------------------------------------------------------
//
// method : 		ModbusClass::write_class_property
// 
// description : 	Set class description as property in database
//
//-----------------------------------------------------------------------------
void ModbusClass::write_class_property()
{
	//	First time, check if database used
	//--------------------------------------------
	if (Tango::Util::_UseDb == false)
		return;

	Tango::DbData	data;
	string	classname = get_name();
	string	header;
	string::size_type	start, end;

	//	Put title
	Tango::DbDatum	title("ProjectTitle");
	string	str_title("Modbus");
	title << str_title;
	data.push_back(title);

	//	Put Description
	Tango::DbDatum	description("Description");
	vector<string>	str_desc;
	str_desc.push_back("A Class to handle the modbus protocol over TCP/IP or Serial (RTU).");
	description << str_desc;
	data.push_back(description);
		
	//	put cvs location
	string	rcsId(RcsId);
	string	filename(classname);
	start = rcsId.find("/");
	if (start!=string::npos)
	{
		filename += "Class.cpp";
		end   = rcsId.find(filename);
		if (end>start)
		{
			string	strloc = rcsId.substr(start, end-start);
			//	Check if specific repository
			start = strloc.find("/cvsroot/");
			if (start!=string::npos && start>0)
			{
				string	repository = strloc.substr(0, start);
				if (repository.find("/segfs/")!=string::npos)
					strloc = "ESRF:" + strloc.substr(start, strloc.length()-start);
			}
			Tango::DbDatum	cvs_loc("cvs_location");
			cvs_loc << strloc;
			data.push_back(cvs_loc);
		}
	}

	//	Get CVS tag revision
	string	tagname(TagName);
	header = "$Name: ";
	start = header.length();
	string	endstr(" $");
	end   = tagname.find(endstr);
	if (end!=string::npos && end>start)
	{
		string	strtag = tagname.substr(start, end-start);
		Tango::DbDatum	cvs_tag("cvs_tag");
		cvs_tag << strtag;
		data.push_back(cvs_tag);
	}

	//	Get URL location
	string	httpServ(HttpServer);
	if (httpServ.length()>0)
	{
		Tango::DbDatum	db_doc_url("doc_url");
		db_doc_url << httpServ;
		data.push_back(db_doc_url);
	}

	//  Put inheritance
	Tango::DbDatum	inher_datum("InheritedFrom");
	vector<string> inheritance;
	inheritance.push_back("Device_3Impl");
	inher_datum << inheritance;
	data.push_back(inher_datum);

	//	Call database and and values
	//--------------------------------------------
	get_db_class()->put_property(data);
}

}	// namespace
