//=============================================================================
//
// file :        Modbus.h
//
// description : Include for the Modbus class.
//
// project :	Modbus
//
// $Author: jensmeyer $
//
// $Revision: 1.4 $
//
// $Log: Modbus.h,v $
// Revision 1.4  2006/12/01 15:04:31  jensmeyer
// Added the command ReadMultipleCoilsStatus to read several coils (bits)
// at the same time.
//
// Revision 1.3  2005/03/31 15:07:05  jlpons
// Changed namespace name
//
// Revision 1.2  2005/03/01 17:53:35  jlpons
// Few updates.
//
// Revision 1.1  2005/01/14 15:36:55  jlpons
// Initial import
//
//
// copyleft :    European Synchrotron Radiation Facility
//               BP 220, Grenoble 38043
//               FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================
#ifndef _MODBUS_H
#define _MODBUS_H

#include <tango.h>
#include <ModbusCore.h>
//using namespace Tango;

/**
 * @author	$Author: jensmeyer $
 * @version	$Revision: 1.4 $
 */

 //	Add your own constants definitions here.
 //-----------------------------------------------


namespace Modbus_ns
{

/**
 * Class Description:
 * A Class to handle the modbus protocol over TCP/IP or Serial (RTU).
 */

/*
 *	Device States Description:
 */


class Modbus: public Tango::Device_3Impl
{
public :
	//	Add your own data members here
	//-----------------------------------------


	//	Here is the Start of the automatic code generation part
	//-------------------------------------------------------------	
/**
 *	@name attributes
 *	Attributs member data.
 */
//@{
//@}

/**
 *	@name Device properties
 *	Device properties member data.
 */
//@{
/**
 *	RTU'' : Binary serial communication.
 *	''TCP'' : Communication over ethernet.
 */
	string	protocol;
/**
 *	The host IP address  used with the TCP protocol in the form
 *	aa.bb.cc.dd.
 */
	string	iphost;
/**
 *	The name of the serial line device used with RTU protocol.
 *	This can be any device name of a Serial Class object in the Tango
 *	system.
 *	
 */
	string	serialline;
/**
 *	Node index used with the RTU protocol 
 *	when several controllers are chained on one serial line
 */
	Tango::DevShort	address;
//@}

/**@name Constructors
 * Miscellaneous constructors */
//@{
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	Modbus(Tango::DeviceClass *cl,string &s);
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	Modbus(Tango::DeviceClass *cl,const char *s);
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device name
 *	@param d	Device description.
 */
	Modbus(Tango::DeviceClass *cl,const char *s,const char *d);
//@}

/**@name Destructor
 * Only one desctructor is defined for this class */
//@{
/**
 * The object desctructor.
 */	
	~Modbus() {delete_device();};
/**
 *	will be called at device destruction or at init command.
 */
	void delete_device();
//@}

	
/**@name Miscellaneous methods */
//@{
/**
 *	Initialize the device
 */
	virtual void init_device();
/**
 *	Always executed method befor execution command method.
 */
	virtual void always_executed_hook();

//@}

/**
 * @name Modbus methods prototypes
 */

//@{
/**
 *	Execution allowed for ForceSingleCoil command.
 */
	virtual bool is_ForceSingleCoil_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for ReadCoilStatus command.
 */
	virtual bool is_ReadCoilStatus_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for ReadInputStatus command.
 */
	virtual bool is_ReadInputStatus_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for ReadHoldingRegisters command.
 */
	virtual bool is_ReadHoldingRegisters_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for ReadInputRegisters command.
 */
	virtual bool is_ReadInputRegisters_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for PresetSingleRegister command.
 */
	virtual bool is_PresetSingleRegister_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for ReadExceptionStatus command.
 */
	virtual bool is_ReadExceptionStatus_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for FetchCommEventCtr command.
 */
	virtual bool is_FetchCommEventCtr_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for ForceMultipleCoils command.
 */
	virtual bool is_ForceMultipleCoils_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for ReadMultipleCoilsStatus command.
 */
	virtual bool is_ReadMultipleCoilsStatus_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for PresetMultipleRegisters command.
 */
	virtual bool is_PresetMultipleRegisters_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for MaskWriteRegister command.
 */
	virtual bool is_MaskWriteRegister_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for ReadWriteRegister command.
 */
	virtual bool is_ReadWriteRegister_allowed(const CORBA::Any &any);
/**
 * Write single coil (digital I/O) state.
 *	@param	argin	coil address, 0/1
 *	@exception DevFailed
 */
	void	force_single_coil(const Tango::DevVarShortArray *);
/**
 * Read coil (digital I/O) status.
 *	@param	argin	coil address
 *	@return	Coil status
 *	@exception DevFailed
 */
	Tango::DevShort	read_coil_status(Tango::DevShort);
/**
 * Read discrete input status. Return one boolean per array element.
 *	@param	argin	input address, no. of inputs
 *	@return	Input status.
 *	@exception DevFailed
 */
	Tango::DevVarCharArray	*read_input_status(const Tango::DevVarShortArray *);
/**
 * Read multiple 16bits registers.
 *	@param	argin	register address, no. of registers
 *	@return	Holding 16bits register.
 *	@exception DevFailed
 */
	Tango::DevVarShortArray	*read_holding_registers(const Tango::DevVarShortArray *);
/**
 * Read Multiple 16bits input registers.
 *	@param	argin	register address, no. of registers
 *	@return	Input 16bits registers
 *	@exception DevFailed
 */
	Tango::DevVarShortArray	*read_input_registers(const Tango::DevVarShortArray *);
/**
 * Write single 16bits register.
 *	@param	argin	Register address, register value.
 *	@exception DevFailed
 */
	void	preset_single_register(const Tango::DevVarShortArray *);
/**
 * Read exception status (usually a predefined range of 8 bits
 *	@return	exception status
 *	@exception DevFailed
 */
	Tango::DevShort	read_exception_status();
/**
 * Fetch communications event counter.
 *	@return	status, event count
 *	@exception DevFailed
 */
	Tango::DevVarShortArray	*fetch_comm_event_ctr();
/**
 * Write multiple coils (digital I/O) state.
 *	argin[0] = coil_address
 *	argin[1] = number of coils
 *	argin[2] = 1st coil state
 *	argin[3] = 2nd coil state
 *	...
 *	@param	argin	coil address, nb of coils, coil states
 *	@exception DevFailed
 */
	void	force_multiple_coils(const Tango::DevVarShortArray *);
/**
 * Read multiple coil (digital I/O) status.
 *	argin[0] = register address
 *	argin[1] = number of registers
 *	@param	argin	coil address, nb of coils
 *	@return	Status of coils
 *	@exception DevFailed
 */
	Tango::DevVarShortArray	*read_multiple_coils_status(const Tango::DevVarShortArray *);
/**
 * Write multiple 16bits registers.
 *	argin[0] = register address
 *	argin[1] = number of registers
 *	argin[2] = 1st register
 *	argin[3] = 2nd register
 *	...
 *	@param	argin	register address, nb of registers, register data
 *	@exception DevFailed
 */
	void	preset_multiple_registers(const Tango::DevVarShortArray *);
/**
 * Mask write a 16bits register.
 *	@param	argin	register address, AND mask, OR mask
 *	@exception DevFailed
 */
	void	mask_write_register(const Tango::DevVarShortArray *);
/**
 * Read and Write multiple 16bits registers.
 *	argin[0] = read address
 *	argin[1] = nb of registers to read
 *	argin[2] = write address,
 *	argin[3] = nb of registers to write,
 *	argin[4] = 1st register value to write
 *	argin[5] = 2nd register value to write
 *	...
 *	@param	argin	read address, no. to read, write address, nb.of write, write data
 *	@return	read registers
 *	@exception DevFailed
 */
	Tango::DevVarShortArray	*read_write_register(const Tango::DevVarShortArray *);

/**
 *	Read the device properties from database
 */
	 void get_device_property();
//@}

	//	Here is the end of the automatic code generation part
	//-------------------------------------------------------------	



protected :	
	//	Add your own data members here
	//-----------------------------------------
	int get_protocol_number();
	void check_argin(const Tango::DevVarShortArray *argin,int lgth,char *where);
	ModbusCore *modbusCore;
	
};

}	// namespace

#endif	// _MODBUS_H
