static const char *RcsId = "$Header: /cvsroot/tango-ds/Communication/Modbus/Modbus.cpp,v 1.5 2006/12/07 09:40:09 michel_peru Exp $";
//+=============================================================================
//
// file :         Modbus.cpp
//
// description :  C++ source for the Modbus and its commands. 
//                The class is derived from Device. It represents the
//                CORBA servant object which will be accessed from the
//                network. All commands which can be executed on the
//                Modbus are implemented in this file.
//
// project :      TANGO Device Server
//
// $Author: michel_peru $
//
// $Revision: 1.5 $
//
// $Log: Modbus.cpp,v $
// Revision 1.5  2006/12/07 09:40:09  michel_peru
// Modified "ReadInputRegisters" in order to access more than 120 registers.
//
// Revision 1.4  2006/12/01 15:04:31  jensmeyer
// Added the command ReadMultipleCoilsStatus to read several coils (bits)
// at the same time.
//
// Revision 1.3  2005/03/31 15:07:05  jlpons
// Changed namespace name
//
// Revision 1.2  2005/03/01 17:53:35  jlpons
// Few updates.
//
// Revision 1.1  2005/01/14 15:36:55  jlpons
// Initial import
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================



//===================================================================
//
//	The following table gives the correspondance
//	between commands and method's name.
//
//  Command's name           |  Method's name
//	----------------------------------------
//  State                    |  dev_state()
//  Status                   |  dev_status()
//  ForceSingleCoil          |  force_single_coil()
//  ReadCoilStatus           |  read_coil_status()
//  ReadInputStatus          |  read_input_status()
//  ReadHoldingRegisters     |  read_holding_registers()
//  ReadInputRegisters       |  read_input_registers()
//  PresetSingleRegister     |  preset_single_register()
//  ReadExceptionStatus      |  read_exception_status()
//  FetchCommEventCtr        |  fetch_comm_event_ctr()
//  ForceMultipleCoils       |  force_multiple_coils()
//  ReadMultipleCoilsStatus  |  read_multiple_coils_status()
//  PresetMultipleRegisters  |  preset_multiple_registers()
//  MaskWriteRegister        |  mask_write_register()
//  ReadWriteRegister        |  read_write_register()
//
//===================================================================


#include <tango.h>
#include <Modbus.h>
#include <ModbusClass.h>

namespace Modbus_ns
{

  //+----------------------------------------------------------------------------
  //
  // method : 		Modbus::Modbus(string &s)
  // 
  // description : 	constructor for simulated Modbus
  //
  // in : - cl : Pointer to the DeviceClass object
  //      - s : Device name 
  //
  //-----------------------------------------------------------------------------
  Modbus::Modbus(Tango::DeviceClass *cl,string &s)
    :Tango::Device_3Impl(cl,s.c_str())
  {
    init_device();
  }

  Modbus::Modbus(Tango::DeviceClass *cl,const char *s)
    :Tango::Device_3Impl(cl,s)
  {
    init_device();
  }

  Modbus::Modbus(Tango::DeviceClass *cl,const char *s,const char *d)
    :Tango::Device_3Impl(cl,s,d)
  {
    init_device();
  }
  //+----------------------------------------------------------------------------
  //
  // method : 		Modbus::delete_device()
  // 
  // description : 	will be called at device destruction or at init command.
  //
  //-----------------------------------------------------------------------------
  void Modbus::delete_device()
  {
    //	Delete device's allocated object
    if(modbusCore)
      delete modbusCore;
  }

  //+----------------------------------------------------------------------------
  //
  // method : 		Modbus::init_device()
  // 
  // description : 	will be called at device initialization.
  //
  //-----------------------------------------------------------------------------
  void Modbus::init_device()
  {
    INFO_STREAM << "Modbus::Modbus() create device " << device_name << endl;
	
    modbusCore=NULL;

    // Initialise variables to default values
    //--------------------------------------------
    get_device_property();
	
    // Check configuration
	
    if( get_protocol_number()==MBUS_TCP ) {
	
      if(iphost.length()==0) {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_init",
				       (const char *)"Iphost property must be defined for TCP protocol.",
				       (const char *)"Modbus::init_device");

      }
	
    } else {
	
      if(serialline.length()==0) {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_init",
				       (const char *)"Serialline property must be defined for RTU protocol.",
				       (const char *)"Modbus::init_device");

      }
	
    }
	
    // Create the modbus core object
    long error=0;
    modbusCore = new ModbusCore((char *)serialline.c_str(),
				get_protocol_number(),
				address,
				(char *)iphost.c_str(),
				&error);
	
    if(error) {
      char tmp[256];
      sprintf(tmp,"Failed to create the modbus object. Error code:%d:",error);
      Tango::Except::throw_exception(
				     (const char *)"Modbus::error_init",
				     (const char *)tmp,
				     (const char *)"Modbus::init_device");
    }
	
    set_status(modbusCore->Status());
	
	
  }


  //+----------------------------------------------------------------------------
  //
  // method : 		Modbus::readDeviceProperies()
  // 
  // description : 	Read the device properties from database.
  //
  //-----------------------------------------------------------------------------
  void Modbus::get_device_property()
  {
    //	Initialize your default values here.
    //------------------------------------------
    protocol = "RTU";
    address = 1;
    serialline = "";
    iphost = "";

    //	Read device properties from database.(Automatic code generation)
    //-------------------------------------------------------------
	Tango::DbData	dev_prop;
	dev_prop.push_back(Tango::DbDatum("Protocol"));
	dev_prop.push_back(Tango::DbDatum("Iphost"));
	dev_prop.push_back(Tango::DbDatum("Serialline"));
	dev_prop.push_back(Tango::DbDatum("Address"));

	//	Call database and extract values
	//--------------------------------------------
	if (Tango::Util::instance()->_UseDb==true)
		get_db_device()->get_property(dev_prop);
	Tango::DbDatum	def_prop, cl_prop;
	ModbusClass	*ds_class =
		(static_cast<ModbusClass *>(get_device_class()));
	int	i = -1;

	//	Try to initialize Protocol from class property
	cl_prop = ds_class->get_class_property(dev_prop[++i].name);
	if (cl_prop.is_empty()==false)	cl_prop  >>  protocol;
	//	Try to initialize Protocol from default device value
	def_prop = ds_class->get_default_device_property(dev_prop[i].name);
	if (def_prop.is_empty()==false)	def_prop  >>  protocol;
	//	And try to extract Protocol value from database
	if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  protocol;

	//	Try to initialize Iphost from class property
	cl_prop = ds_class->get_class_property(dev_prop[++i].name);
	if (cl_prop.is_empty()==false)	cl_prop  >>  iphost;
	//	Try to initialize Iphost from default device value
	def_prop = ds_class->get_default_device_property(dev_prop[i].name);
	if (def_prop.is_empty()==false)	def_prop  >>  iphost;
	//	And try to extract Iphost value from database
	if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  iphost;

	//	Try to initialize Serialline from class property
	cl_prop = ds_class->get_class_property(dev_prop[++i].name);
	if (cl_prop.is_empty()==false)	cl_prop  >>  serialline;
	//	Try to initialize Serialline from default device value
	def_prop = ds_class->get_default_device_property(dev_prop[i].name);
	if (def_prop.is_empty()==false)	def_prop  >>  serialline;
	//	And try to extract Serialline value from database
	if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  serialline;

	//	Try to initialize Address from class property
	cl_prop = ds_class->get_class_property(dev_prop[++i].name);
	if (cl_prop.is_empty()==false)	cl_prop  >>  address;
	//	Try to initialize Address from default device value
	def_prop = ds_class->get_default_device_property(dev_prop[i].name);
	if (def_prop.is_empty()==false)	def_prop  >>  address;
	//	And try to extract Address value from database
	if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  address;



    //	End of Automatic code generation
    //-------------------------------------------------------------

  }
  //+----------------------------------------------------------------------------
  //
  // method : 		Modbus::always_executed_hook()
  // 
  // description : 	method always executed before any command is executed
  //
  //-----------------------------------------------------------------------------
  void Modbus::always_executed_hook()
  {
	
  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::force_single_coil
 *
 *	description:	method to execute "ForceSingleCoil"
 *	Write single coil (digital I/O) state.
 *
 * @param	argin	coil address, 0/1
 *
 */
//+------------------------------------------------------------------
  void Modbus::force_single_coil(const Tango::DevVarShortArray *argin)
  {
    DEBUG_STREAM << "Modbus::force_single_coil(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    short coil_address, coil_value;
    unsigned char query[5], response[5];

    check_argin(argin,2,"Modbus::force_single_coil");
    coil_address = (*argin)[0];
    coil_value = (*argin)[1];

    query[0] = FORCE_SINGLE_COIL;
    query[1] = coil_address >> 8;
    query[2] = coil_address & 0xff;
    if (coil_value)
      {
	query[3] = 0xff;
	query[4] = 0x00;
      }
    else
      {
	query[3] = 0x00;
	query[4] = 0x00;
      }

    if(modbusCore->SendGet(query,5,response,5,&error) != OK)
      {		
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_write",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::force_single_coil");
      }


    for (int i=0; i<5; i++)
      {
	if (query[i] != response[i])
	  {
            Tango::Except::throw_exception(
					   (const char *)"Modbus::error_write",
					   (const char *)"Failed to force single coil (response not equal to query).",
					   (const char *)"Modbus::force_single_coil");
		
	  }
      }

  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::read_coil_status
 *
 *	description:	method to execute "ReadCoilStatus"
 *	Read coil (digital I/O) status.
 *
 * @param	argin	coil address
 * @return	Coil status
 *
 */
//+------------------------------------------------------------------
  Tango::DevShort Modbus::read_coil_status(Tango::DevShort argin)
  {
    Tango::DevShort	argout ;
    DEBUG_STREAM << "Modbus::read_coil_status(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    short coil_address, bit;
    unsigned char query[5], response[1024];
			
    query[0] = READ_COIL_STATUS;
    query[1] = argin >> 8;
    query[2] = argin & 0xff;
    query[3] = 0;  // Read only one bit
    query[4] = 1;  

    if(modbusCore->SendGet(query,5,response,3,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_read",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::read_coil_status");
      }
	
    argout = (response[2]!=0)?1:0;

    return argout;

  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::read_input_status
 *
 *	description:	method to execute "ReadInputStatus"
 *	Read discrete input status. Return one boolean per array element.
 *
 * @param	argin	input address, no. of inputs
 * @return	Input status.
 *
 */
//+------------------------------------------------------------------
  Tango::DevVarCharArray *Modbus::read_input_status(const Tango::DevVarShortArray *argin)
  {
    //	POGO has generated a method core with argout allocation.
    //	If you would like to use a static reference without copying,
    //	See "TANGO Device Server Programmer's Manual"
    //		(chapter : Writing a TANGO DS / Exchanging data)
    //------------------------------------------------------------
    Tango::DevVarCharArray	*argout  = new Tango::DevVarCharArray();
    DEBUG_STREAM << "Modbus::read_input_status(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    short input_address, no_inputs, no_bytes, byteidx;
    unsigned char bitmask, query[5], response[1024];
	
    check_argin(argin,2,"Modbus::read_input_status");
    input_address = (*argin)[0];
    no_inputs = (*argin)[1];

    query[0] = READ_INPUT_STATUS;
    query[1] = input_address >> 8;
    query[2] = input_address & 0xff;
    query[3] = no_inputs >> 8;
    query[4] = no_inputs & 0xff;

    no_bytes = (no_inputs+7)/8;
    if(modbusCore->SendGet(query,5,response,no_bytes+2,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_read",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::read_input_status");
      }
	
    argout->length(no_inputs);
    int nb=0;
    for(int i=0;i<no_inputs;i++) {
      bitmask = (1 << (i%8));
      byteidx = i/8 + 2;
      (*argout)[i] = (response[byteidx] & bitmask)?1:0;
    }

    return argout;
  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::read_holding_registers
 *
 *	description:	method to execute "ReadHoldingRegisters"
 *	Read multiple 16bits registers.
 *
 * @param	argin	register address, no. of registers
 * @return	Holding 16bits register.
 *
 */
//+------------------------------------------------------------------
  Tango::DevVarShortArray *Modbus::read_holding_registers(const Tango::DevVarShortArray *argin)
  {
    //	POGO has generated a method core with argout allocation.
    //	If you would like to use a static reference without copying,
    //	See "TANGO Device Server Programmer's Manual"
    //		(chapter : Writing a TANGO DS / Exchanging data)
    //------------------------------------------------------------
    Tango::DevVarShortArray	*argout  = new Tango::DevVarShortArray();
    DEBUG_STREAM << "Modbus::read_holding_registers(): entering... !" << endl;
  
    //	Add your own code to control device here
    long error;
    short register_address, no_registers, no_bytes;
    unsigned char query[5], response[1024];
  
    check_argin(argin,2,"Modbus::read_holding_registers");
    register_address = (*argin)[0];
    no_registers = (*argin)[1];

    query[0] = READ_HOLDING_REGISTERS;
    query[1] = register_address >> 8;
    query[2] = register_address & 0xff;
    query[3] = no_registers >> 8;
    query[4] = no_registers & 0xff;
    
    no_bytes = no_registers*2;
    if(modbusCore->SendGet(query,5,response,no_bytes+2,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_read",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::read_holding_registers");
      }
    
    argout->length(no_registers);
    for (int i=0; i < no_registers; i++)
      (*argout)[i] = (response[i*2+2] << 8) + response[i*2+3];
    return argout;
  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::read_input_registers
 *
 *	description:	method to execute "ReadInputRegisters"
 *	Read Multiple 16bits input registers.
 *
 * @param	argin	register address, no. of registers
 * @return	Input 16bits registers
 *
 */
//+------------------------------------------------------------------
  Tango::DevVarShortArray *Modbus::read_input_registers(const Tango::DevVarShortArray *argin)
  {
    //	POGO has generated a method core with argout allocation.
    //	If you would like to use a static reference without copying,
    //	See "TANGO Device Server Programmer's Manual"
    //		(chapter : Writing a TANGO DS / Exchanging data)
    //------------------------------------------------------------
    Tango::DevVarShortArray	*argout  = new Tango::DevVarShortArray();
    argout->length(1);
    (*argout)[0] = 0;
    DEBUG_STREAM << "Modbus::read_input_registers(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    short register_address, no_registers, no_bytes;
    unsigned char query[5], response[1024];
	
    check_argin(argin,2,"Modbus::read_input_registers");
    register_address = (*argin)[0];
    no_registers = (*argin)[1];
    argout->length(no_registers);

    //---------------------------------------
    // A modbus response frame is limited to
    // 250 bytes.
    // Limiting the number of registers to
    // be read at 120 per call seems OK.

#define MAX_NB_REG 120

    //---------------------------------------

    int index = 0;

    
    do  // Do as many readouts as required.
      {
	int nb_reg_to_get;  // The number of registers to be read at next call.
	
	if(no_registers > MAX_NB_REG)  // Check for limit.
	  nb_reg_to_get = MAX_NB_REG;
	else
	  nb_reg_to_get = no_registers;

#ifdef EBUG
	cout << "register_address = " << register_address << endl;
	cout << "nb_reg_to_get    = " << nb_reg_to_get << endl;
#endif

	query[0] = READ_INPUT_REGISTERS;
	query[1] = register_address >> 8;
	query[2] = register_address & 0xff;
	query[3] = nb_reg_to_get >> 8;
	query[4] = nb_reg_to_get & 0xff;
	
	no_bytes = nb_reg_to_get * 2;

	if(modbusCore->SendGet(query,5,response,no_bytes+2,&error) != OK)
	  {
	    Tango::Except::throw_exception(
					   (const char *)"Modbus::error_read",
					   (const char *)modbusCore->GetErrorMessage(error),
					   (const char *)"Modbus::read_input_registers");
	  }
	
	for (int i=0; i < nb_reg_to_get; i++, index++)  // Copy received data to argout
	  (*argout)[index] = (response[i*2+2] << 8) + response[i*2+3];

	register_address += nb_reg_to_get; // Update address pointer.
	no_registers -= nb_reg_to_get;     // Update remaining data to be read.
      }
    while(no_registers > 0);  // Still some registers to be read?

    return argout;
  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::preset_single_register
 *
 *	description:	method to execute "PresetSingleRegister"
 *	Write single 16bits register.
 *
 * @param	argin	Register address, register value.
 *
 */
//+------------------------------------------------------------------
  void Modbus::preset_single_register(const Tango::DevVarShortArray *argin)
  {
    DEBUG_STREAM << "Modbus::preset_single_register(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    short register_address, value;
    unsigned char query[5], response[1024];
	
    check_argin(argin,2,"Modbus::preset_single_register");
    register_address = (*argin)[0];
    value = (*argin)[1];
	
    query[0] = PRESET_SINGLE_REGISTER;
    query[1] = register_address >> 8;
    query[2] = register_address & 0xff;
    query[3] = value >> 8;
    query[4] = value & 0xff;

    if(modbusCore->SendGet(query,5,response,5,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_write",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::preset_single_register");
      }
		

  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::read_exception_status
 *
 *	description:	method to execute "ReadExceptionStatus"
 *	Read exception status (usually a predefined range of 8 bits
 *
 * @return	exception status
 *
 */
//+------------------------------------------------------------------
  Tango::DevShort Modbus::read_exception_status()
  {
    Tango::DevShort	argout ;
    DEBUG_STREAM << "Modbus::read_exception_status(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    unsigned char query[5], response[1024];
	
    query[0] = READ_EXCEPTION_STATUS;

    if(modbusCore->SendGet(query,1,response,2,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_read",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::read_exception_status");
      }

    argout = (short)response[0];

    return argout;
  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::fetch_comm_event_ctr
 *
 *	description:	method to execute "FetchCommEventCtr"
 *	Fetch communications event counter.
 *
 * @return	status, event count
 *
 */
//+------------------------------------------------------------------
  Tango::DevVarShortArray *Modbus::fetch_comm_event_ctr()
  {
    //	POGO has generated a method core with argout allocation.
    //	If you would like to use a static reference without copying,
    //	See "TANGO Device Server Programmer's Manual"
    //		(chapter : Writing a TANGO DS / Exchanging data)
    //------------------------------------------------------------
    Tango::DevVarShortArray	*argout  = new Tango::DevVarShortArray();
    DEBUG_STREAM << "Modbus::fetch_comm_event_ctr(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    unsigned char query[5], response[1024];
	
    query[0] = FETCH_COMM_EVENT_CTR;

    if(modbusCore->SendGet(query,1,response,5,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_read",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::fetch_comm_event_ctr");
      }
	
    argout->length(2);
    (*argout)[0] = (response[0] << 8) + response[1];
    (*argout)[1] = (response[2] << 8) + response[3];

    return argout;
  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::force_multiple_coils
 *
 *	description:	method to execute "ForceMultipleCoils"
 *	Write multiple coils (digital I/O) state.
 *	argin[0] = coil_address
 *	argin[1] = number of coils
 *	argin[2] = 1st coil state
 *	argin[3] = 2nd coil state
 *	...
 *
 * @param	argin	coil address, nb of coils, coil states
 *
 */
//+------------------------------------------------------------------
  void Modbus::force_multiple_coils(const Tango::DevVarShortArray *argin)
  {
    DEBUG_STREAM << "Modbus::force_multiple_coils(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    short coil_address, no_coils, no_bytes, byteidx;
    unsigned char bitmask, query[1024], response[1024];
	
    if(argin->length()<3) {
      Tango::Except::throw_exception(
				     (const char *)"Modbus::error_write",
				     (const char *)"At least 3 input arguments expected.",
				     (const char *)"Modbus::force_multiple_coils");	
    }

    coil_address = (*argin)[0];
    no_coils = (*argin)[1];
	
    check_argin(argin,2+no_coils,"Modbus::force_multiple_coils");

    memset(query,0,1024);
    query[0] = FORCE_MULTIPLE_COILS;
    query[1] = coil_address >> 8;
    query[2] = coil_address & 0xff;
    query[3] = no_coils >> 8;
    query[4] = no_coils & 0xff;
    query[5] = (no_coils+7)/8;
    for (int i=0; i<no_coils; i++)
      {
	bitmask = (1 << (i%8));
	byteidx = i/8 + 6;
	if((*argin)[2+i])
	  query[byteidx] |= bitmask;
      }
    no_bytes = 6+(no_coils+7)/8;

    if(modbusCore->SendGet(query,no_bytes,response,5,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_write",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::force_multiple_coils");
      }

  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::preset_multiple_registers
 *
 *	description:	method to execute "PresetMultipleRegisters"
 *	Write multiple 16bits registers.
 *	argin[0] = register address
 *	argin[1] = number of registers
 *	argin[2] = 1st register
 *	argin[3] = 2nd register
 *	...
 *
 * @param	argin	register address, nb of registers, register data
 *
 */
//+------------------------------------------------------------------
  void Modbus::preset_multiple_registers(const Tango::DevVarShortArray *argin)
  {
    DEBUG_STREAM << "Modbus::preset_multiple_registers(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    short register_address, no_registers, no_bytes;
    unsigned char query[1024], response[1024];
	
    if(argin->length()<3) {
      Tango::Except::throw_exception(
				     (const char *)"Modbus::error_write",
				     (const char *)"At least 3 input arguments expected.",
				     (const char *)"Modbus::preset_multiple_registers");	
    }
	
    register_address = (*argin)[0];
    no_registers = (*argin)[1];
	
    check_argin(argin,2+no_registers,"Modbus::preset_multiple_registers");

    query[0] = PRESET_MULTIPLE_REGISTERS;
    query[1] = register_address >> 8;
    query[2] = register_address & 0xff;
    query[3] = no_registers >> 8;
    query[4] = no_registers & 0xff;
    query[5] = no_registers * 2;
    no_bytes = 6;
    for (int i=0; i<no_registers; i++)
      {
	query[6+(i*2)]   = ((*argin)[2+i]) >> 8;
	no_bytes++;
	query[6+(i*2)+1] = ((*argin)[2+i]) & 0xff;
	no_bytes++;
      }

    if(modbusCore->SendGet(query,no_bytes,response,5,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_write",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::preset_multiple_registers");
      }

  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::mask_write_register
 *
 *	description:	method to execute "MaskWriteRegister"
 *	Mask write a 16bits register.
 *
 * @param	argin	register address, AND mask, OR mask
 *
 */
//+------------------------------------------------------------------
  void Modbus::mask_write_register(const Tango::DevVarShortArray *argin)
  {
    DEBUG_STREAM << "Modbus::mask_write_register(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    short register_address, and_mask, or_mask;
    unsigned char query[1024], response[1024];
	
    check_argin(argin,3,"Modbus::mask_write_register");
    register_address = (*argin)[0];
    and_mask = (*argin)[1];
    or_mask = (*argin)[2];

    query[0] = MASK_WRITE_REGISTER;
    query[1] = (*argin)[0] >> 8;
    query[2] = (*argin)[0] & 0xff;
    query[3] = (*argin)[1] >> 8;
    query[4] = (*argin)[1] & 0xff;
    query[5] = (*argin)[2] >> 8;
    query[6] = (*argin)[2] & 0xff;

    if(modbusCore->SendGet(query,7,response,6,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_write",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::mask_write_register");
      }


  }

  //+------------------------------------------------------------------
/**
 *	method:	Modbus::read_write_register
 *
 *	description:	method to execute "ReadWriteRegister"
 *	Read and Write multiple 16bits registers.
 *	argin[0] = read address
 *	argin[1] = nb of registers to read
 *	argin[2] = write address,
 *	argin[3] = nb of registers to write,
 *	argin[4] = 1st register value to write
 *	argin[5] = 2nd register value to write
 *	...
 *
 * @param	argin	read address, no. to read, write address, nb.of write, write data
 * @return	read registers
 *
 */
//+------------------------------------------------------------------
  Tango::DevVarShortArray *Modbus::read_write_register(const Tango::DevVarShortArray *argin)
  {
    //	POGO has generated a method core with argout allocation.
    //	If you would like to use a static reference without copying,
    //	See "TANGO Device Server Programmer's Manual"
    //		(chapter : Writing a TANGO DS / Exchanging data)
    //------------------------------------------------------------
    Tango::DevVarShortArray	*argout  = new Tango::DevVarShortArray();
    DEBUG_STREAM << "Modbus::read_write_register(): entering... !" << endl;

    //	Add your own code to control device here
    long error;
    short no_bytes, no_read_registers, no_write_registers;
    unsigned char query[1024], response[1024];
	
    if(argin->length()<5) {
      Tango::Except::throw_exception(
				     (const char *)"Modbus::error_write",
				     (const char *)"At least 5 input arguments expected.",
				     (const char *)"Modbus::read_write_register");	
    }
	
    no_read_registers = (*argin)[1];
    no_write_registers = (*argin)[3];
    no_bytes = 0;
    check_argin(argin,4+no_write_registers,"Modbus::read_write_register");
	
    query[no_bytes++] = READ_WRITE_REGISTERS;
    query[no_bytes++] = (*argin)[0] >> 8;           // Read address MSB
    query[no_bytes++] = (*argin)[0] & 0xff;         // Read address LSB 
    query[no_bytes++] = no_read_registers >> 8;     // Word count for read MSB
    query[no_bytes++] = no_read_registers & 0xff;   // Word count for read LSB
    query[no_bytes++] = (*argin)[2] >> 8;           // Write address MSB
    query[no_bytes++] = (*argin)[2] & 0xff;         // Write address LSB 
    query[no_bytes++] = no_write_registers >> 8;    // Word count for write MSB
    query[no_bytes++] = no_write_registers & 0xff;  // Word count for write LSB
    query[no_bytes++] = no_write_registers*2;       // Byte count
    for (int i=0; i<no_write_registers; i++)
      {
	query[no_bytes++] = (*argin)[i+4] >> 8;
	query[no_bytes++] = (*argin)[i+4] & 0xff;
      }

    if(modbusCore->SendGet(query,no_bytes,response,2+no_read_registers*2,&error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_write",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::read_write_register");
      }
	
    if(no_read_registers != (short)(response[1]/2)) {
      char tmp[128];
      sprintf(tmp,"Wrong number of read registers. Got %d regs instead of %d",
	      (int)(response[1]/2) , (int)(no_read_registers));
      Tango::Except::throw_exception(
				     (const char *)"Modbus::error_read",
				     (const char *)tmp,
				     (const char *)"Modbus::read_write_register");	
    }
		
    argout->length(no_read_registers);
    for (int i=0; i<no_read_registers; i++)
      {
	(*argout)[i] = (response[i*2+2] << 8) + response[i*2+3];
      }

    return argout;
  }

  //------------------------------------------------------------
  // method: get_protocol_number
  //
  // Descr: Return the protocol id according to the resource string.
  //------------------------------------------------------------
  int Modbus::get_protocol_number() {

    if (strcasecmp(protocol.c_str(),"rtu")   == 0)
      return MBUS_RTU;

    if (strcasecmp(protocol.c_str(),"ascii") == 0)
      return MBUS_ASCII;

    if (strcasecmp(protocol.c_str(),"tcp")   == 0)
      return MBUS_TCP;

  }

  //------------------------------------------------------------
  // Check if argin has the expected length and throw DevFailed 
  // in case of error.
  //------------------------------------------------------------
  void Modbus::check_argin(const Tango::DevVarShortArray *argin,int lgth,char *where) {

    char tmp[256];
    sprintf(tmp,"Incorrect number of input arguments (%d expected)",lgth);
  
    if (argin->length() != lgth)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_write",
				       (const char *)tmp,
				       (const char *)where);		  
      }

  }


  //+------------------------------------------------------------------
/**
 *	method:	Modbus::read_multiple_coils_status
 *
 *	description:	method to execute "ReadMultipleCoilsStatus"
 *	Read multiple coil (digital I/O) status.
 *	argin[0] = register address
 *	argin[1] = number of registers
 *
 * @param	argin	coil address, nb of coils
 * @return	Status of coils
 *
 */
//+------------------------------------------------------------------
  Tango::DevVarShortArray *Modbus::read_multiple_coils_status(const Tango::DevVarShortArray *argin)
  {
    //	POGO has generated a method core with argout allocation.
    //	If you would like to use a static reference without copying,
    //	See "TANGO Device Server Programmer's Manual"
    //		(chapter : Writing a TANGO DS / Exchanging data)
    //------------------------------------------------------------
	
    DEBUG_STREAM << "Modbus::read_multiple_coils_status(): entering... !" << endl;

    //	Add your own code to control device here

    long error;
    short coil_address, no_coils;
    unsigned char query[1024], response[1024];
	
    if ( argin->length() != 2 ) 
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_write",
				       (const char *)"2 input arguments required.",
				       (const char *)"Modbus::read_multiple_coils_status");	
      }

		
    coil_address = (*argin)[0];
    no_coils     = (*argin)[1];

    query[0] = READ_COIL_STATUS;
    query[1] = coil_address >> 8;
    query[2] = coil_address & 0xff;
    query[3] = no_coils >> 8;
    query[4] = no_coils & 0xff;


    short no_bytes = (no_coils+7)/8;
    DEBUG_STREAM << "no of bytes = " << no_bytes << endl;
	
    if ( modbusCore->SendGet (query, 5, response, (no_bytes + 2), &error) != OK)
      {
	Tango::Except::throw_exception(
				       (const char *)"Modbus::error_read",
				       (const char *)modbusCore->GetErrorMessage(error),
				       (const char *)"Modbus::read_multiple_coils_status");
      }


    Tango::DevVarShortArray	*argout  = new Tango::DevVarShortArray();
    argout->length(no_coils);
	
	
    for (int seq=0, idx=0 ; seq < no_bytes ; seq++)
      {
	unsigned char word = response[seq + 2];
	for (int i=0 ; (i < 8)  && (idx < no_coils); i++)
	  {
	    DEBUG_STREAM << idx << ":	" << word << " & " << (1<<i) << " = " << (word & 1<<i) << endl;
	    unsigned char bit_value = (word & (1<<i)) >> i;
			
	    (*argout)[idx] = (bit_value != 0) ? 1:0;
	    idx++;
	  }
      }	
	
    return argout;
  }


}	//	namespace
